/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ui.command;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.webservice.was.consumption.ui.plugin.WebServiceWasConsumptionUIPlugin;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.ext.model.WsbndArtifactEdit;
import com.ibm.etools.webservice.was.ext.model.WsextArtifactEdit;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import com.ibm.etools.webservice.wsbnd.PCBinding;
import com.ibm.etools.webservice.wsbnd.SecurityRequestReceiverBindingConfig;
import com.ibm.etools.webservice.wsbnd.SecurityResponseSenderBindingConfig;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.etools.webservice.wsbnd.impl.WsbndFactoryImpl;
import com.ibm.etools.webservice.wscommonbnd.CanonicalizationMethod;
import com.ibm.etools.webservice.wscommonbnd.CertPathSettings;
import com.ibm.etools.webservice.wscommonbnd.CertStoreList;
import com.ibm.etools.webservice.wscommonbnd.CertStoreRef;
import com.ibm.etools.webservice.wscommonbnd.CollectionCertStore;
import com.ibm.etools.webservice.wscommonbnd.DigestMethod;
import com.ibm.etools.webservice.wscommonbnd.Key;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.KeyStore;
import com.ibm.etools.webservice.wscommonbnd.SignatureMethod;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonbnd.SigningKey;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchor;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchorRef;
import com.ibm.etools.webservice.wscommonbnd.X509Certificate;
import com.ibm.etools.webservice.wscommonbnd.impl.WscommonbndFactoryImpl;
import com.ibm.etools.webservice.wscommonext.Integrity;
import com.ibm.etools.webservice.wscommonext.Reference;
import com.ibm.etools.webservice.wscommonext.ReferencePart;
import com.ibm.etools.webservice.wscommonext.RequiredIntegrity;
import com.ibm.etools.webservice.wscommonext.impl.WscommonextFactoryImpl;
import com.ibm.etools.webservice.wsext.PcBinding;
import com.ibm.etools.webservice.wsext.SecurityRequestReceiverServiceConfig;
import com.ibm.etools.webservice.wsext.SecurityResponseSenderServiceConfig;
import com.ibm.etools.webservice.wsext.ServerServiceConfig;
import com.ibm.etools.webservice.wsext.WsDescExt;
import com.ibm.etools.webservice.wsext.WsExtension;
import com.ibm.etools.webservice.wsext.impl.WsextFactoryImpl;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSDDArtifactEdit;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.core.context.TransientResourceContext;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class AddIBMWebServicesSecurityDSIGCommand
extends AbstractDataModelOperation {
    private final String WEBSERVICES_XML = "webservices.xml";
    private final String IBM_WEBSERVICES_BND_XMI = "ibm-webservices-bnd.xmi";
    private final String IBM_WEBSERVICES_EXT_XMI = "ibm-webservices-ext.xmi";
    private JavaWSDLParameterBase javaWSDLParam = null;
    private static final byte SECURITY_CONFIG = 1;
    private EList wsDescriptions = null;
    private String routerModule = null;
    IPath ibmWebServicesXMLPath = null;
    IPath ibmWebServicesBndXMIPath = null;
    IPath ibmWebServicesExtXMIPath = null;
    private String eJBProjectName;
    private IProject serviceProject;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = super.getEnvironment();
        IStatus status = Status.OK_STATUS;
        if (this.javaWSDLParam == null) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
        }
        if (this.javaWSDLParam.getSecurityConfig() != 1) {
            return status;
        }
        if (this.javaWSDLParam.getJ2eeLevel().equals("1.4")) {
            this.copyTemplateToTempDirectory("/samples/BasicSig/ibm-webservices-bnd.xmi", "ibm-webservices-bnd.xmi", status, env, monitor);
            this.copyTemplateToTempDirectory("/samples/BasicSig/ibm-webservices-ext.xmi", "ibm-webservices-ext.xmi", status, env, monitor);
        } else {
            this.copyTemplateToTempDirectory("/samples/BasicSig/ibm-webservicesv5-bnd.xmi", "ibm-webservices-bnd.xmi", status, env, monitor);
            this.copyTemplateToTempDirectory("/samples/BasicSig/ibm-webservicesv5-ext.xmi", "ibm-webservices-ext.xmi", status, env, monitor);
        }
        return status;
    }

    private void copyTemplateToTempDirectory(String source, String fileName, IStatus status, IEnvironment env, IProgressMonitor monitor) {
        try {
            String inputLine;
            String tempDir = J2EEUtils.removeFileProtocol((String)this.javaWSDLParam.getTempOutput());
            File file = new File(String.valueOf(tempDir) + "sec");
            if (!file.exists()) {
                file.mkdirs();
            }
            FileWriter fw = new FileWriter(String.valueOf(tempDir) + "sec" + File.separator + fileName);
            DataInputStream is = new DataInputStream(WebServiceWasConsumptionUIPlugin.getInstance().getBundle().getEntry(source).openStream());
            while ((inputLine = is.readLine()) != null) {
                fw.write(inputLine);
            }
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void getNamesFromWebServicesXML(IProject ddProject) {
        WSDDArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WSDDArtifactEdit.getWSDDArtifactEditForRead((IProject)ddProject);
            WebServices webservices = artifactEdit.getWebServices();
            this.wsDescriptions = webservices.getWebServiceDescriptions();
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void updateWsExtDSIG(IProject ddProject) {
        String wsNameLink = ((WebServiceDescription)this.wsDescriptions.get(0)).getWebServiceDescriptionName();
        EList portComponents = ((WebServiceDescription)this.wsDescriptions.get(0)).getPortComponents();
        WsextArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WsextArtifactEdit.getWSEXTArtifactEditForWrite((IProject)ddProject);
            WsExtension wsext = artifactEdit.getWsExtension();
            WsextFactoryImpl wsextfactory = new WsextFactoryImpl();
            WsDescExt wsDescExt = null;
            PcBinding pcBinding = null;
            EList wsDescExts = wsext.getWsDescExt();
            int i = 0;
            while (i < wsDescExts.size()) {
                WsDescExt tmpWsDescExt = (WsDescExt)wsDescExts.get(i);
                if (tmpWsDescExt.getWsDescNameLink() != null && tmpWsDescExt.getWsDescNameLink().equals(wsNameLink)) {
                    wsext.getWsDescExt().remove(i);
                    break;
                }
                ++i;
            }
            if (wsDescExt == null) {
                wsDescExt = wsextfactory.createWsDescExt();
                wsDescExt.setWsDescNameLink(wsNameLink);
                wsext.getWsDescExt().add((Object)wsDescExt);
            }
            EList pcBnds = wsDescExt.getPcBinding();
            int i2 = 0;
            while (i2 < pcBnds.size()) {
                PcBinding pcBnd = (PcBinding)pcBnds.get(i2);
                if (pcBnd.getPcNameLink() != null && pcBnd.equals(((PortComponent)portComponents.get(0)).getPortComponentName())) {
                    pcBinding = pcBnd;
                    break;
                }
                ++i2;
            }
            if (pcBinding == null) {
                pcBinding = wsextfactory.createPcBinding();
                pcBinding.setPcNameLink(((PortComponent)portComponents.get(0)).getPortComponentName());
                pcBinding.setScope("Session");
                wsDescExt.getPcBinding().add((Object)pcBinding);
            }
            WscommonextFactoryImpl wscommonextfactory = new WscommonextFactoryImpl();
            ServerServiceConfig serverserviceconfig = wsextfactory.createServerServiceConfig();
            serverserviceconfig.setActorURI("myActorURI");
            SecurityRequestReceiverServiceConfig secReqRecServiceConfig = wsextfactory.createSecurityRequestReceiverServiceConfig();
            RequiredIntegrity reqIntegrity = wscommonextfactory.createRequiredIntegrity();
            Reference reference = wscommonextfactory.createReference();
            reference.setPart(ReferencePart.BODY_LITERAL);
            reqIntegrity.getReferences().add((Object)reference);
            secReqRecServiceConfig.setRequiredIntegrity(reqIntegrity);
            SecurityResponseSenderServiceConfig secResSndServiceConfig = wsextfactory.createSecurityResponseSenderServiceConfig();
            Integrity integrity = wscommonextfactory.createIntegrity();
            reference = wscommonextfactory.createReference();
            reference.setPart(ReferencePart.BODY_LITERAL);
            integrity.getReferences().add((Object)reference);
            secResSndServiceConfig.setIntegrity(integrity);
            serverserviceconfig.setSecurityRequestReceiverServiceConfig(secReqRecServiceConfig);
            serverserviceconfig.setSecurityResponseSenderServiceConfig(secResSndServiceConfig);
            pcBinding.setServerServiceConfig(serverserviceconfig);
            wsext.setRouterModuleName(this.routerModule);
            artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void updateWsBndDSIG(IProject ddProject) {
        String wsNameLink = ((WebServiceDescription)this.wsDescriptions.get(0)).getWebServiceDescriptionName();
        EList portComponents = ((WebServiceDescription)this.wsDescriptions.get(0)).getPortComponents();
        WsbndArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForWrite((IProject)ddProject);
            WSBinding wsbnd = artifactEdit.getWSBinding();
            WSDescBinding wsDescBinding = null;
            PCBinding pcBinding = null;
            WsbndFactoryImpl wsbndfactory = new WsbndFactoryImpl();
            EList wscbindings = wsbnd.getWsdescBindings();
            int i = 0;
            while (i < wscbindings.size()) {
                WSDescBinding wsDscBnd = (WSDescBinding)wscbindings.get(i);
                if (wsDscBnd.getWsDescNameLink() != null && wsDscBnd.getWsDescNameLink().equals(wsNameLink)) {
                    wsDescBinding = wsDscBnd;
                    break;
                }
                ++i;
            }
            if (wsDescBinding == null) {
                wsDescBinding = wsbndfactory.createWSDescBinding();
                wsDescBinding.setWsDescNameLink(wsNameLink);
                wsbnd.getWsdescBindings().add((Object)wsDescBinding);
            }
            EList pcBindings = wsDescBinding.getPcBindings();
            int j = 0;
            while (j < pcBindings.size()) {
                PCBinding pcBnd = (PCBinding)pcBindings.get(j);
                if (pcBnd.getPcNameLink() != null && pcBnd.getPcNameLink().equals(((PortComponent)portComponents.get(0)).getPortComponentName())) {
                    pcBinding = pcBnd;
                    break;
                }
                ++j;
            }
            if (pcBinding == null) {
                pcBinding = wsbndfactory.createPCBinding();
                pcBinding.setPcNameLink(((PortComponent)portComponents.get(0)).getPortComponentName());
                wsDescBinding.getPcBindings().add((Object)pcBinding);
            }
            SecurityRequestReceiverBindingConfig newSecReqRecBndConfig = wsbndfactory.createSecurityRequestReceiverBindingConfig();
            WscommonbndFactoryImpl wscommonbndfactory = new WscommonbndFactoryImpl();
            CertStoreList certStoreList = wscommonbndfactory.createCertStoreList();
            CollectionCertStore collectionCertStore = wscommonbndfactory.createCollectionCertStore();
            collectionCertStore.setName("WS509CertStore");
            collectionCertStore.setProvider("IBMCertPath");
            X509Certificate x509Cert = wscommonbndfactory.createX509Certificate();
            x509Cert.setPath("${USER_INSTALL_ROOT}/etc/ws-security/samples/intca2.cer");
            collectionCertStore.getX509Certificates().add((Object)x509Cert);
            certStoreList.getCollectionCertStores().add((Object)collectionCertStore);
            SigningInfo signInfo = wscommonbndfactory.createSigningInfo();
            SignatureMethod signatureMethod = wscommonbndfactory.createSignatureMethod();
            signatureMethod.setAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
            CertPathSettings certPathSettings = wscommonbndfactory.createCertPathSettings();
            TrustAnchorRef trustanchorRef = wscommonbndfactory.createTrustAnchorRef();
            trustanchorRef.setRef("WS509TrustAnchor");
            CertStoreRef certStoreRef = wscommonbndfactory.createCertStoreRef();
            certStoreRef.setRef("WS509CertStore");
            certPathSettings.setTrustAnchorRef(trustanchorRef);
            certPathSettings.setCertStoreRef(certStoreRef);
            CanonicalizationMethod canonicalizationMethod = wscommonbndfactory.createCanonicalizationMethod();
            canonicalizationMethod.setAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            DigestMethod digestMethod = wscommonbndfactory.createDigestMethod();
            digestMethod.setAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
            signInfo.setSignatureMethod(signatureMethod);
            signInfo.setCertPathSettings(certPathSettings);
            signInfo.setCanonicalizationMethod(canonicalizationMethod);
            signInfo.setDigestMethod(digestMethod);
            KeyStore keyStore = wscommonbndfactory.createKeyStore();
            keyStore.setPath("${USER_INSTALL_ROOT}/etc/ws-security/samples/dsig-receiver.ks");
            keyStore.setType("JKS");
            keyStore.setStorepass("{xor}LDotKTot");
            TrustAnchor trustAnchor = wscommonbndfactory.createTrustAnchor();
            trustAnchor.setName("WS509TrustAnchor");
            trustAnchor.setKeyStore(keyStore);
            newSecReqRecBndConfig.setCertStoreList(certStoreList);
            newSecReqRecBndConfig.getSigningInfos().add((Object)signInfo);
            newSecReqRecBndConfig.getTrustAnchors().add((Object)trustAnchor);
            SecurityResponseSenderBindingConfig newSecResSndBndConfig = wsbndfactory.createSecurityResponseSenderBindingConfig();
            signInfo = wscommonbndfactory.createSigningInfo();
            signatureMethod = wscommonbndfactory.createSignatureMethod();
            signatureMethod.setAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
            SigningKey signingKey = wscommonbndfactory.createSigningKey();
            signingKey.setName("serversignerkey");
            signingKey.setLocatorRef("SampleServerSignerKey");
            canonicalizationMethod = wscommonbndfactory.createCanonicalizationMethod();
            canonicalizationMethod.setAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            digestMethod = wscommonbndfactory.createDigestMethod();
            digestMethod.setAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
            signInfo.setSignatureMethod(signatureMethod);
            signInfo.setSigningKey(signingKey);
            signInfo.setCanonicalizationMethod(canonicalizationMethod);
            signInfo.setDigestMethod(digestMethod);
            KeyLocator keyLocator = wscommonbndfactory.createKeyLocator();
            keyLocator.setName("SampleServerSignerKey");
            keyLocator.setClassname("com.ibm.wsspi.wssecurity.config.KeyStoreKeyLocator");
            keyStore = wscommonbndfactory.createKeyStore();
            keyStore.setPath("${USER_INSTALL_ROOT}/etc/ws-security/samples/dsig-receiver.ks");
            keyStore.setType("JKS");
            keyStore.setStorepass("{xor}LDotKTot");
            Key key = wscommonbndfactory.createKey();
            key.setAlias("soapprovider");
            key.setKeypass("{xor}LDotKTot");
            key.setName("serversignerkey");
            keyLocator.setKeyStore(keyStore);
            keyLocator.getKeys().add((Object)key);
            newSecResSndBndConfig.setSigningInfo(signInfo);
            newSecResSndBndConfig.getKeyLocators().add((Object)keyLocator);
            pcBinding.setSecurityRequestReceiverBindingConfig(newSecReqRecBndConfig);
            pcBinding.setSecurityResponseSenderBindingConfig(newSecResSndBndConfig);
            artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void updateWsExtDSIG6(IProject ddProject) {
        WsextArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WsextArtifactEdit.getWSEXTArtifactEditForWrite((IProject)ddProject);
            WsExtension wsext = artifactEdit.getWsExtension();
            EList wsDescExts = wsext.getWsDescExt();
            WsDescExt wsDescExt = (WsDescExt)wsDescExts.get(0);
            wsDescExt.setWsDescNameLink(((WebServiceDescription)this.wsDescriptions.get(0)).getWebServiceDescriptionName());
            EList portComponents = ((WebServiceDescription)this.wsDescriptions.get(0)).getPortComponents();
            EList pcBnds = wsDescExt.getPcBinding();
            PcBinding pcBinding = (PcBinding)pcBnds.get(0);
            pcBinding.setPcNameLink(((PortComponent)portComponents.get(0)).getPortComponentName());
            int p = 1;
            while (p < portComponents.size()) {
                EObject newPcBinding = EcoreUtil.copy((EObject)pcBinding);
                ((PcBinding)newPcBinding).setPcNameLink(((PortComponent)portComponents.get(p)).getPortComponentName());
                wsDescExt.getPcBinding().add((Object)newPcBinding);
                ++p;
            }
            int ws = 1;
            while (ws < this.wsDescriptions.size()) {
                WsDescExt newWsDescExt = (WsDescExt)EcoreUtil.copy((EObject)wsDescExt);
                newWsDescExt.setWsDescNameLink(((WebServiceDescription)this.wsDescriptions.get(ws)).getWebServiceDescriptionName());
                portComponents = ((WebServiceDescription)this.wsDescriptions.get(ws)).getPortComponents();
                pcBnds = newWsDescExt.getPcBinding();
                pcBinding = (PcBinding)pcBnds.get(0);
                pcBinding.setPcNameLink(((PortComponent)portComponents.get(0)).getPortComponentName());
                int p2 = 1;
                while (p2 < portComponents.size()) {
                    EObject newPcBinding = EcoreUtil.copy((EObject)pcBinding);
                    ((PcBinding)newPcBinding).setPcNameLink(((PortComponent)portComponents.get(p2)).getPortComponentName());
                    newWsDescExt.getPcBinding().add((Object)newPcBinding);
                    ++p2;
                }
                wsext.getWsDescExt().add((Object)newWsDescExt);
                ++ws;
            }
            wsext.setRouterModuleName(this.routerModule);
            artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void updateWsBndDSIG6(IProject ddProject) {
        WsbndArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForWrite((IProject)ddProject);
            WSBinding wsbnd = artifactEdit.getWSBinding();
            EList wscbindings = wsbnd.getWsdescBindings();
            WSDescBinding wsDescBinding = (WSDescBinding)wscbindings.get(0);
            wsDescBinding.setWsDescNameLink(((WebServiceDescription)this.wsDescriptions.get(0)).getWebServiceDescriptionName());
            EList portComponents = ((WebServiceDescription)this.wsDescriptions.get(0)).getPortComponents();
            EList pcBindings = wsDescBinding.getPcBindings();
            PCBinding pcBinding = (PCBinding)pcBindings.get(0);
            pcBinding.setPcNameLink(((PortComponent)portComponents.get(0)).getPortComponentName());
            int p = 1;
            while (p < portComponents.size()) {
                EObject newPCBinding = EcoreUtil.copy((EObject)pcBinding);
                ((PCBinding)newPCBinding).setPcNameLink(((PortComponent)portComponents.get(p)).getPortComponentName());
                wsDescBinding.getPcBindings().add((Object)newPCBinding);
                ++p;
            }
            int ws = 1;
            while (ws < this.wsDescriptions.size()) {
                WSDescBinding newWsDescBinding = (WSDescBinding)EcoreUtil.copy((EObject)wsDescBinding);
                newWsDescBinding.setWsDescNameLink(((WebServiceDescription)this.wsDescriptions.get(ws)).getWebServiceDescriptionName());
                portComponents = ((WebServiceDescription)this.wsDescriptions.get(ws)).getPortComponents();
                pcBindings = newWsDescBinding.getPcBindings();
                pcBinding = (PCBinding)pcBindings.get(0);
                pcBinding.setPcNameLink(((PortComponent)portComponents.get(0)).getPortComponentName());
                int p2 = 1;
                while (p2 < portComponents.size()) {
                    EObject newPCBinding = EcoreUtil.copy((EObject)pcBinding);
                    ((PCBinding)newPCBinding).setPcNameLink(((PortComponent)portComponents.get(p2)).getPortComponentName());
                    newWsDescBinding.getPcBindings().add((Object)newPCBinding);
                    ++p2;
                }
                wsbnd.getWsdescBindings().add((Object)newWsDescBinding);
                ++ws;
            }
            artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void copyTemplateFromBundle(String source, IPath target, IStatus status, IEnvironment env, IProgressMonitor monitor) {
        try {
            TransientResourceContext context = new TransientResourceContext();
            context.setOverwriteFilesEnabled(true);
            context.setCreateFoldersEnabled(true);
            context.setCheckoutFilesEnabled(true);
            FileResourceUtils.createFile((ResourceContext)context, (IPath)target, (InputStream)WebServiceWasConsumptionUIPlugin.getInstance().getBundle().getEntry(source).openStream(), (IProgressMonitor)monitor, (IStatusHandler)env.getStatusHandler());
        }
        catch (Exception e) {
            status = StatusUtils.errorStatus((String)Messages.MSG_ERROR_FILECOPY, (Throwable)e);
            env.getStatusHandler().reportError(status);
        }
    }

    private void getWSDDFilePath(IProject ddProject) {
        IPath projectPath = ddProject.getFullPath();
        IVirtualComponent component = ComponentCore.createComponent((IProject)ddProject);
        IVirtualFolder ivFolder = null;
        if (J2EEUtils.isWebProject((IProject)ddProject)) {
            ivFolder = J2EEUtils.getWebDeploymentDescriptorFolder((IVirtualComponent)component);
        } else if (J2EEUtils.isEJBProject((IProject)ddProject)) {
            ivFolder = J2EEUtils.getEJBDeploymentDescriptorFolder((IVirtualComponent)component);
        }
        IVirtualFile ivFile = ivFolder.getFile("webservices.xml");
        if (ivFile.exists()) {
            this.ibmWebServicesXMLPath = projectPath.append(ivFile.getProjectRelativePath());
        }
        if ((ivFile = ivFolder.getFile("ibm-webservices-bnd.xmi")).exists()) {
            this.ibmWebServicesBndXMIPath = projectPath.append(ivFile.getProjectRelativePath());
        }
        if ((ivFile = ivFolder.getFile("ibm-webservices-ext.xmi")).exists()) {
            this.ibmWebServicesExtXMIPath = projectPath.append(ivFile.getProjectRelativePath());
        }
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setEJBProjectName(String projectName) {
        this.eJBProjectName = projectName;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject = serviceProject;
    }
}

