/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.utc;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.webservice.was.consumption.ui.plugin.Log;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import com.ibm.ws.ast.st.common.core.internal.AbstractWASServer;
import com.ibm.ws.ast.st.common.core.internal.provisional.IWebSphereCommonServer;
import com.ibm.ws.ast.st.core.model.IWebSphereServerBehaviour;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.ext.test.JavaProxyTestCommand;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.wst.command.internal.env.core.selection.BooleanSelection;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.ws.internal.wsrt.TestInfo;

public class WASUTCFinishCommand
extends AbstractDataModelOperation
implements JavaProxyTestCommand {
    private String UTC = "UTC";
    private String PRELOAD = "/preload?object=";
    private IServer sampleExistingServer;
    private String proxyBean;
    private String appEar = "&app=";
    private String module = "&module=";
    private String wasAdminPort = "&wasAdminPort=";
    private String wasAdminConn = "&wasAdminConn=";
    private String portNum = "&port=";
    private TestInfo testInfo;
    private String BOUNDARY = "---------------------------7d62e91100822";
    boolean isDebugEnabled = Platform.inDebugMode() && "true".equals(Platform.getDebugOption((String)"com.ibm.ast.ws.creation.ui/debug"));

    public WASUTCFinishCommand(TestInfo testInfo) {
        this();
        this.testInfo = testInfo;
    }

    public WASUTCFinishCommand() {
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        StringBuffer urlString;
        block11: {
            this.sampleExistingServer = this.testInfo.getClientExistingServer();
            this.proxyBean = this.testInfo.getProxyBean();
            IWebSphereServerBehaviour webSphereServer = (IWebSphereServerBehaviour)this.sampleExistingServer.getAdapter(IWebSphereServerBehaviour.class);
            String temp = "";
            if (webSphereServer == null) {
                return Status.OK_STATUS;
            }
            temp = String.valueOf(webSphereServer.getBaseURL()) + "/";
            urlString = new StringBuffer(temp);
            urlString.append(this.UTC).append(this.PRELOAD).append(this.proxyBean);
            urlString.append(this.appEar).append(this.testInfo.getClientEARProject());
            urlString.append(this.module).append(this.testInfo.getClientProject());
            try {
                IWebSphereCommonServer wasServer = (IWebSphereCommonServer)this.sampleExistingServer.getAdapter(IWebSphereCommonServer.class);
                if (wasServer == null || !(wasServer instanceof AbstractWASServer)) break block11;
                AbstractWASServer server = (AbstractWASServer)wasServer;
                if (server.isSecurityEnabled()) {
                    try {
                        StringBuffer initialUrl = new StringBuffer(temp);
                        initialUrl.append(this.UTC).append("/initialize");
                        HTTPGetRequest getReq = new HTTPGetRequest(initialUrl.toString());
                        StringBuffer getData = new StringBuffer("?");
                        getData.append(this.wasAdminConn).append(server.getServerConnectionType());
                        getData.append(this.wasAdminPort).append(server.getServerAdminPortNum());
                        getData.append(this.portNum).append(server.getServerAdminPortNum());
                        getReq.httpGet(getData.toString());
                        StringBuffer wasClassLoaderUrl = new StringBuffer(temp);
                        wasClassLoaderUrl.append(this.UTC).append("/html/detail/was.jsp");
                        getReq = new HTTPGetRequest(wasClassLoaderUrl.toString());
                        getReq.httpGet(null);
                        StringBuffer classLoadUrl = new StringBuffer(temp);
                        classLoadUrl.append(this.UTC).append("/classloader");
                        HTTPPostRequest postReq = new HTTPPostRequest(classLoadUrl.toString());
                        postReq.setHeaderProperties("Cookie", getReq.getCookie());
                        postReq.setHeaderProperties("Content-Type", "multipart/form-data; boundary=" + this.BOUNDARY);
                        Properties credentialProps = new Properties();
                        if (server.getSecurityUserId() != null) {
                            credentialProps.setProperty("user", server.getSecurityUserId());
                        }
                        if (server.getSecurityPasswd() != null) {
                            credentialProps.setProperty("password", server.getSecurityPasswd());
                        }
                        postReq.httpPost(this.buildMultiPartRequest(this.BOUNDARY, credentialProps));
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                }
                urlString.append(this.wasAdminConn).append(server.getServerConnectionType());
                urlString.append(this.wasAdminPort).append(server.getServerAdminPortNum());
                urlString.append(this.portNum).append(server.getServerAdminPortNum());
            }
            catch (Exception exception) {}
        }
        try {
            URL url = new URL(urlString.toString());
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser browser = browserSupport.createBrowser(6, null, null, null);
            browser.openURL(url);
        }
        catch (MalformedURLException malformedURLException) {
            Log.write((Object)this, "Launching browser", 4, "The test client url was malformed");
        }
        catch (PartInitException pie) {
            IEnvironment env = super.getEnvironment();
            IStatus errStatus = StatusUtils.errorStatus((String)Messages.MSG_ERROR_UTC_LAUNCHING_BROWSER, (Throwable)pie);
            env.getStatusHandler().reportError(errStatus);
            return errStatus;
        }
        return Status.OK_STATUS;
    }

    public void setExistingServer(IServer sampleExistingServer) {
        this.sampleExistingServer = sampleExistingServer;
    }

    public void setServerTypeID(String ServerTypeID) {
    }

    public void setRunClientTest(boolean runClientTest) {
    }

    public void setJspFolder(String jspFolder) {
    }

    public void setSampleProject(String sampleProject) {
    }

    public void setClientProject(String clientProject) {
    }

    public void setProxyBean(String proxyBean) {
        this.proxyBean = proxyBean;
    }

    public void setSetEndpointMethod(String setSetEndpointMethod) {
    }

    public void setEndpoint(List endpoints) {
    }

    public void setEndpoint(String endpoint) {
    }

    public void setMethods(BooleanSelection[] methods) {
    }

    private String getHeaderField(Map map, String fieldName) {
        for (String key : map.keySet()) {
            if (key == null || !key.equalsIgnoreCase(fieldName)) continue;
            List values = (List)map.get(key);
            int i = 0;
            while (i < values.size()) {
                String headerValue;
                if (values.get(i) != null && (headerValue = this.getValue(values.get(i).toString())) != null) {
                    return headerValue;
                }
                ++i;
            }
        }
        return null;
    }

    private String getValue(String originalHeader) {
        int spaceIndex = originalHeader.indexOf(" ");
        if (spaceIndex == -1) {
            return originalHeader;
        }
        return originalHeader.substring(0, spaceIndex);
    }

    private void printHeaderFields(Map map) {
        for (String key : map.keySet()) {
            List values = (List)map.get(key);
            int i = 0;
            while (i < values.size()) {
                System.out.println(String.valueOf(key) + ": " + values.get(i));
                ++i;
            }
        }
    }

    private String buildMultiPartRequest(String boundary, Properties data) {
        StringBuffer sb = new StringBuffer();
        sb.append("\r\n");
        for (String string : data.keySet()) {
            sb.append("--").append(boundary);
            sb.append("\r\n");
            sb.append("Content-Disposition: form-data; name=\"");
            sb.append(string);
            sb.append("\"\r\n\r\n");
            sb.append(data.get(string));
            sb.append("\r\n");
        }
        sb.append("--").append(boundary).append("--");
        sb.append("\r\n");
        return sb.toString();
    }

    private class HTTPGetRequest {
        String urlString;
        String cookie = null;

        HTTPGetRequest(String url) {
            this.urlString = url;
        }

        void httpGet(String data) throws Exception {
            String line;
            StringBuffer getURL = new StringBuffer(this.urlString);
            if (data != null) {
                getURL.append(data);
            }
            URL url = new URL(this.urlString);
            URLConnection conn = url.openConnection();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            if (WASUTCFinishCommand.this.isDebugEnabled) {
                System.out.println("HTTP Header for Get request " + this.urlString);
                WASUTCFinishCommand.this.printHeaderFields(conn.getHeaderFields());
            }
            this.cookie = WASUTCFinishCommand.this.getHeaderField(conn.getHeaderFields(), "Set-Cookie");
            while ((line = rd.readLine()) != null) {
                if (!WASUTCFinishCommand.this.isDebugEnabled) continue;
                System.out.println(line);
            }
            rd.close();
        }

        String getCookie() {
            return this.cookie;
        }
    }

    private class HTTPPostRequest {
        String urlString;
        String cookie = null;
        Properties reqProperties = new Properties();

        HTTPPostRequest(String url) {
            this.urlString = url;
        }

        void httpPost(String data) throws Exception {
            String line;
            URL url = new URL(this.urlString);
            URLConnection conn = url.openConnection();
            for (String string : this.reqProperties.keySet()) {
                conn.setRequestProperty(string, this.reqProperties.getProperty(string));
            }
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            if (WASUTCFinishCommand.this.isDebugEnabled) {
                System.out.println("HTTP Header for Post request " + this.urlString);
                WASUTCFinishCommand.this.printHeaderFields(conn.getHeaderFields());
            }
            this.cookie = WASUTCFinishCommand.this.getHeaderField(conn.getHeaderFields(), "Set-Cookie");
            while ((line = bufferedReader.readLine()) != null) {
                if (!WASUTCFinishCommand.this.isDebugEnabled) continue;
                System.out.println(line);
            }
            wr.close();
            bufferedReader.close();
        }

        String getCookie() {
            return this.cookie;
        }

        void setHeaderProperties(String key, String value) {
            this.reqProperties.setProperty(key, value);
        }
    }
}

