/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.task;

import com.ibm.etools.environment.resource.ResourceException;
import com.ibm.etools.webservice.was.consumption.command.AbstractEmitterCommand;
import com.ibm.etools.webservice.was.consumption.command.AbstractWSDL2JavaCommand;
import com.ibm.etools.webservice.was.consumption.registry.EnvironmentAdapterRegistry;
import com.ibm.etools.webservice.was.consumption.ui.plugin.WebServiceWasConsumptionUIPlugin;
import com.ibm.etools.webservice.was.consumption.ui.task.Stub2BeanInfo;
import com.ibm.etools.webservice.was.consumption.util.WSDLUtils;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.internal.plugin.JavaEMFNature;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JavaWSDLMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JaxrpcmapResource;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.PortMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.ServiceInterfaceMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.WSDLServiceName;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class Stub2BeanTask
extends AbstractDataModelOperation {
    private WebServicesParser webServicesParser;
    private JavaWSDLParameterBase javaWSDLParam_;
    private AbstractWSDL2JavaCommand wsdl2Java_;
    private String discoveredWsdlPortElementName;
    private Vector portTypes_ = new Vector();
    private String proxyBean_;
    private String proxyEndpoint_;
    private Vector proxyBeanList_ = new Vector();
    private Hashtable namespaceToPackageMapping;
    private Hashtable portTypeToSEIMapping;
    private Hashtable proxyBeanToSEIMapping_ = new Hashtable();
    private IProject clientProject_;
    private String setEndpointMethodName;
    private HashMap portsInJaxRPC = null;
    private String originalPartName = null;
    private JaxrpcmapResource jaxRPCMappingFile = null;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        File file;
        String inputWsdlLocation;
        Definition def;
        IEnvironment env = super.getEnvironment();
        if (this.javaWSDLParam_.getDevelopCodeGenOnly()) {
            return Status.OK_STATUS;
        }
        if (env == null) {
            env = EnvironmentAdapterRegistry.getInstance().getAdapter().getDefaultEnvironment();
        }
        if ((def = this.webServicesParser.getWSDLDefinition(inputWsdlLocation = this.javaWSDLParam_.getInputWsdlLocation())) == null && (file = new File(inputWsdlLocation)).exists()) {
            try {
                def = this.webServicesParser.getWSDLDefinition(file.toURL().toString());
            }
            catch (MalformedURLException murle) {
                Status errorStatus = new Status(4, "com.ibm.etools.webservice.was.creation.ui", 0, murle.getMessage(), (Throwable)murle);
                WebServiceWasConsumptionUIPlugin.getInstance().getLog().log((IStatus)errorStatus);
            }
        }
        HashMap pkg2nsMapping = this.javaWSDLParam_.getMappings();
        Map services = def.getServices();
        this.portsInJaxRPC = new HashMap();
        for (Service service : services.values()) {
            PortType portType;
            String servicePkgName = this.getPackageName(service.getQName().getNamespaceURI());
            if (servicePkgName == null) {
                servicePkgName = WSDLUtils.getPackageName(service, (Map)pkg2nsMapping);
            }
            this.originalPartName = service.getQName().getLocalPart();
            String serviceClassName = this.getClassNameFromJaxRpcMapping();
            String jndiName = this.originalPartName;
            Map ports = service.getPorts();
            if (this.discoveredWsdlPortElementName == null) {
                for (Port port : ports.values()) {
                    portType = port.getBinding().getPortType();
                    String seiName = this.getSEIName(portType.getQName().getNamespaceURI(), portType.getQName().getLocalPart());
                    if (seiName == null) continue;
                    this.portsInJaxRPC.put(port, seiName);
                }
            }
            for (Port port : ports.values()) {
                if (!serviceClassName.equals(port.getBinding().getPortType().getQName().getLocalPart())) continue;
                portType = port.getBinding().getPortType();
                String portTypePkgName = this.getPackageName(portType.getQName().getNamespaceURI());
                if (portTypePkgName == null) {
                    portTypePkgName = WSDLUtils.getPackageName(portType, (Map)pkg2nsMapping);
                }
                if (!servicePkgName.equals(portTypePkgName)) break;
                serviceClassName = String.valueOf(serviceClassName) + "_Service";
                break;
            }
            List portAccessorsInServiceClass = null;
            try {
                portAccessorsInServiceClass = this.getPortMethodsForServiceClass(servicePkgName, serviceClassName);
            }
            catch (CoreException coreException) {
                portAccessorsInServiceClass = Collections.EMPTY_LIST;
            }
            for (Port port : ports.values()) {
                Status errorStatus;
                String portTypeClassName;
                String tmpPortName = this.getJavaPortNameFromJaxRpcMapping(port.getName());
                StringBuffer portNameAccessorSB = new StringBuffer("get");
                portNameAccessorSB.append(tmpPortName.substring(0, 1).toUpperCase());
                if (tmpPortName.length() > 1) {
                    portNameAccessorSB.append(tmpPortName.substring(1));
                }
                String portNameAccessor = portNameAccessorSB.toString();
                if (this.discoveredWsdlPortElementName != null && !this.discoveredWsdlPortElementName.equals(port.getName()) || this.discoveredWsdlPortElementName == null && this.portsInJaxRPC.size() > 0 && !this.portsInJaxRPC.containsKey(port) || !portAccessorsInServiceClass.contains(portNameAccessor)) continue;
                PortType portType2 = port.getBinding().getPortType();
                QName portTypeQName = portType2.getQName();
                StringBuffer portTypeID = new StringBuffer();
                portTypeID.append(portTypeQName.getNamespaceURI());
                portTypeID.append("#");
                portTypeID.append(portTypeQName.getLocalPart());
                if (this.portTypes_.contains(portTypeID.toString())) continue;
                this.portTypes_.add(portTypeID.toString());
                Stub2BeanInfo stub2BeanInfo = new Stub2BeanInfo();
                stub2BeanInfo.setSetEndpointMethodName(this.setEndpointMethodName);
                stub2BeanInfo.setClientProject(this.clientProject_);
                String portTypePkgName = this.getPackageName(portType2.getQName().getNamespaceURI());
                if (portTypePkgName == null) {
                    portTypePkgName = WSDLUtils.getPackageName(portType2, (Map)pkg2nsMapping);
                }
                if (jndiName.equals(portTypeClassName = portTypeQName.getLocalPart()) && portTypePkgName.equals(servicePkgName)) {
                    portTypeClassName = this.javaWSDLParam_.getJ2eeLevel().equals("1.3") ? String.valueOf(portTypeClassName) + "_Port" : String.valueOf(portTypeClassName) + "_PortType";
                }
                portTypeClassName = this.xmlNameToJava(portTypeClassName);
                stub2BeanInfo.setPackage(portTypePkgName);
                stub2BeanInfo.setClass(String.valueOf(portTypeClassName) + "Proxy");
                this.proxyBean_ = portTypePkgName != null && portTypePkgName.trim().length() > 0 ? String.valueOf(portTypePkgName) + "." + stub2BeanInfo.getProxyClass() : stub2BeanInfo.getProxyClass();
                this.proxyEndpoint_ = this.getSoapAddressFromPort(port);
                this.proxyBeanList_.add(this.proxyBean_);
                String portName = this.xmlNameToJava(port.getName());
                serviceClassName = this.xmlNameToJava(serviceClassName);
                String seiName = this.getSEIName(portType2.getQName().getNamespaceURI(), portType2.getQName().getLocalPart());
                if (seiName != null) {
                    portTypeClassName = seiName.indexOf(".") != -1 ? seiName.substring(seiName.lastIndexOf(".") + 1) : seiName;
                    this.proxyBeanToSEIMapping_.put(this.proxyBean_, seiName);
                }
                stub2BeanInfo.addSEI(portTypePkgName, portTypeClassName, servicePkgName, serviceClassName, jndiName, portName);
                try {
                    IStatus proxyGenStatus = stub2BeanInfo.write(env, monitor);
                    if (proxyGenStatus.getSeverity() == 4) {
                        return proxyGenStatus;
                    }
                    if (this.discoveredWsdlPortElementName == null) continue;
                    return Status.OK_STATUS;
                }
                catch (CoreException ce) {
                    WebServiceWasConsumptionUIPlugin.getInstance().getLog().log(ce.getStatus());
                }
                catch (IOException ioe) {
                    errorStatus = new Status(4, "com.ibm.etools.webservice.was.creation.ui", 0, ioe.getMessage(), (Throwable)ioe);
                    WebServiceWasConsumptionUIPlugin.getInstance().getLog().log((IStatus)errorStatus);
                }
                catch (ResourceException re) {
                    errorStatus = new Status(4, "com.ibm.etools.webservice.was.creation.ui", 0, re.getMessage(), (Throwable)re);
                    WebServiceWasConsumptionUIPlugin.getInstance().getLog().log((IStatus)errorStatus);
                }
            }
        }
        return Status.OK_STATUS;
    }

    private final List getPortMethodsForServiceClass(String serviceClassPkgName, String serviceClassName) throws CoreException {
        EList allServiceMethods;
        ArrayList<String> allAccessorsForServiceClass = new ArrayList<String>();
        JavaEMFNature javaMOF = JavaEMFNature.createRuntime((IProject)this.clientProject_);
        JavaClass serviceClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(serviceClassPkgName, serviceClassName, javaMOF.getResourceSet());
        if (serviceClass != null && (allServiceMethods = serviceClass.getMethods()) != null) {
            for (Method serviceMethod : allServiceMethods) {
                String serviceMethodName = serviceMethod.getName();
                if (serviceMethod.isConstructor() || serviceMethod.isNative() || serviceMethod.getJavaVisibility().getValue() != 0 || !serviceMethodName.startsWith("get")) continue;
                allAccessorsForServiceClass.add(serviceMethodName);
            }
        }
        return allAccessorsForServiceClass;
    }

    private String getSoapAddressFromPort(Port port) {
        try {
            for (Object obj : port.getExtensibilityElements()) {
                if (!(obj instanceof SOAPAddress)) continue;
                SOAPAddress soapAddress = (SOAPAddress)obj;
                return soapAddress.getLocationURI();
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam_;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam_ = javaWSDLParam;
    }

    public void setWsdl2JavaCommand(AbstractEmitterCommand wsdl2Java) {
        if (wsdl2Java instanceof AbstractWSDL2JavaCommand) {
            this.wsdl2Java_ = (AbstractWSDL2JavaCommand)wsdl2Java;
        }
    }

    public WebServicesParser getWebServicesParser() {
        return this.webServicesParser;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    public void setDiscoveredWsdlPortElementName(String discoveredWsdlPortElementName) {
        this.discoveredWsdlPortElementName = discoveredWsdlPortElementName;
    }

    public void setClientProject(IProject clientProject) {
        this.clientProject_ = clientProject;
    }

    public String getProxyBean() {
        return this.proxyBean_;
    }

    public Vector getProxyBeanList() {
        return this.proxyBeanList_;
    }

    public void setSetEndpointMethodName(String setEndpointMethodName) {
        this.setEndpointMethodName = setEndpointMethodName;
    }

    private String xmlNameToJava(String xmlName) {
        String computedResult;
        if (this.wsdl2Java_ != null && (computedResult = this.wsdl2Java_.xmlNameToJava(xmlName)) != null) {
            return computedResult;
        }
        return xmlName;
    }

    private String getPackageName(String namespace) {
        if (this.namespaceToPackageMapping != null && namespace != null) {
            return (String)this.namespaceToPackageMapping.get(namespace);
        }
        return null;
    }

    private String getSEIName(String namespace, String localPart) {
        if (this.portTypeToSEIMapping != null && namespace != null && localPart != null) {
            return (String)this.portTypeToSEIMapping.get(String.valueOf(namespace) + ":" + localPart);
        }
        return null;
    }

    public void setNamespaceToPackageMapping(Hashtable namespaceToPackageMapping) {
        this.namespaceToPackageMapping = namespaceToPackageMapping;
    }

    public void setPortTypeToSEIMapping(Hashtable portTypeToSEIMapping) {
        this.portTypeToSEIMapping = portTypeToSEIMapping;
    }

    public String getProxyEndpoint() {
        return this.proxyEndpoint_;
    }

    public Hashtable getProxyBeanToSEIMapping() {
        return this.proxyBeanToSEIMapping_;
    }

    private String getJavaPortNameFromJaxRpcMapping(String tmpPortName) {
        if (this.jaxRPCMappingFile != null) {
            JavaWSDLMapping j2wMap = this.jaxRPCMappingFile.getJavaWSDLMapping();
            EList mappings = j2wMap.getInterfaceMappings();
            int i = 0;
            while (i < mappings.size()) {
                if (mappings.get(i) instanceof ServiceInterfaceMapping) {
                    ServiceInterfaceMapping siMap = (ServiceInterfaceMapping)mappings.get(i);
                    EList portMappings = siMap.getPortMappings();
                    int j = 0;
                    while (j < portMappings.size()) {
                        PortMapping portMapping = (PortMapping)portMappings.get(j);
                        if (portMapping.getPortName().equals(tmpPortName)) {
                            tmpPortName = portMapping.getJavaPortName();
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return tmpPortName;
    }

    private String getClassNameFromJaxRpcMapping() {
        String className = null;
        if (this.jaxRPCMappingFile != null) {
            JavaWSDLMapping j2wMap = this.jaxRPCMappingFile.getJavaWSDLMapping();
            EList mappings = j2wMap.getInterfaceMappings();
            int i = 0;
            while (i < mappings.size()) {
                ServiceInterfaceMapping siMap;
                WSDLServiceName wsdlServiceName;
                if (mappings.get(i) instanceof ServiceInterfaceMapping && (wsdlServiceName = (siMap = (ServiceInterfaceMapping)mappings.get(i)).getWsdlServiceName()).getLocalPart().equals(this.originalPartName)) {
                    String serviceInterface = siMap.getServiceInterface();
                    className = serviceInterface.substring(serviceInterface.lastIndexOf(".") + 1);
                    break;
                }
                ++i;
            }
        }
        return className;
    }

    public final JaxrpcmapResource getJaxRPCMappingFile() {
        return this.jaxRPCMappingFile;
    }

    public void setJaxRPCMappingFile(JaxrpcmapResource jaxRPCMappingFile) {
        this.jaxRPCMappingFile = jaxRPCMappingFile;
    }
}

