/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.task;

import com.ibm.etools.environment.resource.ResourceException;
import com.ibm.etools.webservice.was.consumption.command.ValidateEditCommand;
import com.ibm.etools.webservice.was.consumption.util.WSDLUtils;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.internal.plugin.JavaEMFNature;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;

public class Stub2BeanInfo {
    private final String NEW_LINE = System.getProperty("line.separator");
    private static final String ENABLE_LOCATOR_CACHING = System.getProperty("enableWSLocatorCaching");
    private int indentCount = 0;
    private String package_ = null;
    private Hashtable<String, String> listSEIMethodsWithNoInputParams = new Hashtable();
    private StringBuffer imports_ = new StringBuffer();
    private StringBuffer seis_ = new StringBuffer();
    private StringBuffer services_ = new StringBuffer();
    private StringBuffer jndiNames_ = new StringBuffer();
    private StringBuffer ports_ = new StringBuffer();
    private String class_ = "SEIBean";
    private Vector usedNames = new Vector();
    private IProject clientProject_;
    private String setEndpointMethodName_ = "setEndpoint";
    private boolean locatorCachingEnabled = false;

    public Stub2BeanInfo() {
        if (ENABLE_LOCATOR_CACHING != null && (ENABLE_LOCATOR_CACHING.equalsIgnoreCase("true") || ENABLE_LOCATOR_CACHING.equalsIgnoreCase("yes"))) {
            this.locatorCachingEnabled = true;
        }
    }

    public void setClientProject(IProject clientProject) {
        this.clientProject_ = clientProject;
    }

    public void setPackage(String pkgName) {
        if (pkgName != null && pkgName.length() > 0) {
            this.package_ = this.manglePackageName(pkgName);
        }
    }

    public void addImports(String pkgName, String className) {
        this.imports_.append(this.toFullyQualifiedClassName(pkgName, className));
        this.imports_.append(";");
    }

    public void addSEI(String seiPkgName, String seiClassName, String servicePkgName, String serviceClassName, String portName) {
        this.addSEI(seiPkgName, seiClassName, servicePkgName, serviceClassName, serviceClassName, portName);
    }

    public void addSEI(String seiPkgName, String seiClassName, String servicePkgName, String serviceClassName, String jndiName, String portName) {
        this.seis_.append(this.toFullyQualifiedClassName(seiPkgName, seiClassName));
        this.seis_.append(";");
        this.services_.append(this.toFullyQualifiedClassName(servicePkgName, serviceClassName));
        this.services_.append(";");
        this.jndiNames_.append(jndiName);
        this.jndiNames_.append(";");
        this.ports_.append(portName);
        this.ports_.append(";");
    }

    public void setClass(String className) {
        if (className != null && className.length() > 0) {
            this.class_ = this.mangleClassName(className);
        }
    }

    public String getProxyClass() {
        return this.class_;
    }

    public void setSetEndpointMethodName(String setEndpointMethodName) {
        this.setEndpointMethodName_ = setEndpointMethodName;
    }

    private String toFullyQualifiedClassName(String pkgName, String className) {
        StringBuffer sb = new StringBuffer();
        if (pkgName != null && pkgName.trim().length() > 0) {
            sb.append(this.manglePackageName(pkgName));
            sb.append(".");
        }
        sb.append(this.mangleClassName(className));
        return sb.toString();
    }

    private String getPackageName(String qname) {
        int index = qname.lastIndexOf(".");
        if (index != -1) {
            return qname.substring(0, index);
        }
        return "";
    }

    private String getClassName(String qname) {
        int index = qname.lastIndexOf(".");
        if (index != -1) {
            return qname.substring(index + 1, qname.length());
        }
        return qname;
    }

    private String manglePackageName(String s) {
        return this.replaceInvalidJavaChars(s);
    }

    private String mangleClassName(String s) {
        s = this.firstCharToUpperCase(WSDLUtils.resolveDotInPortName(s));
        return this.replaceInvalidJavaChars(s);
    }

    private String replaceInvalidJavaChars(String s) {
        char[] c = s.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (!Character.isJavaIdentifierPart(c[i])) {
                c[i] = 46;
            }
            ++i;
        }
        return new String(c);
    }

    private String firstCharToUpperCase(String s) {
        StringBuffer sb = new StringBuffer();
        sb.append(s.substring(0, 1).toUpperCase());
        sb.append(s.substring(1, s.length()));
        return sb.toString();
    }

    private String firstCharToLowerCase(String s) {
        StringBuffer sb = new StringBuffer();
        sb.append(s.substring(0, 1).toLowerCase());
        sb.append(s.substring(1, s.length()));
        return sb.toString();
    }

    private String trimArraySymbol(String s) {
        int index = s.indexOf("[");
        if (index != -1) {
            return s.substring(0, index);
        }
        return s;
    }

    private String getFullyQualifiedName(JavaHelpers javaHelpers) {
        if (javaHelpers.isPrimitive()) {
            return javaHelpers.getJavaName();
        }
        return javaHelpers.getQualifiedName();
    }

    public IStatus write(IEnvironment env, IProgressMonitor progressMonitor) throws CoreException, IOException, ResourceException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, "UTF-8");
        PrintWriter pw = new PrintWriter(new BufferedWriter(writer));
        this.writePackage(pw);
        this.writeImports(pw);
        this.writeClass(pw);
        pw.close();
        baos.close();
        byte[] bytes = baos.toByteArray();
        StringBuffer sb = new StringBuffer();
        if (this.package_ != null && this.package_.length() > 0) {
            sb.append(this.package_);
            sb.append(".");
        }
        sb.append(this.class_);
        sb = new StringBuffer(sb.toString().replace('.', '/'));
        sb.append(".java");
        JavaEMFNature javaMOF = JavaEMFNature.createRuntime((IProject)this.clientProject_);
        IPath proxyPath = JemProjectUtilities.getSourceFolderOrFirst((IProject)javaMOF.getProject(), null).getFile((IPath)new Path(sb.toString())).getFullPath();
        Vector<IPath> pathVector = new Vector<IPath>();
        pathVector.add(proxyPath);
        ValidateEditCommand validateEditCmd = new ValidateEditCommand();
        validateEditCmd.setEnvironment(env);
        validateEditCmd.setFileList(ValidateEditCommand.convertIPathToIFileArray(pathVector));
        IStatus validateStatus = validateEditCmd.execute(progressMonitor, null);
        if (!validateStatus.isOK()) {
            return validateStatus;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        FileResourceUtils.createFile((ResourceContext)((BaseEclipseEnvironment)env).getResourceContext(), (IPath)JemProjectUtilities.getSourceFolderOrFirst((IProject)javaMOF.getProject(), null).getFile((IPath)new Path(sb.toString())).getFullPath(), (InputStream)bais, (IProgressMonitor)progressMonitor, (IStatusHandler)env.getStatusHandler());
        return Status.OK_STATUS;
    }

    private void writePackage(Writer w) throws IOException {
        if (this.package_ != null && this.package_.length() > 0) {
            w.write("package ");
            w.write(this.package_);
            w.write(";");
            this.newLine(w);
        }
    }

    private void writeImports(Writer w) throws IOException {
        StringTokenizer st = new StringTokenizer(this.imports_.toString(), ";");
        while (st.hasMoreTokens()) {
            w.write("import ");
            w.write(st.nextToken());
            w.write(";");
            this.newLine(w);
        }
    }

    private void writeClass(Writer w) throws IOException, CoreException {
        this.newLine(w);
        w.write("public class ");
        w.write(this.class_);
        w.write(" ");
        StringTokenizer st = new StringTokenizer(this.seis_.toString(), ";");
        if (st.hasMoreTokens()) {
            w.write("implements ");
        }
        while (st.hasMoreTokens()) {
            w.write(st.nextToken());
            if (!st.hasMoreTokens()) continue;
            w.write(", ");
        }
        w.write(" {");
        this.incrementIndent();
        this.newLine(w);
        this.writeFieldsDeclarations(w);
        this.writeConstructor(w);
        this.writeInit(w);
        this.writeUseJNDI(w);
        this.writeGetSetEndpoint(w);
        this.writeSEIMethods(w);
        this.writeSEIGetters(w);
        this.decrementIndent();
        this.newLine(w);
        w.write("}");
    }

    private void writeFieldsDeclarations(Writer w) throws IOException {
        w.write("private boolean _useJNDI = true;");
        this.usedNames.add("_useJNDI");
        this.newLine(w);
        w.write("private String _endpoint = null;");
        this.usedNames.add("_endpoint");
        this.newLine(w);
        StringTokenizer st = new StringTokenizer(this.seis_.toString(), ";");
        StringTokenizer serviceTokens = new StringTokenizer(this.services_.toString(), ";");
        while (st.hasMoreTokens()) {
            String sei = st.nextToken();
            String service = serviceTokens.nextToken();
            w.write("private ");
            w.write(sei);
            w.write(" ");
            w.write("__" + this.firstCharToLowerCase(this.getClassName(sei)));
            this.usedNames.add("__" + this.firstCharToLowerCase(this.getClassName(sei)));
            w.write(" = null;");
            this.newLine(w);
            if (!this.locatorCachingEnabled) continue;
            w.write("private ");
            w.write(service);
            w.write(" ");
            w.write("__" + this.firstCharToLowerCase(this.getClassName(service)) + "Locator = null;");
            this.newLine(w);
            w.write("private static java.util.Stack ");
            w.write("__" + this.firstCharToLowerCase(this.getClassName(sei)) + "Stack");
            w.write(" = new java.util.Stack();");
            this.newLine(w);
        }
    }

    private void writeConstructor(Writer w) throws IOException {
        this.newLine(w);
        w.write("public ");
        w.write(this.class_);
        w.write("() {");
        this.incrementIndent();
        this.newLine(w);
        w.write("_init");
        w.write(this.class_);
        w.write("();");
        this.decrementIndent();
        this.newLine(w);
        w.write("}");
        this.newLine(w);
    }

    private void writeInit(Writer w) throws IOException {
        String seiName;
        this.newLine(w);
        w.write("private void _init");
        w.write(this.class_);
        w.write("() {");
        this.newLine(w);
        this.incrementIndent();
        this.newLine(w);
        w.write("if (_useJNDI) {");
        this.incrementIndent();
        this.newLine(w);
        w.write("try {");
        this.incrementIndent();
        this.newLine(w);
        StringTokenizer st = new StringTokenizer(this.seis_.toString(), ";");
        StringTokenizer serviceTokens = new StringTokenizer(this.services_.toString(), ";");
        StringTokenizer jndiNameTokens = new StringTokenizer(this.jndiNames_.toString(), ";");
        StringTokenizer portTokens = new StringTokenizer(this.ports_.toString(), ";");
        if (this.locatorCachingEnabled) {
            while (st.hasMoreTokens()) {
                String sei = this.firstCharToLowerCase(this.getClassName(st.nextToken()));
                String service = serviceTokens.nextToken();
                String portType = portTokens.nextToken();
                w.write("try {");
                this.incrementIndent();
                this.newLine(w);
                w.write("__" + this.firstCharToLowerCase(this.getClassName(service)) + "Locator = (");
                w.write(service);
                w.write(")__" + sei + "Stack.pop();");
                this.decrementIndent();
                this.newLine(w);
                w.write("}");
                this.newLine(w);
                w.write("catch(java.util.EmptyStackException emptyStackEx) {");
                this.incrementIndent();
                this.newLine(w);
                w.write("javax.naming.InitialContext ctx = new javax.naming.InitialContext();");
                this.newLine(w);
                w.write("__" + this.firstCharToLowerCase(this.getClassName(service)) + "Locator = ((");
                w.write(service);
                w.write(")ctx.lookup(\"java:comp/env/service/");
                w.write(jndiNameTokens.nextToken());
                w.write("\"));");
                this.decrementIndent();
                this.newLine(w);
                w.write("}");
                this.newLine(w);
                w.write("__" + sei);
                w.write(" = __" + this.firstCharToLowerCase(this.getClassName(service)) + "Locator.get");
                w.write(this.mangleClassName(portType));
                w.write("();");
                this.newLine(w);
            }
        } else {
            if (st.hasMoreTokens()) {
                w.write("javax.naming.InitialContext ctx = new javax.naming.InitialContext();");
                this.newLine(w);
            }
            while (st.hasMoreTokens()) {
                w.write("__" + this.firstCharToLowerCase(this.getClassName(st.nextToken())));
                w.write(" = ((");
                w.write(serviceTokens.nextToken());
                w.write(")ctx.lookup(\"java:comp/env/service/");
                w.write(jndiNameTokens.nextToken());
                w.write("\")).get");
                w.write(this.mangleClassName(portTokens.nextToken()));
                w.write("();");
            }
        }
        this.decrementIndent();
        this.newLine(w);
        w.write("}");
        this.newLine(w);
        w.write("catch (javax.naming.NamingException namingException) {}");
        this.newLine(w);
        w.write("catch (javax.xml.rpc.ServiceException serviceException) {}");
        this.decrementIndent();
        this.newLine(w);
        w.write("}");
        this.newLine(w);
        StringTokenizer st1 = new StringTokenizer(this.seis_.toString(), ";");
        while (st1.hasMoreTokens()) {
            seiName = "__" + this.firstCharToLowerCase(this.getClassName(st1.nextToken()));
            w.write("if (");
            w.write(seiName);
            w.write(" == null) {");
            this.incrementIndent();
            this.newLine(w);
            w.write("try {");
            this.incrementIndent();
            this.newLine(w);
            st = new StringTokenizer(this.seis_.toString(), ";");
            serviceTokens = new StringTokenizer(this.services_.toString(), ";");
            portTokens = new StringTokenizer(this.ports_.toString(), ";");
            while (st.hasMoreTokens()) {
                w.write("__" + this.firstCharToLowerCase(this.getClassName(st.nextToken())));
                w.write(" = (new ");
                w.write(serviceTokens.nextToken());
                w.write("Locator()).get");
                w.write(this.mangleClassName(portTokens.nextToken()));
                w.write("();");
                this.newLine(w);
            }
            this.decrementIndent();
            this.newLine(w);
            w.write("}");
            this.newLine(w);
            w.write("catch (javax.xml.rpc.ServiceException serviceException) {}");
            this.decrementIndent();
            this.newLine(w);
            w.write("}");
            this.newLine(w);
        }
        st = new StringTokenizer(this.seis_.toString(), ";");
        while (st.hasMoreTokens()) {
            seiName = "__" + this.firstCharToLowerCase(this.getClassName(st.nextToken()));
            w.write("if (");
            w.write(seiName);
            w.write(" != null) {");
            this.incrementIndent();
            this.newLine(w);
            w.write("if (_endpoint != null)");
            this.incrementIndent();
            this.newLine(w);
            w.write("((javax.xml.rpc.Stub)");
            w.write(seiName);
            w.write(")._setProperty(\"javax.xml.rpc.service.endpoint.address\", _endpoint);");
            this.decrementIndent();
            this.newLine(w);
            w.write("else");
            this.incrementIndent();
            this.newLine(w);
            w.write("_endpoint = (String)((javax.xml.rpc.Stub)");
            w.write(seiName);
            w.write(")._getProperty(\"javax.xml.rpc.service.endpoint.address\");");
            this.decrementIndent();
            this.decrementIndent();
            this.newLine(w);
            w.write("}");
            this.newLine(w);
        }
        this.decrementIndent();
        this.newLine(w);
        w.write("}");
        this.newLine(w);
        this.newLine(w);
    }

    private void writeSetPropertyEndpoint(Writer w) throws IOException {
        StringTokenizer st = new StringTokenizer(this.seis_.toString(), ";");
        while (st.hasMoreTokens()) {
            String seiName = "__" + this.firstCharToLowerCase(this.getClassName(st.nextToken()));
            if (this.locatorCachingEnabled) {
                w.write("if (");
                w.write(seiName);
                w.write(" == null) {");
                this.incrementIndent();
                this.newLine(w);
                w.write("_init");
                w.write(this.class_);
                w.write("();");
                this.decrementIndent();
                this.newLine(w);
                w.write("}");
                this.newLine(w);
            }
            w.write("if (");
            w.write(seiName);
            w.write(" != null)");
            this.incrementIndent();
            this.newLine(w);
            w.write("((javax.xml.rpc.Stub)");
            w.write(seiName);
            w.write(")._setProperty(\"javax.xml.rpc.service.endpoint.address\", _endpoint);");
            this.decrementIndent();
            this.newLine(w);
        }
    }

    private void writeUseJNDI(Writer w) throws IOException {
        this.newLine(w);
        w.write("public void useJNDI(boolean useJNDI) {");
        this.incrementIndent();
        this.newLine(w);
        w.write("_useJNDI = useJNDI;");
        this.newLine(w);
        StringTokenizer st = new StringTokenizer(this.seis_.toString(), ";");
        while (st.hasMoreTokens()) {
            w.write("__" + this.firstCharToLowerCase(this.getClassName(st.nextToken())));
            w.write(" = null;");
            this.newLine(w);
        }
        this.decrementIndent();
        this.newLine(w);
        w.write("}");
        this.newLine(w);
    }

    private void writeSEIGetters(Writer w) throws IOException {
        StringTokenizer st = new StringTokenizer(this.seis_.toString(), ";");
        while (st.hasMoreTokens()) {
            String sei = st.nextToken();
            String seiClassName = this.getClassName(sei);
            String seiFieldName = "__" + this.firstCharToLowerCase(seiClassName);
            this.newLine(w);
            w.write("public ");
            w.write(sei);
            String sSEIGetterName = "get" + seiClassName;
            if (this.listSEIMethodsWithNoInputParams.get(sSEIGetterName) == null) {
                w.write(" " + sSEIGetterName);
            } else {
                w.write(" _" + sSEIGetterName);
            }
            w.write("() {");
            this.incrementIndent();
            this.newLine(w);
            w.write("if (");
            w.write(seiFieldName);
            w.write(" == null)");
            this.incrementIndent();
            this.newLine(w);
            w.write("_init");
            w.write(this.class_);
            w.write("();");
            this.decrementIndent();
            this.newLine(w);
            w.write("return ");
            w.write(seiFieldName);
            w.write(";");
            this.decrementIndent();
            this.newLine(w);
            w.write("}");
            this.newLine(w);
        }
    }

    private void writeSEIMethods(Writer w) throws IOException, CoreException {
        this.newLine(w);
        if (this.clientProject_ == null) {
            return;
        }
        JavaEMFNature javaMOF = JavaEMFNature.createRuntime((IProject)this.clientProject_);
        StringTokenizer st = new StringTokenizer(this.seis_.toString(), ";");
        StringTokenizer services = new StringTokenizer(this.services_.toString(), ";");
        while (st.hasMoreTokens()) {
            String sei = st.nextToken();
            String service = services.nextToken();
            JavaClass javaClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(this.getPackageName(sei), this.getClassName(sei), javaMOF.getResourceSet());
            if (javaClass == null) continue;
            EList methods = javaClass.getMethods();
            for (Method method : methods) {
                if (method.isConstructor() || method.isNative() || method.getJavaVisibility().getValue() != 0) continue;
                this.writeSEIMethods(w, javaClass, method, this.getClassName(sei), this.getClassName(service));
            }
        }
    }

    private void writeSEIMethods(Writer w, JavaClass javaClass, Method method, String seiClassName, String serviceClassName) throws IOException {
        w.write("public ");
        if (method.isVoid()) {
            w.write("void ");
        } else {
            w.write(this.getFullyQualifiedName(method.getReturnType()));
            w.write(" ");
        }
        String sMethodName = method.getName();
        w.write(sMethodName);
        w.write("(");
        JavaParameter[] inputParams = method.listParametersWithoutReturn();
        if (inputParams.length == 0) {
            this.listSEIMethodsWithNoInputParams.put(sMethodName, sMethodName);
        }
        int i = 0;
        while (i < inputParams.length) {
            if (i > 0) {
                w.write(", ");
            }
            JavaHelpers javaHelpers = inputParams[i].getJavaType();
            w.write(this.getFullyQualifiedName(javaHelpers));
            w.write(" ");
            w.write(this.getUnusedName(this.getClassName(inputParams[i].getQualifiedName())));
            ++i;
        }
        w.write(")");
        EList exceptions = method.getJavaExceptions();
        if (!exceptions.isEmpty()) {
            w.write(" throws ");
        }
        Iterator it = exceptions.iterator();
        while (it.hasNext()) {
            JavaClass exception = (JavaClass)it.next();
            w.write(exception.getQualifiedNameForReflection());
            if (!it.hasNext()) continue;
            w.write(", ");
        }
        w.write("{");
        this.incrementIndent();
        this.newLine(w);
        String stubName = "__" + this.firstCharToLowerCase(javaClass.getName());
        w.write("if (");
        w.write(stubName);
        w.write(" == null)");
        this.incrementIndent();
        this.newLine(w);
        w.write("_init");
        w.write(this.class_);
        w.write("();");
        this.decrementIndent();
        this.newLine(w);
        if (this.locatorCachingEnabled) {
            w.write("try {");
            this.incrementIndent();
            this.newLine(w);
        }
        if (!method.isVoid()) {
            w.write("return ");
        }
        w.write(stubName);
        w.write(".");
        w.write(method.getName());
        w.write("(");
        int i2 = 0;
        while (i2 < inputParams.length) {
            if (i2 > 0) {
                w.write(", ");
            }
            w.write(this.getUnusedName(this.getClassName(inputParams[i2].getQualifiedName())));
            ++i2;
        }
        w.write(");");
        if (this.locatorCachingEnabled) {
            this.decrementIndent();
            this.newLine(w);
            w.write("}");
            this.newLine(w);
            w.write("catch (java.rmi.RemoteException remoteEx) {");
            this.incrementIndent();
            this.newLine(w);
            w.write("throw remoteEx;");
            this.decrementIndent();
            this.newLine(w);
            w.write("}");
            this.newLine(w);
            w.write("finally {");
            this.incrementIndent();
            this.newLine(w);
            String locator = "__" + this.firstCharToLowerCase(serviceClassName) + "Locator";
            w.write("if (" + locator + " != null) {");
            this.incrementIndent();
            this.newLine(w);
            String stackName = "__" + this.firstCharToLowerCase(seiClassName) + "Stack";
            w.write(String.valueOf(stackName) + ".push(" + locator + ");");
            this.decrementIndent();
            this.newLine(w);
            w.write("}");
            this.newLine(w);
            w.write(String.valueOf(stubName) + " = null;");
            this.newLine(w);
            w.write(String.valueOf(locator) + " = null;");
            this.decrementIndent();
            this.newLine(w);
            w.write("}");
        }
        this.decrementIndent();
        this.newLine(w);
        w.write("}");
        this.newLine(w);
        this.newLine(w);
    }

    private void writeGetSetEndpoint(Writer w) throws IOException {
        this.newLine(w);
        w.write("public String getEndpoint() {");
        this.incrementIndent();
        this.newLine(w);
        w.write("return _endpoint;");
        this.decrementIndent();
        this.newLine(w);
        w.write("}");
        this.newLine(w);
        this.newLine(w);
        w.write("public void ");
        w.write(this.setEndpointMethodName_);
        w.write("(String endpoint) {");
        this.incrementIndent();
        this.newLine(w);
        w.write("_endpoint = endpoint;");
        this.newLine(w);
        this.writeSetPropertyEndpoint(w);
        this.decrementIndent();
        this.newLine(w);
        w.write("}");
        this.newLine(w);
    }

    private void createParentFolder(IResource res) throws CoreException {
        IFolder folder;
        IContainer parent = res.getParent();
        if (parent != null && parent != res && parent instanceof IFolder && !(folder = (IFolder)parent).exists()) {
            this.createParentFolder((IResource)folder);
            folder.create(true, true, null);
        }
    }

    private void incrementIndent() {
        ++this.indentCount;
    }

    private void decrementIndent() {
        --this.indentCount;
    }

    private void indent(Writer w) throws IOException {
        int i = 0;
        while (i < this.indentCount) {
            w.write("  ");
            ++i;
        }
    }

    private void newLine(Writer w) throws IOException {
        w.write(this.NEW_LINE);
        this.indent(w);
    }

    private String getUnusedName(String name) {
        if (this.usedNames.contains(name)) {
            int i = 0;
            while (i < 100) {
                String newName = new StringBuffer(name).append(String.valueOf(i)).toString();
                if (!this.usedNames.contains(newName)) {
                    return newName;
                }
                ++i;
            }
        }
        return name;
    }
}

