/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.task;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.webservice.was.consumption.registry.EnvironmentAdapterRegistry;
import com.ibm.etools.webservice.was.consumption.util.PlatformUtils;
import com.ibm.etools.webservice.was.consumption.util.WSDLUtils;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import com.ibm.etools.webservice.was.utils.WSDLCopierUtil;
import javax.wsdl.Definition;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.util.WSDLCopier;

public class CopyClientWSDLTask
extends AbstractDataModelOperation {
    private final String WSDL_FOLDER = "wsdl";
    private JavaWSDLParameterBase javaWSDLParam = null;
    private IProject proxyProject;
    private WebServicesParser wSParser;
    private String wSDLServicePathname;
    private String wSDLServiceURL;
    private String wsdlRelativePath;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IVirtualFolder ivFolder;
        Definition definition;
        byte type = this.javaWSDLParam.getServerSide();
        IEnvironment env = super.getEnvironment();
        if (env == null) {
            env = EnvironmentAdapterRegistry.getInstance().getAdapter().getDefaultEnvironment();
        }
        if (type == 3) {
            return Status.OK_STATUS;
        }
        IProject project = this.proxyProject;
        String wsdlURL = this.javaWSDLParam.getInputWsdlLocation();
        if (wsdlURL.indexOf(58) < 0 || wsdlURL.indexOf("platform:/resource") >= 0) {
            wsdlURL = PlatformUtils.getFileURLFromPlatform(wsdlURL);
        }
        if ((definition = this.wSParser.getWSDLDefinition(wsdlURL)) == null) {
            IStatus status = StatusUtils.errorStatus((String)Messages.MSG_ERROR_WSDL_NO_DEFINITION);
            env.getStatusHandler().reportError(status);
            return status;
        }
        IPath wsdlPath = project.getFullPath();
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        String infDir = "WEB-INF";
        if (type == 0) {
            try {
                ivFolder = J2EEUtils.getWebDeploymentDescriptorFolder((IVirtualComponent)component);
                wsdlPath = wsdlPath.append(ivFolder.getProjectRelativePath());
                wsdlPath = wsdlPath.append("wsdl").append(WSDLUtils.getWSDLName(wsdlURL));
            }
            catch (Exception e) {
                IStatus status = StatusUtils.errorStatus((String)Messages.MSG_ERROR_WRITE_WSDL, (Throwable)e);
                env.getStatusHandler().reportError(status);
                return status;
            }
        }
        if (type == 4 || type == 5) {
            try {
                ivFolder = null;
                if (type == 4) {
                    ivFolder = J2EEUtils.getEJBDeploymentDescriptorFolder((IVirtualComponent)component);
                } else if (type == 5) {
                    ivFolder = J2EEUtils.getAppClientDeploymentDescriptorFolder((IVirtualComponent)component);
                }
                wsdlPath = wsdlPath.append(ivFolder.getProjectRelativePath());
                wsdlPath = wsdlPath.append("wsdl");
                wsdlPath = wsdlPath.addTrailingSeparator();
                wsdlPath = wsdlPath.append(WSDLUtils.getWSDLName(wsdlURL));
                infDir = "META-INF";
            }
            catch (Exception e) {
                IStatus status = StatusUtils.errorStatus((String)Messages.MSG_ERROR_WRITE_WSDL, (Throwable)e);
                env.getStatusHandler().reportError(status);
                return status;
            }
        }
        if (wsdlPath == null) {
            IStatus status = StatusUtils.errorStatus((String)Messages.MSG_ERROR_WRITE_WSDL);
            env.getStatusHandler().reportError(status);
            return status;
        }
        String wsdlLocation = null;
        try {
            wsdlLocation = PlatformUtils.getPlatformURL(wsdlPath);
            this.javaWSDLParam.setOutputWsdlLocation(wsdlLocation);
            this.wSDLServicePathname = wsdlPath.toString();
            if (wsdlPath != null) {
                this.wSDLServiceURL = PlatformUtils.getPlatformFromPath(wsdlPath.toString());
            }
            this.wsdlRelativePath = null;
            WSDLCopier wsdlCopier = new WSDLCopier(this.wSParser);
            wsdlCopier.setSourceURI(WSDLCopierUtil.uriCreate((String)wsdlURL), definition);
            wsdlCopier.setTargetFolderURI(WSDLCopierUtil.uriCreate((String)WSDLCopierUtil.getBaseURI((String)this.wSDLServiceURL)));
            wsdlCopier.setTargetFilename(WSDLCopierUtil.getLocalname((String)this.wSDLServiceURL));
            IStatus status = WSDLCopierUtil.run((WSDLCopier)wsdlCopier, (IProgressMonitor)monitor);
            if (status != null && status.getSeverity() == 4) {
                return status;
            }
            IPath relativePath = wsdlCopier.getRelativePath();
            if (relativePath.segmentCount() > 1) {
                IPath fullRelativePath = new Path(infDir).append("wsdl").append(relativePath);
                this.wsdlRelativePath = fullRelativePath.toString();
            }
        }
        catch (Exception e) {
            IStatus status = StatusUtils.errorStatus((String)Messages.MSG_ERROR_WRITE_WSDL, (Throwable)e);
            env.getStatusHandler().reportError(status);
            return status;
        }
        return Status.OK_STATUS;
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public String getWSDLServicePathname() {
        return this.wSDLServicePathname;
    }

    public String getWSDLServiceURL() {
        return this.wSDLServiceURL;
    }

    public void setProxyProject(IProject proxyProject) {
        this.proxyProject = proxyProject;
    }

    public void setWebServicesParser(WebServicesParser parser) {
        this.wSParser = parser;
    }

    public String getWsdlRelativePath() {
        return this.wsdlRelativePath;
    }
}

