/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.task;

import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.ws.internal.consumption.command.common.BuildProjectCommand;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class BuildWASProjectTask
extends AbstractDataModelOperation {
    private JavaWSDLParameterBase javaParameter_;
    private IProject project;
    private boolean compileOnlyWhenAutoBuildOff = false;

    public BuildWASProjectTask() {
    }

    public BuildWASProjectTask(boolean compileOnlyWhenAutoBuildOff) {
        this.compileOnlyWhenAutoBuildOff = compileOnlyWhenAutoBuildOff;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus status = Status.OK_STATUS;
        if (this.compileOnlyWhenAutoBuildOff && ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            return status;
        }
        IEnvironment env = super.getEnvironment();
        switch (this.javaParameter_.getServerSide()) {
            case 1: {
                break;
            }
            case 2: 
            case 4: {
                IProject ejbClientProject = this.getClientEJBJarProject(this.project);
                if (ejbClientProject == null || ejbClientProject == this.project) break;
                BuildProjectCommand buildTask = new BuildProjectCommand();
                buildTask.setProject(ejbClientProject);
                buildTask.setForceBuild(true);
                buildTask.setEnvironment(env);
                status = buildTask.execute(monitor, adaptable);
                break;
            }
        }
        BuildProjectCommand buildTask = new BuildProjectCommand();
        buildTask.setProject(this.project);
        buildTask.setForceBuild(true);
        buildTask.setEnvironment(env);
        return buildTask.execute(monitor, adaptable);
    }

    private IProject getClientEJBJarProject(IProject ejbProject) {
        EJBArtifactEdit artifactEdit = null;
        if (!J2EEUtils.isEJBProject((IProject)ejbProject)) {
            return null;
        }
        try {
            artifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)ejbProject);
            IVirtualComponent ejbClientModule = artifactEdit.getEJBClientJarModule();
            if (ejbClientModule != null && ejbClientModule.exists()) {
                IProject iProject = ejbClientModule.getProject();
                return iProject;
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
        return null;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWsdlParam) {
        this.javaParameter_ = javaWsdlParam;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

