/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.command;

import com.ibm.ast.ws.rd.utils.WRDStatusHandler;
import com.ibm.etools.j2ee.reference.EJB3ServiceReferenceDataModel;
import com.ibm.etools.j2ee.reference.ServiceReferenceDataModel;
import com.ibm.etools.webservice.was.consumption.command.AbstractEmitterCommand;
import com.ibm.etools.webservice.was.consumption.command.AbstractEmitterLauncherCommand;
import com.ibm.etools.webservice.was.consumption.command.AbstractWSDL2JavaCommand;
import com.ibm.etools.webservice.was.consumption.command.InitializeEmitterExtensionCommand;
import com.ibm.etools.webservice.was.consumption.command.VerifyIBMJRECommand;
import com.ibm.etools.webservice.was.consumption.registry.EnvironmentAdapterRegistry;
import com.ibm.etools.webservice.was.consumption.ui.command.DefaultsForClientJavaWSDLCommand;
import com.ibm.etools.webservice.was.consumption.ui.command.RetrieveJAXRPCMappingInfoCommand;
import com.ibm.etools.webservice.was.consumption.ui.command.WASClientDefaultingCommand;
import com.ibm.etools.webservice.was.consumption.ui.task.CopyClientWSDLTask;
import com.ibm.etools.webservice.was.consumption.ui.task.DefaultsForHTTPBasicAuthTask;
import com.ibm.etools.webservice.was.consumption.ui.task.Stub2BeanTask;
import com.ibm.etools.webservice.was.consumption.ui.task.ValidateWSDLCommand;
import com.ibm.etools.webservice.was.consumption.util.WSDLUtils;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.ws.ast.st.core.WASRuntimeUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.internal.webservices.WebServiceClientGenerator;
import org.eclipse.jst.j2ee.internal.webservices.WebServicesClientDataHelper;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.ws.internal.common.StringToIProjectTransformer;
import org.eclipse.jst.ws.internal.consumption.command.common.BuildProjectCommand;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class WASClientGenerator
extends WebServiceClientGenerator {
    private String pluginId_ = "com.ibm.etools.webservice.was.consumption.ui";
    private String portName_;
    private AbstractWSDL2JavaCommand wsdl2java_;
    private JavaWSDLParameterBase javaWsdlParam_;

    public IStatus genWebServiceClientArtifacts(WebServicesClientDataHelper dataModel, String portName) {
        this.portName_ = portName;
        return this.genWebServiceClientArtifacts(dataModel);
    }

    public IStatus genWebServiceClientArtifacts(WebServicesClientDataHelper dataModel) {
        String wsdlURL = dataModel.getWSDLUrl();
        String project = dataModel.getProjectName();
        String serviceQName = dataModel.getServiceQName();
        IStatus status = Status.OK_STATUS;
        NullProgressMonitor monitor = new NullProgressMonitor();
        IAdaptable adaptable = null;
        IProject iProject = (IProject)new StringToIProjectTransformer().transform((Object)project);
        IEnvironment env = EnvironmentAdapterRegistry.getInstance().getAdapter().getDefaultEnvironment((IStatusHandler)new WRDStatusHandler());
        VerifyIBMJRECommand verifyJRECommand = new VerifyIBMJRECommand("com.ibm.etools.webservice.was.consumption.ui.ClientGenerator");
        verifyJRECommand.setEnvironment(env);
        status = verifyJRECommand.execute((IProgressMonitor)monitor, adaptable);
        if (status.getSeverity() != 0) {
            return status;
        }
        InitializeEmitterExtensionCommand initEmitterCommand = new InitializeEmitterExtensionCommand();
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)iProject);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return status;
        }
        if (WASRuntimeUtil.isWASv61Runtime((IRuntime)FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)facetedProject.getRuntime()))) {
            initEmitterCommand.setServiceServer("com.ibm.ws.ast.st.v61.server.base");
            initEmitterCommand.setServiceJ2EEVersion("1.4");
        } else if (WASRuntimeUtil.isWASv60Runtime((IRuntime)FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)facetedProject.getRuntime()))) {
            initEmitterCommand.setServiceServer("com.ibm.ws.ast.st.v6.server.base");
            initEmitterCommand.setServiceJ2EEVersion("1.4");
        } else {
            initEmitterCommand.setServiceServer("com.ibm.ws.ast.st.v61.server.base");
            initEmitterCommand.setServiceJ2EEVersion("1.4");
        }
        status = initEmitterCommand.execute((IProgressMonitor)monitor, adaptable);
        if (status.getSeverity() != 0) {
            return status;
        }
        WASClientDefaultingCommand wasClientDefaultingCommand = new WASClientDefaultingCommand();
        wasClientDefaultingCommand.setJavaWSDLParam(initEmitterCommand.getJavaWSDLParam());
        wasClientDefaultingCommand.setClientProject(iProject);
        wasClientDefaultingCommand.setWebServicesParser((WebServicesParser)new WebServicesParserExt());
        wasClientDefaultingCommand.setWsdlURL(wsdlURL);
        wasClientDefaultingCommand.setTestProxySelected(false);
        wasClientDefaultingCommand.setIsClientScenario(true);
        wasClientDefaultingCommand.setGenerateProxy(true);
        status = wasClientDefaultingCommand.execute((IProgressMonitor)monitor, adaptable);
        if (status.getSeverity() != 0) {
            return status;
        }
        DefaultsForHTTPBasicAuthTask httpCommand = new DefaultsForHTTPBasicAuthTask();
        httpCommand.setJavaWSDLParam(wasClientDefaultingCommand.getJavaWSDLParam());
        httpCommand.setWsdlServiceURL(wasClientDefaultingCommand.getWsdlURL());
        httpCommand.setWSParser(wasClientDefaultingCommand.getWebServicesParser());
        status = httpCommand.execute((IProgressMonitor)monitor, adaptable);
        if (status.getSeverity() != 0) {
            return status;
        }
        DefaultsForClientJavaWSDLCommand defClientCommand = new DefaultsForClientJavaWSDLCommand();
        defClientCommand.setJavaWSDLParam(httpCommand.getJavaWSDLParam());
        defClientCommand.setProxyProject(wasClientDefaultingCommand.getClientProject());
        defClientCommand.setWSDLServiceURL(wasClientDefaultingCommand.getWsdlURL());
        status = defClientCommand.execute((IProgressMonitor)monitor, adaptable);
        if (status.getSeverity() != 0) {
            return status;
        }
        ValidateWSDLCommand valWSDLCommand = new ValidateWSDLCommand();
        valWSDLCommand.setWsdlURI(wasClientDefaultingCommand.getWsdlURL());
        valWSDLCommand.setWebServicesParser(wasClientDefaultingCommand.getWebServicesParser());
        status = valWSDLCommand.execute((IProgressMonitor)monitor, adaptable);
        if (status.getSeverity() != 0) {
            return status;
        }
        CopyClientWSDLTask copyCommand = new CopyClientWSDLTask();
        copyCommand.setJavaWSDLParam(defClientCommand.getJavaWSDLParam());
        copyCommand.setWebServicesParser(wasClientDefaultingCommand.getWebServicesParser());
        copyCommand.setProxyProject(wasClientDefaultingCommand.getClientProject());
        status = copyCommand.execute((IProgressMonitor)monitor, adaptable);
        if (status.getSeverity() != 0) {
            return status;
        }
        AbstractEmitterLauncherCommand w2jCommand = new AbstractEmitterLauncherCommand();
        JavaWSDLParameterBase javaWSDLParameter = copyCommand.getJavaWSDLParam();
        w2jCommand.setEmitterData((Object)javaWSDLParameter);
        w2jCommand.setWsdl2JavaCommand(initEmitterCommand.getWsdl2JavaCommand());
        w2jCommand.setEnvironment(env);
        try {
            status = w2jCommand.execute((IProgressMonitor)monitor, adaptable);
        }
        catch (Exception e) {
            e.printStackTrace();
            return status;
        }
        if (status.getSeverity() != 0) {
            return status;
        }
        BuildProjectCommand buildCommand = new BuildProjectCommand();
        buildCommand.setProject(wasClientDefaultingCommand.getClientProject());
        buildCommand.setForceBuild(true);
        status = buildCommand.execute((IProgressMonitor)monitor, adaptable);
        if (status.getSeverity() != 0) {
            return status;
        }
        RetrieveJAXRPCMappingInfoCommand retrieveJaxRpcCmd = new RetrieveJAXRPCMappingInfoCommand();
        retrieveJaxRpcCmd.setEnvironment(env);
        retrieveJaxRpcCmd.setJavaWSDLParam(copyCommand.getJavaWSDLParam());
        retrieveJaxRpcCmd.setProject(wasClientDefaultingCommand.getClientProject());
        status = retrieveJaxRpcCmd.execute((IProgressMonitor)monitor, adaptable);
        if (status.getSeverity() != 0) {
            return status;
        }
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)iProject);
        if (provider != null && provider.getModelObject() != null && provider.getModelObject() instanceof EJBJar) {
            ((EJB3ServiceReferenceDataModel)dataModel).setProperty("ServiceReferenceDataModel.JAX_RPC_MAPPING_FILE", (Object)retrieveJaxRpcCmd.getMappingFile());
        } else {
            ((ServiceReferenceDataModel)dataModel).setProperty("ServiceReferenceDataModel.JAX_RPC_MAPPING_FILE", (Object)retrieveJaxRpcCmd.getMappingFile());
        }
        Stub2BeanTask s2bCommand = new Stub2BeanTask();
        s2bCommand.setJavaWSDLParam(copyCommand.getJavaWSDLParam());
        s2bCommand.setWsdl2JavaCommand(initEmitterCommand.getWsdl2JavaCommand());
        s2bCommand.setSetEndpointMethodName(defClientCommand.getSetEndpointMethodName());
        s2bCommand.setWebServicesParser(wasClientDefaultingCommand.getWebServicesParser());
        s2bCommand.setClientProject(wasClientDefaultingCommand.getClientProject());
        s2bCommand.setNamespaceToPackageMapping(retrieveJaxRpcCmd.getNamespaceToPackageMapping());
        s2bCommand.setPortTypeToSEIMapping(retrieveJaxRpcCmd.getPortTypeToSEIMapping());
        s2bCommand.setJaxRPCMappingFile(retrieveJaxRpcCmd.getJaxRPCMappingFile());
        if (this.portName_ != null) {
            s2bCommand.setDiscoveredWsdlPortElementName(this.portName_);
        }
        if ((status = s2bCommand.execute((IProgressMonitor)monitor, adaptable)).getSeverity() != 0) {
            return status;
        }
        if (serviceQName != null) {
            AbstractEmitterCommand obj = initEmitterCommand.getWsdl2JavaCommand();
            if (obj != null && obj instanceof AbstractWSDL2JavaCommand) {
                this.wsdl2java_ = (AbstractWSDL2JavaCommand)obj;
            }
            this.javaWsdlParam_ = initEmitterCommand.getJavaWSDLParam();
            InterfaceNames interfaceNames = this.calculateSIandSEIName(wasClientDefaultingCommand.getWsdlURL(), serviceQName, wasClientDefaultingCommand.getWebServicesParser());
            String siName = interfaceNames.getSiName();
            String[] seiNames = interfaceNames.getSeiNames();
            if (siName == null || siName.length() == 0 || seiNames == null || seiNames.length == 0) {
                return new Status(4, this.pluginId_, 0, "Problems!!", null);
            }
            dataModel.setServiceInterfaceName(siName);
            dataModel.setServiceEndpointInterfaceNames(seiNames);
        }
        dataModel.setDidGenDescriptors(false);
        return status;
    }

    private String xmlNameToJava(String xmlName) {
        String computedResult;
        if (this.wsdl2java_ != null && (computedResult = this.wsdl2java_.xmlNameToJava(xmlName)) != null) {
            return this.mangleClassName(computedResult);
        }
        return this.mangleClassName(xmlName);
    }

    private String mangleClassName(String s) {
        s = this.firstCharToUpperCase(WSDLUtils.resolveDotInPortName(s));
        return this.replaceInvalidJavaChars(s);
    }

    private String replaceInvalidJavaChars(String s) {
        char[] c = s.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (!Character.isJavaIdentifierPart(c[i])) {
                c[i] = 46;
            }
            ++i;
        }
        return new String(c);
    }

    private String firstCharToUpperCase(String s) {
        StringBuffer sb = new StringBuffer();
        sb.append(s.substring(0, 1).toUpperCase());
        sb.append(s.substring(1, s.length()));
        return sb.toString();
    }

    private InterfaceNames calculateSIandSEIName(String wsdlURL, String serviceQName, WebServicesParser wsParser) {
        InterfaceNames iNames = new InterfaceNames();
        String serviceLocalPart = serviceQName.substring(serviceQName.lastIndexOf(58) + 1);
        Map pkg2nsMapping = null;
        Definition def = wsParser.getWSDLDefinition(wsdlURL);
        Map services = def.getServices();
        Service service2 = null;
        for (Service service2 : services.values()) {
            if (serviceLocalPart.equals(service2.getQName().getLocalPart())) break;
        }
        if (service2 != null) {
            String serviceClassName;
            String servicePkgName = WSDLUtils.getPackageName(service2, pkg2nsMapping);
            String jndiName = serviceClassName = service2.getQName().getLocalPart();
            Map ports = service2.getPorts();
            Iterator it2 = ports.values().iterator();
            while (it2.hasNext()) {
                if (!serviceClassName.equals(((Port)it2.next()).getBinding().getPortType().getQName().getLocalPart())) continue;
                serviceClassName = String.valueOf(serviceClassName) + "_Service";
                break;
            }
            ArrayList<String> seiNames = new ArrayList<String>();
            for (Port port : ports.values()) {
                SOAPAddress soapAddress = null;
                List extensibilityElements = port.getExtensibilityElements();
                if (extensibilityElements != null) {
                    for (Object object : extensibilityElements) {
                        if (!(object instanceof SOAPAddress)) continue;
                        soapAddress = (SOAPAddress)object;
                        break;
                    }
                }
                if (soapAddress == null) continue;
                PortType portType = port.getBinding().getPortType();
                QName portTypeQName = portType.getQName();
                String portTypePkgName = WSDLUtils.getPackageName(portType, pkg2nsMapping);
                String portTypeClassName = portTypeQName.getLocalPart();
                if (jndiName.equals(portTypeClassName)) {
                    portTypeClassName = this.javaWsdlParam_.getJ2eeLevel().equals("1.3") ? String.valueOf(portTypeClassName) + "_Port" : String.valueOf(portTypeClassName) + "_PortType";
                }
                seiNames.add(String.valueOf(portTypePkgName) + "." + this.xmlNameToJava(portTypeClassName));
            }
            iNames.setSiName(String.valueOf(servicePkgName) + "." + this.xmlNameToJava(serviceClassName));
            iNames.setSEINames(this.convertToStringArray(seiNames.toArray()));
        }
        return iNames;
    }

    private String[] convertToStringArray(Object[] a) {
        if (a == null) {
            return new String[0];
        }
        int length = a.length;
        String[] sa = new String[length];
        int i = 0;
        while (i < length) {
            Object obj = a[i];
            if (obj instanceof String) {
                sa[i] = (String)obj;
            }
            ++i;
        }
        return sa;
    }

    private class InterfaceNames {
        private String siName_;
        private String[] seiNames_;

        private InterfaceNames() {
        }

        public String getSiName() {
            return this.siName_;
        }

        public String[] getSeiNames() {
            return this.seiNames_;
        }

        public void setSiName(String siName) {
            this.siName_ = siName;
        }

        public void setSEINames(String[] seiNames) {
            this.seiNames_ = seiNames;
        }
    }
}

