/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.command;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.preferences.PersistentWSIContext;
import org.eclipse.wst.ws.internal.preferences.WSIComplianceUtils;

public class ValidateWSIComplianceCommand
extends AbstractDataModelOperation {
    private JavaWSDLParameterBase javaWSDLParam = null;
    private Vector status = null;
    private IProject serviceProject_ = null;
    private IProject proxyProject_ = null;

    public ValidateWSIComplianceCommand() {
    }

    public ValidateWSIComplianceCommand(String id) {
        this();
        this.setID(id);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment environment = super.getEnvironment();
        if (this.javaWSDLParam == null) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
        }
        this.status = new Vector();
        IProject project = this.serviceProject_;
        byte type = this.javaWSDLParam.getServerSide();
        if (this.proxyProject_ != null && (type == 0 || type == 3 || type == 4 || type == 5)) {
            project = this.proxyProject_;
        }
        PersistentWSIContext wsiContext = new PersistentWSIContext();
        int severity = WSIComplianceUtils.getWSISeverity((IProject)project, (PersistentWSIContext)wsiContext);
        this.checkSecurity(severity);
        this.checkJMS(severity);
        this.checkEJBBinding(severity);
        this.checkRPCEncoded(severity);
        Status[] statuses = this.status.toArray(new Status[this.status.size()]);
        if (statuses.length == 0 || WSIComplianceUtils.checkWSICompliance((IStatusHandler)environment.getStatusHandler(), (Status[])statuses, (IProject)project, (PersistentWSIContext)wsiContext)) {
            return Status.OK_STATUS;
        }
        return StatusUtils.errorStatus((String)"");
    }

    private void checkSecurity(int severity) {
        if (this.javaWSDLParam.getSecurityConfig() != 0) {
            this.status.add(new Status(severity, "ValidateWSIComplianceCommand", 0, Messages.WSI_INCOMPLIANCE_SECURITY, null));
        }
    }

    private void checkJMS(int severity) {
        if (this.javaWSDLParam.getBindingTypes() != null && this.javaWSDLParam.getBindingTypes().indexOf("jms") != -1 || this.javaWSDLParam.getBindingTypes() == null && this.javaWSDLParam.getTransport() != null && this.javaWSDLParam.getTransport().equals("jms")) {
            this.status.add(new Status(severity, "ValidateWSIComplianceCommand", 0, Messages.WSI_INCOMPLIANCE_JMS, null));
        }
    }

    private void checkEJBBinding(int severity) {
        if (this.javaWSDLParam.getBindingTypes() != null && this.javaWSDLParam.getBindingTypes().indexOf("ejb") != -1 || this.javaWSDLParam.getBindingTypes() == null && this.javaWSDLParam.getTransport() != null && this.javaWSDLParam.getTransport().equals("ejb")) {
            this.status.add(new Status(severity, "ValidateWSIComplianceCommand", 0, Messages.WSI_INCOMPLIANCE_EJB_BINDING, null));
        }
    }

    private void checkRPCEncoded(int severity) {
        if ("RPC".equals(this.javaWSDLParam.getStyle()) && "ENCODED".equals(this.javaWSDLParam.getUse())) {
            this.status.add(new Status(severity, "ValidateWSIComplianceCommand", 0, Messages.WSI_INCOMPLIANCE_RPC_ENCODED, null));
        }
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setJavaParameter(JavaWSDLParameterBase javaWSDLParam) {
        if (javaWSDLParam != null) {
            this.setJavaWSDLParam(javaWSDLParam);
        }
    }

    public void setProxyProject(IProject proxyProject_) {
        this.proxyProject_ = proxyProject_;
    }

    public void setServiceProject(IProject serviceProject_) {
        this.serviceProject_ = serviceProject_;
    }
}

