/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.command;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.ast.ws.rd.utils.CopyJAXRPCMappingFileUtil;
import com.ibm.ast.ws.rd.utils.PlatformUtils;
import com.ibm.ast.ws.rd.utils.PostBuildListener;
import com.ibm.etools.webservice.was.consumption.command.ValidateEditCommand;
import com.ibm.etools.webservice.was.consumption.context.CodeGenerationContext;
import com.ibm.etools.webservice.was.consumption.plugin.WebServiceWasConsumptionPlugin;
import com.ibm.etools.webservice.was.consumption.ui.command.UpdateComponentNameCommand;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResourceFactoryRegistry;
import org.eclipse.jst.j2ee.internal.J2EEInit;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSCDDArtifactEdit;
import org.eclipse.jst.j2ee.webservice.internal.WebServiceInit;
import org.eclipse.jst.j2ee.webservice.internal.wsdd.WsddResourceFactory;
import org.eclipse.jst.j2ee.webservice.wsclient.ComponentScopedRefs;
import org.eclipse.jst.j2ee.webservice.wsclient.PortComponentRef;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesClient;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesResource;
import org.eclipse.jst.j2ee.webservice.wsclient.Webservice_clientFactory;
import org.eclipse.jst.j2ee.webservice.wsclient.internal.impl.WebServicesClientResourceFactory;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.command.internal.env.eclipse.EclipseEnvironment;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMRendererFactory;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;

public class UpdateWebServicesClientXmlCommand
extends AbstractDataModelOperation {
    private final String WEBSERVICESCLIENT_XML = "webservicesclient.xml";
    private JavaWSDLParameterBase javaWSDLParam = null;
    IPath webServicesClientXMLPath = null;
    private IProject proxyProject;
    private boolean projectRestartRequired = false;
    private String infDir = null;
    private String ddName = null;
    private String componentScopedReference = null;
    private boolean isContainerless = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        if (this.javaWSDLParam == null) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
        }
        IStatus status = Status.OK_STATUS;
        if (this.isContainerless) {
            return status;
        }
        IEnvironment environment = super.getEnvironment();
        IProject wscXmlProject = this.proxyProject;
        if (wscXmlProject == null) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_SERVICE_PROJECT_NOT_FOUND);
        }
        this.getWSCDDFilePath();
        if (this.javaWSDLParam.getJ2eeLevel().equals("1.3")) {
            if (this.webServicesClientXMLPath == null) {
                status = this.copyWebServicesClientXMLFile(environment, monitor);
                if (this.javaWSDLParam.getServerSide() != 4) return status;
                WSCDDArtifactEdit artifactEdit = null;
                try {
                    try {
                        artifactEdit = WSCDDArtifactEdit.getWSCDDArtifactEditForWrite((IProject)this.proxyProject);
                        WebServicesClient webservicesclient = artifactEdit.getWebServicesClient();
                        if (this.componentScopedReference == null) {
                            this.componentScopedReference = UpdateComponentNameCommand.getSessionBeanName(wscXmlProject);
                        }
                        ((ComponentScopedRefs)webservicesclient.getComponentScopedRefs().get(0)).setComponentName(this.componentScopedReference);
                        artifactEdit.saveIfNecessary(monitor);
                        return status;
                    }
                    catch (Exception e) {
                        IStatus iStatus = StatusUtils.errorStatus((String)(String.valueOf(Messages.MSG_ERROR_PARSING_WEBSERVICESCLIENT_XML) + ": " + e), (Throwable)e);
                        if (artifactEdit == null) return iStatus;
                        artifactEdit.dispose();
                        artifactEdit = null;
                        return iStatus;
                    }
                }
                finally {
                    if (artifactEdit != null) {
                        artifactEdit.dispose();
                        artifactEdit = null;
                    }
                }
            }
            CodeGenerationContext context = WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext();
            if (context.isBackupDD()) {
                CopyJAXRPCMappingFileUtil.backupWebServicesFile((IEnvironment)environment, (IProgressMonitor)monitor, (String)this.webServicesClientXMLPath.toString(), (IProject)wscXmlProject, (String)"webservicesclient.xml");
            }
            ServiceRef serviceRef2 = null;
            ComponentScopedRefs compScopedRef2 = null;
            WebServicesClient webservicesclient = UpdateWebServicesClientXmlCommand.loadResourceFromOutside(this.javaWSDLParam.getTempOutput(), this.infDir);
            if (this.javaWSDLParam.getServerSide() == 4) {
                for (ComponentScopedRefs compScopedRef2 : webservicesclient.getComponentScopedRefs()) {
                }
                if (this.componentScopedReference == null) {
                    this.componentScopedReference = UpdateComponentNameCommand.getSessionBeanName(wscXmlProject);
                }
                compScopedRef2.setComponentName(this.componentScopedReference);
            } else {
                for (ServiceRef serviceRef2 : webservicesclient.getServiceRefs()) {
                }
            }
            WSCDDArtifactEdit artifactEdit = null;
            try {
                try {
                    artifactEdit = WSCDDArtifactEdit.getWSCDDArtifactEditForWrite((IProject)this.proxyProject);
                    WebServicesClient webservicesclientTemp = artifactEdit.getWebServicesClient();
                    if (compScopedRef2 != null) {
                        boolean processed = false;
                        EList eList = webservicesclientTemp.getComponentScopedRefs();
                        int i = 0;
                        while (i < eList.size()) {
                            ComponentScopedRefs compScopedRefTemp = (ComponentScopedRefs)eList.get(i);
                            if (compScopedRefTemp != null && compScopedRefTemp.getComponentName().equalsIgnoreCase(compScopedRef2.getComponentName())) {
                                ServiceRef newServiceRef = (ServiceRef)compScopedRef2.getServiceRefs().get(0);
                                EList serviceRefs = compScopedRefTemp.getServiceRefs();
                                int j = 0;
                                while (j < serviceRefs.size()) {
                                    ServiceRef serviceRefTemp = (ServiceRef)serviceRefs.get(j);
                                    if (serviceRefTemp != null && serviceRefTemp.getServiceRefName().equalsIgnoreCase(newServiceRef.getServiceRefName())) {
                                        serviceRefs.remove((Object)serviceRefTemp);
                                    }
                                    ++j;
                                }
                                serviceRefs.add((Object)this.cloneServiceRef(newServiceRef));
                                processed = true;
                            }
                            ++i;
                        }
                        if (!processed) {
                            eList.add((Object)compScopedRef2);
                        }
                    }
                    if (serviceRef2 != null) {
                        EList eList = webservicesclientTemp.getServiceRefs();
                        int i = 0;
                        while (i < eList.size()) {
                            ServiceRef serviceRefTemp = (ServiceRef)eList.get(i);
                            if (serviceRefTemp != null && serviceRefTemp.getServiceRefName().equalsIgnoreCase(serviceRef2.getServiceRefName())) {
                                eList.remove((Object)serviceRefTemp);
                            }
                            ++i;
                        }
                        eList.add((Object)this.cloneServiceRef(serviceRef2));
                    }
                    artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                    return status;
                }
                catch (Exception e) {
                    IStatus iStatus = StatusUtils.errorStatus((String)(String.valueOf(Messages.MSG_ERROR_PARSING_WEBSERVICESCLIENT_XML) + ": " + e), (Throwable)e);
                    if (artifactEdit == null) return iStatus;
                    artifactEdit.dispose();
                    return iStatus;
                }
            }
            finally {
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        this.copyJ2EEDeploymentDescriptorFile(environment, monitor);
        return status;
    }

    private ServiceRef cloneServiceRef(ServiceRef oldServiceRef) {
        try {
            JavaClass serviceInterfaceFromTemp;
            ResourceSet resSet = WorkbenchResourceHelperBase.getResourceSet((IProject)this.proxyProject);
            Webservice_clientFactory factory = Webservice_clientFactory.eINSTANCE;
            ServiceRef newServiceRef = factory.createServiceRef();
            if (oldServiceRef.getDescription() != null) {
                newServiceRef.setDescription(oldServiceRef.getDescription());
            }
            if (oldServiceRef.getServiceRefName() != null) {
                newServiceRef.setServiceRefName(oldServiceRef.getServiceRefName());
            }
            if (oldServiceRef.getWsdlFile() != null) {
                newServiceRef.setWsdlFile(oldServiceRef.getWsdlFile());
            }
            if (oldServiceRef.getJaxrpcMappingFile() != null) {
                newServiceRef.setJaxrpcMappingFile(oldServiceRef.getJaxrpcMappingFile());
            }
            if (oldServiceRef.getServiceQname() != null) {
                newServiceRef.setServiceQname(oldServiceRef.getServiceQname());
            }
            if ((serviceInterfaceFromTemp = oldServiceRef.getServiceInterface()) != null && serviceInterfaceFromTemp.getQualifiedName() != null) {
                JavaClass newServiceInterfaceClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(serviceInterfaceFromTemp.getQualifiedName(), resSet);
                newServiceRef.setServiceInterface(newServiceInterfaceClass);
            }
            EList portComponentRefs = oldServiceRef.getPortComponentRefs();
            EList newPortComponetRefs = newServiceRef.getPortComponentRefs();
            int i = 0;
            while (i < portComponentRefs.size()) {
                PortComponentRef portComponentRef = (PortComponentRef)portComponentRefs.get(i);
                JavaClass seiFromTemp = portComponentRef.getServiceEndpointInterface();
                if (seiFromTemp != null && seiFromTemp.getQualifiedName() != null) {
                    PortComponentRef newPortComponentRef = factory.createPortComponentRef();
                    JavaClass seiClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(seiFromTemp.getQualifiedName(), resSet);
                    newPortComponentRef.setServiceEndpointInterface(seiClass);
                    if (portComponentRef.getPortComponentLink() != null) {
                        newPortComponentRef.setPortComponentLink(portComponentRef.getPortComponentLink());
                    }
                    newPortComponetRefs.add((Object)newPortComponentRef);
                }
                ++i;
            }
            return newServiceRef;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return oldServiceRef;
        }
    }

    private IStatus copyWebServicesClientXMLFile(IEnvironment environment, IProgressMonitor monitor) {
        if (this.javaWSDLParam.getTempOutput() == null) {
            return Status.OK_STATUS;
        }
        Path outputPath = new Path(PlatformUtils.getPathFromPlatform((String)this.javaWSDLParam.getOutput()));
        String targetOutput = J2EEUtils.removeFileProtocol((String)this.javaWSDLParam.getTempOutput());
        File source = new File(String.valueOf(targetOutput) + this.infDir + File.separator + "webservicesclient.xml");
        FileInputStream finStream = null;
        ResourceContext context = ((BaseEclipseEnvironment)environment).getResourceContext();
        if (environment instanceof EclipseEnvironment) {
            context = ((EclipseEnvironment)environment).getResourceContext();
        }
        try {
            finStream = new FileInputStream(source);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace(System.err);
        }
        IPath targetPath = outputPath.append(this.infDir).append("webservicesclient.xml").makeAbsolute();
        try {
            FileResourceUtils.createFile((ResourceContext)context, (IPath)targetPath, (InputStream)finStream, (IProgressMonitor)monitor, (IStatusHandler)environment.getStatusHandler());
        }
        catch (CoreException ce) {
            ce.printStackTrace(System.err);
        }
        return Status.OK_STATUS;
    }

    private IStatus copyJ2EEDeploymentDescriptorFile(IEnvironment environment, IProgressMonitor monitor) {
        if (this.javaWSDLParam.getTempOutput() == null) {
            return Status.OK_STATUS;
        }
        Path outputPath = new Path(PlatformUtils.getPathFromPlatform((String)this.javaWSDLParam.getOutput()));
        String targetOutput = J2EEUtils.removeFileProtocol((String)this.javaWSDLParam.getTempOutput());
        File source = new File(String.valueOf(targetOutput) + this.infDir + File.separator + this.ddName);
        FileInputStream finStream = null;
        ResourceContext context = ((BaseEclipseEnvironment)environment).getResourceContext();
        if (environment instanceof EclipseEnvironment) {
            context = ((EclipseEnvironment)environment).getResourceContext();
        }
        try {
            finStream = new FileInputStream(source);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace(System.err);
        }
        IPath targetPath = outputPath.append(this.infDir).append(this.ddName).makeAbsolute();
        try {
            Vector<IPath> pathVector = new Vector<IPath>();
            pathVector.add(targetPath);
            ValidateEditCommand validateEditCmd = new ValidateEditCommand();
            validateEditCmd.setEnvironment(environment);
            validateEditCmd.setFileList(ValidateEditCommand.convertIPathToIFileArray(pathVector));
            IStatus validateStatus = validateEditCmd.execute(monitor, null);
            if (!validateStatus.isOK()) {
                return validateStatus;
            }
            PostBuildListener listener = null;
            try {
                listener = new PostBuildListener();
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 16);
                FileResourceUtils.createFile((ResourceContext)context, (IPath)targetPath, (InputStream)finStream, (IProgressMonitor)monitor, (IStatusHandler)environment.getStatusHandler());
                ResourcesPlugin.getWorkspace().build(10, monitor);
                int count = 0;
                while (!listener.isBuildComplete()) {
                    try {
                        Thread.sleep(300L);
                        if (count++ != 2000) continue;
                        WebServiceWasConsumptionPlugin.getInstance().getLog().log(StatusUtils.errorStatus((String)"*** build not complete after 10 minutes"));
                        break;
                    }
                    catch (InterruptedException e) {
                        WebServiceWasConsumptionPlugin.getInstance().getLog().log(StatusUtils.errorStatus((Throwable)e));
                    }
                }
            }
            finally {
                if (listener != null) {
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
                }
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace(System.err);
        }
        return Status.OK_STATUS;
    }

    private void getWSCDDFilePath() {
        IPath projectPath = this.proxyProject.getFullPath();
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.proxyProject);
        IVirtualFolder ivFolder = null;
        if (J2EEUtils.isWebProject((IProject)this.proxyProject)) {
            ivFolder = J2EEUtils.getWebDeploymentDescriptorFolder((IVirtualComponent)component);
            this.infDir = "WEB-INF";
            this.ddName = "web.xml";
        } else if (J2EEUtils.isEJBProject((IProject)this.proxyProject)) {
            ivFolder = J2EEUtils.getEJBDeploymentDescriptorFolder((IVirtualComponent)component);
            this.infDir = "META-INF";
            this.ddName = "ejb-jar.xml";
        } else if (J2EEUtils.isAppClientProject((IProject)this.proxyProject)) {
            ivFolder = J2EEUtils.getAppClientDeploymentDescriptorFolder((IVirtualComponent)component);
            this.infDir = "META-INF";
            this.ddName = "application-client.xml";
        } else {
            return;
        }
        IVirtualFile ivFile = ivFolder.getFile("webservicesclient.xml");
        if (ivFile.exists()) {
            this.webServicesClientXMLPath = projectPath.append(ivFile.getProjectRelativePath());
        }
    }

    public static WebServicesClient loadResourceFromOutside(String rootPath, String infFolder) {
        J2EEInit.init();
        WebServiceInit.init();
        WebServicesClientResourceFactory.registerWith((RendererFactory)new EMF2DOMRendererFactory());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setResourceFactoryRegistry((Resource.Factory.Registry)new J2EEResourceFactoryRegistry());
        URIConverterImpl conv = new URIConverterImpl();
        resourceSet.setURIConverter((URIConverter)conv);
        String filePath = String.valueOf(rootPath) + infFolder + File.separator + "webservicesclient.xml";
        filePath = J2EEUtils.removeFileProtocol((String)filePath);
        URI uri = URI.createFileURI((String)filePath);
        try {
            WebServicesClient wss;
            Resource resource = resourceSet.getResource(uri, true);
            WebServicesResource wsdd = (WebServicesResource)resource;
            WebServicesClient webServicesClient = wss = wsdd.getWebServicesClient();
            return webServicesClient;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            WsddResourceFactory.register();
        }
        return null;
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
        this.isContainerless = javaWSDLParam != null && javaWSDLParam.getContainer() != null && javaWSDLParam.getContainer().equalsIgnoreCase("none");
    }

    public boolean getIsProjectRestartRequired() {
        return this.projectRestartRequired;
    }

    public void setProxyProject(IProject proxyProject) {
        this.proxyProject = proxyProject;
    }

    public void setComponentScopedReference(String componentScopedReference) {
        this.componentScopedReference = componentScopedReference;
    }
}

