/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.command;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.ext.model.WscbndArtifactEdit;
import com.ibm.etools.webservice.was.ext.model.WscextArtifactEdit;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscext.ComponentScopedRefs;
import com.ibm.etools.webservice.wscext.WsClientExtension;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.deploy.J2EEDeployOperation;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSCDDArtifactEdit;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesClient;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.StatusException;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class UpdateComponentNameCommand
extends AbstractDataModelOperation {
    private final String WEBSERVICESCLIENT_XML = "webservicesclient.xml";
    private final String IBM_WEBSERVICESCLIENT_EXT_XMI = "ibm-webservicesclient-ext.xmi";
    private final String IBM_WEBSERVICESCLIENT_BND_XMI = "ibm-webservicesclient-bnd.xmi";
    private JavaWSDLParameterBase javaWSDLParam = null;
    IPath webServicesClientXMLPath = null;
    IPath ibmWebServicesClientExtXMIPath = null;
    IPath ibmWebServicesClientBndXMIPath = null;
    private IProject proxyProject;
    private String componentScopedReference;
    private String clientServer;

    /*
     * Handled impossible loop by adding 'first' condition
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus validateComponentScopedReference(IProject ejbProject, String componentName) {
        EJBArtifactEdit artifactEdit = null;
        if (!J2EEUtils.isEJBProject((IProject)ejbProject)) return Status.OK_STATUS;
        artifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)this.proxyProject);
        EJBJar ejbJar = artifactEdit.getEJBJar();
        EList ejbs = ejbJar.getEnterpriseBeans();
        Iterator it = ejbs.iterator();
        boolean bl = true;
        while (true) {
            if (!bl || (bl = false) || !true) {
                EnterpriseBean ejb = (EnterpriseBean)it.next();
                String ejbName = ejb.getName();
                if (ejbName != null && componentName != null && ejbName.equals(componentName)) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
            }
            if (it.hasNext()) continue;
            break;
        }
        {
            return StatusUtils.warningStatus((String)Messages.bind((String)Messages.MSG_WARNING_INVALID_COMPONENT_NAME, (Object[])new String[]{componentName}), (Throwable)new Exception(Messages.bind((String)Messages.MSG_WARNING_INVALID_COMPONENT_NAME_DETAILS, (Object[])new String[]{componentName})));
            catch (Exception e) {}
            IStatus iStatus = StatusUtils.warningStatus((String)Messages.bind((String)Messages.MSG_WARNING_INVALID_COMPONENT_NAME, (Object[])new String[]{componentName}), (Throwable)e);
            return iStatus;
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        if (this.javaWSDLParam == null) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
        }
        if (this.proxyProject == null) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_SERVICE_PROJECT_NOT_FOUND);
        }
        IEnvironment environment = super.getEnvironment();
        if (this.componentScopedReference == null && this.javaWSDLParam.getServerSide() == 4) {
            this.populateComponentScopedNameLink();
        }
        IStatus returnStatus = Status.OK_STATUS;
        if (this.javaWSDLParam.getServerSide() == 4 && this.componentScopedReference != null) {
            this.getWSCDDFilePath();
            if (this.webServicesClientXMLPath == null && !this.javaWSDLParam.getJ2eeLevel().equals("1.4")) {
                IStatus status = StatusUtils.errorStatus((String)Messages.MSG_ERROR_WEBSERVICESCLIENT_XML_NOT_FOUND);
                environment.getStatusHandler().reportError(status);
                return status;
            }
            if (this.ibmWebServicesClientExtXMIPath == null) {
                IStatus status = StatusUtils.errorStatus((String)Messages.MSG_ERROR_IBM_WEBSERVICESCLIENT_EXT_XMI_NOT_FOUND);
                environment.getStatusHandler().reportError(status);
                return status;
            }
            if (this.ibmWebServicesClientBndXMIPath == null) {
                IStatus status = StatusUtils.errorStatus((String)Messages.MSG_ERROR_IBM_WEBSERVICESCLIENT_BND_XMI_NOT_FOUND);
                environment.getStatusHandler().reportError(status);
                return status;
            }
            String componentName = this.componentScopedReference;
            returnStatus = this.validateComponentScopedReference(this.proxyProject, componentName);
            if (returnStatus.getSeverity() == 2) {
                try {
                    environment.getStatusHandler().report(returnStatus);
                }
                catch (StatusException statusException) {
                    return StatusUtils.errorStatus((String)returnStatus.getMessage(), (Throwable)returnStatus.getException());
                }
            }
            if (this.javaWSDLParam.getJ2eeLevel().equals("1.4")) {
                try {
                    this.updateBndCompScopedNameJ2EE14();
                    this.updateExtCompScopedNameJ2EE14();
                }
                catch (Exception e) {
                    IStatus status = StatusUtils.errorStatus((String)(String.valueOf(Messages.MSG_ERROR_PARSING_WEBSERVICESCLIENT_XML) + ": " + e), (Throwable)e);
                    environment.getStatusHandler().reportError(status);
                    return status;
                }
            }
            WSCDDArtifactEdit wscArtifactEdit = null;
            WscbndArtifactEdit wscBndArtifactEdit = null;
            WscextArtifactEdit wscExtArtifactEdit = null;
            try {
                try {
                    wscArtifactEdit = WSCDDArtifactEdit.getWSCDDArtifactEditForWrite((IProject)this.proxyProject);
                    WebServicesClient webservicesclient = wscArtifactEdit.getWebServicesClient();
                    ((org.eclipse.jst.j2ee.webservice.wsclient.ComponentScopedRefs)webservicesclient.getComponentScopedRefs().get(0)).setComponentName(componentName);
                    wscArtifactEdit.saveIfNecessary(monitor);
                }
                catch (Exception e) {
                    IStatus status = StatusUtils.errorStatus((String)(String.valueOf(Messages.MSG_ERROR_PARSING_WEBSERVICESCLIENT_XML) + ": " + e), (Throwable)e);
                    environment.getStatusHandler().reportError(status);
                    IStatus iStatus = status;
                    if (wscArtifactEdit != null) {
                        wscArtifactEdit.dispose();
                    }
                    return iStatus;
                }
            }
            finally {
                if (wscArtifactEdit != null) {
                    wscArtifactEdit.dispose();
                }
            }
            try {
                try {
                    wscExtArtifactEdit = WscextArtifactEdit.getWSCEXTArtifactEditForWrite((IProject)this.proxyProject);
                    WsClientExtension wscext = wscExtArtifactEdit.getWsClientExtension();
                    ((ComponentScopedRefs)wscext.getComponentScopedRefs().get(0)).setComponentNameLink(componentName);
                    wscExtArtifactEdit.saveIfNecessary(monitor);
                }
                catch (Exception e) {
                    IStatus status = StatusUtils.errorStatus((String)(String.valueOf(Messages.MSG_ERROR_PARSING_WEBSERVICESCLIENT_XML) + ": " + e), (Throwable)e);
                    environment.getStatusHandler().reportError(status);
                    IStatus iStatus = status;
                    if (wscExtArtifactEdit != null) {
                        wscExtArtifactEdit.dispose();
                    }
                    return iStatus;
                }
            }
            finally {
                if (wscExtArtifactEdit != null) {
                    wscExtArtifactEdit.dispose();
                }
            }
            try {
                try {
                    wscBndArtifactEdit = WscbndArtifactEdit.getWSCBNDArtifactEditForWrite((IProject)this.proxyProject);
                    ClientBinding wscbnd = wscBndArtifactEdit.getClientBinding();
                    ((com.ibm.etools.webservice.wscbnd.ComponentScopedRefs)wscbnd.getComponentScopedRefs().get(0)).setComponentNameLink(componentName);
                    wscBndArtifactEdit.saveIfNecessary(monitor);
                }
                catch (Exception e) {
                    IStatus status = StatusUtils.errorStatus((String)(String.valueOf(Messages.MSG_ERROR_PARSING_WEBSERVICESCLIENT_XML) + ": " + e), (Throwable)e);
                    environment.getStatusHandler().reportError(status);
                    IStatus iStatus = status;
                    if (wscBndArtifactEdit != null) {
                        wscBndArtifactEdit.dispose();
                    }
                    return iStatus;
                }
            }
            finally {
                if (wscBndArtifactEdit != null) {
                    wscBndArtifactEdit.dispose();
                }
            }
            if (this.clientServer != null && this.clientServer.indexOf("v5") != -1) {
                try {
                    J2EEDeployOperation j2eeDeployOperation = new J2EEDeployOperation((Object[])new IProject[]{this.proxyProject});
                    IStatus deployStatus = j2eeDeployOperation.execute(monitor, adaptable);
                    if (deployStatus.getSeverity() == 4) {
                        environment.getStatusHandler().reportError(deployStatus);
                    }
                }
                catch (Exception e) {
                    IStatus status = StatusUtils.errorStatus((String)e.getMessage(), (Throwable)e);
                    environment.getStatusHandler().reportError(status);
                    return status;
                }
            }
        }
        return returnStatus;
    }

    private void updateBndCompScopedNameJ2EE14() throws Exception {
        WscbndArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WscbndArtifactEdit.getWSCBNDArtifactEditForWrite((IProject)this.proxyProject);
            ClientBinding wscbnd = artifactEdit.getClientBinding();
            EList eList = wscbnd.getComponentScopedRefs();
            com.ibm.etools.webservice.wscbnd.ComponentScopedRefs compScopedRefTemp = (com.ibm.etools.webservice.wscbnd.ComponentScopedRefs)eList.get(0);
            compScopedRefTemp.setComponentNameLink(this.componentScopedReference);
            artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void updateExtCompScopedNameJ2EE14() throws Exception {
        WscextArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WscextArtifactEdit.getWSCEXTArtifactEditForWrite((IProject)this.proxyProject);
            WsClientExtension wscext = artifactEdit.getWsClientExtension();
            EList eList = wscext.getComponentScopedRefs();
            ComponentScopedRefs compScopedRefTemp = (ComponentScopedRefs)eList.get(0);
            compScopedRefTemp.setComponentNameLink(this.componentScopedReference);
            artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void getWSCDDFilePath() {
        IPath projectPath = this.proxyProject.getFullPath();
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.proxyProject);
        IVirtualFolder ivFolder = null;
        if (J2EEUtils.isWebProject((IProject)this.proxyProject)) {
            ivFolder = J2EEUtils.getWebDeploymentDescriptorFolder((IVirtualComponent)component);
        } else if (J2EEUtils.isEJBProject((IProject)this.proxyProject)) {
            ivFolder = J2EEUtils.getEJBDeploymentDescriptorFolder((IVirtualComponent)component);
        } else if (J2EEUtils.isAppClientProject((IProject)this.proxyProject)) {
            ivFolder = J2EEUtils.getAppClientDeploymentDescriptorFolder((IVirtualComponent)component);
        }
        IVirtualFile ivFile = ivFolder.getFile("webservicesclient.xml");
        if (ivFile.exists()) {
            this.webServicesClientXMLPath = projectPath.append(ivFile.getProjectRelativePath());
        }
        if ((ivFile = ivFolder.getFile("ibm-webservicesclient-bnd.xmi")).exists()) {
            this.ibmWebServicesClientBndXMIPath = projectPath.append(ivFile.getProjectRelativePath());
        }
        if ((ivFile = ivFolder.getFile("ibm-webservicesclient-ext.xmi")).exists()) {
            this.ibmWebServicesClientExtXMIPath = projectPath.append(ivFile.getProjectRelativePath());
        }
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setComponentScopedReference(String componentScopedReference) {
        this.componentScopedReference = componentScopedReference;
    }

    public void setProxyProject(IProject proxyProject) {
        this.proxyProject = proxyProject;
    }

    public void setClientServer(String clientServer) {
        this.clientServer = clientServer;
    }

    private void populateComponentScopedNameLink() {
        EJBArtifactEdit artifactEdit = null;
        if (J2EEUtils.isEJBProject((IProject)this.proxyProject)) {
            try {
                try {
                    artifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)this.proxyProject);
                    EJBJar ejbJar = artifactEdit.getEJBJar();
                    EList ejbs = ejbJar.getEnterpriseBeans();
                    for (EnterpriseBean ejb : ejbs) {
                        if (!ejb.isSession()) continue;
                        this.componentScopedReference = ejb.getName();
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    if (artifactEdit != null) {
                        artifactEdit.dispose();
                    }
                }
            }
            finally {
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
    }

    public static String getSessionBeanName(IProject ejbProject) {
        EJBArtifactEdit artifactEdit = null;
        String sessionBeanName = null;
        if (J2EEUtils.isEJBProject((IProject)ejbProject)) {
            try {
                try {
                    artifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)ejbProject);
                    EJBJar ejbJar = artifactEdit.getEJBJar();
                    EList ejbs = ejbJar.getEnterpriseBeans();
                    for (EnterpriseBean ejb : ejbs) {
                        if (!ejb.isSession()) continue;
                        sessionBeanName = ejb.getName();
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    if (artifactEdit != null) {
                        artifactEdit.dispose();
                    }
                }
            }
            finally {
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        return sessionBeanName;
    }
}

