/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.command;

import com.ibm.ws.ast.st.common.core.internal.provisional.IWebSphereCommonServerExt;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public class ModifyAutoPublishCommand
extends AbstractDataModelOperation {
    private String serverInstanceId = null;
    private int originalPublishValue = -1;
    private final int desiredPublishValue = 1;

    public ModifyAutoPublishCommand() {
    }

    public ModifyAutoPublishCommand(String id) {
        this();
        this.setID(id);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        if (this.serverInstanceId == null) {
            return Status.OK_STATUS;
        }
        try {
            IServer server = ServerCore.findServer((String)this.serverInstanceId);
            if (server.getServerState() == 4 || server.getServerState() == 3) {
                return Status.OK_STATUS;
            }
            IServerWorkingCopy serverWC = server.createWorkingCopy();
            IWebSphereCommonServerExt wasServer = (IWebSphereCommonServerExt)serverWC.loadAdapter(IWebSphereCommonServerExt.class, monitor);
            this.originalPublishValue = wasServer.getAutoPublishDefaultSetting();
            if (this.originalPublishValue == 1) {
                this.originalPublishValue = -1;
                return Status.OK_STATUS;
            }
            wasServer.setAutoPublishDefault(1);
            serverWC.save(true, monitor);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        return Status.OK_STATUS;
    }

    public void setServerInstanceId(String serverInstanceId) {
        this.serverInstanceId = serverInstanceId;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
        if (this.serverInstanceId == null || this.originalPublishValue == -1) {
            return Status.OK_STATUS;
        }
        try {
            IServer server = ServerCore.findServer((String)this.serverInstanceId);
            IServerWorkingCopy serverWC = server.createWorkingCopy();
            IWebSphereCommonServerExt wasServer = (IWebSphereCommonServerExt)serverWC.loadAdapter(IWebSphereCommonServerExt.class, monitor);
            wasServer.setAutoPublishDefault(this.originalPublishValue);
            serverWC.save(true, monitor);
            this.originalPublishValue = -1;
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        return Status.OK_STATUS;
    }

    public int getOriginalPublishValue() {
        return this.originalPublishValue;
    }
}

