/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.command;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.plugin.JavaEMFNature;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jst.ws.internal.consumption.codegen.VisitorAction;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitoractions.DetectNonJavaCharsBeanVisitorAction;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitors.JavaMofBeanVisitor;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class DetectNonJavaCharsCommand
extends AbstractDataModelOperation {
    private JavaWSDLParameterBase javaWSDLParam;

    public DetectNonJavaCharsCommand() {
    }

    public DetectNonJavaCharsCommand(JavaWSDLParameterBase javaWSDLParam) {
        this();
        this.javaWSDLParam = javaWSDLParam;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        try {
            Vector messages = new Vector();
            IStatus status = null;
            if (this.javaWSDLParam == null) {
                return StatusUtils.errorStatus((String)Messages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
            }
            ResourceSet resourceSet = null;
            try {
                JavaEMFNature jMOF = JavaEMFNature.createRuntime((IProject)this.javaWSDLParam.getProject());
                if (jMOF != null) {
                    resourceSet = jMOF.getResourceSet();
                }
            }
            catch (CoreException e) {
                return StatusUtils.errorStatus((String)Messages.MSG_ERR_FAIL_RESOURCESET, (Throwable)e);
            }
            JavaClass javaClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(this.javaWSDLParam.getBeanName(), resourceSet);
            DetectNonJavaCharsBeanVisitorAction beanVisitorAction = new DetectNonJavaCharsBeanVisitorAction(messages, null);
            JavaMofBeanVisitor beanVisitor = new JavaMofBeanVisitor();
            beanVisitor.run((Object)javaClass, (VisitorAction)beanVisitorAction);
            if (messages == null || messages.size() == 0) {
                status = Status.OK_STATUS;
            } else {
                Status[] statuses = new Status[messages.size()];
                int i = 0;
                while (i < messages.size()) {
                    statuses[i] = StatusUtils.warningStatus((String)((String)messages.elementAt(i)));
                    ++i;
                }
                status = StatusUtils.multiStatus((String)Messages.MSG_WARN_JAX_RPC_GENERAL, (IStatus[])statuses);
            }
            return status;
        }
        catch (Throwable throwable) {
            IStatus simpleStatus = Status.OK_STATUS;
            return simpleStatus;
        }
    }
}

