/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.command;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.webservice.was.consumption.registry.EnvironmentAdapterRegistry;
import com.ibm.etools.webservice.was.consumption.util.PlatformUtils;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.core.context.TransientResourceContext;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class CopyMappingXMLCommand
extends AbstractDataModelOperation {
    private JavaWSDLParameterBase javaWSDLParam = null;
    private IProject proxyProject;
    IFile mappingFile = null;
    IPath newOutputPath = null;
    String JaxRpcMappingFileName = null;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus status = Status.OK_STATUS;
        if (this.javaWSDLParam == null) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
        }
        try {
            IResource tempFolder;
            IEnvironment environment = super.getEnvironment();
            if (environment == null) {
                environment = EnvironmentAdapterRegistry.getInstance().getAdapter().getDefaultEnvironment();
            }
            MappingXMLResourceVisitor visitor = new MappingXMLResourceVisitor();
            this.proxyProject.accept((IResourceVisitor)visitor);
            if (this.JaxRpcMappingFileName != null) {
                this.copyIFile(environment, monitor, this.mappingFile, this.newOutputPath, this.JaxRpcMappingFileName);
            }
            if ((tempFolder = ResourceUtils.findResource((String)PlatformUtils.getPathFromPlatform(this.javaWSDLParam.getOutput()))) != null) {
                tempFolder.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    private void copyIFile(IEnvironment env, IProgressMonitor monitor, IFile sourceFile, IPath targetPath, String targetFile) throws Exception {
        IPath target = targetPath.append((IPath)new Path(targetFile));
        TransientResourceContext context = new TransientResourceContext();
        context.setOverwriteFilesEnabled(true);
        context.setCreateFoldersEnabled(true);
        context.setCheckoutFilesEnabled(true);
        FileResourceUtils.createFile((ResourceContext)context, (IPath)target, (InputStream)sourceFile.getContents(), (IProgressMonitor)monitor, (IStatusHandler)env.getStatusHandler());
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setProxyProject(IProject proxyProject) {
        this.proxyProject = proxyProject;
    }

    public String getMappingFile() {
        return this.JaxRpcMappingFileName;
    }

    class MappingXMLResourceVisitor
    implements IResourceVisitor {
        MappingXMLResourceVisitor() {
        }

        public boolean visit(IResource res) {
            String tempPath;
            if (res.getType() == 1 && (tempPath = res.getFullPath().toString()).startsWith(PlatformUtils.getPathFromPlatform(CopyMappingXMLCommand.this.javaWSDLParam.getOutput())) && tempPath.endsWith("_mapping.xml")) {
                CopyMappingXMLCommand.this.mappingFile = (IFile)res;
                CopyMappingXMLCommand.this.newOutputPath = res.getFullPath().uptoSegment(res.getFullPath().segmentCount() - 3);
                CopyMappingXMLCommand.this.JaxRpcMappingFileName = res.getFullPath().removeFirstSegments(res.getFullPath().segmentCount() - 2).toString();
            }
            return true;
        }
    }
}

