/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.command;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.webservice.was.consumption.ui.plugin.WebServiceWasConsumptionUIPlugin;
import com.ibm.etools.webservice.was.consumption.util.PlatformUtils;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.ext.model.WscbndArtifactEdit;
import com.ibm.etools.webservice.was.ext.model.WscextArtifactEdit;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.etools.webservice.wscext.ComponentScopedRefs;
import com.ibm.etools.webservice.wscext.WsClientExtension;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.j2ee.applicationclient.componentcore.util.AppClientArtifactEdit;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.core.context.TransientResourceContext;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class AddIBMWebServicesClientSecurityDSIGandENCC
extends AbstractDataModelOperation {
    private static final byte SECURITY_CONFIG = 3;
    private String WEBSERVICESCLIENT_XML = "webservicesclient.xml";
    private String IBM_WEBSERVICESCLIENT_BND_XMI = "ibm-webservicesclient-bnd.xmi";
    private String IBM_WEBSERVICESCLIENT_EXT_XMI = "ibm-webservicesclient-ext.xmi";
    private JavaWSDLParameterBase javaWSDLParam = null;
    private EList serviceReferences;
    private ArrayList newServiceReferences = new ArrayList();
    private ArrayList wsdlPorts = new ArrayList();
    private ArrayList wsdlServices = new ArrayList();
    IPath webServicesClientXMLPath = null;
    IPath ibmWebServicesClientBndXMIPath = null;
    IPath ibmWebServicesClientExtXMIPath = null;
    private IProject proxyProject;
    private WebServicesParser wSParser;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment environment = super.getEnvironment();
        IStatus status = Status.OK_STATUS;
        if (this.javaWSDLParam == null) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
        }
        if (this.javaWSDLParam.getSecurityConfig() != 3) {
            return status;
        }
        if (this.javaWSDLParam.getJ2eeLevel().equals("1.4")) {
            if (this.javaWSDLParam.getServerSide() == 4) {
                this.copyTemplateToTempDirectory("/samples/BasicSigEnc/ibm-webservicesclientejb-bnd.xmi", "ibm-webservicesclient-bnd.xmi", status, environment, monitor);
                this.copyTemplateToTempDirectory("/samples/BasicSigEnc/ibm-webservicesclientejb-ext.xmi", "ibm-webservicesclient-ext.xmi", status, environment, monitor);
            } else {
                this.copyTemplateToTempDirectory("/samples/BasicSigEnc/ibm-webservicesclient-bnd.xmi", "ibm-webservicesclient-bnd.xmi", status, environment, monitor);
                this.copyTemplateToTempDirectory("/samples/BasicSigEnc/ibm-webservicesclient-ext.xmi", "ibm-webservicesclient-ext.xmi", status, environment, monitor);
            }
        }
        return status;
    }

    private void copyTemplateToTempDirectory(String source, String fileName, IStatus status, IEnvironment env, IProgressMonitor monitor) {
        try {
            String inputLine;
            String tempDir = J2EEUtils.removeFileProtocol((String)this.javaWSDLParam.getTempOutput());
            File file = new File(String.valueOf(tempDir) + "sec");
            if (!file.exists()) {
                file.mkdirs();
            }
            FileWriter fw = new FileWriter(String.valueOf(tempDir) + "sec" + File.separator + fileName);
            DataInputStream is = new DataInputStream(WebServiceWasConsumptionUIPlugin.getInstance().getBundle().getEntry(source).openStream());
            while ((inputLine = is.readLine()) != null) {
                fw.write(inputLine);
            }
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void getNamesFromWebXML() {
        WebArtifactEdit artifactEdit = null;
        try {
            try {
                artifactEdit = WebArtifactEdit.getWebArtifactEditForRead((IProject)this.proxyProject);
                WebApp webapp = artifactEdit.getWebApp();
                this.serviceReferences = webapp.getServiceRefs();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void getNamesFromAppClientXML() {
        AppClientArtifactEdit artifactEdit = null;
        if (J2EEUtils.isAppClientProject((IProject)this.proxyProject)) {
            try {
                try {
                    artifactEdit = AppClientArtifactEdit.getAppClientArtifactEditForRead((IProject)this.proxyProject);
                    ApplicationClient appClient = artifactEdit.getApplicationClient();
                    this.serviceReferences = appClient.getServiceRefs();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    if (artifactEdit != null) {
                        artifactEdit.dispose();
                    }
                }
            }
            finally {
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
    }

    private void getNamesFromEjbJarXML() {
        EJBArtifactEdit artifactEdit = null;
        if (J2EEUtils.isEJBProject((IProject)this.proxyProject)) {
            try {
                try {
                    artifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)this.proxyProject);
                    EJBJar ejbJar = artifactEdit.getEJBJar();
                    EList ejbs = ejbJar.getEnterpriseBeans();
                    int i = 0;
                    while (i < ejbs.size()) {
                        EnterpriseBean bean = (EnterpriseBean)ejbs.get(i);
                        this.serviceReferences = bean.getServiceRefs();
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    if (artifactEdit != null) {
                        artifactEdit.dispose();
                    }
                }
            }
            finally {
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
    }

    private void getPortNameFromWSDL(String wsdlurl) {
        if (wsdlurl.indexOf(58) < 0 || wsdlurl.indexOf("platform:/resource") >= 0) {
            wsdlurl = PlatformUtils.getFileURLFromPlatform(wsdlurl);
        }
        Definition wsdlDefinition = this.wSParser.getWSDLDefinition(wsdlurl);
        this.wsdlServices.addAll(wsdlDefinition.getServices().values());
        int ws = 0;
        while (ws < this.wsdlServices.size()) {
            Service service = (Service)this.wsdlServices.get(ws);
            int sr = 0;
            while (sr < this.serviceReferences.size()) {
                String srName = ((org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef)this.serviceReferences.get(sr)).getServiceRefName();
                if (srName.lastIndexOf(47) != -1) {
                    srName = srName.substring(srName.lastIndexOf(47) + 1);
                }
                if (srName.equals(service.getQName().getLocalPart())) {
                    this.newServiceReferences.add(this.serviceReferences.get(sr));
                }
                ++sr;
            }
            ++ws;
        }
        this.wsdlPorts.addAll(((Service)this.wsdlServices.get(0)).getPorts().values());
    }

    private void updateWsBndDSIG6() {
        WscbndArtifactEdit artifactEdit = null;
        try {
            try {
                artifactEdit = WscbndArtifactEdit.getWSCBNDArtifactEditForWrite((IProject)this.proxyProject);
                ClientBinding wscbnd = artifactEdit.getClientBinding();
                byte type = this.javaWSDLParam.getServerSide();
                EList serviceRefs = type == 4 ? ((com.ibm.etools.webservice.wscbnd.ComponentScopedRefs)wscbnd.getComponentScopedRefs().get(0)).getServiceRefs() : wscbnd.getServiceRefs();
                ServiceRef serRef = (ServiceRef)serviceRefs.get(0);
                serRef.setServiceRefLink(((org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef)this.newServiceReferences.get(0)).getServiceRefName());
                EList portQnameBindings = serRef.getPortQnameBindings();
                PortQnameBinding pqBnd = (PortQnameBinding)portQnameBindings.get(0);
                pqBnd.setPortQnameLocalNameLink(((Port)this.wsdlPorts.get(0)).getName());
                int p = 1;
                while (p < this.wsdlPorts.size()) {
                    EObject newPortQnameBinding = EcoreUtil.copy((EObject)pqBnd);
                    ((PortQnameBinding)newPortQnameBinding).setPortQnameLocalNameLink(((Port)this.wsdlPorts.get(p)).getName());
                    serRef.getPortQnameBindings().add((Object)newPortQnameBinding);
                    ++p;
                }
                int sr = 1;
                while (sr < this.newServiceReferences.size()) {
                    ArrayList wsdlServicesPort = new ArrayList();
                    wsdlServicesPort.addAll(((Service)this.wsdlServices.get(sr)).getPorts().values());
                    ServiceRef newSerRef = (ServiceRef)EcoreUtil.copy((EObject)serRef);
                    newSerRef.setServiceRefLink(((org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef)this.newServiceReferences.get(sr)).getServiceRefName());
                    portQnameBindings = newSerRef.getPortQnameBindings();
                    pqBnd = (PortQnameBinding)portQnameBindings.get(0);
                    pqBnd.setPortQnameLocalNameLink(((Port)wsdlServicesPort.get(0)).getName());
                    int p2 = 1;
                    while (p2 < wsdlServicesPort.size()) {
                        EObject newPortQnameBinding = EcoreUtil.copy((EObject)pqBnd);
                        ((PortQnameBinding)newPortQnameBinding).setPortQnameLocalNameLink(((Port)wsdlServicesPort.get(p2)).getName());
                        newSerRef.getPortQnameBindings().add((Object)newPortQnameBinding);
                        ++p2;
                    }
                    serviceRefs.add((Object)newSerRef);
                    ++sr;
                }
                artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void updateWsExtDSIG6() {
        WscextArtifactEdit artifactEdit = null;
        try {
            try {
                artifactEdit = WscextArtifactEdit.getWSCEXTArtifactEditForWrite((IProject)this.proxyProject);
                WsClientExtension wscext = artifactEdit.getWsClientExtension();
                byte type = this.javaWSDLParam.getServerSide();
                EList serviceRefs = type == 4 ? ((ComponentScopedRefs)wscext.getComponentScopedRefs().get(0)).getServiceRefs() : wscext.getServiceRefs();
                com.ibm.etools.webservice.wscext.ServiceRef serviceRef = (com.ibm.etools.webservice.wscext.ServiceRef)serviceRefs.get(0);
                serviceRef.setServiceRefLink(((org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef)this.newServiceReferences.get(0)).getServiceRefName());
                EList portQnameBindings = serviceRef.getPortQnameBindings();
                com.ibm.etools.webservice.wscext.PortQnameBinding pqBnd = (com.ibm.etools.webservice.wscext.PortQnameBinding)portQnameBindings.get(0);
                pqBnd.setPortQnameLocalNameLink(((Port)this.wsdlPorts.get(0)).getName());
                int p = 1;
                while (p < this.wsdlPorts.size()) {
                    EObject newPortQnameBinding = EcoreUtil.copy((EObject)pqBnd);
                    ((com.ibm.etools.webservice.wscext.PortQnameBinding)newPortQnameBinding).setPortQnameLocalNameLink(((Port)this.wsdlPorts.get(p)).getName());
                    serviceRef.getPortQnameBindings().add((Object)newPortQnameBinding);
                    ++p;
                }
                int sr = 1;
                while (sr < this.newServiceReferences.size()) {
                    ArrayList wsdlServicesPort = new ArrayList();
                    wsdlServicesPort.addAll(((Service)this.wsdlServices.get(sr)).getPorts().values());
                    com.ibm.etools.webservice.wscext.ServiceRef newServiceRef = (com.ibm.etools.webservice.wscext.ServiceRef)EcoreUtil.copy((EObject)serviceRef);
                    newServiceRef.setServiceRefLink(((org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef)this.newServiceReferences.get(sr)).getServiceRefName());
                    portQnameBindings = newServiceRef.getPortQnameBindings();
                    pqBnd = (com.ibm.etools.webservice.wscext.PortQnameBinding)portQnameBindings.get(0);
                    pqBnd.setPortQnameLocalNameLink(((Port)wsdlServicesPort.get(0)).getName());
                    int p2 = 1;
                    while (p2 < wsdlServicesPort.size()) {
                        EObject newPortQnameBinding = EcoreUtil.copy((EObject)pqBnd);
                        ((com.ibm.etools.webservice.wscext.PortQnameBinding)newPortQnameBinding).setPortQnameLocalNameLink(((Port)wsdlServicesPort.get(p2)).getName());
                        newServiceRef.getPortQnameBindings().add((Object)newPortQnameBinding);
                        ++p2;
                    }
                    serviceRefs.add((Object)newServiceRef);
                    ++sr;
                }
                artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void copyTemplateFromBundle(String source, IPath target, IStatus status, IEnvironment env, IProgressMonitor monitor) {
        try {
            TransientResourceContext context = new TransientResourceContext();
            context.setOverwriteFilesEnabled(true);
            context.setCreateFoldersEnabled(true);
            context.setCheckoutFilesEnabled(true);
            FileResourceUtils.createFile((ResourceContext)context, (IPath)target, (InputStream)WebServiceWasConsumptionUIPlugin.getInstance().getBundle().getEntry(source).openStream(), (IProgressMonitor)monitor, (IStatusHandler)env.getStatusHandler());
        }
        catch (Exception e) {
            status = StatusUtils.errorStatus((String)Messages.MSG_ERROR_FILECOPY, (Throwable)e);
            env.getStatusHandler().reportError(status);
        }
    }

    private void getWSCDDFilePath() {
        IPath projectPath = this.proxyProject.getFullPath();
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.proxyProject);
        IVirtualFolder ivFolder = null;
        if (J2EEUtils.isWebProject((IProject)this.proxyProject)) {
            ivFolder = J2EEUtils.getWebDeploymentDescriptorFolder((IVirtualComponent)component);
        } else if (J2EEUtils.isEJBProject((IProject)this.proxyProject)) {
            ivFolder = J2EEUtils.getEJBDeploymentDescriptorFolder((IVirtualComponent)component);
        } else if (J2EEUtils.isAppClientProject((IProject)this.proxyProject)) {
            ivFolder = J2EEUtils.getAppClientDeploymentDescriptorFolder((IVirtualComponent)component);
        }
        IVirtualFile ivFile = ivFolder.getFile(this.WEBSERVICESCLIENT_XML);
        if (ivFile.exists()) {
            this.webServicesClientXMLPath = projectPath.append(ivFile.getProjectRelativePath());
        }
        if ((ivFile = ivFolder.getFile(this.IBM_WEBSERVICESCLIENT_BND_XMI)).exists()) {
            this.ibmWebServicesClientBndXMIPath = projectPath.append(ivFile.getProjectRelativePath());
        }
        if ((ivFile = ivFolder.getFile(this.IBM_WEBSERVICESCLIENT_EXT_XMI)).exists()) {
            this.ibmWebServicesClientExtXMIPath = projectPath.append(ivFile.getProjectRelativePath());
        }
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setProxyProject(IProject proxyProject) {
        this.proxyProject = proxyProject;
    }

    public void setWebServicesParser(WebServicesParser parser) {
        this.wSParser = parser;
    }
}

