/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.validation.wsdl.jaxrpc;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.ast.ws.validation.wsdl.WASValidatorConstants;
import com.ibm.xwt.wsdl.validation.wsdl.IDiagnosticProvider;
import com.ibm.xwt.wsdl.validation.xsd.InlineXSDSchemaValidator;
import java.util.Map;
import org.eclipse.wst.wsdl.ExtensibilityElement;
import org.eclipse.wst.wsdl.util.WSDLDiagnostic;
import org.eclipse.wst.wsdl.util.WSDLDiagnosticImpl;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.NamedNodeMap;

public class WASJaxrpcXSDExtensionsValidator
extends InlineXSDSchemaValidator {
    boolean shouldValidate;

    public void configure(Map options) {
        WASValidatorConstants.configure(options, (IDiagnosticProvider)this);
        this.shouldValidate = WASValidatorConstants.shouldValidate(options);
    }

    public void validate(ExtensibilityElement extensibilityElement) {
        if (this.shouldValidate) {
            super.validate(extensibilityElement);
        }
    }

    protected void doValidate(XSDSchema schema) {
        this.checkNamespaceURIs(schema);
    }

    protected String getMessagePrefix() {
        return "QoS(JAX-RPC): ";
    }

    private void checkNamespaceURIs(XSDSchema schema) {
        NamedNodeMap attributes = schema.getElement().getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            String uri = attributes.item(i).getTextContent().toLowerCase();
            if (!(uri.startsWith("http://") || uri.startsWith("https://") || uri.startsWith("/") || uri.startsWith("./") || uri.startsWith("../"))) {
                WSDLDiagnosticImpl wsdlDiagnostic;
                XSDDiagnostic xsdDiagnostic;
                if (uri.startsWith("urn:")) {
                    xsdDiagnostic = XSDFactory.eINSTANCE.createXSDDiagnostic();
                    xsdDiagnostic.setPrimaryComponent((XSDConcreteComponent)schema);
                    xsdDiagnostic.setKey("URN_NAMESPACE");
                    xsdDiagnostic.setNode(attributes.item(i));
                    wsdlDiagnostic = new WSDLDiagnosticImpl(xsdDiagnostic);
                    wsdlDiagnostic.setSeverity(this.getDefaultSeverity());
                    wsdlDiagnostic.setMessage(String.valueOf(this.getMessagePrefix()) + Messages.URN_NAMESPACE + " " + uri);
                    this.addDiagnostic((WSDLDiagnostic)wsdlDiagnostic);
                } else {
                    xsdDiagnostic = XSDFactory.eINSTANCE.createXSDDiagnostic();
                    xsdDiagnostic.setPrimaryComponent((XSDConcreteComponent)schema);
                    xsdDiagnostic.setKey("BAD_NAMESPACE");
                    xsdDiagnostic.setNode(attributes.item(i));
                    wsdlDiagnostic = new WSDLDiagnosticImpl(xsdDiagnostic);
                    wsdlDiagnostic.setSeverity(this.getDefaultSeverity());
                    wsdlDiagnostic.setMessage(String.valueOf(this.getMessagePrefix()) + Messages.BAD_NAMESPACE + " " + uri);
                    this.addDiagnostic((WSDLDiagnostic)wsdlDiagnostic);
                }
            }
            ++i;
        }
    }
}

