/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.validation.wsdl.jaxrpc;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.ast.ws.validation.wsdl.WASValidatorConstants;
import com.ibm.xwt.wsdl.validation.wsdl.AbstractWSDLValidator;
import com.ibm.xwt.wsdl.validation.wsdl.IDiagnosticProvider;
import java.util.Map;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingFault;
import org.eclipse.wst.wsdl.BindingInput;
import org.eclipse.wst.wsdl.BindingOutput;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.WSDLElement;
import org.w3c.dom.NamedNodeMap;

public class WASJaxrpcWSDLValidator
extends AbstractWSDLValidator {
    public void configure(Map options) {
        WASValidatorConstants.configure(options, (IDiagnosticProvider)this);
    }

    public void validateBinding(Binding binding) {
    }

    public void validateBindingFault(BindingFault bindingFault) {
    }

    public void validateBindingInput(BindingInput bindingInput) {
    }

    public void validateBindingOutput(BindingOutput bindingOutput) {
    }

    public void validateDefinitions(Definition definition) {
        this.checkURInamespaces(definition);
    }

    public void validateImport(Import wsdlImport) {
    }

    public void validatePortType(PortType portType) {
    }

    public void validateTypes(Types types) {
    }

    protected String getMessage(String messageID, Object[] params) {
        return Messages.bind((String)messageID, (Object[])params);
    }

    protected String getMessagePrefix() {
        return "QoS(JAX-RPC): ";
    }

    private void checkURInamespaces(Definition definition) {
        NamedNodeMap attributes = definition.getElement().getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            String uri = attributes.item(i).getTextContent().toLowerCase();
            if (!uri.startsWith("http://") && !uri.startsWith("https://")) {
                if (uri.startsWith("/") || uri.startsWith("./") || uri.startsWith("../")) {
                    this.addDiagnostic((WSDLElement)definition, "RELATIVE_URI", Messages.RELATIVE_URI, new Object[]{uri}, attributes.item(i));
                } else if (uri.startsWith("http://schemas.xmlsoap.org/wsdl/soap12")) {
                    this.addDiagnostic((WSDLElement)definition, "JAXRPC_SOAP12", Messages.JAXRPC_SOAP12, new Object[]{uri}, attributes.item(i));
                } else if (uri.startsWith("urn:")) {
                    this.addDiagnostic((WSDLElement)definition, "URN_NAMESPACE", String.valueOf(Messages.URN_NAMESPACE) + " " + uri, new Object[]{uri}, attributes.item(i));
                } else {
                    this.addDiagnostic((WSDLElement)definition, "BAD_NAMESPACE", String.valueOf(Messages.BAD_NAMESPACE) + " " + uri, new Object[]{uri}, attributes.item(i));
                }
            }
            ++i;
        }
    }
}

