/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.pli.spi.properties;

import com.ibm.adapter.pli.PliMessageResource;
import com.ibm.adapter.pli.spi.properties.PliBaseProperty;
import com.ibm.adapter.pli.spi.properties.PliPlatformProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.PropertyVetoException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PliEndianProperty
extends PliBaseProperty {
    private static String[] validEndianValues = null;

    public PliEndianProperty() throws CoreException {
        super(PliMessageResource.ENDIAN_PROP_NAME, PliMessageResource.ENDIAN_PROP_DISPLAY_NAME, PliMessageResource.ENDIAN_PROP_DESC);
        this.initializeProperty();
    }

    public void setPliKey(String arg) {
        this.pliKey = arg;
    }

    public void setValidValues(Object[] values) throws CoreException {
        Status status = new Status(4, "com.ibm.adapter.pli", 4, PliMessageResource.ERROR_METHOD_NOT_IMPLEMENTED, (Throwable)new Exception(PliMessageResource.ERROR_METHOD_NOT_IMPLEMENTED));
        throw new CoreException((IStatus)status);
    }

    private void initializeProperty() {
        try {
            this.pliKey = "com.ibm.ccl.pli.PLI_ENDIAN";
            validEndianValues = new String[]{"Little", "Big"};
            super.setValidValues((Object[])validEndianValues);
            this.setDefaultValue("Little");
            this.setValue("Little");
            this.setExpert(true);
        }
        catch (CoreException e) {
            this.envStatus = new Status(4, "com.ibm.adapter.pli", 4, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof PliPlatformProperty) {
            if (((String)evt.getNewValue()).equalsIgnoreCase("Win32")) {
                try {
                    this.setValue("Little");
                    this.setDefaultValue("Little");
                }
                catch (CoreException e) {
                    this.envStatus = new Status(4, "com.ibm.adapter.pli", 4, e.getMessage(), (Throwable)e);
                }
            } else if (((String)evt.getNewValue()).equalsIgnoreCase("z/OS")) {
                try {
                    this.setValue("Big");
                    this.setDefaultValue("Big");
                }
                catch (CoreException e) {
                    this.envStatus = new Status(4, "com.ibm.adapter.pli", 4, e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        boolean valid = false;
        int i = 0;
        while (i < validEndianValues.length) {
            if (((String)evt.getNewValue()).equalsIgnoreCase(validEndianValues[i])) {
                valid = true;
                break;
            }
            ++i;
        }
        if (!valid) {
            throw new PropertyVetoException(PliMessageResource.INVALID_PROPERTY_VALUE, (java.beans.PropertyChangeEvent)evt);
        }
    }
}

