/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.pli.spi.properties;

import com.ibm.adapter.pli.PliMessageResource;
import com.ibm.adapter.pli.spi.properties.PliBaseProperty;
import com.ibm.adapter.pli.spi.properties.PliCICSVersionProperty;
import com.ibm.adapter.pli.spi.properties.PliCodepageProperty;
import com.ibm.adapter.pli.spi.properties.PliDbcsProperty;
import com.ibm.adapter.pli.spi.properties.PliEndianProperty;
import com.ibm.adapter.pli.spi.properties.PliFloatingPointFormatProperty;
import com.ibm.adapter.pli.spi.properties.PliGraphicProperty;
import com.ibm.adapter.pli.spi.properties.PliIMSSupportProperty;
import com.ibm.adapter.pli.spi.properties.PliPlatformProperty;
import com.ibm.ccl.pli.importer.IPliPreferenceConstants;
import com.ibm.ccl.pli.plugin.PliPlugin;
import com.ibm.ccl.pli.preference.ui.common.IPliUIPreferenceConstants;
import com.ibm.ccl.pli.preference.ui.plugin.PliPreferenceResources;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.IVetoableChangeListener;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.IPreferenceStore;

public class PliDiscoveryAgentPropertyGroup
extends BasePropertyGroup {
    private IPreferenceStore store = PliPlugin.getDefault().getPreferenceStore();

    public PliDiscoveryAgentPropertyGroup() throws CoreException {
        super(PliMessageResource.PLI_AGENT_PROP_GROUP_NAME, PliMessageResource.PLI_AGENT_PROP_GROUP_DISPLAY_NAME, PliMessageResource.PLI_AGENT_PROP_GROUP_DESC);
        this.initializeSearchParameters();
        this.setValuesFromPreferenceStore((IPropertyGroup)this);
    }

    private void initializeSearchParameters() throws CoreException {
        PliPlatformProperty platform = new PliPlatformProperty();
        PliCodepageProperty codepage = new PliCodepageProperty();
        PliFloatingPointFormatProperty fpt = new PliFloatingPointFormatProperty();
        PliEndianProperty endian = new PliEndianProperty();
        PliDbcsProperty dbcs = new PliDbcsProperty();
        PliGraphicProperty graphic = new PliGraphicProperty();
        PliIMSSupportProperty ims = new PliIMSSupportProperty();
        PliCICSVersionProperty cicsversion = new PliCICSVersionProperty();
        cicsversion.addPropertyChangeListener((IPropertyChangeListener)ims);
        ims.addPropertyChangeListener((IPropertyChangeListener)cicsversion);
        if (dbcs.getEnvStatus().getSeverity() != 0) {
            throw new CoreException((IStatus)dbcs.getEnvStatus());
        }
        if (graphic.getEnvStatus().getSeverity() != 0) {
            throw new CoreException((IStatus)graphic.getEnvStatus());
        }
        platform.addPropertyChangeListener((IPropertyChangeListener)codepage);
        platform.addPropertyChangeListener((IPropertyChangeListener)fpt);
        platform.addPropertyChangeListener((IPropertyChangeListener)endian);
        this.addProperty((IPropertyDescriptor)platform);
        this.addProperty((IPropertyDescriptor)codepage);
        this.addProperty((IPropertyDescriptor)fpt);
        this.addProperty((IPropertyDescriptor)endian);
        this.addProperty((IPropertyDescriptor)ims);
        this.addProperty((IPropertyDescriptor)cicsversion);
        this.addProperty((IPropertyDescriptor)dbcs);
        this.addProperty((IPropertyDescriptor)graphic);
    }

    public Object clone() throws CloneNotSupportedException {
        PliDiscoveryAgentPropertyGroup clone = (PliDiscoveryAgentPropertyGroup)((Object)super.clone());
        PliPlatformProperty platform = (PliPlatformProperty)clone.getProperty(PliMessageResource.PLATFORM_PROP_NAME);
        PliCodepageProperty codepage = (PliCodepageProperty)clone.getProperty(PliMessageResource.CODEPAGE_PROP_NAME);
        PliFloatingPointFormatProperty floatpointformat = (PliFloatingPointFormatProperty)clone.getProperty(PliMessageResource.FLOATING_POINT_FORMAT_PROP_NAME);
        PliEndianProperty endian = (PliEndianProperty)clone.getProperty(PliMessageResource.ENDIAN_PROP_NAME);
        PliIMSSupportProperty ims = (PliIMSSupportProperty)clone.getProperty(PliIMSSupportProperty.getPropertyName());
        platform.addVetoablePropertyChangeListener((IVetoableChangeListener)platform);
        PliCICSVersionProperty cicsversion = (PliCICSVersionProperty)clone.getProperty(PliCICSVersionProperty.getPropertyName());
        cicsversion.addVetoablePropertyChangeListener((IVetoableChangeListener)cicsversion);
        cicsversion.addPropertyChangeListener((IPropertyChangeListener)ims);
        ims.addPropertyChangeListener((IPropertyChangeListener)cicsversion);
        platform.addPropertyChangeListener((IPropertyChangeListener)codepage);
        platform.addPropertyChangeListener((IPropertyChangeListener)floatpointformat);
        platform.addPropertyChangeListener((IPropertyChangeListener)endian);
        return clone;
    }

    private void setValuesFromPreferenceStore(IPropertyGroup group) throws CoreException {
        if (this.store == null) {
            return;
        }
        List<IPropertyDescriptor> list = Arrays.asList(group.getProperties());
        int i = 0;
        while (i < list.size()) {
            PliBaseProperty property;
            String pliKey;
            IPropertyDescriptor element = list.get(i);
            if (element instanceof IPropertyGroup) {
                this.setValuesFromPreferenceStore((IPropertyGroup)element);
            } else if (element instanceof PliBaseProperty && this.store.contains(pliKey = (property = (PliBaseProperty)element).getPliKey())) {
                String pliValue = null;
                if (pliKey.equals("com.ibm.ccl.pli.PLI_PLATFORM_SELECTION")) {
                    pliValue = IPliUIPreferenceConstants.PS_ITEM[this.store.getInt(pliKey)];
                } else if (pliKey.equals("com.ibm.ccl.pli.PLI_FLOATING_POINT_FORMAT")) {
                    pliValue = IPliUIPreferenceConstants.FPF_ITEM[this.store.getInt(pliKey)];
                } else if (pliKey.equals("com.ibm.ccl.pli.PLI_DBCS")) {
                    pliValue = this.store.getBoolean(pliKey) ? PliPreferenceResources.DBCS_VALUE_DBCS : PliPreferenceResources.DBCS_VALUE_NODBCS;
                } else if (pliKey.equals("com.ibm.ccl.pli.PLI_GRAPHIC")) {
                    pliValue = this.store.getBoolean(pliKey) ? PliPreferenceResources.GRAPHIC_VALUE_GRAPHIC : PliPreferenceResources.GRAPHIC_VALUE_NOGRAPHIC;
                } else if (pliKey.equals("com.ibm.ccl.pli.PLI_IMS_SUPPORT")) {
                    pliValue = this.store.getBoolean(pliKey) ? "true" : "false";
                } else if (pliKey.equals("com.ibm.ccl.pli.PLI_CICS_VERSION")) {
                    String ver = this.store.getString(pliKey);
                    if (ver != null) {
                        if (ver.equals("NOCICS")) {
                            pliValue = IPliPreferenceConstants.CICSNONELABEL;
                        } else if (ver.equals("31")) {
                            pliValue = IPliPreferenceConstants.CICS31LABEL;
                        } else if (ver.equals("32")) {
                            pliValue = IPliPreferenceConstants.CICS32LABEL;
                        }
                    }
                } else {
                    pliValue = this.store.getString(pliKey);
                }
                if (property.isEnabled()) {
                    property.setValue(pliValue);
                }
            }
            ++i;
        }
    }
}

