/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.pli;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IResultNode;
import com.ibm.adapter.framework.IResultNodeResponse;
import com.ibm.adapter.framework.IResultNodeSelection;
import com.ibm.adapter.framework.spi.BaseResultNodeResponse;
import com.ibm.adapter.framework.spi.BaseSearchTree;
import com.ibm.adapter.pli.PliMessageResource;
import com.ibm.adapter.pli.PliQueryResultNode;
import com.ibm.adapter.pli.PliResultSelection;
import com.ibm.adapter.pli.spi.properties.PliBaseProperty;
import com.ibm.adapter.pli.spi.properties.PliDiscoveryAgentPropertyGroup;
import com.ibm.adapter.pli.spi.properties.PliPropertyConverter;
import com.ibm.ccl.pli.PLIClassifier;
import com.ibm.ccl.pli.PLIComposedType;
import com.ibm.ccl.pli.PLIElement;
import com.ibm.ccl.pli.importer.ErrorMessageInfo;
import com.ibm.ccl.pli.importer.PliException;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class PliSearchTree
extends BaseSearchTree {
    private boolean isJava = false;
    private Resource importerResource;
    private ArrayList searchResult;

    public PliSearchTree(Resource resource) throws BaseException {
        try {
            this.importerResource = resource;
            if (resource.getURI().toFileString().toLowerCase().endsWith(".java")) {
                this.isJava = true;
            }
            PliDiscoveryAgentPropertyGroup group = null;
            group = this.isJava ? new BasePropertyGroup(PliMessageResource.PLI_AGENT_PROP_GROUP_NAME, PliMessageResource.PLI_AGENT_PROP_GROUP_DISPLAY_NAME, PliMessageResource.PLI_AGENT_PROP_GROUP_DESC) : new PliDiscoveryAgentPropertyGroup();
            this.setFilterProperties((IPropertyGroup)group);
            this.setSelectionStyle(0);
        }
        catch (CoreException e) {
            throw new BaseException(e.getStatus());
        }
    }

    public IResultNodeSelection createResultNodeSelection() {
        return new PliResultSelection();
    }

    public IResultNode getResultNode(String location, IEnvironment environment) throws BaseException {
        return null;
    }

    public IResultNodeResponse performQuery(IPropertyGroup searchParameters, IEnvironment environment) throws BaseException {
        if (this.isJava) {
            this.convertJavaFile2QueryResultNodeTree();
        } else {
            Map importProperties = this.convertSerachParams2HashMap(searchParameters);
            this.importPli(importProperties);
            this.convertPliModel2QueryResultNodeTree();
        }
        return new BaseResultNodeResponse((List)this.searchResult, "");
    }

    private void convertPliModel2QueryResultNodeTree() throws BaseException {
        this.searchResult = new ArrayList();
        Iterator typeIterator = this.importerResource.getContents().iterator();
        try {
            while (typeIterator.hasNext()) {
                Object possibleType = typeIterator.next();
                if (!(possibleType instanceof PLIElement)) continue;
                PLIElement element = (PLIElement)possibleType;
                PLIClassifier classifier = element.getSharedType();
                PliQueryResultNode node = new PliQueryResultNode();
                node.setData(this.importerResource.getURIFragment((EObject)element));
                node.setName(element.getName());
                node.setDescription(element.getName());
                node.setSelectable(true);
                this.searchResult.add(node);
                if (!(classifier instanceof PLIComposedType)) continue;
                this.visitPliElement((PLIComposedType)classifier, node);
            }
        }
        catch (Exception e) {
            Status newStatus = new Status(4, "com.ibm.adapter.pli", 4, String.valueOf(PliMessageResource.ERROR_WALKING_PLI_MODEL) + e.getMessage(), (Throwable)e);
            throw new BaseException((IStatus)newStatus);
        }
    }

    private Map convertSerachParams2HashMap(IPropertyGroup searchParameters) {
        HashMap importProperties = new HashMap();
        this.convertSerachParams2HashMap(searchParameters, importProperties);
        return importProperties;
    }

    private void convertSerachParams2HashMap(IPropertyGroup searchParameters, Map importProperties) {
        IPropertyDescriptor[] searchParametersArg = searchParameters.getProperties();
        int arraySize = searchParametersArg.length;
        int i = 0;
        while (i < arraySize) {
            IPropertyDescriptor obj = searchParametersArg[i];
            if (obj instanceof IPropertyGroup) {
                this.convertSerachParams2HashMap((IPropertyGroup)obj, importProperties);
            } else {
                String pliKey = ((PliBaseProperty)obj).getPliKey();
                String pliValue = (String)((PliBaseProperty)obj).getValue();
                importProperties.put(pliKey, PliPropertyConverter.getPliValue(pliValue));
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void importPli(Map importProperties) throws BaseException {
        block4: {
            block6: {
                block5: {
                    try {
                        this.importerResource.unload();
                        this.importerResource.load(importProperties);
                        break block4;
                    }
                    catch (IOException e) {
                        sb = new StringBuffer();
                        if (!(e instanceof PliException)) break block5;
                        x = (PliException)e;
                        sb.append(x.getMessage()).append("\n").append(x.getMessageNote());
                        errorMessageVector = x.getErrorMessagesVector();
                        if (errorMessageVector.size() > 0) {
                            sb.append("\n").append("\n").append(PliMessageResource.COMPILER_ERRORS_UI_);
                        }
                        i = 0;
                        ** while (i < errorMessageVector.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        info = (ErrorMessageInfo)errorMessageVector.get(i);
                        sb.append("\n").append(i + 1).append(". ").append(info.getMessageString());
                        ++i;
                        continue;
lbl22:
                        // 1 sources

                        break block6;
                    }
                }
                sb.append(PliMessageResource.ERROR_IMPORTING_PLI_FILE).append(". ").append(e.getMessage());
            }
            newStatus = new Status(4, "com.ibm.adapter.pli", 4, sb.toString(), (Throwable)e);
            throw new BaseException((IStatus)newStatus);
        }
    }

    private void visitPliElement(PLIComposedType composedType, PliQueryResultNode parentNode) {
        EList elements = composedType.getElements();
        int i = 0;
        while (i < elements.size()) {
            PLIElement pliElement;
            PLIClassifier childClassifier;
            Object childElement = elements.get(i);
            if (childElement instanceof PLIElement && (childClassifier = (pliElement = (PLIElement)childElement).getSharedType()) instanceof PLIComposedType && pliElement.getArray().size() == 0) {
                PliQueryResultNode childNode = new PliQueryResultNode();
                childNode.setData(this.importerResource.getURIFragment((EObject)pliElement));
                childNode.setName(pliElement.getName());
                childNode.setDescription(pliElement.getName());
                childNode.setSelectable(true);
                parentNode.addChild((IResultNode)childNode);
                this.visitPliElement((PLIComposedType)childClassifier, childNode);
            }
            ++i;
        }
    }

    private void convertJavaFile2QueryResultNodeTree() {
        this.searchResult = new ArrayList();
        File file = new File(this.importerResource.getURI().toFileString());
        PliQueryResultNode node = new PliQueryResultNode();
        node.setName(file.getName());
        node.setSelectable(true);
        this.searchResult.add(node);
    }
}

