/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2ca.internal;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IDiscoveryAgent;
import com.ibm.adapter.framework.internal.build.IBuildAgent;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.adapter.j2ca.IResourceAdapterListener;
import com.ibm.adapter.j2ca.IResourceAdapterRegistry;
import com.ibm.adapter.j2ca.ResourceAdapterEvent;
import com.ibm.adapter.j2ca.internal.ConnectorChangeListener;
import com.ibm.adapter.j2ca.internal.ConnectorProjectSynchronizerExtender;
import com.ibm.adapter.j2ca.internal.LogFacility;
import com.ibm.adapter.j2ca.internal.MessageResource;
import com.ibm.adapter.j2ca.internal.ResourceAdapterDescriptorConstants;
import com.ibm.adapter.j2ca.internal.ResourceAdapterDescriptorImpl;
import com.ibm.adapter.j2ca.spi.util.ConnectorProjectHelper;
import com.ibm.adapter.j2ca.spi.util.InMemoryClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ISynchronizerExtender;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.jca.modulecore.util.ConnectorArtifactEdit;

public class ResourceAdapterRegistry
implements IResourceAdapterRegistry,
com.ibm.adapter.j2ca.spi.IResourceAdapterRegistry,
ResourceAdapterDescriptorConstants,
IResourceDeltaVisitor {
    private static ResourceAdapterRegistry _instance;
    private static ThreadCount threadCount;
    private Map _resourceAdapterRegistry = Collections.synchronizedMap(new HashMap());
    private Vector listeners = new Vector();

    static {
        threadCount = new ThreadCount();
    }

    public static ResourceAdapterRegistry getRegistry() {
        if (_instance == null) {
            ResourceAdapterRegistry.initializeInstance();
        }
        return _instance;
    }

    private static synchronized void initializeInstance() {
        if (_instance == null) {
            _instance = new ResourceAdapterRegistry();
        }
    }

    private ResourceAdapterRegistry() {
        this.initialize();
    }

    public synchronized void addResourceAdapter(IProject project) throws BaseException {
        LogFacility.TrcEntry();
        if (LogFacility.trace) {
            LogFacility.Trace((String)new StringBuffer("Adding Resource Adapter: ").append(project.getName()).toString(), (short)10);
        }
        try {
            try {
                ResourceAdapterDescriptorImpl descriptor = new ResourceAdapterDescriptorImpl(null, project);
                this.registerResourceAdapter(descriptor);
                ConnectorProjectSynchronizerExtender extender = new ConnectorProjectSynchronizerExtender(project);
                ResourceSet resSet = ConnectorArtifactEdit.getConnectorArtifactEditForRead((IProject)project).getConnectorXmiResource().getResourceSet();
                if (resSet instanceof ProjectResourceSet) {
                    ((ProjectResourceSet)resSet).getSynchronizer().addExtender((ISynchronizerExtender)extender);
                }
                if (LogFacility.trace) {
                    LogFacility.Trace((String)new StringBuffer("Finished adding Resource Adapter: ").append(project.getName()).toString(), (short)10);
                }
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    @Override
    public synchronized void addResourceAdapterListener(IResourceAdapterListener listener) {
        try {
            this.listeners.add(listener);
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public IResourceAdapterDescriptor[] getAllImportEnabledAdapters() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            IResourceAdapterDescriptor[] ret;
            IResourceAdapterDescriptor[] descriptors = this.getAllResourceAdapters();
            ArrayList<IResourceAdapterDescriptor> list = new ArrayList<IResourceAdapterDescriptor>();
            int i = 0;
            while (i < descriptors.length) {
                IResourceAdapterDescriptor descriptor = descriptors[i];
                if (descriptor.hasDiscoveryAgent()) {
                    list.add(descriptor);
                }
                ++i;
            }
            if (list.isEmpty()) {
                return null;
            }
            IResourceAdapterDescriptor[] iResourceAdapterDescriptorArray = ret = list.toArray(new IResourceAdapterDescriptor[0]);
            return iResourceAdapterDescriptorArray;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    @Override
    public IResourceAdapterDescriptor[] getAllNonImportAdapters() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            IResourceAdapterDescriptor[] descriptors = this.getAllResourceAdapters();
            ArrayList<IResourceAdapterDescriptor> list = new ArrayList<IResourceAdapterDescriptor>();
            int i = 0;
            while (i < descriptors.length) {
                IResourceAdapterDescriptor descriptor = descriptors[i];
                if (!descriptor.hasDiscoveryAgent()) {
                    list.add(descriptor);
                }
                ++i;
            }
            if (list.isEmpty()) {
                return null;
            }
            IResourceAdapterDescriptor[] iResourceAdapterDescriptorArray = list.toArray(new IResourceAdapterDescriptor[0]);
            return iResourceAdapterDescriptorArray;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    @Override
    public IResourceAdapterDescriptor[] getAllResourceAdapters() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            Iterator iter = this._resourceAdapterRegistry.values().iterator();
            ArrayList completeList = new ArrayList();
            while (iter.hasNext()) {
                List adapters = (List)iter.next();
                completeList.addAll(adapters);
            }
            IResourceAdapterDescriptor[] descriptors = completeList.toArray(new IResourceAdapterDescriptor[0]);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            IResourceAdapterDescriptor[] iResourceAdapterDescriptorArray = descriptors;
            return iResourceAdapterDescriptorArray;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public synchronized IResourceAdapterDescriptor getResourceAdapterForProject(IProject connectorProject) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IResourceAdapterDescriptor[] getResourceAdaptersReferencedByProject(IJavaProject javaProject) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        ArrayList<IResourceAdapterDescriptor> resourceAdapterDescriptors = new ArrayList<IResourceAdapterDescriptor>();
        try {
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            int i = 0;
            while (true) {
                if (i >= entries.length) {
                    IResourceAdapterDescriptor[] iResourceAdapterDescriptorArray = resourceAdapterDescriptors.toArray(new IResourceAdapterDescriptor[0]);
                    return iResourceAdapterDescriptorArray;
                }
                try {
                    IClasspathEntry entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entries[i]);
                    IPath path = entry.getPath();
                    switch (entry.getEntryKind()) {
                        case 2: {
                            IResourceAdapterDescriptor descriptor;
                            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                            if (!project.exists() || ConnectorProjectHelper.isConnectorProject(project) == null || (descriptor = this.getResourceAdapterForProject(project)) == null) break;
                            resourceAdapterDescriptors.add(descriptor);
                        }
                    }
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    @Override
    public synchronized void registerResourceAdapter(IResourceAdapterDescriptor resourceAdapterDescriptor) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            try {
                ArrayList<IResourceAdapterDescriptor> adapters = (ArrayList<IResourceAdapterDescriptor>)this._resourceAdapterRegistry.get(this.getRegistryKey(resourceAdapterDescriptor));
                if (adapters == null) {
                    adapters = new ArrayList<IResourceAdapterDescriptor>();
                    this._resourceAdapterRegistry.put(this.getRegistryKey(resourceAdapterDescriptor), adapters);
                }
                if (!adapters.contains(resourceAdapterDescriptor)) {
                    adapters.add(resourceAdapterDescriptor);
                    resourceAdapterDescriptor.getConnectorProjectDescriptor().addSystemLibrariesToLibraryPath();
                    this.notifyListeners(new ResourceAdapterEvent(0, resourceAdapterDescriptor));
                }
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    @Override
    public synchronized void removeResourceAdapter(IResourceAdapterDescriptor adapter) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            try {
                if (adapter != null) {
                    String key = this.getRegistryKey(adapter);
                    List adapters = (List)this._resourceAdapterRegistry.get(key);
                    if (adapters != null) {
                        adapters.remove(adapter);
                        if (adapters.isEmpty()) {
                            this._resourceAdapterRegistry.remove(key);
                        }
                    }
                    this.notifyListeners(new ResourceAdapterEvent(1, adapter));
                    ClassLoader cl = adapter.getClassLoader();
                    if (cl instanceof InMemoryClassLoader) {
                        InMemoryClassLoader imCl = (InMemoryClassLoader)cl;
                        imCl.closeOpenJars();
                    }
                }
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public synchronized void removeResourceAdapter(IProject project) {
        IResourceAdapterDescriptor adapter = this.getResourceAdapterForProject(project);
        if (adapter != null) {
            this.removeResourceAdapter(adapter);
        }
    }

    @Override
    public synchronized void removeResourceAdapterListener(IResourceAdapterListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void waitForRegistryProcessing() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        long startTime = System.currentTimeMillis();
        ThreadCount threadCount = ResourceAdapterRegistry.threadCount;
        synchronized (threadCount) {
            while (ResourceAdapterRegistry.threadCount.count() > 0) {
                try {
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - startTime > 120000L) {
                        LogFacility.logErrorMessage((String)MessageResource.MSG_ERROR__REGISTRY_TIMEOUT, null);
                        return;
                    }
                    if (ResourceAdapterRegistry.threadCount.containsThread(Thread.currentThread().getName())) {
                        ResourceAdapterRegistry.threadCount.removeThread(Thread.currentThread().getName());
                    }
                    ResourceAdapterRegistry.threadCount.wait(100L);
                }
                catch (InterruptedException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    private String buildResourceAdapterID(String displayName, String version, String vendorName) {
        try {
            return new StringBuffer().append(displayName).append(version).append(vendorName).toString();
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private String getRegistryKey(Connector connector) {
        try {
            return this.buildResourceAdapterID(connector.getDisplayName(), connector.getVersion(), connector.getVendorName());
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private String getRegistryKey(IResourceAdapterDescriptor adapter) {
        try {
            return this.getRegistryKey(adapter.getConnector());
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private void initialize() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            boolean hasConnectorProjects;
            this.processListenerExtensionPoint();
            ConnectorChangeListener listener = new ConnectorChangeListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 14);
            IProject[] connectorProjects = ConnectorProjectHelper.getAllConnectorProjects();
            boolean bl = hasConnectorProjects = connectorProjects != null && connectorProjects.length >= 1;
            if (hasConnectorProjects) {
                int i = 0;
                while (i < connectorProjects.length) {
                    this.addResourceAdapter(connectorProjects[i]);
                    ++i;
                }
            }
        }
        catch (BaseException e1) {
            LogFacility.logErrorMessage((IStatus)e1.getStatus());
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(final ResourceAdapterEvent event) {
        block15: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                Vector targets = null;
                ResourceAdapterRegistry resourceAdapterRegistry = this;
                synchronized (resourceAdapterRegistry) {
                    if (this.listeners != null) {
                        targets = (Vector)this.listeners.clone();
                    }
                }
                if (targets == null) break block15;
                int i = 0;
                while (i < targets.size()) {
                    block16: {
                        if (LogFacility.trace) {
                            LogFacility.Trace((String)new StringBuffer("Notifying listener: ").append(targets.elementAt(i)).toString(), (short)10);
                        }
                        final IResourceAdapterListener target = (IResourceAdapterListener)targets.elementAt(i);
                        try {
                            Thread listenerThread = new Thread(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    if (event.getResourceAdapter() != null) {
                                        ResourceAdapterDescriptorImpl descriptor;
                                        ResourceAdapterDescriptorImpl resourceAdapterDescriptorImpl = descriptor = (ResourceAdapterDescriptorImpl)event.getResourceAdapter();
                                        synchronized (resourceAdapterDescriptorImpl) {
                                            try {
                                                target.notify(event);
                                            }
                                            catch (Throwable e) {
                                                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                                            }
                                            descriptor.removeWaitingListener(this);
                                            ThreadCount threadCount = threadCount;
                                            synchronized (threadCount) {
                                                threadCount.removeThread(this.getName());
                                                threadCount.notifyAll();
                                            }
                                            descriptor.notifyAll();
                                        }
                                    }
                                }
                            };
                            if (event.getResourceAdapter() == null) break block16;
                            ThreadCount threadCount = ResourceAdapterRegistry.threadCount;
                            synchronized (threadCount) {
                                ResourceAdapterRegistry.threadCount.addThread(listenerThread.getName());
                            }
                            ResourceAdapterDescriptorImpl descriptor = (ResourceAdapterDescriptorImpl)event.getResourceAdapter();
                            descriptor.addWaitingListener(listenerThread);
                            listenerThread.start();
                        }
                        catch (Throwable e) {
                            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    ++i;
                }
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    private void processListenerExtensionPoint() {
        block11: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                boolean hasResourceAdapterListeners;
                IConfigurationElement[] resourceAdapterListeners = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.adapter.j2ca.ResourceAdapterListener");
                boolean bl = hasResourceAdapterListeners = resourceAdapterListeners != null && resourceAdapterListeners.length > 0;
                if (hasResourceAdapterListeners) {
                    int i = 0;
                    while (i < resourceAdapterListeners.length) {
                        try {
                            IConfigurationElement listenerElement = resourceAdapterListeners[i];
                            if (LogFacility.trace) {
                                LogFacility.Trace((String)new StringBuffer("Registering Listener: ").append(listenerElement.getAttribute("class")).toString(), (short)10);
                            }
                            IResourceAdapterListener listener = (IResourceAdapterListener)listenerElement.createExecutableExtension("class");
                            this.addResourceAdapterListener(listener);
                            if (LogFacility.trace) {
                                LogFacility.Trace((String)new StringBuffer("Finished Registering Listener: ").append(listenerElement.getAttribute("class")).toString(), (short)10);
                            }
                        }
                        catch (CoreException e) {
                            LogFacility.logErrorMessage((IStatus)e.getStatus());
                        }
                        catch (RuntimeException e) {
                            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                        }
                        ++i;
                    }
                }
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                if (!LogFacility.trace) break block11;
                LogFacility.TrcExit();
            }
        }
    }

    @Override
    public IResourceAdapterDescriptor[] getResourceAdapters(String displayName, String version, String vendorName) throws BaseException {
        List adapters = (List)this._resourceAdapterRegistry.get(this.buildResourceAdapterID(displayName, version, vendorName));
        if (adapters != null) {
            return adapters.toArray(new IResourceAdapterDescriptor[0]);
        }
        return null;
    }

    @Override
    public void updateResourceAdapterDiscoveryAgent(IResourceAdapterDescriptor descriptor, IDiscoveryAgent discoveryAgent, boolean replace) throws BaseException {
        block10: {
            try {
                try {
                    if (descriptor != null) {
                        if (descriptor instanceof ResourceAdapterDescriptorImpl) {
                            ResourceAdapterDescriptorImpl modifyDescriptor = (ResourceAdapterDescriptorImpl)descriptor;
                            if (modifyDescriptor.hasDiscoveryAgent() && !replace) {
                                String message = MessageResource.bind((String)MessageResource.MSG_ERROR__DA_EXISTS_FOR_RA, (Object)descriptor.getConnectorProject().getName());
                                LogFacility.logErrorMessage((String)message, null);
                                throw BaseException.createException((String)message, null);
                            }
                            modifyDescriptor.setDiscoveryAgent(discoveryAgent);
                            break block10;
                        }
                        String message = MessageResource.bind((String)MessageResource.MSG_ERROR__RA_CANT_BE_MOD, (Object)descriptor.getConnectorProject().getName());
                        LogFacility.logErrorMessage((String)message, null);
                        throw BaseException.createException((String)message, null);
                    }
                    String message = MessageResource.bind((String)MessageResource.MSG_ERROR__RA_CANT_BE_FOUND, (Object)"");
                    LogFacility.logErrorMessage((String)message, null);
                    throw BaseException.createException((String)message, null);
                }
                catch (BaseException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                    throw e;
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            finally {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean visit(IResourceDelta delta) throws CoreException {
        try {
            if (delta.getResource() == null) return true;
            switch (delta.getResource().getType()) {
                case 4: {
                    project = (IProject)delta.getResource();
                    if (ConnectorProjectHelper.isConnectorProject(project) == null) return false;
                    if (delta.getKind() == 1) {
                        if (LogFacility.trace) {
                            LogFacility.Trace((String)new StringBuffer("Adding ").append(project.getName()).append(" to the resource adapter registry").toString(), (short)10);
                        }
                        try {
                            ResourceAdapterRegistry.getRegistry().addResourceAdapter(project);
                            return false;
                        }
                        catch (BaseException e) {
                            LogFacility.logErrorMessage((IStatus)e.getStatus());
                        }
                        return false;
                    }
                    if (delta.getKind() == 4 && (delta.getFlags() & 16384) == 16384) {
                        if (project.isOpen()) {
                            if (LogFacility.trace) {
                                LogFacility.Trace((String)new StringBuffer("Adding ").append(project.getName()).append(" to the registry as the project was opened").toString(), (short)10);
                            }
                            try {
                                ResourceAdapterRegistry.getRegistry().addResourceAdapter(project);
                                return false;
                            }
                            catch (BaseException e) {
                                LogFacility.logErrorMessage((IStatus)e.getStatus());
                            }
                            return false;
                        }
                        if (LogFacility.trace) {
                            LogFacility.Trace((String)new StringBuffer("Removed ").append(project.getName()).append(" from the registry as the project was closed").toString(), (short)10);
                        }
                        ResourceAdapterRegistry.getRegistry().removeResourceAdapter(project);
                        return false;
                    }
                    if (delta.getKind() != 4) return true;
                    if ((delta.getFlags() & 262144) != 262144) return true;
                    if (LogFacility.trace) {
                        LogFacility.Trace((String)new StringBuffer("Adding ").append(project.getName()).append(" to the registry as the project was replaced").toString(), (short)10);
                    }
                    try {
                        ResourceAdapterRegistry.getRegistry().addResourceAdapter(project);
                        return false;
                    }
                    catch (BaseException e) {
                        LogFacility.logErrorMessage((IStatus)e.getStatus());
                    }
                    return false;
                }
                case 2: {
                    element = JavaCore.create((IResource)delta.getResource());
                    if (element == null) return true;
                    if (element.getElementType() != 4) return true;
                    descriptor = (ResourceAdapterDescriptorImpl)this.getResourceAdapterForProject(element.getJavaProject().getProject());
                    if (descriptor == null) return true;
                    try {
                        descriptor.refreshClassLoader();
                        if (LogFacility.trace) {
                            LogFacility.Trace((String)new StringBuffer("Refreshing class loader for  ").append(descriptor.getConnector().getDisplayName()).append(" as it was changed").toString(), (short)10);
                        }
                        this.notifyListeners(new ResourceAdapterEvent(2, descriptor, delta.getResource()));
                        return false;
                    }
                    catch (BaseException e) {
                        LogFacility.logErrorMessage((IStatus)e.getStatus());
                    }
                    return true;
                }
                case 1: {
                    eventOccurred = true;
                    file = (IFile)delta.getResource();
                    descriptor = (ResourceAdapterDescriptorImpl)this.getResourceAdapterForProject(file.getProject());
                    if (descriptor == null) return false;
                    if (delta.getKind() != 4 || (delta.getFlags() & 131072) != 131072) ** GOTO lbl63
                    eventOccurred = false;
                    ** GOTO lbl109
lbl63:
                    // 1 sources

                    if (!file.getName().equalsIgnoreCase("ra.xml")) ** GOTO lbl85
                    try {
                        if (delta.getKind() != 1) ** GOTO lbl70
                        if (LogFacility.trace) {
                            LogFacility.Trace((String)new StringBuffer("Adding ").append(file.getProject().getName()).append(" to the resource adapter registry").toString(), (short)10);
                        }
                        ResourceAdapterRegistry.getRegistry().addResourceAdapter(file.getProject());
                        ** GOTO lbl109
lbl70:
                        // 1 sources

                        if (delta.getKind() != 2) ** GOTO lbl75
                        if (LogFacility.trace) {
                            LogFacility.Trace((String)new StringBuffer("Removed ").append(file.getProject().getName()).append(" from the registry as the deployment descriptor was deleted").toString(), (short)10);
                        }
                        ResourceAdapterRegistry.getRegistry().removeResourceAdapter(file.getProject());
                        ** GOTO lbl109
lbl75:
                        // 1 sources

                        if (delta.getKind() != 4) ** GOTO lbl80
                        descriptor.refreshDeploymentDescriptor();
                        if (LogFacility.trace) {
                            LogFacility.Trace((String)new StringBuffer("Refreshing ra.xml data  ").append(descriptor.getConnector().getDisplayName()).append(" as it was changed").toString(), (short)10);
                        }
                        ** GOTO lbl109
lbl80:
                        // 1 sources

                        eventOccurred = false;
                    }
                    catch (BaseException e) {
                        LogFacility.logErrorMessage((IStatus)e.getStatus());
                    }
                    ** GOTO lbl109
lbl85:
                    // 1 sources

                    if (!file.getName().equalsIgnoreCase(".classpath")) ** GOTO lbl95
                    try {
                        descriptor.refreshClassLoader();
                        if (LogFacility.trace) {
                            LogFacility.Trace((String)new StringBuffer("Refreshing classloader for  ").append(descriptor.getConnector().getDisplayName()).append(" as its classpath was changed").toString(), (short)10);
                        }
                        ** GOTO lbl109
                    }
                    catch (BaseException e) {
                        LogFacility.logErrorMessage((IStatus)e.getStatus());
                    }
                    ** GOTO lbl109
lbl95:
                    // 1 sources

                    if (!"discovery-service.xml".equalsIgnoreCase(file.getName())) ** GOTO lbl98
                    eventOccurred = true;
                    ** GOTO lbl109
lbl98:
                    // 1 sources

                    if (!this.isFileClassPathSensitive(file, descriptor.getClassLoader())) ** GOTO lbl108
                    try {
                        descriptor.refreshClassLoader();
                        if (LogFacility.trace) {
                            LogFacility.Trace((String)new StringBuffer("Refreshing classloader for  ").append(descriptor.getConnector().getDisplayName()).append(" as a resource on its classpath has changed").toString(), (short)10);
                        }
                        ** GOTO lbl109
                    }
                    catch (BaseException e) {
                        LogFacility.logErrorMessage((IStatus)e.getStatus());
                    }
                    ** GOTO lbl109
lbl108:
                    // 1 sources

                    eventOccurred = false;
lbl109:
                    // 14 sources

                    if (eventOccurred == false) return false;
                    this.notifyListeners(new ResourceAdapterEvent(2, descriptor, (IResource)file));
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        return true;
    }

    private boolean isFileClassPathSensitive(IFile file, ClassLoader loader) {
        int index = file.getName().lastIndexOf(46);
        if (index >= 0) {
            String fileExtension = file.getName().substring(index + 1);
            if ("class".equalsIgnoreCase(fileExtension) || "properties".equalsIgnoreCase(fileExtension) || "jar".equalsIgnoreCase(fileExtension)) {
                if (loader.getResource(file.getProjectRelativePath().toString()) != null) {
                    return true;
                }
                IPath path = file.getProjectRelativePath().removeFirstSegments(1);
                int i = path.segmentCount();
                while (i > 0) {
                    if (loader.getResource(path.removeFirstSegments(i).toString()) != null) {
                        return true;
                    }
                    --i;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public void updateResourceAdapterBuildAgent(IResourceAdapterDescriptor descriptor, IBuildAgent buildAgent, boolean replace) throws BaseException {
        block10: {
            try {
                try {
                    if (descriptor != null) {
                        if (descriptor instanceof ResourceAdapterDescriptorImpl) {
                            ResourceAdapterDescriptorImpl modifyDescriptor = (ResourceAdapterDescriptorImpl)descriptor;
                            if (modifyDescriptor.hasBuildAgent() && !replace) {
                                String message = MessageResource.bind((String)MessageResource.MSG_ERROR__BA_EXISTS_FOR_RA, (Object)descriptor.getConnectorProject().getName());
                                LogFacility.logErrorMessage((String)message, null);
                                throw BaseException.createException((String)message, null);
                            }
                            modifyDescriptor.setBuildAgent(buildAgent);
                            break block10;
                        }
                        String message = MessageResource.bind((String)MessageResource.MSG_ERROR__RA_CANT_BE_MOD, (Object)descriptor.getConnectorProject().getName());
                        LogFacility.logErrorMessage((String)message, null);
                        throw BaseException.createException((String)message, null);
                    }
                    String message = MessageResource.bind((String)MessageResource.MSG_ERROR__RA_CANT_BE_FOUND, (Object)"");
                    LogFacility.logErrorMessage((String)message, null);
                    throw BaseException.createException((String)message, null);
                }
                catch (BaseException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                    throw e;
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            finally {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
    }

    private static final class ThreadCount {
        private ArrayList threads = new ArrayList();

        private ThreadCount() {
        }

        public void addThread(String threadID) {
            this.threads.add(threadID);
        }

        public void removeThread(String threadID) {
            this.threads.remove(threadID);
        }

        public boolean containsThread(String threadID) {
            return this.threads.contains(threadID);
        }

        public int count() {
            return this.threads.size();
        }
    }
}

