#!/bin/bash

function usage() {
	echo
	echo "Usage: ${0##*/} -f importFile [-s generationStyle] [-e eclipseRoot] [-d workspace]"
	echo
	echo "    importFile: the name of the import definition file (XML)"
	echo
	echo "The following are optional, defaults are provided in ${0##*/}"
	echo "or in environment variables \"workspace\" and \"eclipse_root\""
	echo
    echo "    generationStyle: 0 = (default)Does not try to match any VAJ generation style"
    echo "                     1 = Match VAJ gen options: Direct, no notification, no inner class, no shorten names, no primitive type arrays"
    echo "                     2 = Match VAJ gen options: Direct, no notification, no inner class, shorten names,    no primitive type arrays"
	echo "    workspace: the name of the workspace directory"
	echo "    eclipseRoot: the base Eclipse directory"
	echo
	echo
}

if [ $# -eq 0 ] ; then
	clear
	usage
	exit -1
fi

#
# Set the defaults for eclipse_root and workspace
#
if [[ "$eclipse_root" -eq "" ]] ; then
	eclipse_root=/opt/IBM/WebSphereStudio/eclipse
fi

if [[ "$workspace" -eq "" ]] ; then
	workspace=$HOME/workspace
fi

while [ $# -ne 0 ]
do
   if [[ $1 = "-f" ]] ; then
      import_file=$2 && shift && shift
   else
      if [[ $1 = "-d" ]] ; then
         workspace=$2 && shift && shift
      else
         if [[ $1 = "-e" ]] ; then
            eclipse_root=$2 && shift && shift
         else
            if [[ $1 = "-s" ]] ; then
               generation_style=$2 && shift && shift
            else
               shift # ignore unrecognized flag
            fi
         fi
      fi
   fi
done

if [[ $import_file = "" ]] ; then
   clear
   echo Need to set import_file
   echo
   usage
   exit -1
fi

# ======================
# Run the plugin
# ======================
echo eclipse_root=$eclipse_root
echo workspace=$workspace
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$eclipse_root

echo ${0##*/} begins...
$eclipse_root/jre/bin/java -Xmx256M -verify -cp $eclipse_root/startup.jar org.eclipse.core.launcher.Main -clean -data $workspace -os linux -ws gtk -application com.ibm.adapter.j2c.command.BatchImport -file=$import_file -style=$generation_style
echo ${0##*/} complete.

