/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2c.internal.codegen.util;

import com.ibm.adapter.j2c.internal.codegen.util.BaseGenerator;
import com.ibm.adapter.j2c.internal.codegen.util.MethodGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.BadLocationException;

public abstract class TypeGenerator
extends BaseGenerator {
    protected IType type;
    protected TypeDeclaration backingTypeModel;
    protected IType[] interfaceTypes;

    public TypeGenerator(ICompilationUnit value, IType type) {
        super(value);
        this.type = type;
    }

    public TypeGenerator(ICompilationUnit value) {
        this(value, null);
    }

    protected IType getType() {
        if (this.type == null) {
            this.type = this.getICompilationUnit().findPrimaryType();
        }
        return this.type;
    }

    public String getSuperClass() {
        return null;
    }

    public String[] getInterfaces() {
        return null;
    }

    public String[] getFields() {
        return null;
    }

    public MethodGenerator[] getMethods() {
        return null;
    }

    public String getBody() {
        return null;
    }

    @Override
    protected void generate(IProgressMonitor monitor, CompilationUnit astCompilationUnit) throws JavaModelException {
        MethodGenerator[] methods;
        String body;
        super.generate(monitor, astCompilationUnit);
        AST ast = astCompilationUnit.getAST();
        ASTVisitor typeVisitor = new ASTVisitor(){

            public boolean visit(TypeDeclaration node) {
                super.visit(node);
                if (node.getName().getIdentifier().equals(TypeGenerator.this.getType().getElementName())) {
                    TypeGenerator.this.backingTypeModel = node;
                }
                return false;
            }
        };
        astCompilationUnit.accept(typeVisitor);
        if (this.backingTypeModel == null) {
            return;
        }
        if (this.getSuperClass() != null) {
            SimpleType type = ast.newSimpleType((Name)ast.newSimpleName(this.getSuperClass()));
            this.backingTypeModel.setSuperclassType((Type)type);
        }
        if ((body = this.getBody()) != null) {
            TypeGenerator.generateTypeBody(monitor, this.backingTypeModel, TypeGenerator.createTypeWrapper(body));
        }
        if (this.getFields() != null) {
            TypeGenerator.generateFields(monitor, this.backingTypeModel, this.getFields());
        }
        if ((methods = this.getMethods()) != null) {
            int i = 0;
            while (i < methods.length) {
                methods[i].generate(monitor, astCompilationUnit);
                ++i;
            }
        }
        if (this.getInterfaces() != null) {
            String[] interfaces = this.getInterfaces();
            ArrayList<Name> addedInterfaces = new ArrayList<Name>();
            int i = 0;
            while (i < interfaces.length) {
                Name name = TypeGenerator.deriveASTName(ast, interfaces[i]);
                boolean found = false;
                Iterator itr = this.backingTypeModel.superInterfaceTypes().iterator();
                while (itr.hasNext() && !found) {
                    Type t = (Type)itr.next();
                    SimpleName nm = null;
                    if (t.isQualifiedType()) {
                        nm = ((QualifiedType)t).getName();
                    } else if (t.isSimpleType()) {
                        nm = ((SimpleType)t).getName();
                    }
                    found = nm.subtreeMatch(new ASTMatcher(), (Object)name);
                }
                if (!found) {
                    this.backingTypeModel.superInterfaceTypes().add(ast.newSimpleType(name));
                    addedInterfaces.add(name);
                }
                ++i;
            }
            if (!this.backingTypeModel.isInterface()) {
                this.addInterfaceMethods(addedInterfaces, monitor, astCompilationUnit);
            }
        }
        if (this.getComments() != null) {
            TypeGenerator.generateComments(monitor, (BodyDeclaration)this.backingTypeModel, this.getComments());
        }
    }

    private void addInterfaceMethods(List interfaceNames, IProgressMonitor monitor, CompilationUnit astCompilationUnit) throws JavaModelException {
        try {
            ITypeBinding typeBinding;
            ASTParser parser = ASTParser.newParser((int)AST_PARSER_LEVEL);
            parser.setResolveBindings(true);
            this.getICompilationUnit().getBuffer().setContents(this.getFormattedChanges(this.getICompilationUnit().getSource(), astCompilationUnit));
            parser.setSource(this.getICompilationUnit());
            CompilationUnit holder = (CompilationUnit)parser.createAST(monitor);
            Iterator types = holder.types().iterator();
            TypeDeclaration resolvableTypeDec = null;
            while (resolvableTypeDec == null && types.hasNext()) {
                TypeDeclaration td = (TypeDeclaration)types.next();
                if (!td.subtreeMatch(new ASTMatcher(), (Object)this.backingTypeModel)) continue;
                resolvableTypeDec = td;
            }
            if (resolvableTypeDec != null && (typeBinding = resolvableTypeDec.resolveBinding()) != null) {
                ITypeBinding[] interfaceBindings = typeBinding.getInterfaces();
                Iterator interfaceItr = interfaceNames.iterator();
                ArrayList<IType> interfaces = new ArrayList<IType>();
                while (interfaceItr.hasNext()) {
                    Name interfaceName = (Name)interfaceItr.next();
                    IType interfaceType = null;
                    int count = 0;
                    while (count < interfaceBindings.length) {
                        if (interfaceName.isQualifiedName() && interfaceName.getFullyQualifiedName().equals(interfaceBindings[count].getQualifiedName()) || interfaceName.isSimpleName() && interfaceName.getFullyQualifiedName().equals(interfaceBindings[count].getName())) {
                            interfaceType = this.getType().getJavaProject().findType(interfaceBindings[count].getQualifiedName());
                            break;
                        }
                        ++count;
                    }
                    if (interfaceType == null) continue;
                    interfaces.add(interfaceType);
                    this.addInterfaceMethods(interfaceType, monitor, astCompilationUnit, parser);
                    ITypeHierarchy hierarchy = interfaceType.newSupertypeHierarchy(new ICompilationUnit[]{this.getICompilationUnit()}, monitor);
                    IType[] superInterfaces = hierarchy.getAllSuperInterfaces(interfaceType);
                    int t = 0;
                    while (t < superInterfaces.length) {
                        interfaces.add(superInterfaces[t]);
                        this.addInterfaceMethods(superInterfaces[t], monitor, astCompilationUnit, parser);
                        ++t;
                    }
                }
                this.interfaceTypes = interfaces.toArray(new IType[0]);
            }
        }
        catch (BadLocationException e) {
            throw new JavaModelException((Throwable)e, 4);
        }
    }

    private void addInterfaceMethods(IType interfaceType, IProgressMonitor monitor, CompilationUnit astCompilationUnit, ASTParser parser) throws JavaModelException {
        if (interfaceType != null) {
            final AST ast = astCompilationUnit.getAST();
            if (!interfaceType.isBinary()) {
                parser.setSource(interfaceType.getCompilationUnit());
                CompilationUnit astTypeCUnit = (CompilationUnit)parser.createAST(monitor);
                final MethodDeclaration[] declaredMethods = this.backingTypeModel.getMethods();
                astTypeCUnit.accept(new ASTVisitor(){

                    public boolean visit(MethodDeclaration node) {
                        boolean found = false;
                        int i = 0;
                        while (!found && i < declaredMethods.length) {
                            if (node.getName().subtreeMatch(new ASTMatcher(), (Object)declaredMethods[i].getName())) {
                                List p1 = node.parameters();
                                List p2 = declaredMethods[i].parameters();
                                if (p1.size() == p2.size()) {
                                    if (p1.size() == 0) {
                                        found = true;
                                    } else {
                                        SingleVariableDeclaration[] svd1 = node.parameters().toArray(new SingleVariableDeclaration[p1.size()]);
                                        SingleVariableDeclaration[] svd2 = declaredMethods[i].parameters().toArray(new SingleVariableDeclaration[p1.size()]);
                                        int count = 0;
                                        boolean match = true;
                                        while (match && count < p1.size()) {
                                            match = svd1[count].subtreeMatch(new ASTMatcher(), (Object)svd2[count]);
                                            ++count;
                                        }
                                        found = match;
                                    }
                                }
                            }
                            ++i;
                        }
                        if (!found) {
                            MethodDeclaration copiedNode = (MethodDeclaration)ASTNode.copySubtree((AST)ast, (ASTNode)node);
                            TypeGenerator.generateMethodBody(copiedNode, TypeGenerator.generateDefaultBody(copiedNode));
                            TypeGenerator.this.backingTypeModel.bodyDeclarations().add(copiedNode);
                        }
                        return false;
                    }
                });
            }
        }
    }

    public static void generateFields(IProgressMonitor monitor, TypeDeclaration typeDeclaration, String[] fields) {
        StringBuffer fieldsText = new StringBuffer();
        int i = 0;
        while (i < fields.length - 1) {
            fieldsText.append(fields[i]);
            fieldsText.append("\n");
            ++i;
        }
        fieldsText.append(fields[fields.length - 1]);
        TypeGenerator.generateTypeBody(monitor, typeDeclaration, TypeGenerator.createTypeWrapper(fieldsText.toString()));
    }
}

