/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2c.internal.codegen.util;

import com.ibm.adapter.j2c.internal.MessageResource;
import com.ibm.adapter.j2c.internal.codegen.util.BaseGenerator;
import com.ibm.adapter.j2c.internal.codegen.util.ParamType;
import com.ibm.adapter.j2c.internal.codegen.util.TypeGenerator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public abstract class MethodGenerator
extends BaseGenerator {
    private MethodDeclaration backingMethodModel = null;
    private TypeDeclaration backingTypeModel = null;
    private IType parentType = null;
    private TypeGenerator typeGenerator = null;

    public MethodGenerator(ICompilationUnit value, IType parentType) {
        super(value);
        this.parentType = parentType;
    }

    public MethodGenerator(ICompilationUnit value) {
        this(value, null);
    }

    public MethodGenerator(TypeGenerator value) {
        this(value.getICompilationUnit());
        this.typeGenerator = value;
    }

    @Override
    protected ICompilationUnit getICompilationUnit() {
        if (this.cUnit == null) {
            this.cUnit = this.typeGenerator.getICompilationUnit();
        }
        return this.cUnit;
    }

    protected IType getParentType() {
        if (this.parentType == null) {
            this.parentType = this.typeGenerator != null ? this.typeGenerator.getType() : this.getICompilationUnit().findPrimaryType();
        }
        return this.parentType;
    }

    protected MethodDeclaration getBackingModel() {
        if (this.backingMethodModel == null) {
            throw new RuntimeException(MessageResource.ERR_METHOD_MODEL_NOT_FOUND);
        }
        return this.backingMethodModel;
    }

    public boolean isConstructor() {
        return false;
    }

    public String getMethodName() {
        return null;
    }

    public int getModifiers() {
        return 1;
    }

    public ParamType getReturnType() {
        return new ParamType();
    }

    public ParamType[] getArguments() {
        return null;
    }

    public String[] getArgumentNames() {
        return null;
    }

    public String[] getExceptions() {
        return null;
    }

    public String getBody() {
        return null;
    }

    private boolean isSameParameterTypes(List singleVariableDeclarations) {
        ParamType[] params = this.getArguments();
        if (params == null && singleVariableDeclarations.isEmpty()) {
            return true;
        }
        if (params == null) {
            return false;
        }
        if (params.length == singleVariableDeclarations.size()) {
            int i = 0;
            while (i < params.length) {
                SingleVariableDeclaration dec = (SingleVariableDeclaration)singleVariableDeclarations.get(i);
                if (!params[i].getName().equals(dec.getType().toString())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void generate(final IProgressMonitor monitor, CompilationUnit astCompilationUnit) throws JavaModelException {
        if (this.getMethodName() == null) {
            return;
        }
        super.generate(monitor, astCompilationUnit);
        final AST ast = astCompilationUnit.getAST();
        ASTVisitor typeVisitor = new ASTVisitor(){

            public boolean visit(TypeDeclaration node) {
                super.visit(node);
                if (node.getName().getIdentifier().equals(MethodGenerator.this.getParentType().getElementName())) {
                    MethodGenerator.this.backingTypeModel = node;
                }
                return false;
            }
        };
        astCompilationUnit.accept(typeVisitor);
        if (this.backingTypeModel != null) {
            ASTVisitor methodVisitor = new ASTVisitor(){

                public boolean visit(MethodDeclaration node) {
                    super.visit(node);
                    SimpleName name = (SimpleName)MethodGenerator.deriveASTName(ast, MethodGenerator.this.getMethodName());
                    if (node.getName().subtreeMatch(new ASTMatcher(), (Object)name) && MethodGenerator.this.isSameParameterTypes(node.parameters())) {
                        String[] thrownExceptions;
                        String body;
                        MethodGenerator.this.backingMethodModel = node;
                        if (MethodGenerator.this.getMethodAnnotations() != null && !MethodGenerator.this.getMethodAnnotations().isEmpty()) {
                            MethodGenerator.generateAnnotations(monitor, (BodyDeclaration)MethodGenerator.this.backingMethodModel, MethodGenerator.this.getMethodAnnotations());
                        }
                        if ((body = MethodGenerator.this.getBody()) != null && !MethodGenerator.this.backingTypeModel.isInterface()) {
                            MethodGenerator.generateMethodBody(node, body);
                        }
                        if (MethodGenerator.this.getComments() != null) {
                            MethodGenerator.generateComments(monitor, (BodyDeclaration)node, MethodGenerator.this.getComments());
                        }
                        if ((thrownExceptions = MethodGenerator.this.getExceptions()) != null) {
                            int i = 0;
                            while (i < thrownExceptions.length) {
                                MethodGenerator.this.generateExceptions(node, thrownExceptions[i]);
                                ++i;
                            }
                        }
                    }
                    return false;
                }
            };
            this.backingTypeModel.accept(methodVisitor);
        }
        if (this.backingMethodModel == null && this.backingTypeModel != null) {
            String[] thrownExceptions;
            int i;
            MethodDeclaration methodDec = ast.newMethodDeclaration();
            methodDec.setConstructor(this.isConstructor());
            if (this.getMethodAnnotations() != null && !this.getMethodAnnotations().isEmpty()) {
                MethodGenerator.generateAnnotations(monitor, (BodyDeclaration)methodDec, this.getMethodAnnotations());
            }
            methodDec.modifiers().addAll(ast.newModifiers(this.getModifiers()));
            methodDec.setName((SimpleName)MethodGenerator.deriveASTName(ast, this.getMethodName()));
            methodDec.setReturnType2(this.getReturnType().createType(ast));
            if (this.getArguments() != null) {
                ParamType[] types = this.getArguments();
                String[] argumentNames = this.getArgumentNames();
                i = 0;
                while (i < types.length) {
                    SingleVariableDeclaration svd = ast.newSingleVariableDeclaration();
                    svd.setType(types[i].createType(ast));
                    if (argumentNames != null) {
                        svd.setName((SimpleName)MethodGenerator.deriveASTName(ast, argumentNames[i]));
                    } else {
                        svd.setName((SimpleName)MethodGenerator.deriveASTName(ast, "arg" + i));
                    }
                    methodDec.parameters().add(svd);
                    ++i;
                }
            }
            this.backingMethodModel = methodDec;
            String bodyText = this.getBody();
            if (bodyText == null) {
                bodyText = MethodGenerator.generateDefaultBody(this.backingMethodModel);
            }
            if (bodyText != null && !this.backingTypeModel.isInterface()) {
                MethodGenerator.generateMethodBody(methodDec, bodyText);
            }
            if (this.getComments() != null) {
                MethodGenerator.generateComments(monitor, (BodyDeclaration)methodDec, this.getComments());
            }
            if ((thrownExceptions = this.getExceptions()) != null) {
                i = 0;
                while (i < thrownExceptions.length) {
                    this.generateExceptions(methodDec, thrownExceptions[i]);
                    ++i;
                }
            }
            this.backingTypeModel.bodyDeclarations().add(methodDec);
        }
    }

    private void generateExceptions(MethodDeclaration node, String exception) {
        List thrownExceptions = node.thrownExceptions();
        Iterator i = thrownExceptions.iterator();
        ASTMatcher matcher = new ASTMatcher();
        Name exceptionName = MethodGenerator.deriveASTName(node.getAST(), exception);
        boolean found = false;
        while (!found && i.hasNext()) {
            found = exceptionName.subtreeMatch(matcher, i.next());
        }
        if (!found) {
            thrownExceptions.add(exceptionName);
        }
    }
}

