/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2c.internal.codegen.util;

import com.ibm.adapter.j2c.internal.CodegenPlugin;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public abstract class BaseGenerator {
    static String TYPE_HEADER = "class TempType {";
    static String TYPE_END = "}";
    public static int AST_PARSER_LEVEL = 3;
    protected ICompilationUnit cUnit;
    protected static final IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();

    BaseGenerator(ICompilationUnit value) {
        this.cUnit = value;
    }

    protected ICompilationUnit getICompilationUnit() {
        return this.cUnit;
    }

    public String[] getImportStatements() {
        return null;
    }

    public String[] getClasspathProjects() {
        return null;
    }

    public String[] getClasspathContainerPaths() {
        return null;
    }

    public String getComments() {
        return null;
    }

    public List<Annotation> getTypeAnnotations() {
        return null;
    }

    public List<Annotation> getMethodAnnotations() {
        return null;
    }

    public void generate() throws JavaModelException {
        this.generate((IProgressMonitor)new NullProgressMonitor());
    }

    public void generate(IProgressMonitor monitor) throws JavaModelException {
        boolean workingCopyPassed = this.getICompilationUnit().isWorkingCopy();
        boolean hasUnsavedChanges = this.getICompilationUnit().hasUnsavedChanges();
        if (!workingCopyPassed) {
            this.cUnit = this.getICompilationUnit().getWorkingCopy(monitor);
        }
        ASTParser astParser = ASTParser.newParser((int)AST_PARSER_LEVEL);
        astParser.setResolveBindings(true);
        astParser.setSource(this.getICompilationUnit());
        String originalText = this.getICompilationUnit().getSource();
        CompilationUnit astCompilationUnit = (CompilationUnit)astParser.createAST(monitor);
        astCompilationUnit.recordModifications();
        this.generate(monitor, astCompilationUnit);
        try {
            this.getICompilationUnit().getBuffer().setContents(this.getFormattedChanges(originalText, astCompilationUnit));
        }
        catch (BadLocationException e) {
            throw new JavaModelException((Throwable)e, 4);
        }
        if (!hasUnsavedChanges) {
            this.getICompilationUnit().reconcile(0, false, null, monitor);
            this.getICompilationUnit().commitWorkingCopy(true, monitor);
            if (!workingCopyPassed) {
                this.getICompilationUnit().discardWorkingCopy();
            }
        }
    }

    protected void generate(IProgressMonitor monitor, CompilationUnit astCompilationUnit) throws JavaModelException {
        String[] classpathContainers;
        String[] classpathProjects;
        String[] importStatements = this.getImportStatements();
        if (importStatements != null) {
            int i = 0;
            while (i < importStatements.length) {
                ImportDeclaration importDeclaration = astCompilationUnit.getAST().newImportDeclaration();
                String importStatement = importStatements[i];
                if (importStatement.endsWith("*")) {
                    importStatement = importStatement.substring(0, importStatement.lastIndexOf("."));
                    importDeclaration.setOnDemand(true);
                }
                importDeclaration.setName(BaseGenerator.deriveASTName(astCompilationUnit.getAST(), importStatement));
                boolean found = false;
                Iterator itr = astCompilationUnit.imports().iterator();
                while (itr.hasNext() && !found) {
                    ImportDeclaration dec = (ImportDeclaration)itr.next();
                    found = dec.subtreeMatch(new ASTMatcher(), (Object)importDeclaration);
                }
                if (!found) {
                    astCompilationUnit.imports().add(importDeclaration);
                }
                ++i;
            }
        }
        if ((classpathProjects = this.getClasspathProjects()) != null) {
            int i = 0;
            while (i < classpathProjects.length) {
                IProject clsPathProject = ResourcesPlugin.getWorkspace().getRoot().getProject(classpathProjects[i]);
                BaseGenerator.addProjectToClassPath(this.getICompilationUnit().getJavaProject(), clsPathProject);
                ++i;
            }
        }
        if ((classpathContainers = this.getClasspathContainerPaths()) != null) {
            int i = 0;
            while (i < classpathContainers.length) {
                IClasspathEntry entry;
                Path path = new Path(classpathContainers[i]);
                IJavaProject currentProject = this.getICompilationUnit().getJavaProject();
                if (!BaseGenerator.isOnClasspath(currentProject, entry = JavaCore.newContainerEntry((IPath)path))) {
                    BaseGenerator.addClasspathEntry(currentProject, entry);
                }
                ++i;
            }
        }
    }

    protected static void generateAnnotations(IProgressMonitor monitor, BodyDeclaration node, List<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            Annotation copiedNode = (Annotation)ASTNode.copySubtree((AST)node.getAST(), (ASTNode)annotation);
            node.modifiers().add(copiedNode);
        }
    }

    protected static void generateComments(IProgressMonitor monitor, BodyDeclaration node, String commentsText) {
        char[] source = commentsText.toCharArray();
        ASTParser parser = ASTParser.newParser((int)AST_PARSER_LEVEL);
        parser.setKind(1);
        parser.setSource(source);
        parser.setSourceRange(0, source.length);
        ASTNode newBody = parser.createAST(monitor);
        CompilationUnit unit = (CompilationUnit)newBody;
        if (unit.getCommentList().isEmpty()) {
            return;
        }
        Comment comments = (Comment)unit.getCommentList().get(0);
        if (comments.isDocComment()) {
            if (node.getJavadoc() != null) {
                List newTags = ((Javadoc)comments).tags();
                List existingTags = node.getJavadoc().tags();
                Iterator i = newTags.iterator();
                ASTMatcher matcher = new ASTMatcher();
                while (i.hasNext()) {
                    TagElement tagElement = (TagElement)i.next();
                    Iterator existingTagsItr = existingTags.iterator();
                    boolean found = false;
                    while (!found && existingTagsItr.hasNext()) {
                        TagElement existingTag = (TagElement)existingTagsItr.next();
                        found = tagElement.subtreeMatch(matcher, (Object)existingTag);
                    }
                    if (found) continue;
                    tagElement = (TagElement)ASTNode.copySubtree((AST)node.getAST(), (ASTNode)tagElement);
                    existingTags.add(tagElement);
                }
            } else {
                if (commentsText.indexOf("-") > 0) {
                    comments.accept(new ASTVisitor(true){

                        public boolean visit(TagElement node) {
                            if (!node.fragments().isEmpty()) {
                                Object o = node.fragments().get(0);
                                try {
                                    String text = ((TextElement)o).getText();
                                    int index = text.indexOf("-");
                                    if (index == 0 || index == 1) {
                                        int firstSpace = text.indexOf(" ", index);
                                        String tagPostfix = text.substring(index, firstSpace);
                                        ((TextElement)o).setText(text.substring(firstSpace));
                                        node.setTagName(String.valueOf(node.getTagName()) + tagPostfix);
                                    }
                                }
                                catch (ClassCastException classCastException) {}
                            }
                            return false;
                        }
                    });
                }
                comments.accept(new ASTVisitor(true){

                    public boolean visit(TagElement node) {
                        if (!node.fragments().isEmpty()) {
                            Object o = node.fragments().get(0);
                            try {
                                String text = ((TextElement)o).getText();
                                if (text.startsWith(" ")) {
                                    ((TextElement)o).setText(text.substring(1));
                                }
                            }
                            catch (ClassCastException classCastException) {}
                        }
                        return false;
                    }
                });
                comments = (Comment)ASTNode.copySubtree((AST)node.getAST(), (ASTNode)comments);
                node.setJavadoc((Javadoc)comments);
            }
        }
    }

    protected static void generateTypeBody(IProgressMonitor monitor, final TypeDeclaration typeDeclaration, String bodyText) {
        ASTParser astMethodParser = ASTParser.newParser((int)AST_PARSER_LEVEL);
        astMethodParser.setKind(8);
        astMethodParser.setSource(bodyText.toCharArray());
        astMethodParser.setSourceRange(0, bodyText.toCharArray().length);
        CompilationUnit astTypeCUnit = (CompilationUnit)astMethodParser.createAST(monitor);
        final AST ast = typeDeclaration.getAST();
        final FieldDeclaration[] declaredFields = typeDeclaration.getFields();
        final MethodDeclaration[] declaredMethods = typeDeclaration.getMethods();
        astTypeCUnit.accept(new ASTVisitor(){

            public boolean visit(FieldDeclaration node) {
                boolean found = false;
                int i = 0;
                while (!found && i < declaredFields.length) {
                    if (node.subtreeMatch(new ASTMatcher(), (Object)declaredFields[i])) {
                        found = true;
                    }
                    ++i;
                }
                if (!found) {
                    FieldDeclaration copiedNode = (FieldDeclaration)ASTNode.copySubtree((AST)ast, (ASTNode)node);
                    typeDeclaration.bodyDeclarations().add(0, copiedNode);
                }
                return false;
            }

            public boolean visit(MethodDeclaration node) {
                boolean found = false;
                int i = 0;
                while (!found && i < declaredMethods.length) {
                    if (node.getName().subtreeMatch(new ASTMatcher(), (Object)declaredMethods[i].getName())) {
                        List p1 = node.parameters();
                        List p2 = declaredMethods[i].parameters();
                        if (p1.size() == p2.size()) {
                            if (p1.size() == 0) {
                                found = true;
                            } else {
                                SingleVariableDeclaration[] svd1 = node.parameters().toArray(new SingleVariableDeclaration[p1.size()]);
                                SingleVariableDeclaration[] svd2 = declaredMethods[i].parameters().toArray(new SingleVariableDeclaration[p1.size()]);
                                int count = 0;
                                boolean match = true;
                                while (match && count < p1.size()) {
                                    match = svd1[count].subtreeMatch(new ASTMatcher(), (Object)svd2[count]);
                                    ++count;
                                }
                                found = match;
                            }
                        }
                    }
                    ++i;
                }
                MethodDeclaration copiedNode = (MethodDeclaration)ASTNode.copySubtree((AST)ast, (ASTNode)node);
                if (!found) {
                    typeDeclaration.bodyDeclarations().add(copiedNode);
                } else {
                    int position = typeDeclaration.bodyDeclarations().indexOf(declaredMethods[i - 1]);
                    typeDeclaration.bodyDeclarations().remove(position);
                    typeDeclaration.bodyDeclarations().add(position, copiedNode);
                }
                return false;
            }
        });
    }

    protected final String getFormattedChanges(String baseSource, CompilationUnit astCompilationUnit) throws JavaModelException, BadLocationException {
        Document document = new Document(baseSource);
        Map options = astCompilationUnit.getJavaElement().getJavaProject().getOptions(true);
        options.put("org.eclipse.jdt.core.formatter.comment.format_javadoc_comments", "true");
        options.put("org.eclipse.jdt.core.formatter.comment.format_header", "false");
        TextEdit textEdit = astCompilationUnit.rewrite((IDocument)document, options);
        textEdit.apply((IDocument)document);
        return document.get();
    }

    public static final Name deriveASTName(AST ast, String value) {
        int index = value.lastIndexOf(".");
        Object name = null;
        name = index >= 0 ? ast.newQualifiedName(BaseGenerator.deriveASTName(ast, value.substring(0, index)), ast.newSimpleName(value.substring(index + 1))) : ast.newSimpleName(value);
        return name;
    }

    protected final String getNameFromType(Type value) {
        StringBuffer buffer = new StringBuffer();
        if (value.isQualifiedType()) {
            buffer.append(((QualifiedType)value).getQualifier());
            buffer.append(".");
            buffer.append(((QualifiedType)value).getName().getFullyQualifiedName());
        } else if (value.isSimpleType()) {
            buffer.append(((SimpleType)value).getName().getFullyQualifiedName());
        }
        return buffer.toString();
    }

    protected static final String createTypeWrapper(String body) {
        StringBuffer typeText = new StringBuffer();
        typeText.append(TYPE_HEADER);
        typeText.append(body);
        typeText.append(TYPE_END);
        return typeText.toString();
    }

    public static void addProjectToClassPath(IJavaProject javaProject, IProject aProject) throws JavaModelException {
        if (!javaProject.getProject().equals((Object)aProject) && !javaProject.isOnClasspath((IResource)aProject)) {
            BaseGenerator.addClasspathEntry(javaProject, JavaCore.newProjectEntry((IPath)aProject.getFullPath()));
            IJavaProject tempJavaProject = JavaCore.create((IProject)aProject);
            if (tempJavaProject.exists()) {
                IClasspathEntry[] classPath = tempJavaProject.getRawClasspath();
                int i = 0;
                while (i < classPath.length) {
                    IClasspathEntry resolvedEntry;
                    IProject tempProject;
                    if (classPath[i].getEntryKind() == 2 && (tempProject = workspaceRoot.getProject((resolvedEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)classPath[i])).getPath().lastSegment())).exists()) {
                        BaseGenerator.addProjectToClassPath(javaProject, tempProject);
                    }
                    ++i;
                }
            }
        }
    }

    public static boolean isOnClasspath(IJavaProject javaProject, IClasspathEntry entry) {
        boolean found = false;
        try {
            IClasspathEntry[] classPath = javaProject.getRawClasspath();
            int i = 0;
            while (!found && i < classPath.length) {
                found = classPath[i++].equals(entry);
            }
        }
        catch (JavaModelException e) {
            CodegenPlugin.getDefault().getLog().log(e.getStatus());
        }
        return found;
    }

    public static String getTypeName(Type type) {
        String typeName = null;
        if (type.isQualifiedType()) {
            typeName = ((QualifiedType)type).getName().getIdentifier();
        } else if (type.isSimpleType()) {
            Name name = ((SimpleType)type).getName();
            typeName = name.isQualifiedName() ? ((QualifiedName)name).getFullyQualifiedName() : ((SimpleName)name).getIdentifier();
        }
        return typeName;
    }

    public static void addClasspathEntry(IJavaProject javaProject, IClasspathEntry entry) throws JavaModelException {
        IClasspathEntry[] classPath = javaProject.getRawClasspath();
        IClasspathEntry[] newClasspath = new IClasspathEntry[classPath.length + 1];
        System.arraycopy(classPath, 0, newClasspath, 0, classPath.length);
        newClasspath[classPath.length] = entry;
        javaProject.setRawClasspath(newClasspath, (IProgressMonitor)new NullProgressMonitor());
    }

    public static ICompilationUnit create(IProject project, String srcFolder, String packageName, String fileName, String contents) throws JavaModelException {
        return BaseGenerator.create(JavaCore.create((IProject)project), srcFolder, packageName, fileName, contents);
    }

    public static ICompilationUnit create(String projectName, String srcFolder, String packageName, String fileName, String contents) throws JavaModelException {
        return BaseGenerator.create(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName), srcFolder, packageName, fileName, contents);
    }

    public static ICompilationUnit create(IJavaProject javaProject, String srcFolder, String packageName, String fileName, String contents) throws JavaModelException {
        IPackageFragment pkgFragment;
        if (!javaProject.exists()) {
            try {
                javaProject.getProject().create(null);
                javaProject.getProject().open(null);
                IProjectDescription projectDescription = javaProject.getProject().getDescription();
                projectDescription.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
                javaProject.getProject().setDescription(projectDescription, null);
                if (srcFolder != null) {
                    IFolder folder = javaProject.getProject().getFolder(srcFolder);
                    folder.create(true, true, null);
                }
                javaProject.setRawClasspath(new IClasspathEntry[]{JavaCore.newSourceEntry((IPath)(srcFolder == null ? javaProject.getProject().getFullPath() : new Path(String.valueOf(javaProject.getProject().getFullPath().toString()) + "/" + srcFolder))), JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER"))}, null);
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
        IPackageFragmentRoot root = null;
        if (srcFolder != null) {
            root = javaProject.findPackageFragmentRoot((IPath)new Path(String.valueOf(javaProject.getProject().getFullPath().toString()) + "/" + srcFolder));
        }
        if (root == null) {
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            int count = 0;
            while (root == null && count < roots.length) {
                if (roots[count].getKind() == 1) {
                    root = roots[count];
                }
                ++count;
            }
            if (root == null) {
                root = javaProject.getPackageFragmentRoot(javaProject.getCorrespondingResource());
            }
        }
        if (!(pkgFragment = root.getPackageFragment(packageName)).exists()) {
            pkgFragment = root.createPackageFragment(packageName, false, (IProgressMonitor)new NullProgressMonitor());
        }
        return pkgFragment.createCompilationUnit(fileName, contents, true, (IProgressMonitor)new NullProgressMonitor());
    }

    protected static void generateMethodBody(MethodDeclaration node, String bodyText) {
        char[] source = bodyText.toCharArray();
        ASTParser parser = ASTParser.newParser((int)AST_PARSER_LEVEL);
        parser.setKind(2);
        parser.setSource(source);
        ASTNode newBody = parser.createAST((IProgressMonitor)new NullProgressMonitor());
        newBody = ASTNode.copySubtree((AST)node.getAST(), (ASTNode)newBody);
        node.setBody((Block)newBody);
    }

    protected static String generateDefaultBody(MethodDeclaration declaration) {
        Type returnType = declaration.getReturnType2();
        if (!returnType.isPrimitiveType()) {
            return "\t\treturn null;\n";
        }
        if (((PrimitiveType)returnType).getPrimitiveTypeCode().equals(PrimitiveType.VOID)) {
            return "\t\treturn;\n";
        }
        if (((PrimitiveType)returnType).getPrimitiveTypeCode().equals(PrimitiveType.INT) || ((PrimitiveType)returnType).getPrimitiveTypeCode().equals(PrimitiveType.LONG) || ((PrimitiveType)returnType).getPrimitiveTypeCode().equals(PrimitiveType.SHORT) || ((PrimitiveType)returnType).getPrimitiveTypeCode().equals(PrimitiveType.CHAR) || ((PrimitiveType)returnType).getPrimitiveTypeCode().equals(PrimitiveType.BYTE)) {
            return "\t\treturn 0;\n";
        }
        if (((PrimitiveType)returnType).getPrimitiveTypeCode().equals(PrimitiveType.BOOLEAN)) {
            return "\t\treturn false;\n";
        }
        if (((PrimitiveType)returnType).getPrimitiveTypeCode().equals(PrimitiveType.FLOAT)) {
            return "\t\treturn 0.0f;\n";
        }
        return "\t\treturn 0.0d;\n";
    }
}

