/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2c.internal.codegen.inbound.validation;

import com.ibm.adapter.j2c.internal.MessageResource;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IMarkerResolution2;

public class StatelessAnnotationRemoveProblemResolution
implements IMarkerResolution2 {
    public String getDescription() {
        return NLS.bind((String)MessageResource.ANNOTATION_PROBLEM_RESOLUTION_LABEL_1, (Object)"@Stateless");
    }

    public Image getImage() {
        return null;
    }

    public String getLabel() {
        return NLS.bind((String)MessageResource.ANNOTATION_PROBLEM_RESOLUTION_LABEL_1, (Object)"@Stateless");
    }

    public void run(IMarker marker) {
        IResource resource = marker.getResource();
        ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)((IFile)resource));
        boolean isWorkingCopy = cu.isWorkingCopy();
        if (!isWorkingCopy) {
            try {
                ICompilationUnit wccu = cu.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                this.fixIt(wccu, isWorkingCopy);
            }
            catch (JavaModelException javaModelException) {}
        } else {
            this.fixIt(cu, isWorkingCopy);
        }
    }

    private void fixIt(final ICompilationUnit cu, boolean isWorkingCopy) {
        try {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(cu);
            parser.setResolveBindings(true);
            String originalText = cu.getSource();
            final CompilationUnit astCU = (CompilationUnit)parser.createAST(null);
            astCU.recordModifications();
            ASTVisitor typeVisitor = new ASTVisitor(){

                public boolean visit(TypeDeclaration node) {
                    super.visit(node);
                    if (node.getName().getIdentifier().equals(cu.getElementName().substring(0, cu.getElementName().indexOf(".java")))) {
                        MarkerAnnotation statelessAnnotation = astCU.getAST().newMarkerAnnotation();
                        statelessAnnotation.setTypeName((Name)astCU.getAST().newSimpleName("Stateless"));
                        Annotation copiedNode = (Annotation)ASTNode.copySubtree((AST)node.getAST(), (ASTNode)statelessAnnotation);
                        List modifiers = node.modifiers();
                        int localIndex = 0;
                        for (IExtendedModifier modifier : modifiers) {
                            SingleMemberAnnotation annotation;
                            if (!(modifier instanceof SingleMemberAnnotation) || !"Local".equals((annotation = (SingleMemberAnnotation)modifier).getTypeName().getFullyQualifiedName())) continue;
                            localIndex = modifiers.indexOf(annotation) + 1;
                            break;
                        }
                        node.modifiers().add(localIndex, copiedNode);
                    }
                    return false;
                }
            };
            astCU.accept(typeVisitor);
            Document document = new Document(originalText);
            TextEdit textEdit = astCU.rewrite((IDocument)document, null);
            textEdit.apply((IDocument)document);
            CodeFormatter cf = ToolFactory.createCodeFormatter(null);
            TextEdit cfte = cf.format(8, document.get(), 0, document.get().length(), 0, null);
            if (cfte != null) {
                cfte.apply((IDocument)document);
            }
            cu.getBuffer().setContents(document.get());
            cu.reconcile(0, false, null, (IProgressMonitor)new NullProgressMonitor());
            cu.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
            if (!isWorkingCopy) {
                cu.discardWorkingCopy();
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (MalformedTreeException malformedTreeException) {
        }
        catch (BadLocationException badLocationException) {}
    }
}

