/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2c.internal.codegen.inbound.validation;

import com.ibm.adapter.j2c.internal.MessageResource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IMarkerResolution2;

public class EJBAnnotationRemoveProblemResolution
implements IMarkerResolution2 {
    private IMarker marker;

    public String getDescription() {
        return NLS.bind((String)MessageResource.ANNOTATION_PROBLEM_RESOLUTION_LABEL_1, (Object)"@EJB");
    }

    public Image getImage() {
        return null;
    }

    public String getLabel() {
        return NLS.bind((String)MessageResource.ANNOTATION_PROBLEM_RESOLUTION_LABEL_1, (Object)"@EJB");
    }

    public void run(IMarker marker) {
        this.marker = marker;
        IResource resource = marker.getResource();
        ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)((IFile)resource));
        boolean isWorkingCopy = cu.isWorkingCopy();
        if (!isWorkingCopy) {
            try {
                ICompilationUnit wccu = cu.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                this.fixIt(wccu, isWorkingCopy);
            }
            catch (JavaModelException javaModelException) {}
        } else {
            this.fixIt(cu, isWorkingCopy);
        }
    }

    private void fixIt(ICompilationUnit cu, boolean isWorkingCopy) {
        try {
            String localInterfaceFieldType = (String)this.marker.getAttribute("sourceId");
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(cu);
            parser.setResolveBindings(true);
            String originalText = cu.getSource();
            CompilationUnit astCU = (CompilationUnit)parser.createAST(null);
            astCU.recordModifications();
            TypeVisitor typeVisitor = new TypeVisitor(localInterfaceFieldType, cu);
            astCU.accept((ASTVisitor)typeVisitor);
            if (typeVisitor.isFieldDeleted()) {
                String localInterfaceFieldName = null;
                localInterfaceFieldName = localInterfaceFieldType.length() > 1 ? String.valueOf(localInterfaceFieldType.substring(0, 1).toLowerCase()) + localInterfaceFieldType.substring(1) : localInterfaceFieldType.toLowerCase();
                String localInterfaceField = "@EJB private " + localInterfaceFieldType + " " + localInterfaceFieldName + "\n";
                this.generateField((IProgressMonitor)new NullProgressMonitor(), typeVisitor.getType(), localInterfaceField);
                Document document = new Document(originalText);
                TextEdit textEdit = astCU.rewrite((IDocument)document, null);
                textEdit.apply((IDocument)document);
                CodeFormatter cf = ToolFactory.createCodeFormatter(null);
                TextEdit cfte = cf.format(8, document.get(), 0, document.get().length(), 0, null);
                if (cfte != null) {
                    cfte.apply((IDocument)document);
                }
                cu.getBuffer().setContents(document.get());
                cu.reconcile(0, false, null, (IProgressMonitor)new NullProgressMonitor());
                cu.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                if (!isWorkingCopy) {
                    cu.discardWorkingCopy();
                }
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (MalformedTreeException malformedTreeException) {
        }
        catch (BadLocationException badLocationException) {
        }
        catch (CoreException coreException) {}
    }

    private void generateField(IProgressMonitor monitor, final TypeDeclaration typeDeclaration, String field) {
        String TYPE_HEADER = "class TempType {";
        String TYPE_END = "}";
        StringBuffer typeText = new StringBuffer();
        typeText.append(TYPE_HEADER);
        typeText.append(field);
        typeText.append(TYPE_END);
        String bodyText = typeText.toString();
        ASTParser astMethodParser = ASTParser.newParser((int)3);
        astMethodParser.setKind(8);
        astMethodParser.setSource(bodyText.toCharArray());
        astMethodParser.setSourceRange(0, bodyText.toCharArray().length);
        CompilationUnit astTypeCUnit = (CompilationUnit)astMethodParser.createAST(monitor);
        final AST ast = typeDeclaration.getAST();
        final FieldDeclaration[] declaredFields = typeDeclaration.getFields();
        astTypeCUnit.accept(new ASTVisitor(){

            public boolean visit(FieldDeclaration node) {
                FieldDeclaration copiedNode = (FieldDeclaration)ASTNode.copySubtree((AST)ast, (ASTNode)node);
                if (declaredFields != null && declaredFields.length > 0) {
                    typeDeclaration.bodyDeclarations().add(declaredFields.length, copiedNode);
                } else {
                    typeDeclaration.bodyDeclarations().add(0, copiedNode);
                }
                return false;
            }
        });
    }

    class TypeVisitor
    extends ASTVisitor {
        String localInterfaceFieldType;
        ICompilationUnit cu;
        TypeDeclaration type;
        boolean deleted;

        public TypeVisitor(String localInterfaceFieldType, ICompilationUnit cu) {
            this.localInterfaceFieldType = localInterfaceFieldType;
            this.cu = cu;
        }

        public TypeDeclaration getType() {
            return this.type;
        }

        public boolean isFieldDeleted() {
            return this.deleted;
        }

        public boolean visit(TypeDeclaration node) {
            super.visit(node);
            if (node.getName().getIdentifier().equals(this.cu.getElementName().substring(0, this.cu.getElementName().indexOf(".java")))) {
                this.type = node;
                FieldDeclaration[] fields = node.getFields();
                if (fields != null) {
                    FieldDeclaration[] fieldDeclarationArray = fields;
                    int n = fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FieldDeclaration field = fieldDeclarationArray[n2];
                        if (field.getType().resolveBinding().getName().equals(this.localInterfaceFieldType)) {
                            field.delete();
                            this.deleted = true;
                            break;
                        }
                        ++n2;
                    }
                }
            }
            return false;
        }
    }
}

