/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2c.internal.codegen.inbound.apt;

import com.ibm.adapter.j2c.inbound.annotations.ActivationSpecification;
import com.ibm.adapter.j2c.inbound.annotations.InboundAdapter;
import com.ibm.adapter.j2c.internal.CodegenPlugin;
import com.ibm.adapter.j2c.internal.MessageResource;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.adapter.j2ca.IResourceAdapterRegistry;
import com.ibm.adapter.j2ca.RegistryFactory;
import com.ibm.adapter.j2ca.spi.util.ProjectUtils;
import com.ibm.etools.annotations.core.api.TriggerAnnotationsRetriever;
import com.ibm.jee.was.descriptors.ejb.EjbBindingsDescriptor;
import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.apt.core.env.EclipseAnnotationProcessorEnvironment;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.TextEdit;

public class InboundAdapterAnnotationsProcessor
implements AnnotationProcessor {
    private AnnotationProcessorEnvironment env;
    private IJavaProject javaProject;
    private static Map<String, MessageDrivenTypeMetadata> messageDrivenTypeMetadataTable = new HashMap<String, MessageDrivenTypeMetadata>();
    private static Map<String, StatelessTypeMetadata> statelessTypeMetadataTable = new HashMap<String, StatelessTypeMetadata>();

    public InboundAdapterAnnotationsProcessor(AnnotationProcessorEnvironment env) {
        this.env = env;
        this.javaProject = ((EclipseAnnotationProcessorEnvironment)env).getJavaProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        ArrayList<InboundAdapterArtifactsGenerationModel> modelsToGen = new ArrayList<InboundAdapterArtifactsGenerationModel>();
        Map<String, MessageDrivenTypeMetadata> map = messageDrivenTypeMetadataTable;
        synchronized (map) {
            boolean processed = this.processMessageDrivenTypeMetadata();
            if (!processed) {
                return;
            }
            processed = this.processStatelessTypeMetadata();
            if (!processed) {
                return;
            }
            Map<String, InboundAdapterArtifactsGenerationModel> modelTable = this.initializeInboundAdapterArtifactsGenerationModel();
            if (!modelTable.isEmpty()) {
                this.cleanupDeadMarkers();
                Collection<InboundAdapterArtifactsGenerationModel> generationModels = modelTable.values();
                for (InboundAdapterArtifactsGenerationModel generationModel : generationModels) {
                    if (!generationModel.updated() && this.MDBHelperExists(generationModel)) continue;
                    modelsToGen.add(generationModel);
                    generationModel.getMessageDrivenTypeMetadata().setUpdated(false);
                    generationModel.getStatelessTypeMetadata().setUpdated(false);
                }
            }
        }
        if (!modelsToGen.isEmpty()) {
            this.generate(modelsToGen);
        }
    }

    public AnnotationProcessorEnvironment getEnvironment() {
        return this.env;
    }

    private void generate(ArrayList<InboundAdapterArtifactsGenerationModel> generationModels) {
        for (InboundAdapterArtifactsGenerationModel generationModel : generationModels) {
            this.generateMDBHelper(generationModel);
            this.generateEJBBindingsDescriptor(generationModel);
            this.generateInboundEventInterceptor(generationModel);
        }
    }

    private Map<String, InboundAdapterArtifactsGenerationModel> initializeInboundAdapterArtifactsGenerationModel() {
        HashMap<String, InboundAdapterArtifactsGenerationModel> modelTable = new HashMap<String, InboundAdapterArtifactsGenerationModel>();
        HashMap<String, MessageDrivenTypeMetadata> mdbTable = new HashMap<String, MessageDrivenTypeMetadata>();
        Collection<MessageDrivenTypeMetadata> messageDrivenTypeMetadataValues = messageDrivenTypeMetadataTable.values();
        for (MessageDrivenTypeMetadata messageDrivenTypeMetadata : messageDrivenTypeMetadataValues) {
            mdbTable.put(new StringBuffer(messageDrivenTypeMetadata.getProject().getProject().getName()).append("::").append(messageDrivenTypeMetadata.getLocalInterfaceClassName()).toString(), messageDrivenTypeMetadata);
        }
        Collection<StatelessTypeMetadata> statelessTypeMetadataValues = statelessTypeMetadataTable.values();
        for (StatelessTypeMetadata statelessTypeMetadata : statelessTypeMetadataValues) {
            MessageDrivenTypeMetadata messageDrivenTypeMetadata = (MessageDrivenTypeMetadata)mdbTable.get(new StringBuffer(statelessTypeMetadata.getProject().getProject().getName()).append("::").append(statelessTypeMetadata.getLocalInterfaceClassName()).toString());
            if (messageDrivenTypeMetadata == null || !messageDrivenTypeMetadata.getProject().equals(this.javaProject)) continue;
            InboundAdapterArtifactsGenerationModel generationModel = new InboundAdapterArtifactsGenerationModel();
            generationModel.setMessageDrivenTypeMetadata(messageDrivenTypeMetadata);
            generationModel.setStatelessTypeMetadata(statelessTypeMetadata);
            modelTable.put(messageDrivenTypeMetadata.getMessageDrivenBeanClassName(), generationModel);
        }
        return modelTable;
    }

    private boolean processMessageDrivenTypeMetadata() {
        boolean processed = false;
        List inboundAdapterAnnotations = TriggerAnnotationsRetriever.getAnnotations((String)InboundAdapter.class.getName());
        for (IAnnotation inboundAdapterAnnotation : inboundAdapterAnnotations) {
            IAnnotation messageDrivenAnnotation;
            IJavaProject project = inboundAdapterAnnotation.getJavaProject();
            if (!project.equals(this.javaProject)) continue;
            IType messageDrivenBeanType = (IType)inboundAdapterAnnotation.getParent();
            if (!messageDrivenBeanType.exists()) {
                MessageDrivenTypeMetadata mdtMetadata = new MessageDrivenTypeMetadata(project);
                mdtMetadata.setMessageDrivenBeanClassName(messageDrivenBeanType.getFullyQualifiedName());
                messageDrivenTypeMetadataTable.remove(mdtMetadata.getKey());
                continue;
            }
            IAnnotation eventEndPointConfigAnnotation = messageDrivenBeanType.getAnnotation("EventEndPointConfiguration");
            EventEndPointConfigurationTypeMetadata eventEndPointConfigTypeMetadata = null;
            if (eventEndPointConfigAnnotation.exists()) {
                eventEndPointConfigTypeMetadata = new EventEndPointConfigurationTypeMetadata();
                try {
                    IMemberValuePair[] eventEndPointConfigAnnotationMembers;
                    IMemberValuePair[] iMemberValuePairArray = eventEndPointConfigAnnotationMembers = eventEndPointConfigAnnotation.getMemberValuePairs();
                    int n = eventEndPointConfigAnnotationMembers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemberValuePair eventEndPointConfigAnnotationMember = iMemberValuePairArray[n2];
                        String memberName = eventEndPointConfigAnnotationMember.getMemberName();
                        if ("jmsConnectionFactoryJNDIName".equals(memberName)) {
                            eventEndPointConfigTypeMetadata.setJmsConnectionFactoryJNDIName((String)eventEndPointConfigAnnotationMember.getValue());
                        } else if ("jmsDestinationJNDIName".equals(memberName)) {
                            eventEndPointConfigTypeMetadata.setJmsDestinationJNDIName((String)eventEndPointConfigAnnotationMember.getValue());
                        } else if ("namingProviderURL_Host".equals(memberName)) {
                            eventEndPointConfigTypeMetadata.setNamingProviderHostName((String)eventEndPointConfigAnnotationMember.getValue());
                        } else if ("namingProviderURL_Port".equals(memberName)) {
                            eventEndPointConfigTypeMetadata.setNamingProviderPort((String)eventEndPointConfigAnnotationMember.getValue());
                        } else if ("jmsConnectionAuthentication_ClientName".equals(memberName)) {
                            eventEndPointConfigTypeMetadata.setJmsConnectionAuthenticationClientName((String)eventEndPointConfigAnnotationMember.getValue());
                        } else if ("jmsConnectionAuthentication_ClientPassword".equals(memberName)) {
                            eventEndPointConfigTypeMetadata.setJmsConnectionAuthenticationClientPassword((String)eventEndPointConfigAnnotationMember.getValue());
                        } else if ("monitor".equals(memberName)) {
                            eventEndPointConfigTypeMetadata.setMonitor((Boolean)eventEndPointConfigAnnotationMember.getValue());
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException jme) {
                    Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 4, jme.getLocalizedMessage(), (Throwable)jme);
                    ILog logger = CodegenPlugin.getDefault().getLog();
                    logger.log((IStatus)status);
                    return false;
                }
            }
            if (!(messageDrivenAnnotation = messageDrivenBeanType.getAnnotation("MessageDriven")).exists()) continue;
            String messageDrivenBeanClassName = messageDrivenBeanType.getFullyQualifiedName();
            MessageDrivenTypeMetadata messageDrivenTypeMetadata = new MessageDrivenTypeMetadata(project);
            if (eventEndPointConfigTypeMetadata != null) {
                messageDrivenTypeMetadata.setEventEndPointConfigurationTypeMetadata(eventEndPointConfigTypeMetadata);
            }
            messageDrivenTypeMetadata.setMessageDrivenBeanClassName(messageDrivenBeanClassName);
            try {
                IField[] fields;
                IMemberValuePair[] inboundAdapterAnnotationMembers;
                IMemberValuePair[] iMemberValuePairArray = inboundAdapterAnnotationMembers = inboundAdapterAnnotation.getMemberValuePairs();
                int n = inboundAdapterAnnotationMembers.length;
                int memberName = 0;
                while (memberName < n) {
                    IMemberValuePair member = iMemberValuePairArray[memberName];
                    if ("activationSpec".equals(member.getMemberName()) && member.getValue() instanceof IAnnotation && ActivationSpecification.class.getSimpleName().equals(((IAnnotation)member.getValue()).getElementName())) {
                        IMemberValuePair[] activationSpecAnnotationMembers;
                        IMemberValuePair[] iMemberValuePairArray2 = activationSpecAnnotationMembers = ((IAnnotation)member.getValue()).getMemberValuePairs();
                        int n3 = activationSpecAnnotationMembers.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMemberValuePair activationSpecAnnotationMember = iMemberValuePairArray2[n4];
                            String memberName2 = activationSpecAnnotationMember.getMemberName();
                            if ("jndiName".equals(memberName2)) {
                                messageDrivenTypeMetadata.setActivationSpecJNDIName((String)activationSpecAnnotationMember.getValue());
                            } else if ("activationSpecClass".equals(memberName2)) {
                                messageDrivenTypeMetadata.setActivationSpecClassName((String)activationSpecAnnotationMember.getValue());
                            } else if ("authenticationAlias".equals(memberName2)) {
                                messageDrivenTypeMetadata.setAuthenticationAlias((String)activationSpecAnnotationMember.getValue());
                            }
                            ++n4;
                        }
                    } else if ("functionSelectorClass".equals(member.getMemberName())) {
                        messageDrivenTypeMetadata.setFunctionSelectorClassName((String)member.getValue());
                    }
                    ++memberName;
                }
                IField[] iFieldArray = fields = messageDrivenBeanType.getFields();
                int n5 = fields.length;
                n = 0;
                while (n < n5) {
                    IField field = iFieldArray[n];
                    IAnnotation statelessSessionEJBReferenceAnnotation = field.getAnnotation("EJB");
                    if (statelessSessionEJBReferenceAnnotation.exists()) {
                        String localInterfaceName = Signature.toString((String)field.getTypeSignature());
                        IImportDeclaration[] imports = messageDrivenBeanType.getCompilationUnit().getImports();
                        boolean foundInterface = false;
                        IImportDeclaration[] iImportDeclarationArray = imports;
                        int n6 = imports.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            IImportDeclaration localInterfaceImport = iImportDeclarationArray[n7];
                            if (localInterfaceImport.getElementName().indexOf(localInterfaceName) > 0) {
                                messageDrivenTypeMetadata.setLocalInterfaceClassName(localInterfaceImport.getElementName());
                                foundInterface = true;
                                break;
                            }
                            ++n7;
                        }
                        if (!foundInterface) {
                            String packageName = messageDrivenBeanType.getCompilationUnit().getPackageDeclarations()[0].getElementName();
                            String localInterfaceClassName = String.valueOf(packageName) + "." + localInterfaceName;
                            messageDrivenTypeMetadata.setLocalInterfaceClassName(localInterfaceClassName);
                        }
                    }
                    ++n;
                }
            }
            catch (JavaModelException jme) {
                Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 4, jme.getLocalizedMessage(), (Throwable)jme);
                ILog logger = CodegenPlugin.getDefault().getLog();
                logger.log((IStatus)status);
                return false;
            }
            if (!messageDrivenTypeMetadata.hasCompleteMetadata()) continue;
            if (!messageDrivenTypeMetadataTable.containsKey(messageDrivenTypeMetadata.getKey())) {
                messageDrivenTypeMetadata.setUpdated(true);
                messageDrivenTypeMetadataTable.put(messageDrivenTypeMetadata.getKey(), messageDrivenTypeMetadata);
            } else {
                MessageDrivenTypeMetadata currentMessageDrivenTypeMetadata = messageDrivenTypeMetadataTable.get(messageDrivenTypeMetadata.getKey());
                if (!currentMessageDrivenTypeMetadata.equals(messageDrivenTypeMetadata)) {
                    messageDrivenTypeMetadata.setUpdated(true);
                    messageDrivenTypeMetadataTable.put(messageDrivenTypeMetadata.getKey(), messageDrivenTypeMetadata);
                } else {
                    currentMessageDrivenTypeMetadata.setUpdated(false);
                }
            }
            processed = true;
        }
        return processed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processStatelessTypeMetadata() {
        boolean processed = false;
        List statelessAnnotations = TriggerAnnotationsRetriever.getAnnotations((String)"Stateless");
        for (IAnnotation statelessAnnotation : statelessAnnotations) {
            IJavaProject project = statelessAnnotation.getJavaProject();
            if (!project.equals(this.javaProject)) continue;
            try {
                IType[] interfaces;
                IType statelessSessionBeanType = (IType)statelessAnnotation.getParent();
                if (!statelessSessionBeanType.exists()) {
                    StatelessTypeMetadata stMetadata = new StatelessTypeMetadata(project);
                    stMetadata.setStatelessSessionBeanClassName(statelessSessionBeanType.getFullyQualifiedName());
                    statelessTypeMetadataTable.remove(stMetadata.getKey());
                    continue;
                }
                ITypeHierarchy hierarchy = statelessSessionBeanType.newSupertypeHierarchy(null);
                IType[] iTypeArray = interfaces = hierarchy.getSuperInterfaces(statelessSessionBeanType);
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    IType interfaceType = iTypeArray[n2];
                    IAnnotation localInterfaceAnnotation = statelessSessionBeanType.getAnnotation("Local");
                    if (localInterfaceAnnotation.exists()) {
                        IMethod[] methods;
                        IMemberValuePair[] localInterfaceAnnotationMembers;
                        IMemberValuePair[] iMemberValuePairArray = localInterfaceAnnotationMembers = localInterfaceAnnotation.getMemberValuePairs();
                        int n3 = localInterfaceAnnotationMembers.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMemberValuePair member = iMemberValuePairArray[n4];
                            String interfaceName = (String)member.getValue();
                            if (!interfaceName.equals(interfaceType.getFullyQualifiedName())) {
                                return false;
                            }
                            ++n4;
                        }
                        String statelessSessionBeanClassName = statelessSessionBeanType.getFullyQualifiedName();
                        StatelessTypeMetadata statelessTypeMetadata = new StatelessTypeMetadata(project);
                        statelessTypeMetadata.setStatelessSessionBeanClassName(statelessSessionBeanClassName);
                        statelessTypeMetadata.setLocalInterfaceClassName(interfaceType.getFullyQualifiedName());
                        EventTypeMetadata eventTypeMetadata = new EventTypeMetadata();
                        IMethod[] iMethodArray = methods = statelessSessionBeanType.getMethods();
                        int n5 = methods.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IAnnotation eventAnnotation;
                            int n7;
                            IMethod method = iMethodArray[n6];
                            String methodName = method.getElementName();
                            IAnnotation inboundMethodBindingAnnotation = method.getAnnotation("InboundMethodBinding");
                            if (inboundMethodBindingAnnotation.exists()) {
                                String[] parameters;
                                IMemberValuePair[] inboundMethodBindingAnnotationMembers = inboundMethodBindingAnnotation.getMemberValuePairs();
                                String nativeMethodName = null;
                                IMemberValuePair[] iMemberValuePairArray2 = inboundMethodBindingAnnotationMembers;
                                n7 = inboundMethodBindingAnnotationMembers.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    IMemberValuePair member = iMemberValuePairArray2[n8];
                                    if ("nativeMethod".equals(member.getMemberName())) {
                                        nativeMethodName = (String)member.getValue();
                                    }
                                    ++n8;
                                }
                                statelessTypeMetadata.addMethodEntry(nativeMethodName, methodName);
                                String returnType = Signature.toString((String)method.getReturnType());
                                if (!"void".equals(returnType)) {
                                    statelessTypeMetadata.addOutputRecordEntry(methodName, returnType);
                                }
                                if ((parameters = method.getParameterTypes()).length > 0) {
                                    statelessTypeMetadata.addInputRecordEntry(methodName, Signature.toString((String)parameters[0]));
                                }
                            }
                            if ((eventAnnotation = method.getAnnotation("Event")).exists()) {
                                IMemberValuePair[] eventAnnotationMembers = eventAnnotation.getMemberValuePairs();
                                String name = null;
                                IMemberValuePair[] iMemberValuePairArray3 = eventAnnotationMembers;
                                int n9 = eventAnnotationMembers.length;
                                n7 = 0;
                                while (n7 < n9) {
                                    IMemberValuePair member = iMemberValuePairArray3[n7];
                                    if ("name".equals(member.getMemberName())) {
                                        name = (String)member.getValue();
                                        if (eventTypeMetadata != null) {
                                            eventTypeMetadata.addEventName(methodName, name);
                                        }
                                    }
                                    ++n7;
                                }
                            }
                            ++n6;
                        }
                        if (eventTypeMetadata != null && !eventTypeMetadata.getEventNameEntries().isEmpty()) {
                            statelessTypeMetadata.setEventTypeMetadata(eventTypeMetadata);
                        }
                        if (statelessTypeMetadata.hasCompleteMetadata()) {
                            if (!statelessTypeMetadataTable.containsKey(statelessTypeMetadata.getKey())) {
                                statelessTypeMetadataTable.put(statelessTypeMetadata.getKey(), statelessTypeMetadata);
                                statelessTypeMetadata.setUpdated(true);
                            } else {
                                StatelessTypeMetadata currentStatelessTypeMetadata = statelessTypeMetadataTable.get(statelessTypeMetadata.getKey());
                                if (!currentStatelessTypeMetadata.equals(statelessTypeMetadata)) {
                                    statelessTypeMetadata.setUpdated(true);
                                    statelessTypeMetadataTable.put(statelessTypeMetadata.getKey(), statelessTypeMetadata);
                                } else {
                                    currentStatelessTypeMetadata.setUpdated(false);
                                }
                            }
                            processed = true;
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException jme) {
                Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 4, jme.getLocalizedMessage(), (Throwable)jme);
                ILog logger = CodegenPlugin.getDefault().getLog();
                logger.log((IStatus)status);
                return false;
            }
        }
        return processed;
    }

    private void generateEJBBindingsDescriptor(InboundAdapterArtifactsGenerationModel generationModel) {
        if (this.javaProject != null && this.javaProject.exists()) {
            try {
                IProject project = this.javaProject.getProject();
                EjbBindingsDescriptor descriptor = new EjbBindingsDescriptor(project);
                String qualifiedClassName = generationModel.getMessageDrivenTypeMetadata().getMessageDrivenBeanClassName();
                String className = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(".") + 1);
                String activationSpecJNDIName = generationModel.getMessageDrivenTypeMetadata().getActivationSpecJNDIName();
                String authenticationAlias = generationModel.getMessageDrivenTypeMetadata().getAuthenticationAlias();
                descriptor.setMessageDrivenBindingJcaAdapter(className, activationSpecJNDIName, authenticationAlias, null);
            }
            catch (CoreException ce) {
                Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 4, ce.getLocalizedMessage(), (Throwable)ce);
                ILog logger = CodegenPlugin.getDefault().getLog();
                logger.log((IStatus)status);
            }
        }
    }

    private void generateMDBHelper(InboundAdapterArtifactsGenerationModel generationModel) {
        try {
            if (this.javaProject != null && this.javaProject.exists()) {
                String content = this.buildMDBHelperCompilationUnitContent(generationModel);
                this.createCompilationUnit(this.javaProject, String.valueOf(generationModel.getMessageDrivenTypeMetadata().getMessageDrivenBeanClassName()) + "Helper", content);
            }
        }
        catch (CoreException ce) {
            Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 4, ce.getLocalizedMessage(), (Throwable)ce);
            ILog logger = CodegenPlugin.getDefault().getLog();
            logger.log((IStatus)status);
        }
    }

    private boolean MDBHelperExists(InboundAdapterArtifactsGenerationModel generationModel) {
        boolean exists = false;
        if (this.javaProject != null && this.javaProject.exists()) {
            IType type;
            String className;
            block5: {
                String parentName = generationModel.getMessageDrivenTypeMetadata().getMessageDrivenBeanClassName();
                className = String.valueOf(parentName) + "Helper";
                IType parentType = null;
                type = null;
                try {
                    parentType = this.javaProject.findType(parentName);
                    if (parentType != null) break block5;
                    return true;
                }
                catch (JavaModelException javaModelException) {}
            }
            type = this.javaProject.findType(className);
            if (type != null) {
                exists = true;
            }
        }
        return exists;
    }

    private void generateInboundEventInterceptor(InboundAdapterArtifactsGenerationModel generationModel) {
        try {
            String content;
            if (this.javaProject != null && this.javaProject.exists() && (content = this.buildInboundEventInterceptorCompilationUnitContent(generationModel)) != null) {
                this.createCompilationUnit(this.javaProject, String.valueOf(generationModel.getMessageDrivenTypeMetadata().getMessageDrivenBeanClassName()) + "EventInterceptor", content);
            }
        }
        catch (CoreException ce) {
            Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 4, ce.getLocalizedMessage(), (Throwable)ce);
            ILog logger = CodegenPlugin.getDefault().getLog();
            logger.log((IStatus)status);
        }
    }

    private String buildMDBHelperCompilationUnitContent(InboundAdapterArtifactsGenerationModel generationModel) {
        String method;
        EventTypeMetadata eventTypeMetadata;
        boolean hasOutput;
        StringBuffer stringBuffer = new StringBuffer();
        String NL = System.getProperties().getProperty("line.separator");
        String qualifiedClassName = generationModel.getMessageDrivenTypeMetadata().getMessageDrivenBeanClassName();
        String javaPackage = qualifiedClassName.substring(0, qualifiedClassName.lastIndexOf("."));
        String className = String.valueOf(qualifiedClassName.substring(qualifiedClassName.lastIndexOf(".") + 1)) + "Helper";
        stringBuffer.append("package " + javaPackage + ";" + NL);
        stringBuffer.append("import javax.annotation.Generated;" + NL);
        Date time = Calendar.getInstance().getTime();
        String date = DateFormat.getDateTimeInstance(0, 0).format(time);
        stringBuffer.append("@Generated(comments=\"" + MessageResource.GENERATED_ANNOTATION_COMMENT + "\",date=\"" + date + "\",value={\"" + MessageResource.GENERATED_ANNOTATION_VALUE + "\"})" + NL);
        stringBuffer.append(String.valueOf(NL) + "public class " + className + "{" + NL);
        stringBuffer.append("\tprivate static java.util.HashMap<String,String> methodNameTable = new java.util.HashMap<String,String>();");
        stringBuffer.append("\tprivate static java.util.HashMap<String,String> inputDataTable = new java.util.HashMap<String,String>();");
        boolean bl = hasOutput = !generationModel.getStatelessTypeMetadata().getOutputDataEntries().isEmpty();
        if (hasOutput) {
            stringBuffer.append("\tprivate static java.util.HashMap<String, String> outputDataTable = new java.util.HashMap<String, String>();");
        }
        if ((eventTypeMetadata = generationModel.getStatelessTypeMetadata().getEventTypeMetadata()) != null) {
            stringBuffer.append("\tprivate static java.util.HashMap<String,String> eventNameTable = new java.util.HashMap<String,String>();");
        }
        stringBuffer.append(String.valueOf(NL) + "\tpublic static void initialize() {" + NL);
        Set<Map.Entry<String, String>> methodMappings = generationModel.getStatelessTypeMetadata().getMethodNameEntries();
        for (Map.Entry<String, String> methodMapping : methodMappings) {
            String nativeMethod = methodMapping.getKey();
            method = methodMapping.getValue();
            stringBuffer.append("\t\tmethodNameTable.put(\"" + (String)nativeMethod + "\"," + "\"" + method + "\");" + NL);
        }
        Set<Map.Entry<String, String>> inputDataMappings = generationModel.getStatelessTypeMetadata().getInputDataEntries();
        for (Map.Entry entry : inputDataMappings) {
            method = (String)entry.getKey();
            String inputRecord = (String)entry.getValue();
            stringBuffer.append("\t\tinputDataTable.put(\"" + method + "\"," + "\"" + inputRecord + "\");" + NL);
        }
        if (hasOutput) {
            Set<Map.Entry<String, String>> set = generationModel.getStatelessTypeMetadata().getOutputDataEntries();
            for (Map.Entry<String, String> outputDataMapping : set) {
                String method2 = outputDataMapping.getKey();
                String outputRecord = outputDataMapping.getValue();
                stringBuffer.append("\t\toutputDataTable.put(\"" + method2 + "\"," + "\"" + outputRecord + "\");" + NL);
            }
        }
        if (eventTypeMetadata != null) {
            Set<Map.Entry<String, String>> set = eventTypeMetadata.getEventNameEntries();
            for (Map.Entry<String, String> eventNameMapping : set) {
                String methodName = eventNameMapping.getKey();
                String eventName = eventNameMapping.getValue();
                stringBuffer.append("\t\teventNameTable.put(\"" + methodName + "\"," + "\"" + eventName + "\");" + NL);
            }
        }
        stringBuffer.append("\t}" + NL);
        stringBuffer.append("\tpublic static void cleanup() {" + NL);
        stringBuffer.append("\t\tmethodNameTable.clear();" + NL);
        stringBuffer.append("\t\tinputDataTable.clear();" + NL);
        if (hasOutput) {
            stringBuffer.append("\t\toutputDataTable.clear();" + NL);
        }
        if (eventTypeMetadata != null) {
            stringBuffer.append("\t\teventNameTable.clear();" + NL);
        }
        stringBuffer.append("\t}" + NL + NL);
        stringBuffer.append("\t/**" + NL);
        stringBuffer.append("\t* @param inputs - objects passed to the business method of the MessageDriven EJB" + NL);
        stringBuffer.append("\t* @return Stateless Session EJB business method name that will be invoked by corresponding business method of the MessageDriven EJB" + NL);
        stringBuffer.append("\t* @throws javax.resource.ResourceException" + NL);
        stringBuffer.append("\t*/" + NL);
        stringBuffer.append("\tpublic static String getInvocationTargetMethodName(Object[] inputs) throws javax.resource.ResourceException {" + NL);
        stringBuffer.append("\t\tString methodName = null;" + NL);
        stringBuffer.append("\t\ttry {" + NL);
        stringBuffer.append("\t\t\tcommonj.connector.runtime.FunctionSelector selector = new " + generationModel.getMessageDrivenTypeMetadata().getFunctionSelectorClassName() + "();" + NL);
        stringBuffer.append("\t\t\tString nativeMethodName = selector.generateEISFunctionName(inputs);" + NL);
        stringBuffer.append("\t\t\tif (nativeMethodName == null || nativeMethodName.trim().length() == 0)" + NL);
        stringBuffer.append("\t\t\t\tthrow new javax.resource.ResourceException(\"Native method name is invalid\");" + NL);
        stringBuffer.append("\t\t\tmethodName = methodNameTable.get(nativeMethodName);" + NL);
        stringBuffer.append("\t\t\tif (methodName == null || methodName.length() == 0)" + NL);
        stringBuffer.append("\t\t\t\tthrow new javax.resource.ResourceException(\"Cannot find target invocation method name for the native method name: \" + nativeMethodName + \".\");" + NL);
        stringBuffer.append("\t\t} catch(commonj.connector.runtime.SelectorException e) {" + NL);
        stringBuffer.append("\t\t\tjavax.resource.ResourceException resourceException = new javax.resource.ResourceException();" + NL);
        stringBuffer.append("\t\t\tresourceException.initCause(e);" + NL);
        stringBuffer.append("\t\t\tthrow resourceException;" + NL);
        stringBuffer.append("\t\t}" + NL);
        stringBuffer.append("\t\treturn methodName;" + NL);
        stringBuffer.append("\t}" + NL + NL);
        stringBuffer.append("\t/**" + NL);
        stringBuffer.append("\t* @param methodName - business method name of the Stateless Session EJB" + NL);
        stringBuffer.append("\t* @return fully qualified class name of the input object passed to the business method of the Stateless Session EJB" + NL);
        stringBuffer.append("\t* @throws javax.resource.ResourceException" + NL);
        stringBuffer.append("\t*/" + NL);
        stringBuffer.append("\tpublic static String getInvocationTargetMethodInputRecordClassName(String methodName) throws javax.resource.ResourceException {" + NL);
        stringBuffer.append("\t\tString inputRecordName = inputDataTable.get(methodName);" + NL);
        stringBuffer.append("\t\tif (inputRecordName == null || inputRecordName.trim().length() == 0)" + NL);
        stringBuffer.append("\t\t\tthrow new javax.resource.ResourceException(\"Cannot find corresponding Java Bean Record name for \" + methodName);" + NL);
        stringBuffer.append("\t\treturn inputRecordName;" + NL);
        stringBuffer.append("\t}" + NL + NL);
        if (hasOutput) {
            stringBuffer.append("\t/**" + NL);
            stringBuffer.append("\t* @param methodName - business method name of the Stateless Session EJB" + NL);
            stringBuffer.append("\t* @return fully qualified class name of the output object returned by the business method of the Stateless Session EJB" + NL);
            stringBuffer.append("\t* @throws javax.resource.ResourceException" + NL);
            stringBuffer.append("\t*/" + NL);
            stringBuffer.append("\tpublic static String getInvocationTargetMethodOutputRecordName(String methodName) throws javax.resource.ResourceException {" + NL);
            stringBuffer.append("\t\tString outputRecordName = outputDataTable.get(methodName);" + NL);
            stringBuffer.append("\t\tif (outputRecordName == null || outputRecordName.trim().length() == 0)" + NL);
            stringBuffer.append("\t\t\tthrow new javax.resource.ResourceException(\"Can not find corresponding Java Bean Record name\");" + NL);
            stringBuffer.append("\t\treturn outputRecordName;" + NL);
            stringBuffer.append("\t}" + NL);
        }
        if (eventTypeMetadata != null) {
            stringBuffer.append("\t/**" + NL);
            stringBuffer.append("\t* @param methodName - business method name of the Stateless Session EJB" + NL);
            stringBuffer.append("\t* @return name of the business event" + NL);
            stringBuffer.append("\t*/" + NL);
            stringBuffer.append("\tpublic static String getEventName(String methodName) {" + NL);
            stringBuffer.append("\t\treturn eventNameTable.get(methodName);" + NL);
            stringBuffer.append("\t}" + NL + NL);
        }
        stringBuffer.append("\t/**" + NL);
        stringBuffer.append("\t* @param inputs - objects passed to the business method of the MessageDriven EJB" + NL);
        stringBuffer.append("\t* @return instance of the javax.resource.cci.Record. This object should be one of the parameters passed to the business method of the MessageDriven EJB" + NL);
        stringBuffer.append("\t* @throws javax.resource.ResourceException" + NL);
        stringBuffer.append("\t*/" + NL);
        stringBuffer.append("\tpublic static javax.resource.cci.Record findRecord(Object[] inputs) throws javax.resource.ResourceException {" + NL);
        stringBuffer.append("\t\tjavax.resource.cci.Record record = null;" + NL);
        stringBuffer.append("\t\tfor (Object input : inputs) {" + NL);
        stringBuffer.append("\t\t\tif (input instanceof javax.resource.cci.Record) {" + NL);
        stringBuffer.append("\t\t\t\trecord = (javax.resource.cci.Record) input;" + NL);
        stringBuffer.append("\t\t\t\tbreak;" + NL);
        stringBuffer.append("\t\t\t}" + NL);
        stringBuffer.append("\t\t}" + NL);
        stringBuffer.append("\t\tif (record == null)" + NL);
        stringBuffer.append("\t\t\tthrow new javax.resource.ResourceException(" + NL);
        stringBuffer.append("\t\t\t\t\"Invalid record type was passed: One of the input parameters must implement javax.resource.cci.Record interface.\");" + NL);
        stringBuffer.append("\t\treturn record;" + NL);
        stringBuffer.append("\t}" + NL);
        stringBuffer.append("\t@SuppressWarnings(\"unchecked\")" + NL);
        stringBuffer.append("\tpublic static void send(Object[] inputs, Object statelessEJBLocalInterface) throws javax.resource.ResourceException {" + NL);
        stringBuffer.append("\t\ttry {" + NL);
        stringBuffer.append("\t\t\tjavax.resource.cci.Record record = findRecord(inputs);" + NL);
        stringBuffer.append("\t\t\tString methodName = getInvocationTargetMethodName(inputs);" + NL);
        stringBuffer.append("\t\t\tString recordName = getInvocationTargetMethodInputRecordClassName(methodName);" + NL);
        stringBuffer.append("\t\t\tif (recordName.equals(record.getClass().getName())) {" + NL);
        stringBuffer.append("\t\t\t\tjava.lang.reflect.Method method = statelessEJBLocalInterface.getClass().getMethod(methodName, new Class[] { record.getClass() });" + NL);
        stringBuffer.append("\t\t\t\tmethod.invoke(statelessEJBLocalInterface, new Object[] { record });" + NL);
        stringBuffer.append("\t\t\t} else {" + NL);
        stringBuffer.append("\t\t\t\tClass recordClass = Class.forName(recordName);" + NL);
        stringBuffer.append("\t\t\t\tObject recordObject = recordClass.newInstance();" + NL);
        stringBuffer.append("\t\t\t\tif (recordObject instanceof commonj.connector.runtime.RecordHolder) {" + NL);
        stringBuffer.append("\t\t\t\t\t((commonj.connector.runtime.RecordHolder) recordObject).setRecord((javax.resource.cci.Record) record);" + NL);
        stringBuffer.append("\t\t\t\t\tjava.lang.reflect.Method method = statelessEJBLocalInterface.getClass().getMethod(methodName, new Class[] { recordClass });" + NL);
        stringBuffer.append("\t\t\t\t\tmethod.invoke(statelessEJBLocalInterface, new Object[] { recordObject });" + NL);
        stringBuffer.append("\t\t\t\t} else if ((record instanceof javax.resource.cci.Streamable) && (recordObject instanceof javax.resource.cci.Streamable)) {" + NL);
        stringBuffer.append("\t\t\t\t\tjava.io.ByteArrayOutputStream outputStream = new java.io.ByteArrayOutputStream();" + NL);
        stringBuffer.append("\t\t\t\t\t((javax.resource.cci.Streamable)record).write (outputStream);" + NL);
        stringBuffer.append("\t\t\t\t\tjava.io.ByteArrayInputStream inputStream = new java.io.ByteArrayInputStream(outputStream.toByteArray());" + NL);
        stringBuffer.append("\t\t\t\t\t((javax.resource.cci.Streamable)recordObject).read (inputStream);" + NL);
        stringBuffer.append("\t\t\t\t\tjava.lang.reflect.Method method = statelessEJBLocalInterface.getClass().getMethod(methodName, new Class[] { recordClass });" + NL);
        stringBuffer.append("\t\t\t\t\tmethod.invoke(statelessEJBLocalInterface, new Object[] { recordObject });" + NL);
        stringBuffer.append("\t\t\t\t} else {" + NL);
        stringBuffer.append("\t\t\t\t\tthrow new javax.resource.ResourceException(\"Invalid record type was passed: \" + recordClass.getName() + \" must implement javax.resource.cci.Record or commonj.connector.runtime.RecordHolder interface.\");" + NL);
        stringBuffer.append("\t\t\t\t}" + NL);
        stringBuffer.append("\t\t\t}" + NL);
        stringBuffer.append("\t\t} catch (Exception e) {" + NL);
        stringBuffer.append("\t\t\tjavax.resource.ResourceException resourceException = new javax.resource.ResourceException();" + NL);
        stringBuffer.append("\t\t\tresourceException.initCause(e);" + NL);
        stringBuffer.append("\t\t\tthrow resourceException;" + NL);
        stringBuffer.append("\t\t}" + NL);
        stringBuffer.append("\t}" + NL);
        stringBuffer.append("\t@SuppressWarnings(\"unchecked\")" + NL);
        stringBuffer.append("\tpublic static javax.resource.cci.Record sendReceive(Object[] inputs, Object statelessEJBLocalInterface) throws javax.resource.ResourceException {" + NL);
        stringBuffer.append("\t\ttry {" + NL);
        stringBuffer.append("\t\t\tObject result = null;" + NL);
        stringBuffer.append("\t\t\tjavax.resource.cci.Record record = findRecord(inputs);" + NL);
        stringBuffer.append("\t\t\tString methodName = getInvocationTargetMethodName(inputs);" + NL);
        stringBuffer.append("\t\t\tString recordName = getInvocationTargetMethodInputRecordClassName(methodName);" + NL);
        stringBuffer.append("\t\t\tif (recordName.equals(record.getClass().getName())) {" + NL);
        stringBuffer.append("\t\t\t\tjava.lang.reflect.Method method = statelessEJBLocalInterface.getClass().getMethod(methodName, new Class[] { record.getClass() });" + NL);
        stringBuffer.append("\t\t\t\tresult = method.invoke(statelessEJBLocalInterface, new Object[] { record });" + NL);
        stringBuffer.append("\t\t\t\treturn (javax.resource.cci.Record) result;" + NL);
        stringBuffer.append("\t\t\t} else {" + NL);
        stringBuffer.append("\t\t\t\tClass recordClass = Class.forName(recordName);" + NL);
        stringBuffer.append("\t\t\t\tObject recordObject = recordClass.newInstance();" + NL);
        stringBuffer.append("\t\t\t\tif (recordObject instanceof commonj.connector.runtime.RecordHolder) {" + NL);
        stringBuffer.append("\t\t\t\t\t((commonj.connector.runtime.RecordHolder) recordObject).setRecord((javax.resource.cci.Record) record);" + NL);
        stringBuffer.append("\t\t\t\t\tjava.lang.reflect.Method method = statelessEJBLocalInterface.getClass().getMethod(methodName, new Class[] { recordClass });" + NL);
        stringBuffer.append("\t\t\t\t\tresult = method.invoke(statelessEJBLocalInterface, new Object[] { recordObject });" + NL);
        stringBuffer.append("\t\t\t\t\tif (result instanceof commonj.connector.runtime.RecordHolder)" + NL);
        stringBuffer.append("\t\t\t\t\t\treturn ((commonj.connector.runtime.RecordHolder) result).getRecord();" + NL);
        stringBuffer.append("\t\t\t\t\telse if (result instanceof javax.resource.cci.Record)" + NL);
        stringBuffer.append("\t\t\t\t\t\treturn (javax.resource.cci.Record) result;" + NL);
        stringBuffer.append("\t\t\t\t} else if ((record instanceof javax.resource.cci.Streamable) && (recordObject instanceof javax.resource.cci.Streamable)) {" + NL);
        stringBuffer.append("\t\t\t\t\tjava.io.ByteArrayOutputStream outputStream = new java.io.ByteArrayOutputStream();" + NL);
        stringBuffer.append("\t\t\t\t\t((javax.resource.cci.Streamable)record).write (outputStream);" + NL);
        stringBuffer.append("\t\t\t\t\tjava.io.ByteArrayInputStream inputStream = new java.io.ByteArrayInputStream(outputStream.toByteArray());" + NL);
        stringBuffer.append("\t\t\t\t\t((javax.resource.cci.Streamable)recordObject).read (inputStream);" + NL);
        stringBuffer.append("\t\t\t\t\tjava.lang.reflect.Method method = statelessEJBLocalInterface.getClass().getMethod(methodName, new Class[] { recordClass });" + NL);
        stringBuffer.append("\t\t\t\t\tresult = method.invoke(statelessEJBLocalInterface, new Object[] { recordObject });" + NL);
        stringBuffer.append("\t\t\t\t\tif (result instanceof commonj.connector.runtime.RecordHolder)" + NL);
        stringBuffer.append("\t\t\t\t\t\treturn ((commonj.connector.runtime.RecordHolder) result).getRecord();" + NL);
        stringBuffer.append("\t\t\t\t\telse if (result instanceof javax.resource.cci.Record)" + NL);
        stringBuffer.append("\t\t\t\t\t\treturn (javax.resource.cci.Record)result;" + NL);
        stringBuffer.append("\t\t\t\t} else {" + NL);
        stringBuffer.append("\t\t\t\t\tthrow new javax.resource.ResourceException(\"Invalid record type was passed: \" + recordClass.getName() + \" must implement javax.resource.cci.Record or commonj.connector.runtime.RecordHolder interface.\");" + NL);
        stringBuffer.append("\t\t\t\t}" + NL);
        stringBuffer.append("\t\t\t}" + NL);
        stringBuffer.append("\t\t} catch (Exception e) {" + NL);
        stringBuffer.append("\t\t\tjavax.resource.ResourceException resourceException = new javax.resource.ResourceException();" + NL);
        stringBuffer.append("\t\t\tresourceException.initCause(e);" + NL);
        stringBuffer.append("\t\t\tthrow resourceException;" + NL);
        stringBuffer.append("\t\t}" + NL + NL);
        stringBuffer.append("\t\treturn null;" + NL);
        stringBuffer.append("\t}" + NL);
        stringBuffer.append("}" + NL);
        return stringBuffer.toString();
    }

    private String buildInboundEventInterceptorCompilationUnitContent(InboundAdapterArtifactsGenerationModel generationModel) {
        EventEndPointConfigurationTypeMetadata eventEndPointConfigTypeMetadata = generationModel.getMessageDrivenTypeMetadata().getEventEndPointConfigurationTypeMetadata();
        if (eventEndPointConfigTypeMetadata != null) {
            StringBuffer stringBuffer = new StringBuffer();
            String NL = System.getProperties().getProperty("line.separator");
            String qualifiedClassName = generationModel.getMessageDrivenTypeMetadata().getMessageDrivenBeanClassName();
            String javaPackage = qualifiedClassName.substring(0, qualifiedClassName.lastIndexOf("."));
            String className = String.valueOf(qualifiedClassName.substring(qualifiedClassName.lastIndexOf(".") + 1)) + "EventInterceptor";
            stringBuffer.append("package " + javaPackage + ";" + NL);
            stringBuffer.append("import javax.interceptor.AroundInvoke;" + NL);
            stringBuffer.append(String.valueOf(NL) + "public class " + className + "{" + NL);
            stringBuffer.append(String.valueOf(NL) + "\t@AroundInvoke");
            stringBuffer.append(String.valueOf(NL) + "\tpublic Object monitorEvents(javax.interceptor.InvocationContext invokeCtx) throws Exception {" + NL);
            boolean monitor = eventEndPointConfigTypeMetadata.getMonitor();
            stringBuffer.append("\t\tboolean monitor = " + Boolean.toString(monitor) + ";" + NL);
            stringBuffer.append("\t\tif(monitor) {" + NL);
            stringBuffer.append("\t\t\ttry {" + NL);
            stringBuffer.append("\t\t\t\tsendAdapterInboundEvent(invokeCtx);" + NL);
            stringBuffer.append("\t\t\t} catch(Exception e){" + NL);
            stringBuffer.append("\t\t\t\t// only log the exception to allow for MessageDriven business method execution." + NL);
            stringBuffer.append("\t\t\t\tjava.util.logging.Logger logger = java.util.logging.Logger.getLogger(invokeCtx.getTarget().getClass().getName());" + NL);
            stringBuffer.append("\t\t\t\tlogger.logp(java.util.logging.Level.SEVERE, invokeCtx.getTarget().getClass().getName(), invokeCtx.getMethod().getName(), e.getLocalizedMessage(), e);" + NL);
            stringBuffer.append("\t\t\t}" + NL);
            stringBuffer.append("\t\t}" + NL + NL);
            stringBuffer.append("\t\treturn invokeCtx.proceed();" + NL);
            stringBuffer.append("\t}" + NL);
            stringBuffer.append(String.valueOf(NL) + "\tpublic void sendAdapterInboundEvent(javax.interceptor.InvocationContext invokeCtx) throws javax.resource.ResourceException {" + NL);
            stringBuffer.append("\t\ttry {" + NL);
            stringBuffer.append("\t\t\tObject[] inputs = invokeCtx.getParameters();" + NL);
            String helperClassName = String.valueOf(qualifiedClassName.substring(qualifiedClassName.lastIndexOf(".") + 1)) + "Helper";
            stringBuffer.append("\t\t\tString methodName = " + helperClassName + ".getInvocationTargetMethodName(inputs);" + NL);
            stringBuffer.append("\t\t\tString eventName = " + helperClassName + ".getEventName(methodName);" + NL);
            stringBuffer.append("\t\t\tString recordName = " + helperClassName + ".getInvocationTargetMethodInputRecordClassName(methodName);" + NL);
            stringBuffer.append("\t\t\tString boSchemaName = recordName.substring(recordName.lastIndexOf('.') + 1);" + NL);
            stringBuffer.append("\t\t\tString operationName = eventName.substring(0,eventName.indexOf(boSchemaName));" + NL);
            stringBuffer.append("\t\t\tString eventXMLString = createAdapterCBEEvent(inputs, recordName, operationName, boSchemaName);" + NL);
            String hostName = null;
            String clientName = null;
            String host = eventEndPointConfigTypeMetadata.getNamingProviderHostName();
            if (host != null) {
                hostName = host;
                String port = eventEndPointConfigTypeMetadata.getNamingProviderPort();
                stringBuffer.append("\t\t\tjava.util.Hashtable<String, String> env = new java.util.Hashtable<String, String>();" + NL);
                stringBuffer.append("\t\t\tenv.put(javax.naming.Context.INITIAL_CONTEXT_FACTORY, \"com.ibm.websphere.naming.WsnInitialContextFactory\");" + NL);
                stringBuffer.append("\t\t\tenv.put(javax.naming.Context.PROVIDER_URL, \"iiop://" + hostName + ":" + port + "\");" + NL);
                stringBuffer.append("\t\t\tjavax.naming.InitialContext initContext = new javax.naming.InitialContext(env);" + NL);
            } else {
                stringBuffer.append("\t\t\tjavax.naming.InitialContext initContext = new javax.naming.InitialContext();" + NL);
            }
            String connectionFactoryJNDIName = eventEndPointConfigTypeMetadata.getJmsConnectionFactoryJNDIName();
            stringBuffer.append("\t\t\tjavax.jms.ConnectionFactory connectionFactory = (javax.jms.ConnectionFactory) initContext.lookup(\"" + connectionFactoryJNDIName + "\");" + NL);
            String destinationJNDIName = eventEndPointConfigTypeMetadata.getJmsDestinationJNDIName();
            stringBuffer.append("\t\t\tjavax.jms.Destination destination = (javax.jms.Destination) initContext.lookup(\"" + destinationJNDIName + "\");" + NL);
            stringBuffer.append("\t\t\tinitContext.close();" + NL);
            String userName = eventEndPointConfigTypeMetadata.getJmsConnectionAuthenticationClientName();
            if (userName != null) {
                clientName = userName;
                String clientPassword = eventEndPointConfigTypeMetadata.getJmsConnectionAuthenticationClientPassword();
                stringBuffer.append("\t\t\tjavax.jms.Connection connection = (javax.jms.Connection) connectionFactory.createConnection(\"" + clientName + "\"" + ", " + "\"" + clientPassword + "\"" + ");" + NL);
            } else {
                stringBuffer.append("\t\t\tjavax.jms.Connection connection = (javax.jms.Connection) connectionFactory.createConnection();" + NL);
            }
            stringBuffer.append("\t\t\tjavax.jms.Session session = connection.createSession(true, javax.jms.Session.SESSION_TRANSACTED);" + NL);
            stringBuffer.append("\t\t\tjavax.jms.MessageProducer sender = session.createProducer(destination);" + NL);
            stringBuffer.append("\t\t\tjavax.jms.TextMessage message = session.createTextMessage();" + NL);
            stringBuffer.append("\t\t\tmessage.setText(eventXMLString);" + NL);
            stringBuffer.append("\t\t\tmessage.setJMSType(\"CREATE_EVENTS_NOTIFICATION_V2_0\");" + NL);
            stringBuffer.append("\t\t\tmessage.setStringProperty(\"eventName\", operationName);" + NL);
            stringBuffer.append("\t\t\tsender.send(message);" + NL);
            stringBuffer.append("\t\t\tsender.close();" + NL);
            stringBuffer.append("\t\t\tsession.close();" + NL);
            stringBuffer.append("\t\t\tconnection.close();" + NL);
            stringBuffer.append("\t\t} catch (Exception e) {" + NL);
            stringBuffer.append("\t\t\tjavax.resource.ResourceException resourceException = new javax.resource.ResourceException();" + NL);
            stringBuffer.append("\t\t\tresourceException.initCause(e);" + NL);
            stringBuffer.append("\t\t\tthrow resourceException;" + NL);
            stringBuffer.append("\t\t}" + NL);
            stringBuffer.append("\t}" + NL);
            stringBuffer.append(String.valueOf(NL) + "\tprivate String createAdapterCBEEvent(Object[] inputs, String recordName,String operationName,String boSchemaName) throws javax.resource.ResourceException {" + NL);
            stringBuffer.append("\t\torg.eclipse.hyades.logging.events.cbe.EventFactory eventFactory = null;" + NL);
            stringBuffer.append("\t\torg.eclipse.hyades.logging.events.cbe.CommonBaseEvent event = null;" + NL);
            stringBuffer.append("\t\tString eventXMLString = null;" + NL);
            stringBuffer.append("\t\ttry {" + NL);
            stringBuffer.append("\t\t\teventFactory = (org.eclipse.hyades.logging.events.cbe.EventFactory) org.eclipse.hyades.logging.events.cbe.EventFactoryFactory.createEventFactory();" + NL);
            stringBuffer.append("\t\t\tevent = eventFactory.createCommonBaseEvent();" + NL);
            stringBuffer.append("\t\t\tevent.setVersion(\"1.0.1\");" + NL);
            stringBuffer.append("\t\t\tlong currentTime = System.currentTimeMillis();" + NL);
            stringBuffer.append("\t\t\tevent.setCreationTimeAsLong(currentTime);" + NL);
            stringBuffer.append("\t\t\tif(operationName.length() <= 64)" + NL);
            stringBuffer.append("\t\t\t\tevent.setExtensionName(operationName);" + NL);
            stringBuffer.append("\t\t\tString timeStamp = Long.toString(currentTime);" + NL);
            stringBuffer.append("\t\t\tString threadID = Long.toString(Thread.currentThread().getId());" + NL);
            stringBuffer.append("\t\t\tevent.setGlobalInstanceId(threadID + \"_\" + timeStamp); // Thread ID plus the timeStamp for unique Global Instance ID" + NL);
            stringBuffer.append("\t\t\torg.eclipse.hyades.logging.events.cbe.ComponentIdentification componentID = eventFactory.createComponentIdentification();" + NL);
            stringBuffer.append("\t\t\tcomponentID.setComponentIdType(org.eclipse.hyades.logging.events.cbe.ComponentIdentification.COMPONENT_ID_TYPE_PRODUCT_NAME);" + NL);
            String adapterDisplayName = this.getAdapterDisplayName(generationModel.getMessageDrivenTypeMetadata());
            stringBuffer.append("\t\t\tcomponentID.setComponent(\"" + adapterDisplayName + "\"" + ");" + NL);
            stringBuffer.append("\t\t\tcomponentID.setComponentType(\"WebSphere Adapter\");" + NL);
            stringBuffer.append("\t\t\tcomponentID.setSubComponent(boSchemaName);" + NL);
            stringBuffer.append("\t\t\tcomponentID.setLocationType(org.eclipse.hyades.logging.events.cbe.ComponentIdentification.LOCATION_TYPE_HOSTNAME);" + NL);
            if (hostName == null) {
                hostName = "localhost";
            }
            stringBuffer.append("\t\t\tcomponentID.setLocation(\"" + hostName + "\"" + ");" + NL);
            stringBuffer.append("\t\t\tcomponentID.setExecutionEnvironment(System.getProperty(\"os.name\"));" + NL);
            stringBuffer.append("\t\t\tcomponentID.setProcessId(timeStamp);" + NL);
            stringBuffer.append("\t\t\tcomponentID.setThreadId(threadID);" + NL);
            stringBuffer.append("\t\t\tevent.setSourceComponentId(componentID);" + NL + NL);
            stringBuffer.append("\t\t\t// create situation object" + NL);
            stringBuffer.append("\t\t\torg.eclipse.hyades.logging.events.cbe.Situation situation = eventFactory.createSituation();" + NL);
            stringBuffer.append("\t\t\t// set situationType to AvailableSituation" + NL);
            stringBuffer.append("\t\t\tsituation.setRequestSituation(\"EXTERNAL\", // reasoningScope" + NL);
            stringBuffer.append("\t\t\t\t\t\t\t\t\"\", // situationQualifier" + NL);
            stringBuffer.append("\t\t\t\t\t\t\t\t\"SUCCESSFUL\"); // successDisposition" + NL);
            stringBuffer.append("\t\t\tevent.setSituation(situation);" + NL + NL);
            stringBuffer.append("\t\t\tjavax.resource.cci.Record inputRecord = " + helperClassName + ".findRecord(inputs);" + NL);
            stringBuffer.append("\t\t\tjavax.resource.cci.Record clonedInputRecord = ((javax.resource.cci.Record)inputRecord.clone());" + NL);
            stringBuffer.append("\t\t\tObject businessObject = null;" + NL);
            stringBuffer.append("\t\t\tif (recordName.equals(inputRecord.getClass().getName())) {" + NL);
            stringBuffer.append("\t\t\t\tbusinessObject = inputRecord;" + NL);
            stringBuffer.append("\t\t\t} else {" + NL);
            stringBuffer.append("\t\t\t\tClass recordClass = Class.forName(recordName);" + NL);
            stringBuffer.append("\t\t\t\tObject recordObject = recordClass.newInstance();" + NL);
            stringBuffer.append("\t\t\t\tif (recordObject instanceof commonj.connector.runtime.RecordHolder) {" + NL);
            stringBuffer.append("\t\t\t\t\t((commonj.connector.runtime.RecordHolder) recordObject).setRecord((javax.resource.cci.Record) clonedInputRecord);" + NL);
            stringBuffer.append("\t\t\t\t\tbusinessObject = recordObject;" + NL);
            stringBuffer.append("\t\t\t\t} else {" + NL);
            stringBuffer.append("\t\t\t\t\tthrow new javax.resource.ResourceException(\"Invalid record type was passed: \"" + NL);
            stringBuffer.append("\t\t\t\t\t\t\t\t\t\t+ recordClass.getName()" + NL);
            stringBuffer.append("\t\t\t\t\t\t\t\t\t\t+ \" must implement javax.resource.cci.Record or commonj.connector.runtime.RecordHolder interface.\");" + NL);
            stringBuffer.append("\t\t\t\t}" + NL);
            stringBuffer.append("\t\t\t}" + NL + NL);
            stringBuffer.append("\t\t\t// Add in Business Data" + NL);
            stringBuffer.append("\t\t\tjava.io.ByteArrayOutputStream outputStream = new java.io.ByteArrayOutputStream();" + NL);
            stringBuffer.append("\t\t\tClass recordClass = Class.forName(recordName);" + NL);
            stringBuffer.append("\t\t\tjavax.xml.bind.JAXBContext jaxbCtx = javax.xml.bind.JAXBContext.newInstance(recordClass);" + NL);
            stringBuffer.append("\t\t\tjavax.xml.bind.Marshaller marshaller = jaxbCtx.createMarshaller();" + NL);
            stringBuffer.append("\t\t\tmarshaller.setProperty(javax.xml.bind.Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);" + NL);
            stringBuffer.append("\t\t\tmarshaller.setProperty(javax.xml.bind.Marshaller.JAXB_ENCODING, \"UTF-8\");" + NL);
            stringBuffer.append("\t\t\tmarshaller.marshal(businessObject, outputStream);" + NL);
            stringBuffer.append("\t\t\tString xml = outputStream.toString();" + NL);
            stringBuffer.append("\t\t\tevent.addAny(xml.substring(xml.indexOf(\">\") + 1));" + NL);
            stringBuffer.append("\t\t\teventXMLString = org.eclipse.hyades.logging.events.cbe.util.EventFormatter.toCanonicalXMLDocString(event);" + NL);
            stringBuffer.append("\t\t} catch (Exception e) {" + NL);
            stringBuffer.append("\t\t\tjavax.resource.ResourceException resourceException = new javax.resource.ResourceException();" + NL);
            stringBuffer.append("\t\t\tresourceException.initCause(e);" + NL);
            stringBuffer.append("\t\t\tthrow resourceException;" + NL);
            stringBuffer.append("\t\t}" + NL + NL);
            stringBuffer.append("\t\treturn eventXMLString;" + NL);
            stringBuffer.append("\t}" + NL);
            stringBuffer.append("}" + NL);
            return stringBuffer.toString();
        }
        return null;
    }

    private ICompilationUnit createCompilationUnit(IJavaProject project, String qualifiedClassName, String content) throws CoreException {
        if (project == null || qualifiedClassName == null) {
            return null;
        }
        ICompilationUnit unit = null;
        try {
            IType type = project.findType(qualifiedClassName);
            if (type != null && type.getJavaProject() == project) {
                unit = type.getCompilationUnit();
                unit.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            IPackageFragmentRoot pkgRoot = ProjectUtils.getSourcePackage((IJavaProject)project);
            String packageName = qualifiedClassName.substring(0, qualifiedClassName.lastIndexOf("."));
            String className = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(".") + 1);
            IPackageFragment pkgFragment = pkgRoot.createPackageFragment(packageName, false, null);
            Document document = new Document(content);
            Map options = project.getOptions(true);
            options.put("org.eclipse.jdt.core.formatter.comment.format_javadoc_comments", "true");
            options.put("org.eclipse.jdt.core.formatter.comment.format_header", "false");
            CodeFormatter codeFormatter = ToolFactory.createCodeFormatter((Map)options);
            TextEdit textEdit = codeFormatter.format(8, document.get(), 0, document.get().length(), 0, null);
            if (textEdit != null) {
                textEdit.apply((IDocument)document);
            }
            unit = pkgFragment.createCompilationUnit(String.valueOf(className) + ".java", document.get(), true, (IProgressMonitor)new NullProgressMonitor());
            unit.save((IProgressMonitor)new NullProgressMonitor(), true);
        }
        catch (Exception e) {
            String message = NLS.bind((String)MessageResource.ERR_CANNOT_CREATE_COMPILATION_UNIT, (Object)qualifiedClassName, (Object)project.getProject().getName());
            Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 4, message, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        return unit;
    }

    private void cleanupDeadMarkers() {
        this.cleanupDeadMarkers(TriggerAnnotationsRetriever.getAnnotations((String)"Local"));
        this.cleanupDeadMarkers(TriggerAnnotationsRetriever.getAnnotations((String)"Stateless"));
        this.cleanupDeadMarkers(TriggerAnnotationsRetriever.getAnnotations((String)"MessageDriven"));
        this.cleanupDeadMarkers(TriggerAnnotationsRetriever.getAnnotations((String)"EJB"));
        this.cleanupDeadMarkers(TriggerAnnotationsRetriever.getAnnotations((String)"PostConstruct"));
        this.cleanupDeadMarkers(TriggerAnnotationsRetriever.getAnnotations((String)"PreDestroy"));
    }

    private void cleanupDeadMarkers(List<IAnnotation> inboundAdapterAnnotations) {
        for (IAnnotation annotation : inboundAdapterAnnotations) {
            IJavaElement parent = annotation.getParent();
            IType declaringType = null;
            if (parent instanceof IType) {
                declaringType = (IType)parent;
            } else if (parent instanceof IField) {
                declaringType = ((IField)parent).getDeclaringType();
            } else if (parent instanceof IMethod) {
                declaringType = ((IMethod)parent).getDeclaringType();
            }
            try {
                IMarker[] markers = declaringType.getResource().findMarkers("com.ibm.adapter.j2c.codegen.J2CInboundBeanAnnotationMarker", false, 2);
                if (markers == null) continue;
                IMarker markerForDelete = null;
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    Object target = marker.getAttribute("target");
                    if (annotation.getElementName().equals(target)) {
                        markerForDelete = marker;
                        break;
                    }
                    ++n2;
                }
                if (markerForDelete == null) continue;
                markerForDelete.delete();
            }
            catch (CoreException coreException) {}
        }
    }

    private String getAdapterDisplayName(MessageDrivenTypeMetadata mdbMetaData) {
        IResourceAdapterDescriptor[] raDescriptors;
        String adapterDisplayName = "";
        boolean foundRA = false;
        String activationSpecClassName = mdbMetaData.getActivationSpecClassName();
        IResourceAdapterRegistry raRegistry = RegistryFactory.getFactory().getAPIResourceAdapterRegistry();
        IResourceAdapterDescriptor[] iResourceAdapterDescriptorArray = raDescriptors = raRegistry.getResourceAdaptersReferencedByProject(this.javaProject);
        int n = raDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceAdapterDescriptor.IMessageListenerDescriptor[] messageListeners;
            IResourceAdapterDescriptor raDescriptor = iResourceAdapterDescriptorArray[n2];
            IResourceAdapterDescriptor.IMessageListenerDescriptor[] iMessageListenerDescriptorArray = messageListeners = raDescriptor.getMessageListeners();
            int n3 = messageListeners.length;
            int n4 = 0;
            while (n4 < n3) {
                IResourceAdapterDescriptor.IMessageListenerDescriptor messageListener = iMessageListenerDescriptorArray[n4];
                if (activationSpecClassName.equals(messageListener.getActivationSpecName())) {
                    adapterDisplayName = raDescriptor.getConnector().getDisplayName();
                    foundRA = true;
                    break;
                }
                ++n4;
            }
            if (foundRA) break;
            ++n2;
        }
        return adapterDisplayName;
    }

    private class CommonInboundAdapterMetadata {
        protected String localInterfaceClassName;
        private boolean updated;

        private CommonInboundAdapterMetadata() {
        }

        public String getLocalInterfaceClassName() {
            return this.localInterfaceClassName;
        }

        public void setLocalInterfaceClassName(String localInterfaceClassName) {
            this.localInterfaceClassName = localInterfaceClassName;
        }

        public boolean isUpdated() {
            return this.updated;
        }

        public void setUpdated(boolean updated) {
            this.updated = updated;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (!(object instanceof CommonInboundAdapterMetadata)) {
                return false;
            }
            CommonInboundAdapterMetadata other = (CommonInboundAdapterMetadata)object;
            if (this.localInterfaceClassName == null ^ other.localInterfaceClassName == null) {
                return false;
            }
            return this.localInterfaceClassName == null || this.localInterfaceClassName.equals(other.localInterfaceClassName);
        }
    }

    private class EventEndPointConfigurationTypeMetadata {
        private String namingProviderHostName;
        private String namingProviderPort;
        private String jmsConnectionFactoryJNDIName;
        private String jmsDestinationJNDIName;
        private String jmsConnectionAuthenticationClientName;
        private String jmsConnectionAuthenticationClientPassword;
        private boolean monitor;

        private EventEndPointConfigurationTypeMetadata() {
        }

        public String getNamingProviderHostName() {
            return this.namingProviderHostName;
        }

        public void setNamingProviderHostName(String namingProviderHostName) {
            this.namingProviderHostName = namingProviderHostName;
        }

        public String getNamingProviderPort() {
            return this.namingProviderPort;
        }

        public void setNamingProviderPort(String namingProviderPort) {
            this.namingProviderPort = namingProviderPort;
        }

        public String getJmsConnectionFactoryJNDIName() {
            return this.jmsConnectionFactoryJNDIName;
        }

        public void setJmsConnectionFactoryJNDIName(String jmsConnectionFactoryJNDIName) {
            this.jmsConnectionFactoryJNDIName = jmsConnectionFactoryJNDIName;
        }

        public String getJmsDestinationJNDIName() {
            return this.jmsDestinationJNDIName;
        }

        public void setJmsDestinationJNDIName(String jmsDestinationJNDIName) {
            this.jmsDestinationJNDIName = jmsDestinationJNDIName;
        }

        public String getJmsConnectionAuthenticationClientName() {
            return this.jmsConnectionAuthenticationClientName;
        }

        public void setJmsConnectionAuthenticationClientName(String jmsConnectionAuthenticationClientName) {
            this.jmsConnectionAuthenticationClientName = jmsConnectionAuthenticationClientName;
        }

        public String getJmsConnectionAuthenticationClientPassword() {
            return this.jmsConnectionAuthenticationClientPassword;
        }

        public void setJmsConnectionAuthenticationClientPassword(String jmsConnectionAuthenticationClientPassword) {
            this.jmsConnectionAuthenticationClientPassword = jmsConnectionAuthenticationClientPassword;
        }

        public boolean getMonitor() {
            return this.monitor;
        }

        public void setMonitor(boolean monitor) {
            this.monitor = monitor;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (!(object instanceof EventEndPointConfigurationTypeMetadata)) {
                return false;
            }
            EventEndPointConfigurationTypeMetadata other = (EventEndPointConfigurationTypeMetadata)object;
            if (this.namingProviderHostName == null ^ other.namingProviderHostName == null) {
                return false;
            }
            if (this.namingProviderHostName != null && !this.namingProviderHostName.equals(other.namingProviderHostName)) {
                return false;
            }
            if (this.namingProviderPort == null ^ other.namingProviderPort == null) {
                return false;
            }
            if (this.namingProviderPort != null && !this.namingProviderPort.equals(other.namingProviderPort)) {
                return false;
            }
            if (this.jmsConnectionFactoryJNDIName == null ^ other.jmsConnectionFactoryJNDIName == null) {
                return false;
            }
            if (this.jmsConnectionFactoryJNDIName != null && !this.jmsConnectionFactoryJNDIName.equals(other.jmsConnectionFactoryJNDIName)) {
                return false;
            }
            if (this.jmsDestinationJNDIName == null ^ other.jmsDestinationJNDIName == null) {
                return false;
            }
            if (this.jmsDestinationJNDIName != null && !this.jmsDestinationJNDIName.equals(other.jmsDestinationJNDIName)) {
                return false;
            }
            if (this.jmsConnectionAuthenticationClientName == null ^ other.jmsConnectionAuthenticationClientName == null) {
                return false;
            }
            if (this.jmsConnectionAuthenticationClientName != null && !this.jmsConnectionAuthenticationClientName.equals(other.jmsConnectionAuthenticationClientName)) {
                return false;
            }
            if (this.jmsConnectionAuthenticationClientPassword == null ^ other.jmsConnectionAuthenticationClientPassword == null) {
                return false;
            }
            if (this.jmsConnectionAuthenticationClientPassword != null && !this.jmsConnectionAuthenticationClientPassword.equals(other.jmsConnectionAuthenticationClientPassword)) {
                return false;
            }
            return this.monitor == other.monitor;
        }

        public int hashCode() {
            int hashCode = this.jmsConnectionFactoryJNDIName.hashCode() + this.jmsDestinationJNDIName.hashCode();
            return hashCode;
        }
    }

    private class EventTypeMetadata {
        private Map<String, String> eventNameTable = new HashMap<String, String>();

        private EventTypeMetadata() {
        }

        public Set<Map.Entry<String, String>> getEventNameEntries() {
            return this.eventNameTable.entrySet();
        }

        public String getEventName(String methodName) {
            return this.eventNameTable.get(methodName);
        }

        public void addEventName(String methodName, String eventName) {
            this.eventNameTable.put(methodName, eventName);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (!(object instanceof EventTypeMetadata)) {
                return false;
            }
            EventTypeMetadata other = (EventTypeMetadata)object;
            boolean equals = this.eventNameTable.entrySet().equals(other.getEventNameEntries());
            return equals;
        }

        public int hashCode() {
            return this.eventNameTable.hashCode();
        }
    }

    private class InboundAdapterArtifactsGenerationModel {
        private MessageDrivenTypeMetadata messageDrivenTypeMetadata;
        private StatelessTypeMetadata statelessTypeMetadata;

        private InboundAdapterArtifactsGenerationModel() {
        }

        public MessageDrivenTypeMetadata getMessageDrivenTypeMetadata() {
            return this.messageDrivenTypeMetadata;
        }

        public void setMessageDrivenTypeMetadata(MessageDrivenTypeMetadata messageDrivenTypeMetadata) {
            this.messageDrivenTypeMetadata = messageDrivenTypeMetadata;
        }

        public StatelessTypeMetadata getStatelessTypeMetadata() {
            return this.statelessTypeMetadata;
        }

        public void setStatelessTypeMetadata(StatelessTypeMetadata statelessTypeMetadata) {
            this.statelessTypeMetadata = statelessTypeMetadata;
        }

        public boolean updated() {
            return this.messageDrivenTypeMetadata.isUpdated() || this.statelessTypeMetadata.isUpdated();
        }
    }

    private class MessageDrivenTypeMetadata
    extends CommonInboundAdapterMetadata {
        private String messageDrivenBeanClassName;
        private String functionSelectorClassName;
        private String activationSpecClassName;
        private String activationSpecJNDIName;
        private String authenticationAlias;
        private EventEndPointConfigurationTypeMetadata eventEndPointConfigurationTypeMetadata;
        private IJavaProject project;

        public MessageDrivenTypeMetadata(IJavaProject aProject) {
            this.project = aProject;
        }

        public String getKey() {
            StringBuffer sb = new StringBuffer(this.project.getProject().getName());
            sb.append("::");
            sb.append(this.messageDrivenBeanClassName);
            return sb.toString();
        }

        public boolean hasCompleteMetadata() {
            return this.messageDrivenBeanClassName != null && this.functionSelectorClassName != null && this.localInterfaceClassName != null && this.activationSpecClassName != null && this.activationSpecJNDIName != null;
        }

        public String getMessageDrivenBeanClassName() {
            return this.messageDrivenBeanClassName;
        }

        public void setMessageDrivenBeanClassName(String messageDrivenBeanClassName) {
            this.messageDrivenBeanClassName = messageDrivenBeanClassName;
        }

        public String getFunctionSelectorClassName() {
            return this.functionSelectorClassName;
        }

        public void setFunctionSelectorClassName(String functionSelectorClassName) {
            this.functionSelectorClassName = functionSelectorClassName;
        }

        public String getActivationSpecClassName() {
            return this.activationSpecClassName;
        }

        public void setActivationSpecClassName(String activationSpecClassName) {
            this.activationSpecClassName = activationSpecClassName;
        }

        public String getActivationSpecJNDIName() {
            return this.activationSpecJNDIName;
        }

        public void setActivationSpecJNDIName(String activationSpecJNDIName) {
            this.activationSpecJNDIName = activationSpecJNDIName;
        }

        public String getAuthenticationAlias() {
            return this.authenticationAlias;
        }

        public void setAuthenticationAlias(String authenticationAlias) {
            this.authenticationAlias = authenticationAlias;
        }

        public EventEndPointConfigurationTypeMetadata getEventEndPointConfigurationTypeMetadata() {
            return this.eventEndPointConfigurationTypeMetadata;
        }

        public void setEventEndPointConfigurationTypeMetadata(EventEndPointConfigurationTypeMetadata eventEndPointConfigurationTypeMetadata) {
            this.eventEndPointConfigurationTypeMetadata = eventEndPointConfigurationTypeMetadata;
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (!(object instanceof MessageDrivenTypeMetadata)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            MessageDrivenTypeMetadata other = (MessageDrivenTypeMetadata)object;
            if (this.project == null ^ other.project == null) {
                return false;
            }
            if (this.project != null && !this.project.equals(other.project)) {
                return false;
            }
            if (this.messageDrivenBeanClassName == null ^ other.messageDrivenBeanClassName == null) {
                return false;
            }
            if (this.messageDrivenBeanClassName != null && !this.messageDrivenBeanClassName.equals(other.messageDrivenBeanClassName)) {
                return false;
            }
            if (this.functionSelectorClassName == null ^ other.functionSelectorClassName == null) {
                return false;
            }
            if (this.functionSelectorClassName != null && !this.functionSelectorClassName.equals(other.functionSelectorClassName)) {
                return false;
            }
            if (this.activationSpecClassName == null ^ other.activationSpecClassName == null) {
                return false;
            }
            if (this.activationSpecClassName != null && !this.activationSpecClassName.equals(other.activationSpecClassName)) {
                return false;
            }
            if (this.activationSpecJNDIName == null ^ other.activationSpecJNDIName == null) {
                return false;
            }
            if (this.activationSpecJNDIName != null && !this.activationSpecJNDIName.equals(other.activationSpecJNDIName)) {
                return false;
            }
            if (this.authenticationAlias == null ^ other.authenticationAlias == null) {
                return false;
            }
            if (this.authenticationAlias != null && !this.authenticationAlias.equals(other.authenticationAlias)) {
                return false;
            }
            if (this.eventEndPointConfigurationTypeMetadata == null ^ other.eventEndPointConfigurationTypeMetadata == null) {
                return false;
            }
            return this.eventEndPointConfigurationTypeMetadata == null || this.eventEndPointConfigurationTypeMetadata.equals(other.eventEndPointConfigurationTypeMetadata);
        }

        public int hashCode() {
            int hashCode = this.localInterfaceClassName.hashCode() + this.messageDrivenBeanClassName.hashCode() + this.functionSelectorClassName.hashCode() + this.activationSpecClassName.hashCode() + this.activationSpecJNDIName.hashCode();
            return hashCode;
        }

        public void setProject(IJavaProject aProject) {
            this.project = aProject;
        }

        public IJavaProject getProject() {
            return this.project;
        }
    }

    private class StatelessTypeMetadata
    extends CommonInboundAdapterMetadata {
        private String statelessSessionBeanClassName;
        private Map<String, String> methodNameTable = new HashMap<String, String>();
        private Map<String, String> inputDataTable = new HashMap<String, String>();
        private Map<String, String> outputDataTable = new HashMap<String, String>();
        private EventTypeMetadata eventTypeMetadata;
        private IJavaProject project;

        public StatelessTypeMetadata(IJavaProject aProject) {
            this.project = aProject;
        }

        public String getKey() {
            StringBuffer sb = new StringBuffer(this.project.getProject().getName());
            sb.append("::");
            sb.append(this.statelessSessionBeanClassName);
            return sb.toString();
        }

        public boolean hasCompleteMetadata() {
            return this.localInterfaceClassName != null && !this.methodNameTable.isEmpty();
        }

        public void addMethodEntry(String nativeMethod, String method) {
            this.methodNameTable.put(nativeMethod, method);
        }

        public Set<Map.Entry<String, String>> getMethodNameEntries() {
            return this.methodNameTable.entrySet();
        }

        public void addInputRecordEntry(String method, String inputRecord) {
            this.inputDataTable.put(method, inputRecord);
        }

        public Set<Map.Entry<String, String>> getInputDataEntries() {
            return this.inputDataTable.entrySet();
        }

        public void addOutputRecordEntry(String method, String outputRecord) {
            this.outputDataTable.put(method, outputRecord);
        }

        public Set<Map.Entry<String, String>> getOutputDataEntries() {
            return this.outputDataTable.entrySet();
        }

        public String getStatelessSessionBeanClassName() {
            return this.statelessSessionBeanClassName;
        }

        public void setStatelessSessionBeanClassName(String statelessSessionBeanClassName) {
            this.statelessSessionBeanClassName = statelessSessionBeanClassName;
        }

        public EventTypeMetadata getEventTypeMetadata() {
            return this.eventTypeMetadata;
        }

        public void setEventTypeMetadata(EventTypeMetadata eventTypeMetadata) {
            this.eventTypeMetadata = eventTypeMetadata;
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (!(object instanceof StatelessTypeMetadata)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            StatelessTypeMetadata other = (StatelessTypeMetadata)object;
            if (this.project == null ^ other.project == null) {
                return false;
            }
            if (this.project != null && !this.project.equals(other.project)) {
                return false;
            }
            if (this.statelessSessionBeanClassName == null ^ other.statelessSessionBeanClassName == null) {
                return false;
            }
            if (this.statelessSessionBeanClassName != null && !this.statelessSessionBeanClassName.equals(other.statelessSessionBeanClassName)) {
                return false;
            }
            if (this.methodNameTable == null ^ other.methodNameTable == null) {
                return false;
            }
            if (this.methodNameTable != null && !this.methodNameTable.entrySet().equals(other.methodNameTable.entrySet())) {
                return false;
            }
            if (this.inputDataTable == null ^ other.inputDataTable == null) {
                return false;
            }
            if (this.inputDataTable != null && !this.inputDataTable.entrySet().equals(other.inputDataTable.entrySet())) {
                return false;
            }
            if (this.outputDataTable == null ^ other.outputDataTable == null) {
                return false;
            }
            if (this.outputDataTable != null && !this.outputDataTable.entrySet().equals(other.outputDataTable.entrySet())) {
                return false;
            }
            if (this.eventTypeMetadata == null ^ other.eventTypeMetadata == null) {
                return false;
            }
            return this.eventTypeMetadata == null || this.eventTypeMetadata.equals(other.eventTypeMetadata);
        }

        public int hashCode() {
            int hashCode = this.localInterfaceClassName.hashCode() + this.statelessSessionBeanClassName.hashCode() + this.methodNameTable.hashCode() + this.inputDataTable.hashCode() + this.outputDataTable.hashCode();
            return hashCode;
        }

        public void setProject(IJavaProject aProject) {
            this.project = aProject;
        }

        public IJavaProject getProject() {
            return this.project;
        }
    }
}

