/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2c.internal.codegen.inbound;

import com.ibm.adapter.emd.extension.description.J2CServiceDescription;
import com.ibm.adapter.j2c.internal.CodegenPlugin;
import com.ibm.adapter.j2c.internal.MessageResource;
import com.ibm.adapter.j2c.internal.codegen.util.BaseGenerator;
import com.ibm.adapter.j2c.internal.codegen.util.NewTypeGeneratorBean;
import com.ibm.adapter.j2c.internal.codegen.util.ParamType;
import commonj.connector.metadata.description.FunctionDescription;
import commonj.connector.metadata.description.InboundFunctionDescription;
import commonj.connector.metadata.description.InboundServiceDescription;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;

public class InboundAdapterPatternGenerator
extends NewTypeGeneratorBean {
    private J2CServiceDescription serviceDescriptionWrapper;
    private String localInterfaceName;
    private Map<String, String> functionMap = new HashMap<String, String>();
    private AST ast;

    public void setServiceDescriptionWrapper(J2CServiceDescription serviceDescriptionWrapper) {
        this.serviceDescriptionWrapper = serviceDescriptionWrapper;
    }

    public void setLocalInterfaceName(String localInterfaceName) {
        this.localInterfaceName = localInterfaceName;
    }

    public void setFunctionMap(Map<String, String> functionMap) {
        this.functionMap = functionMap;
    }

    @Override
    protected void generate(IProgressMonitor monitor, CompilationUnit astCompilationUnit) throws JavaModelException {
        NormalAnnotation generatedAnnotation;
        super.generate(monitor, astCompilationUnit);
        this.ast = astCompilationUnit.getAST();
        this.backingTypeModel.modifiers().clear();
        if (this.getImportStatements().length == 1 && Arrays.asList(this.getImportStatements()).contains("javax.annotation.Generated")) {
            generatedAnnotation = this.generateGeneratedAnnotation(this.ast, MessageResource.GENERATED_ANNOTATION_COMMENT);
            this.addTypeAnnotation((Annotation)generatedAnnotation);
            InboundAdapterPatternGenerator.generateAnnotations(monitor, (BodyDeclaration)this.backingTypeModel, this.getTypeAnnotations());
            this.backingTypeModel.modifiers().add(this.ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        }
        if (Arrays.asList(this.getImportStatements()).contains("javax.ejb.Local") && Arrays.asList(this.getImportStatements()).contains("javax.ejb.Stateless")) {
            generatedAnnotation = this.generateGeneratedAnnotation(this.ast, MessageResource.GENERATED_ANNOTATION_COMMENT_STATELESS);
            this.addTypeAnnotation((Annotation)generatedAnnotation);
            SingleMemberAnnotation localAnnotation = this.generateLocalAnnotation(this.ast);
            this.addTypeAnnotation((Annotation)localAnnotation);
            MarkerAnnotation statelessAnnotation = this.ast.newMarkerAnnotation();
            statelessAnnotation.setTypeName((Name)this.ast.newSimpleName("Stateless"));
            this.addTypeAnnotation((Annotation)statelessAnnotation);
            InboundAdapterPatternGenerator.generateAnnotations(monitor, (BodyDeclaration)this.backingTypeModel, this.getTypeAnnotations());
            this.backingTypeModel.modifiers().add(this.ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
            InboundServiceDescription serviceDescription = (InboundServiceDescription)this.serviceDescriptionWrapper.getServiceDescription();
            final HashMap<String, String> nativeMethodLookup = new HashMap<String, String>();
            List<FunctionDescription> methodDefinitions = Arrays.asList(serviceDescription.getFunctionDescriptions());
            for (InboundFunctionDescription inboundFunctionDescription : methodDefinitions) {
                String functionName = inboundFunctionDescription.getName();
                String methodName = this.functionMap.get(functionName);
                String nativeMethodName = inboundFunctionDescription.getEISFunctionName();
                nativeMethodLookup.put(methodName, nativeMethodName);
            }
            ASTVisitor methodVisitor = new ASTVisitor(){

                public boolean visit(MethodDeclaration node) {
                    super.visit(node);
                    String methodName = node.getName().getFullyQualifiedName();
                    if (nativeMethodLookup.containsKey(methodName)) {
                        node.modifiers().clear();
                        J2CServiceDescription.InboundEventDescription inboundEvent = InboundAdapterPatternGenerator.this.serviceDescriptionWrapper.getInboundEventDescription();
                        if (inboundEvent != null) {
                            NormalAnnotation eventAnnotation = InboundAdapterPatternGenerator.this.generateEventAnnotation(InboundAdapterPatternGenerator.this.ast, methodName);
                            Annotation copiedNode = (Annotation)ASTNode.copySubtree((AST)node.getAST(), (ASTNode)eventAnnotation);
                            node.modifiers().add(copiedNode);
                        }
                        String nativeMethodName = (String)nativeMethodLookup.get(methodName);
                        NormalAnnotation methodAnnotation = InboundAdapterPatternGenerator.this.generateInboundMethodBindingAnnotation(InboundAdapterPatternGenerator.this.ast, nativeMethodName);
                        Annotation copiedNode = (Annotation)ASTNode.copySubtree((AST)node.getAST(), (ASTNode)methodAnnotation);
                        node.modifiers().add(copiedNode);
                        node.modifiers().add(InboundAdapterPatternGenerator.this.ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
                    }
                    return false;
                }
            };
            this.backingTypeModel.accept(methodVisitor);
        }
        if (Arrays.asList(this.getImportStatements()).contains("javax.ejb.MessageDriven") && Arrays.asList(this.getImportStatements()).contains("com.ibm.adapter.j2c.inbound.annotations.InboundAdapter")) {
            generatedAnnotation = this.generateGeneratedAnnotation(this.ast, MessageResource.GENERATED_ANNOTATION_COMMENT);
            this.addTypeAnnotation((Annotation)generatedAnnotation);
            J2CServiceDescription.InboundEventDescription inboundEvent = this.serviceDescriptionWrapper.getInboundEventDescription();
            if (inboundEvent != null) {
                NormalAnnotation eventMonitorConfigAnnotation = this.generateEventEndPointConfigAnnotation(this.ast, inboundEvent);
                this.addTypeAnnotation((Annotation)eventMonitorConfigAnnotation);
            }
            NormalAnnotation inboundAdapterAnnotation = this.generateInboundAdapterAnnotation(this.ast, this.serviceDescriptionWrapper);
            this.addTypeAnnotation((Annotation)inboundAdapterAnnotation);
            MarkerAnnotation messageDrivenAnnotation = this.ast.newMarkerAnnotation();
            messageDrivenAnnotation.setTypeName((Name)this.ast.newSimpleName("MessageDriven"));
            this.addTypeAnnotation((Annotation)messageDrivenAnnotation);
            InboundAdapterPatternGenerator.generateAnnotations(monitor, (BodyDeclaration)this.backingTypeModel, this.getTypeAnnotations());
            this.backingTypeModel.modifiers().add(this.ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
            String localInterfaceFieldName = null;
            localInterfaceFieldName = this.localInterfaceName.length() > 1 ? String.valueOf(this.localInterfaceName.substring(0, 1).toLowerCase()) + this.localInterfaceName.substring(1) : this.localInterfaceName.toLowerCase();
            this.addField("@EJB private " + this.localInterfaceName + " " + localInterfaceFieldName);
            this.addField("private javax.ejb.MessageDrivenContext messageDrivenCtx");
            InboundAdapterPatternGenerator.generateFields(monitor, this.backingTypeModel, this.getFields());
            this.generateMessageDrivenEJBMethod(null, this.ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD), new ParamType(ParamType.VOID), "setMessageDrivenContext", new ParamType[]{new ParamType("javax.ejb.MessageDrivenContext")}, new String[]{"ctx"}, "javax.ejb.EJBException", "\t\tmessageDrivenCtx = ctx;\n");
            this.generateMessageDrivenEJBMethod(null, this.ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD), new ParamType("javax.ejb.MessageDrivenContext"), "getMessageDrivenContext", null, null, null, "\t\treturn messageDrivenCtx;\n");
            MarkerAnnotation initializeAnnotation = this.ast.newMarkerAnnotation();
            initializeAnnotation.setTypeName((Name)this.ast.newSimpleName("PostConstruct"));
            this.generateMessageDrivenEJBMethod(new Annotation[]{initializeAnnotation}, this.ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD), new ParamType(ParamType.VOID), "initialize", null, null, null, "\t\t" + this.getClassName() + "Helper.initialize();\n");
            MarkerAnnotation cleanupAnnotation = this.ast.newMarkerAnnotation();
            cleanupAnnotation.setTypeName((Name)this.ast.newSimpleName("PreDestroy"));
            this.generateMessageDrivenEJBMethod(new Annotation[]{cleanupAnnotation}, this.ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD), new ParamType(ParamType.VOID), "cleanup", null, null, null, "\t\t" + this.getClassName() + "Helper.cleanup();\n");
            IType[] iTypeArray = this.interfaceTypes;
            int n = this.interfaceTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType iType = iTypeArray[n2];
                if (iType != null && iType.isBinary()) {
                    boolean isInboundAdapter = false;
                    List modifiers = this.backingTypeModel.modifiers();
                    if (!modifiers.isEmpty()) {
                        for (IExtendedModifier modifier : modifiers) {
                            Annotation annotation;
                            if (!modifier.isAnnotation() || !"InboundAdapter".equals((annotation = (Annotation)modifier).getTypeName().getFullyQualifiedName())) continue;
                            isInboundAdapter = true;
                            break;
                        }
                    }
                    IMethod[] methods = iType.getMethods();
                    int i = 0;
                    while (i < methods.length) {
                        MethodDeclaration methodDeclaration = this.ast.newMethodDeclaration();
                        if (inboundEvent != null) {
                            SingleMemberAnnotation interceptorAnnotation = this.generateMethodLevelInterceptorsAnnotation(this.ast);
                            Annotation copiedNode = (Annotation)ASTNode.copySubtree((AST)this.ast, (ASTNode)interceptorAnnotation);
                            methodDeclaration.modifiers().add(copiedNode);
                        }
                        methodDeclaration.modifiers().add(this.ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
                        IMethod method = methods[i];
                        methodDeclaration.setName(this.ast.newSimpleName(method.getElementName()));
                        String[] parameterNames = method.getParameterNames();
                        String[] parameterTypes = method.getParameterTypes();
                        int j = 0;
                        while (j < parameterNames.length) {
                            SingleVariableDeclaration parameter = this.ast.newSingleVariableDeclaration();
                            parameter.setName(this.ast.newSimpleName(parameterNames[j]));
                            String parameterType = Signature.toString((String)parameterTypes[j]);
                            parameter.setType((Type)this.ast.newSimpleType(InboundAdapterPatternGenerator.deriveASTName(this.ast, parameterType)));
                            methodDeclaration.parameters().add(parameter);
                            ++j;
                        }
                        String returnType = Signature.toString((String)method.getReturnType());
                        if ("void".equals(returnType)) {
                            methodDeclaration.setReturnType2((Type)this.ast.newPrimitiveType(PrimitiveType.VOID));
                        } else {
                            SimpleType returnType2 = this.ast.newSimpleType(InboundAdapterPatternGenerator.deriveASTName(this.ast, returnType));
                            methodDeclaration.setReturnType2((Type)returnType2);
                        }
                        String[] exceptionTypes = method.getExceptionTypes();
                        int j2 = 0;
                        while (j2 < exceptionTypes.length) {
                            String exceptionType = Signature.toString((String)exceptionTypes[j2]);
                            Name exception = InboundAdapterPatternGenerator.deriveASTName(this.ast, exceptionType);
                            methodDeclaration.thrownExceptions().add(exception);
                            ++j2;
                        }
                        if (isInboundAdapter) {
                            InboundAdapterPatternGenerator.generateMethodBody(methodDeclaration, this.generateMDBListenerMethodBody(parameterNames, parameterTypes, returnType, localInterfaceFieldName));
                        } else {
                            InboundAdapterPatternGenerator.generateMethodBody(methodDeclaration, InboundAdapterPatternGenerator.generateDefaultBody(methodDeclaration));
                        }
                        this.backingTypeModel.bodyDeclarations().add(methodDeclaration);
                        ++i;
                    }
                }
                ++n2;
            }
        }
    }

    private void generateMessageDrivenEJBMethod(Annotation[] annotations, Modifier modifier, ParamType returnType, String methodName, ParamType[] parameterTypes, String[] parameterNames, String thrownException, String body) {
        MethodDeclaration methodDec = this.ast.newMethodDeclaration();
        if (annotations != null) {
            Annotation[] annotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                Annotation copiedNode = (Annotation)ASTNode.copySubtree((AST)this.ast, (ASTNode)annotation);
                methodDec.modifiers().add(copiedNode);
                ++n2;
            }
        }
        methodDec.modifiers().add(modifier);
        methodDec.setReturnType2(returnType.createType(this.ast));
        methodDec.setName((SimpleName)InboundAdapterPatternGenerator.deriveASTName(this.ast, methodName));
        if (parameterTypes != null) {
            int i = 0;
            while (i < parameterTypes.length) {
                SingleVariableDeclaration svd = this.ast.newSingleVariableDeclaration();
                svd.setType(parameterTypes[i].createType(this.ast));
                if (parameterNames != null) {
                    svd.setName((SimpleName)InboundAdapterPatternGenerator.deriveASTName(this.ast, parameterNames[i]));
                } else {
                    svd.setName((SimpleName)InboundAdapterPatternGenerator.deriveASTName(this.ast, "arg" + i));
                }
                methodDec.parameters().add(svd);
                ++i;
            }
        }
        if (thrownException != null) {
            Name exceptionName = InboundAdapterPatternGenerator.deriveASTName(this.ast, thrownException);
            methodDec.thrownExceptions().add(exceptionName);
        }
        InboundAdapterPatternGenerator.generateMethodBody(methodDec, body);
        this.backingTypeModel.bodyDeclarations().add(methodDec);
    }

    private NormalAnnotation generateGeneratedAnnotation(AST ast, String comment) {
        NormalAnnotation generatedAnnotation = ast.newNormalAnnotation();
        generatedAnnotation.setTypeName((Name)ast.newSimpleName("Generated"));
        MemberValuePair commentsMember = ast.newMemberValuePair();
        commentsMember.setName(ast.newSimpleName("comments"));
        StringLiteral comments = ast.newStringLiteral();
        comments.setLiteralValue(comment);
        commentsMember.setValue((Expression)comments);
        generatedAnnotation.values().add(commentsMember);
        MemberValuePair dateMember = ast.newMemberValuePair();
        dateMember.setName(ast.newSimpleName("date"));
        StringLiteral date = ast.newStringLiteral();
        Date time = Calendar.getInstance().getTime();
        String dateFormat = DateFormat.getDateTimeInstance(0, 0).format(time);
        date.setLiteralValue(dateFormat);
        dateMember.setValue((Expression)date);
        generatedAnnotation.values().add(dateMember);
        MemberValuePair valueMember = ast.newMemberValuePair();
        valueMember.setName(ast.newSimpleName("value"));
        ArrayInitializer arrayInit = ast.newArrayInitializer();
        StringLiteral codegenName = ast.newStringLiteral();
        codegenName.setLiteralValue(MessageResource.GENERATED_ANNOTATION_VALUE);
        arrayInit.expressions().add(codegenName);
        valueMember.setValue((Expression)arrayInit);
        generatedAnnotation.values().add(valueMember);
        return generatedAnnotation;
    }

    private NormalAnnotation generateInboundMethodBindingAnnotation(AST ast, String nativeMethodName) {
        NormalAnnotation inboundMethodBindingAnnotation = ast.newNormalAnnotation();
        inboundMethodBindingAnnotation.setTypeName((Name)ast.newSimpleName("InboundMethodBinding"));
        MemberValuePair nativeMethodMember = ast.newMemberValuePair();
        nativeMethodMember.setName(ast.newSimpleName("nativeMethod"));
        StringLiteral nativeMethod = ast.newStringLiteral();
        nativeMethod.setLiteralValue(nativeMethodName);
        nativeMethodMember.setValue((Expression)nativeMethod);
        inboundMethodBindingAnnotation.values().add(nativeMethodMember);
        return inboundMethodBindingAnnotation;
    }

    private NormalAnnotation generateEventAnnotation(AST ast, String methodName) {
        NormalAnnotation eventAnnotation = ast.newNormalAnnotation();
        eventAnnotation.setTypeName((Name)ast.newSimpleName("Event"));
        MemberValuePair eventNameMember = ast.newMemberValuePair();
        eventNameMember.setName(ast.newSimpleName("name"));
        StringLiteral eventNameValue = ast.newStringLiteral();
        eventNameValue.setLiteralValue(methodName);
        eventNameMember.setValue((Expression)eventNameValue);
        eventAnnotation.values().add(eventNameMember);
        return eventAnnotation;
    }

    private SingleMemberAnnotation generateLocalAnnotation(AST ast) {
        SingleMemberAnnotation localAnnotation = ast.newSingleMemberAnnotation();
        localAnnotation.setTypeName((Name)ast.newSimpleName("Local"));
        TypeLiteral localInterfaceClass = ast.newTypeLiteral();
        SimpleType localInterfaceType = ast.newSimpleType(BaseGenerator.deriveASTName(ast, this.getInterfaces()[0]));
        localInterfaceClass.setType((Type)localInterfaceType);
        localAnnotation.setValue((Expression)localInterfaceClass);
        return localAnnotation;
    }

    private SingleMemberAnnotation generateMethodLevelInterceptorsAnnotation(AST ast) {
        SingleMemberAnnotation interceptorsAnnotation = ast.newSingleMemberAnnotation();
        interceptorsAnnotation.setTypeName((Name)ast.newSimpleName("Interceptors"));
        TypeLiteral interceptorClass = ast.newTypeLiteral();
        SimpleType interceptorType = ast.newSimpleType(BaseGenerator.deriveASTName(ast, String.valueOf(this.getClassName()) + "EventInterceptor"));
        interceptorClass.setType((Type)interceptorType);
        ArrayInitializer arrayInit = ast.newArrayInitializer();
        arrayInit.expressions().add(interceptorClass);
        interceptorsAnnotation.setValue((Expression)arrayInit);
        return interceptorsAnnotation;
    }

    private NormalAnnotation generateInboundAdapterAnnotation(AST ast, J2CServiceDescription serviceDescriptionWrapper) {
        InboundServiceDescription serviceDescription = (InboundServiceDescription)serviceDescriptionWrapper.getServiceDescription();
        NormalAnnotation activationSpecAnnotation = ast.newNormalAnnotation();
        activationSpecAnnotation.setTypeName((Name)ast.newSimpleName("ActivationSpecification"));
        MemberValuePair activationSpecClassMember = ast.newMemberValuePair();
        activationSpecClassMember.setName(ast.newSimpleName("activationSpecClass"));
        TypeLiteral activationSpecClass = ast.newTypeLiteral();
        String activationSpecClassName = serviceDescription.getInboundConnectionAdvancedConfiguration().getInboundConnectionType().createInboundConnectionBeans().getActivationSpecJavaBean().getClass().getName();
        SimpleType activationSpecType = ast.newSimpleType(BaseGenerator.deriveASTName(ast, activationSpecClassName));
        activationSpecClass.setType((Type)activationSpecType);
        activationSpecClassMember.setValue((Expression)activationSpecClass);
        activationSpecAnnotation.values().add(activationSpecClassMember);
        MemberValuePair jndiNameMember = ast.newMemberValuePair();
        jndiNameMember.setName(ast.newSimpleName("jndiName"));
        StringLiteral jndiName = ast.newStringLiteral();
        jndiName.setLiteralValue(serviceDescriptionWrapper.getJNDILookupName());
        jndiNameMember.setValue((Expression)jndiName);
        activationSpecAnnotation.values().add(jndiNameMember);
        String jaasAlias = serviceDescriptionWrapper.getJAASAlias();
        if (jaasAlias != null && !"".equals(jaasAlias)) {
            MemberValuePair jaasAliasMember = ast.newMemberValuePair();
            jaasAliasMember.setName(ast.newSimpleName("authenticationAlias"));
            StringLiteral authenticationAlias = ast.newStringLiteral();
            authenticationAlias.setLiteralValue(jaasAlias);
            jaasAliasMember.setValue((Expression)authenticationAlias);
            activationSpecAnnotation.values().add(jaasAliasMember);
        }
        NormalAnnotation inboundAdapterAnnotation = ast.newNormalAnnotation();
        inboundAdapterAnnotation.setTypeName((Name)ast.newSimpleName("InboundAdapter"));
        MemberValuePair activationSpecMember = ast.newMemberValuePair();
        activationSpecMember.setName(ast.newSimpleName("activationSpec"));
        activationSpecMember.setValue((Expression)activationSpecAnnotation);
        inboundAdapterAnnotation.values().add(activationSpecMember);
        MemberValuePair functionSelectorClassMember = ast.newMemberValuePair();
        functionSelectorClassMember.setName(ast.newSimpleName("functionSelectorClass"));
        TypeLiteral functionSelectorClass = ast.newTypeLiteral();
        String functionSelectorClassName = serviceDescription.getFunctionSelectorClassName();
        SimpleType functionSelectorType = ast.newSimpleType(BaseGenerator.deriveASTName(ast, functionSelectorClassName));
        functionSelectorClass.setType((Type)functionSelectorType);
        functionSelectorClassMember.setValue((Expression)functionSelectorClass);
        inboundAdapterAnnotation.values().add(functionSelectorClassMember);
        return inboundAdapterAnnotation;
    }

    private NormalAnnotation generateEventEndPointConfigAnnotation(AST ast, J2CServiceDescription.InboundEventDescription inboundEvent) {
        J2CServiceDescription.InboundEventDescription.JMSConnectionAuthentication jmsConnectionAuthentication;
        NormalAnnotation eventMonitorConfigAnnotation = ast.newNormalAnnotation();
        eventMonitorConfigAnnotation.setTypeName((Name)ast.newSimpleName("EventEndPointConfiguration"));
        J2CServiceDescription.InboundEventDescription.JMSAdminObjects jmsAdminObjects = inboundEvent.getJMSAdminObjects();
        MemberValuePair jmsConnectionFactoryJNDINameMember = ast.newMemberValuePair();
        jmsConnectionFactoryJNDINameMember.setName(ast.newSimpleName("jmsConnectionFactoryJNDIName"));
        StringLiteral jmsConnectionFactoryJNDIName = ast.newStringLiteral();
        jmsConnectionFactoryJNDIName.setLiteralValue(jmsAdminObjects.getConnectionFactoryJNDIName());
        jmsConnectionFactoryJNDINameMember.setValue((Expression)jmsConnectionFactoryJNDIName);
        eventMonitorConfigAnnotation.values().add(jmsConnectionFactoryJNDINameMember);
        MemberValuePair jmsDestinationJNDINameMember = ast.newMemberValuePair();
        jmsDestinationJNDINameMember.setName(ast.newSimpleName("jmsDestinationJNDIName"));
        StringLiteral jmsDestinationJNDIName = ast.newStringLiteral();
        jmsDestinationJNDIName.setLiteralValue(jmsAdminObjects.getDestinationJNDIName());
        jmsDestinationJNDINameMember.setValue((Expression)jmsDestinationJNDIName);
        eventMonitorConfigAnnotation.values().add(jmsDestinationJNDINameMember);
        J2CServiceDescription.InboundEventDescription.NamingProviderURL namingProviderURL = inboundEvent.getNamingProviderURL();
        if (namingProviderURL != null) {
            String port;
            String hostName = namingProviderURL.getHost();
            if (hostName != null && !"".equals(hostName)) {
                MemberValuePair hostNameMember = ast.newMemberValuePair();
                hostNameMember.setName(ast.newSimpleName("namingProviderURL_Host"));
                StringLiteral hostNameValue = ast.newStringLiteral();
                hostNameValue.setLiteralValue(hostName);
                hostNameMember.setValue((Expression)hostNameValue);
                eventMonitorConfigAnnotation.values().add(hostNameMember);
            }
            if ((port = namingProviderURL.getPort()) != null && !"".equals(port)) {
                MemberValuePair portMember = ast.newMemberValuePair();
                portMember.setName(ast.newSimpleName("namingProviderURL_Port"));
                StringLiteral portValue = ast.newStringLiteral();
                portValue.setLiteralValue(port);
                portMember.setValue((Expression)portValue);
                eventMonitorConfigAnnotation.values().add(portMember);
            }
        }
        if ((jmsConnectionAuthentication = inboundEvent.getJMSConnectionAuthentication()) != null) {
            String clientPassword;
            String clientName = jmsConnectionAuthentication.getClientName();
            if (clientName != null && !"".equals(clientName)) {
                MemberValuePair clientNameMember = ast.newMemberValuePair();
                clientNameMember.setName(ast.newSimpleName("jmsConnectionAuthentication_ClientName"));
                StringLiteral clientNameValue = ast.newStringLiteral();
                clientNameValue.setLiteralValue(clientName);
                clientNameMember.setValue((Expression)clientNameValue);
                eventMonitorConfigAnnotation.values().add(clientNameMember);
            }
            if ((clientPassword = jmsConnectionAuthentication.getClientPassword()) != null && !"".equals(clientPassword)) {
                MemberValuePair clientPasswordMember = ast.newMemberValuePair();
                clientPasswordMember.setName(ast.newSimpleName("jmsConnectionAuthentication_ClientPassword"));
                StringLiteral clientPasswordValue = ast.newStringLiteral();
                clientPasswordValue.setLiteralValue(clientPassword);
                clientPasswordMember.setValue((Expression)clientPasswordValue);
                eventMonitorConfigAnnotation.values().add(clientPasswordMember);
            }
        }
        MemberValuePair monitorMember = ast.newMemberValuePair();
        monitorMember.setName(ast.newSimpleName("monitor"));
        BooleanLiteral monitorValue = ast.newBooleanLiteral(true);
        monitorMember.setValue((Expression)monitorValue);
        eventMonitorConfigAnnotation.values().add(monitorMember);
        return eventMonitorConfigAnnotation;
    }

    private String generateMDBListenerMethodBody(String[] parameterNames, String[] parameterTypes, String returnType, String localInterfaceFieldName) {
        StringBuffer body = new StringBuffer();
        body.append("\t\ttry {\n");
        if ("void".equals(returnType)) {
            body.append("\t\t\t" + this.getClassName() + "Helper.send(");
        } else {
            body.append("\t\t\treturn " + this.getClassName() + "Helper.sendReceive(");
        }
        body.append("new Object[] {");
        int i = 0;
        while (i < parameterNames.length - 1) {
            body.append(parameterNames[i]).append(",");
            ++i;
        }
        body.append(parameterNames[parameterNames.length - 1]);
        body.append("}, " + localInterfaceFieldName + ");");
        body.append("\t\t} catch(Exception e) {\n");
        body.append("\t\t\tthrow new javax.ejb.EJBException(e);\n");
        body.append("\t\t}");
        return body.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isRecordType(String qualifiedClassName) {
        IType mdb = this.getType();
        IJavaProject project = mdb.getJavaProject();
        try {
            IType type = project.findType(qualifiedClassName);
            if (type == null) return false;
            if ("javax.resource.cci.Record".equals(type.getFullyQualifiedName())) {
                return true;
            }
            if ("commonj.connector.runtime.RecordHolder".equals(type.getFullyQualifiedName())) {
                return true;
            }
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
            IType[] interfaces = hierarchy.getAllSuperInterfaces(type);
            int i = 0;
            while (true) {
                if (i >= interfaces.length) {
                    return false;
                }
                IType superInterface = interfaces[i];
                if ("javax.resource.cci.Record".equals(superInterface.getFullyQualifiedName())) {
                    return true;
                }
                if ("commonj.connector.runtime.RecordHolder".equals(superInterface.getFullyQualifiedName())) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            CodegenPlugin.getDefault().getLog().log(e.getStatus());
        }
        return false;
    }
}

