/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2c.codegen.writer.properties;

import com.ibm.adapter.j2c.codegen.writer.properties.DescriptionColumnDescriptor;
import com.ibm.adapter.j2c.codegen.writer.properties.MethodNameProperty;
import com.ibm.adapter.j2c.codegen.writer.properties.OperationNameColumnDescriptor;
import com.ibm.adapter.j2c.internal.MessageResource;
import com.ibm.propertygroup.ITableCellProperty;
import com.ibm.propertygroup.ITableProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.IVetoableChangeListener;
import com.ibm.propertygroup.spi.PropertyVetoException;
import com.ibm.propertygroup.spi.TableCellProperty;
import com.ibm.propertygroup.spi.TableProperty;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;

public class OperationsTableProperty
extends TableProperty {
    public static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005, 2006 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    public static String OPERATIONS_TABLE_PROPERTY_NAME = "OPERATIONS_TABLE_PROPERTY";

    public OperationsTableProperty(BasePropertyGroup parentGroup) throws CoreException {
        this(OPERATIONS_TABLE_PROPERTY_NAME, MessageResource.METHOD_TREE_PG_DISPLAY_NAME, MessageResource.METHOD_TREE_PG_DISPLAY_NAME, parentGroup);
    }

    public OperationsTableProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup) throws CoreException {
        super(propertyName, displayName, propertyDescription, parentGroup);
        this.assignID("com.ibm.adapter.j2c.codegen.writer.properties.OperationsTableProperty");
        this.addColumn(new OperationNameColumnDescriptor());
        this.addColumn(new DescriptionColumnDescriptor());
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (evt.getSource() instanceof ITableCellProperty) {
            ITableCellProperty property = (ITableCellProperty)evt.getSource();
            if (!property.getName().equals(MethodNameProperty.METHOD_NAME_PROPERTY_NAME)) {
                return;
            }
            String newName = (String)evt.getNewValue();
            if (newName == null) {
                return;
            }
            ArrayList<String> operations = new ArrayList<String>();
            try {
                int numRows = this.rowCount();
                int i = 0;
                while (i < numRows) {
                    ITableCellProperty[] row = this.getRowProperties(i);
                    String operationName = row[0].getValueAsString();
                    if (operationName != null) {
                        operations.add(operationName);
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {
                return;
            }
            for (String name : operations) {
                if (!newName.equalsIgnoreCase(name)) continue;
                throw new PropertyVetoException(MessageResource.bind((String)MessageResource.ERR_DUPLICATE_METHOD_NAME, (Object)newName), (java.beans.PropertyChangeEvent)evt);
            }
        }
    }

    public ITableCellProperty[] createNewRow() throws CoreException {
        ITableCellProperty[] properties = super.createNewRow();
        ITableCellProperty cell = properties[0];
        ITableProperty.ColumnDescriptor[] columns = this.getColumns();
        if (cell instanceof TableCellProperty) {
            ((TableCellProperty)cell).addVetoablePropertyChangeListener((IVetoableChangeListener)this);
            ((TableCellProperty)cell).addVetoablePropertyChangeListener((IVetoableChangeListener)columns[0]);
        }
        if ((cell = properties[1]) instanceof TableCellProperty) {
            ((TableCellProperty)cell).addVetoablePropertyChangeListener((IVetoableChangeListener)columns[1]);
        }
        return properties;
    }

    public Object clone() throws CloneNotSupportedException {
        OperationsTableProperty clone = (OperationsTableProperty)((Object)super.clone());
        ArrayList<ITableCellProperty> operations = new ArrayList<ITableCellProperty>();
        ArrayList<ITableCellProperty> descripitions = new ArrayList<ITableCellProperty>();
        ITableProperty.ColumnDescriptor[] columns = null;
        try {
            columns = clone.getColumns();
            int numRows = clone.rowCount();
            int i = 0;
            while (i < numRows) {
                ITableCellProperty[] row = clone.getRowProperties(i);
                operations.add(row[0]);
                descripitions.add(row[1]);
                ++i;
            }
        }
        catch (CoreException coreException) {
            return clone;
        }
        int i = 0;
        while (i < operations.size()) {
            TableCellProperty property = (TableCellProperty)operations.get(i);
            TableCellProperty description = (TableCellProperty)descripitions.get(i);
            property.addVetoablePropertyChangeListener((IVetoableChangeListener)clone);
            property.addVetoablePropertyChangeListener((IVetoableChangeListener)columns[0]);
            description.addVetoablePropertyChangeListener((IVetoableChangeListener)columns[1]);
            ++i;
        }
        return clone;
    }
}

