/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2c.codegen.writer.properties;

import com.ibm.adapter.emd.extension.description.spi.J2CServiceDescription;
import com.ibm.adapter.j2c.internal.CodegenPlugin;
import com.ibm.adapter.j2c.internal.MessageResource;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import com.ibm.propertygroup.spi.IVetoableChangeListener;
import com.ibm.propertygroup.spi.PropertyVetoException;
import com.ibm.propertygroup.spi.common.JavaClassNameProperty;
import com.ibm.propertygroup.spi.common.JavaPackageProperty;
import com.ibm.propertygroup.spi.common.JavaProjectProperty;
import commonj.connector.metadata.description.FunctionDescription;
import commonj.connector.metadata.description.ServiceDescription;
import java.util.Arrays;
import java.util.ListIterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;

public class J2CWriterPropertyGroup
extends BasePropertyGroup {
    private boolean addOperation = false;
    private J2CServiceDescription definition;

    public J2CWriterPropertyGroup(J2CServiceDescription definition, boolean addOperation) throws CoreException {
        super("J2C Java Bean Writer Properties", null, "J2C Java Bean Writer Properties");
        this.definition = definition;
        this.addOperation = addOperation;
        this.initializePropertyGroup();
    }

    private void initializePropertyGroup() throws CoreException {
        JavaProjectProperty projectProperty = new JavaProjectProperty("Project", MessageResource.PROJECT_PROPERTY_DISPLAY_NAME, MessageResource.PROJECT_PROPERTY_DESCRIPTION, (BasePropertyGroup)this);
        projectProperty.setRequired(true);
        projectProperty.setEnabled(true);
        JavaPackageProperty pkgProperty = new JavaPackageProperty("PackageName", MessageResource.PACKAGE_NAME_PROPERTY_DISPLAY_NAME, MessageResource.PACKAGE_NAME_PROPERTY_DESCRIPTION, this){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyChangeType() == 0 && ((IPropertyDescriptor)evt.getSource()).getName().equals("Project")) {
                    try {
                        if (evt.getNewValue() != null) {
                            this.setJavaProject((IJavaProject)evt.getNewValue());
                        }
                    }
                    catch (CoreException e) {
                        CodegenPlugin.getDefault().getLog().log(e.getStatus());
                    }
                    if (evt.getNewValue() == null) {
                        this.setEnabled(false);
                    } else {
                        this.setEnabled(true);
                    }
                    return;
                }
            }
        };
        pkgProperty.setRequired(true);
        pkgProperty.setEnabled(false);
        JavaClassNameProperty interfaceNameProperty = new JavaClassNameProperty("InterfaceName", MessageResource.INTERFACE_NAME_PROPERTY_DISPLAY_NAME, MessageResource.INTERFACE_NAME_PROPERTY_DESCRIPTION, this){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyChangeType() == 0) {
                    if (((IPropertyDescriptor)evt.getSource()).getName().equals("Project")) {
                        if (evt.getNewValue() == null) {
                            this.setEnabled(false);
                        } else {
                            this.setEnabled(true);
                        }
                    } else if (((IPropertyDescriptor)evt.getSource()).getName().equals("PackageName")) {
                        try {
                            boolean setValue = this.isSet();
                            this.setValue(this.getValue());
                            this.setSet(setValue);
                        }
                        catch (CoreException coreException) {}
                    }
                }
            }
        };
        interfaceNameProperty.setRequired(true);
        interfaceNameProperty.setEnabled(false);
        JavaClassNameProperty bindingNameProperty = new JavaClassNameProperty("BindingName", MessageResource.BINDING_NAME_PROPERTY_DISPLAY_NAME, MessageResource.BINDING_NAME_PROPERTY_DESCRIPTION, this){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyChangeType() == 0) {
                    if (((IPropertyDescriptor)evt.getSource()).getName().equals("Project")) {
                        if (evt.getNewValue() == null) {
                            this.setEnabled(false);
                        } else {
                            this.setEnabled(true);
                        }
                    } else if (((IPropertyDescriptor)evt.getSource()).getName().equals("InterfaceName")) {
                        if (!this.isSet()) {
                            if (evt.getNewValue() == null) {
                                this.unSet();
                            } else {
                                try {
                                    this.setValue(evt.getNewValue() + "Impl");
                                }
                                catch (CoreException e) {
                                    CodegenPlugin.getDefault().getLog().log(e.getStatus());
                                }
                                this.setSet(false);
                            }
                        }
                    } else if (((IPropertyDescriptor)evt.getSource()).getName().equals("PackageName")) {
                        try {
                            boolean setValue = this.isSet();
                            this.setValue(this.getValue());
                            this.setSet(setValue);
                        }
                        catch (CoreException coreException) {}
                    }
                }
            }
        };
        bindingNameProperty.setRequired(true);
        bindingNameProperty.setEnabled(false);
        projectProperty.addPropertyChangeListener((IPropertyChangeListener)pkgProperty);
        projectProperty.addPropertyChangeListener((IPropertyChangeListener)bindingNameProperty);
        projectProperty.addPropertyChangeListener((IPropertyChangeListener)interfaceNameProperty);
        projectProperty.addVetoablePropertyChangeListener(new IVetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                IJavaProject project = (IJavaProject)evt.getNewValue();
                if (project == null || !project.exists()) {
                    throw new PropertyVetoException(MessageResource.ERR_PROJECT_DOES_NOT_EXIST, (java.beans.PropertyChangeEvent)evt);
                }
            }
        });
        pkgProperty.addPropertyChangeListener((IPropertyChangeListener)interfaceNameProperty);
        pkgProperty.addPropertyChangeListener((IPropertyChangeListener)bindingNameProperty);
        interfaceNameProperty.addPropertyChangeListener((IPropertyChangeListener)bindingNameProperty);
        interfaceNameProperty.addVetoablePropertyChangeListener((IVetoableChangeListener)new CheckExistingClassVetoableChangeListener(interfaceNameProperty, projectProperty, pkgProperty));
        interfaceNameProperty.addVetoablePropertyChangeListener((IVetoableChangeListener)new CheckNameVetoableChangeListener(interfaceNameProperty, bindingNameProperty));
        bindingNameProperty.addVetoablePropertyChangeListener((IVetoableChangeListener)new CheckExistingClassVetoableChangeListener(interfaceNameProperty, projectProperty, pkgProperty));
        bindingNameProperty.addVetoablePropertyChangeListener((IVetoableChangeListener)new CheckNameVetoableChangeListener(bindingNameProperty, interfaceNameProperty));
        BasePropertyGroup overallCommandGroup = new BasePropertyGroup("CommandBean", MessageResource.GENERATE_COMMAND_BEAN_OVERALL_GROUP_DISPLAY_NAME, MessageResource.GENERATE_COMMAND_BEAN_OVERALL_GROUP_DESCRIPTION);
        this.addProperty((IPropertyDescriptor)overallCommandGroup);
        ServiceDescription serviceDescription = this.definition.getServiceDescription();
        ListIterator<FunctionDescription> methodDefinitions = Arrays.asList(serviceDescription.getFunctionDescriptions()).listIterator();
        while (methodDefinitions.hasNext()) {
            com.ibm.adapter.emd.extension.description.spi.FunctionDescription methodDefn = (com.ibm.adapter.emd.extension.description.spi.FunctionDescription)methodDefinitions.next();
            BasePropertyGroup commandGroup = new BasePropertyGroup(methodDefn.getName(), String.valueOf(MessageResource.GENERATE_COMMAND_BEAN_GROUP_DISPLAY_NAME) + methodDefn.getName(), String.valueOf(MessageResource.GENERATE_COMMAND_BEAN_GROUP_DESCRIPTION) + methodDefn.getName()){

                public void propertyChange(PropertyChangeEvent evt) {
                }
            };
            overallCommandGroup.addProperty((IPropertyDescriptor)commandGroup);
            BaseSingleValuedProperty enable = new BaseSingleValuedProperty("EnableGenerate", MessageResource.ENABLE_GENERATE_COMMAND_BEAN_PROPERTY_DISPLAY_NAME, MessageResource.ENABLE_GENERATE_COMMAND_BEAN_PROPERTY_DESCRIPTION, Boolean.class, commandGroup);
            BaseSingleValuedProperty methodName = new BaseSingleValuedProperty(methodDefn.getName(), null, MessageResource.COMMAND_BEAN_METHOD_NAME_DESCRIPTION, String.class, commandGroup);
            methodName.setReadOnly(true);
            BaseSingleValuedProperty commandBeanName = new BaseSingleValuedProperty("CommandBeanName", MessageResource.COMMAND_BEAN_PROPERTY_DISPLAY_NAME, MessageResource.COMMAND_BEAN_PROPERTY_DESCRIPTION, String.class, commandGroup){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyChangeType() == 0) {
                        this.setEnabled((Boolean)evt.getNewValue());
                    }
                }

                public void vetoableChange(java.beans.PropertyChangeEvent evt) throws PropertyVetoException {
                    Object newValue = evt.getNewValue();
                    if (newValue == null) {
                        throw new PropertyVetoException(MessageResource.ERR_VALUE_IS_NULL, evt);
                    }
                    IStatus status = JavaConventions.validateJavaTypeName((String)newValue.toString());
                    if (!status.isOK()) {
                        throw new PropertyVetoException(status.getMessage(), evt);
                    }
                }
            };
            commandBeanName.setEnabled(false);
            BaseSingleValuedProperty commandBeanInputName = new BaseSingleValuedProperty("Input", MessageResource.COMMAND_BEAN_INPUT_DISPLAY_NAME, MessageResource.COMMAND_BEAN_INPUT_DESCRIPTION, String.class, commandGroup){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyChangeType() == 0) {
                        this.setEnabled((Boolean)evt.getNewValue());
                    }
                }

                public void vetoableChange(java.beans.PropertyChangeEvent evt) throws PropertyVetoException {
                    Object newValue = evt.getNewValue();
                    if (newValue == null) {
                        throw new PropertyVetoException(MessageResource.ERR_VALUE_IS_NULL, evt);
                    }
                }
            };
            commandBeanInputName.setEnabled(false);
            BaseSingleValuedProperty commandBeanOutputName = new BaseSingleValuedProperty("Output", MessageResource.COMMAND_BEAN_OUTPUT_DISPLAY_NAME, MessageResource.COMMAND_BEAN_OUTPUT_DESCRIPTION, String.class, commandGroup){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyChangeType() == 0) {
                        this.setEnabled((Boolean)evt.getNewValue());
                    }
                }

                public void vetoableChange(java.beans.PropertyChangeEvent evt) throws PropertyVetoException {
                    Object newValue = evt.getNewValue();
                    if (newValue == null) {
                        throw new PropertyVetoException(MessageResource.ERR_VALUE_IS_NULL, evt);
                    }
                }
            };
            commandBeanOutputName.setEnabled(false);
            enable.addPropertyChangeListener((IPropertyChangeListener)commandBeanName);
            enable.addPropertyChangeListener((IPropertyChangeListener)commandBeanInputName);
            enable.addPropertyChangeListener((IPropertyChangeListener)commandBeanOutputName);
            enable.setDefaultValue((Object)Boolean.FALSE);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        BasePropertyGroup group = (BasePropertyGroup)super.clone();
        JavaProjectProperty projectProperty = (JavaProjectProperty)group.getProperty("Project");
        JavaPackageProperty pkgProperty = (JavaPackageProperty)group.getProperty("PackageName");
        JavaClassNameProperty interfaceNameProperty = (JavaClassNameProperty)group.getProperty("InterfaceName");
        JavaClassNameProperty bindingNameProperty = (JavaClassNameProperty)group.getProperty("BindingName");
        projectProperty.addPropertyChangeListener((IPropertyChangeListener)pkgProperty);
        projectProperty.addPropertyChangeListener((IPropertyChangeListener)bindingNameProperty);
        projectProperty.addPropertyChangeListener((IPropertyChangeListener)interfaceNameProperty);
        projectProperty.addVetoablePropertyChangeListener(new IVetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                IJavaProject project = (IJavaProject)evt.getNewValue();
                if (project == null || !project.exists()) {
                    throw new PropertyVetoException(MessageResource.ERR_PROJECT_DOES_NOT_EXIST, (java.beans.PropertyChangeEvent)evt);
                }
            }
        });
        pkgProperty.addPropertyChangeListener((IPropertyChangeListener)interfaceNameProperty);
        pkgProperty.addPropertyChangeListener((IPropertyChangeListener)bindingNameProperty);
        interfaceNameProperty.addPropertyChangeListener((IPropertyChangeListener)bindingNameProperty);
        interfaceNameProperty.addVetoablePropertyChangeListener((IVetoableChangeListener)new CheckExistingClassVetoableChangeListener(interfaceNameProperty, projectProperty, pkgProperty));
        interfaceNameProperty.addVetoablePropertyChangeListener((IVetoableChangeListener)new CheckNameVetoableChangeListener(interfaceNameProperty, bindingNameProperty));
        bindingNameProperty.addVetoablePropertyChangeListener((IVetoableChangeListener)new CheckExistingClassVetoableChangeListener(interfaceNameProperty, projectProperty, pkgProperty));
        bindingNameProperty.addVetoablePropertyChangeListener((IVetoableChangeListener)new CheckNameVetoableChangeListener(bindingNameProperty, interfaceNameProperty));
        return group;
    }

    class CheckExistingClassVetoableChangeListener
    implements IVetoableChangeListener {
        JavaClassNameProperty source;
        JavaProjectProperty project;
        JavaPackageProperty pkg;

        public CheckExistingClassVetoableChangeListener(JavaClassNameProperty source, JavaProjectProperty project, JavaPackageProperty pkg) {
            this.source = source;
            this.project = project;
            this.pkg = pkg;
        }

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            IJavaProject javaProject = (IJavaProject)this.project.getValue();
            if (javaProject != null) {
                String className = null;
                if (((IPropertyDescriptor)evt.getSource()).getName().equals(this.source.getName())) {
                    className = (String)evt.getNewValue();
                }
                if (className != null && !className.equals("")) {
                    IPackageFragment javaPackage = (IPackageFragment)this.pkg.getValue();
                    IType javaType = null;
                    try {
                        if (javaPackage != null) {
                            String packageName = javaPackage.getElementName();
                            javaType = javaProject.findType(packageName, className);
                        } else {
                            javaType = javaProject.findType(className);
                        }
                        if (javaType == null) {
                            ICompilationUnit cu;
                            IResource resource;
                            IPath location;
                            if (javaPackage != null && (location = (resource = (cu = javaPackage.getCompilationUnit(String.valueOf(className) + ".java")).getResource()).getLocation()) != null && location.toFile().exists()) {
                                throw new PropertyVetoException(MessageResource.ERR_TYPE_EXISTS_DIFFERENT_CASE, (java.beans.PropertyChangeEvent)evt);
                            }
                        } else if (javaType.getJavaProject().equals(javaProject) && !J2CWriterPropertyGroup.this.addOperation) {
                            throw new PropertyVetoException(MessageResource.ERR_JAVA_CLASS_REWRITE, (java.beans.PropertyChangeEvent)evt, 1);
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    class CheckNameVetoableChangeListener
    implements IVetoableChangeListener {
        JavaClassNameProperty source;
        JavaClassNameProperty target;

        public CheckNameVetoableChangeListener(JavaClassNameProperty source, JavaClassNameProperty target) {
            this.source = source;
            this.target = target;
        }

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (((IPropertyDescriptor)evt.getSource()).getName().equals(this.source.getName())) {
                String interfaceName = (String)evt.getNewValue();
                String bindingName = this.target.getValueAsString();
                if (bindingName != null && interfaceName != null && bindingName.equals(interfaceName)) {
                    throw new PropertyVetoException(MessageResource.ERR_INTERFACE_NAME_EQUALS_BINDING_NAME, (java.beans.PropertyChangeEvent)evt);
                }
            }
        }
    }
}

