/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2c.codegen.writer.properties;

import com.ibm.adapter.emd.extension.description.spi.J2CServiceDescription;
import com.ibm.adapter.emd.internal.properties.JNDITargetProperty;
import com.ibm.adapter.emd.properties.wrapper.PropertyGroupWrapper;
import com.ibm.adapter.emd.util.EMDUtil;
import com.ibm.adapter.j2c.codegen.writer.properties.LabelProperty;
import com.ibm.adapter.j2c.internal.MessageResource;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import com.ibm.propertygroup.spi.IVetoableChangeListener;
import com.ibm.propertygroup.spi.PropertyVetoException;
import commonj.connector.metadata.discovery.connection.OutboundConnectionConfiguration;
import commonj.connector.metadata.discovery.properties.PropertyGroup;
import org.eclipse.core.runtime.CoreException;

public class ConnectionPropertyGroup
extends BasePropertyGroup {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2007 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    public static final String CONNECTION_GROUP_NAME = "CONNECTION_GROUP_NAME";
    public static final String IS_MANAGED_CONNECTION_NAME = "IS_MANAGED_CONNECTION_NAME";
    public static final String IS_NON_MANAGED_CONNECTION_NAME = "IS_NON_MANAGED_CONNECTION_NAME";
    private J2CServiceDescription definition;
    private LabelProperty label;
    private BaseSingleValuedProperty isManagedConnectionProperty;
    private JNDITargetProperty jndiTarget;
    private BaseSingleValuedProperty isNonManagedConnectionProperty;
    private PropertyGroupWrapper connectionPropertiesWrapper;
    private PropertyGroup mcfPG;

    public ConnectionPropertyGroup(OutboundConnectionConfiguration connectionConfig, J2CServiceDescription definition) throws CoreException {
        super(CONNECTION_GROUP_NAME, MessageResource.CONNECTION_GROUP_DISPLAY_NAME, MessageResource.CONNECTION_GROUP_DISPLAY_NAME);
        this.definition = definition;
        this.initializePropertyGroup(connectionConfig);
    }

    private void initializePropertyGroup(OutboundConnectionConfiguration connectionConfig) throws CoreException {
        this.label = new LabelProperty(this, MessageResource.CONNECTION_GROUP_DESCRIPTION);
        this.isManagedConnectionProperty = new BaseSingleValuedProperty(IS_MANAGED_CONNECTION_NAME, MessageResource.IS_MANAGED_CONNECTION_DISPLAY_NAME, MessageResource.IS_MANAGED_CONNECTION_DISPLAY_NAME, Boolean.class, (BasePropertyGroup)this);
        this.isManagedConnectionProperty.setDefaultValue((Object)Boolean.TRUE);
        this.isManagedConnectionProperty.addPropertyChangeListener((IPropertyChangeListener)this);
        this.isManagedConnectionProperty.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        String JNDITargetPropertyDescription = com.ibm.adapter.emd.internal.MessageResource.JNDI_TARGET_PROPERTY_MCF_DESCRIPTION;
        this.jndiTarget = new JNDITargetProperty((BasePropertyGroup)this, JNDITargetPropertyDescription);
        this.jndiTarget.addPropertyChangeListener((IPropertyChangeListener)this);
        this.jndiTarget.assignID("com.ibm.j2c.property.mcf");
        this.isNonManagedConnectionProperty = new BaseSingleValuedProperty(IS_NON_MANAGED_CONNECTION_NAME, MessageResource.IS_NON_MANAGED_CONNECTION_DISPLAY_NAME, MessageResource.IS_NON_MANAGED_CONNECTION_DISPLAY_NAME, Boolean.class, (BasePropertyGroup)this);
        this.isNonManagedConnectionProperty.setValue((Object)Boolean.FALSE);
        this.isNonManagedConnectionProperty.addPropertyChangeListener((IPropertyChangeListener)this);
        this.isNonManagedConnectionProperty.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        this.mcfPG = connectionConfig.createManagedConnectionFactoryProperties();
        this.connectionPropertiesWrapper = new PropertyGroupWrapper(this.mcfPG.getName(), this.mcfPG.getDisplayName(), this.mcfPG.getDescription(), EMDUtil.getEMDSpecVersion((IResourceAdapterDescriptor)this.definition.getResourceAdapterDescriptor()));
        this.connectionPropertiesWrapper.addPropertiesToPropertyGroup(this.mcfPG);
    }

    public Object clone() throws CloneNotSupportedException {
        BaseSingleValuedProperty isNonManagedConnectionProperty;
        BaseSingleValuedProperty isManagedConnectionProperty;
        ConnectionPropertyGroup clone = (ConnectionPropertyGroup)((Object)super.clone());
        clone.isManagedConnectionProperty = isManagedConnectionProperty = (BaseSingleValuedProperty)clone.getProperty(IS_MANAGED_CONNECTION_NAME);
        JNDITargetProperty jndiTarget = (JNDITargetProperty)clone.getProperty(JNDITargetProperty.JNDI_TARGET_PROPERTY_NAME);
        clone.jndiTarget = jndiTarget != null ? jndiTarget : (JNDITargetProperty)this.jndiTarget.clone();
        clone.isNonManagedConnectionProperty = isNonManagedConnectionProperty = (BaseSingleValuedProperty)clone.getProperty(IS_NON_MANAGED_CONNECTION_NAME);
        PropertyGroupWrapper connectionPropertiesWrapper = (PropertyGroupWrapper)clone.getProperty(this.mcfPG.getName());
        clone.connectionPropertiesWrapper = connectionPropertiesWrapper != null ? connectionPropertiesWrapper : (PropertyGroupWrapper)this.connectionPropertiesWrapper.clone();
        clone.isManagedConnectionProperty.addPropertyChangeListener((IPropertyChangeListener)clone);
        clone.isManagedConnectionProperty.addVetoablePropertyChangeListener((IVetoableChangeListener)clone);
        clone.isNonManagedConnectionProperty.addPropertyChangeListener((IPropertyChangeListener)clone);
        clone.isNonManagedConnectionProperty.addVetoablePropertyChangeListener((IVetoableChangeListener)clone);
        clone.jndiTarget.addPropertyChangeListener((IPropertyChangeListener)clone);
        return clone;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyChangeType() == 0) {
            if (evt.getSource() == this.isManagedConnectionProperty) {
                if (Boolean.TRUE.equals(evt.getNewValue())) {
                    if (Boolean.TRUE.equals(this.isNonManagedConnectionProperty.getValue())) {
                        this.remove((IPropertyDescriptor)this.isNonManagedConnectionProperty);
                        this.remove((IPropertyDescriptor)this.connectionPropertiesWrapper);
                    }
                    this.addProperty((IPropertyDescriptor)this.jndiTarget);
                    this.addProperty((IPropertyDescriptor)this.isNonManagedConnectionProperty);
                    if (Boolean.TRUE.equals(this.isNonManagedConnectionProperty.getValue())) {
                        this.addProperty((IPropertyDescriptor)this.connectionPropertiesWrapper);
                    }
                } else if (Boolean.FALSE.equals(evt.getNewValue())) {
                    this.remove((IPropertyDescriptor)this.jndiTarget);
                }
            }
            if (evt.getSource() == this.isNonManagedConnectionProperty) {
                if (Boolean.TRUE.equals(evt.getNewValue())) {
                    this.addProperty((IPropertyDescriptor)this.connectionPropertiesWrapper);
                } else if (Boolean.FALSE.equals(evt.getNewValue())) {
                    this.remove((IPropertyDescriptor)this.connectionPropertiesWrapper);
                }
            }
            if (evt.getSource() == this.jndiTarget) {
                String jndi = this.getJndiTarget();
                this.definition.setJNDILookupName(jndi);
            }
        }
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (evt.getSource() == this.isManagedConnectionProperty ? Boolean.FALSE.equals(evt.getNewValue()) && Boolean.FALSE.equals((Boolean)this.isNonManagedConnectionProperty.getValue()) : evt.getSource() == this.isNonManagedConnectionProperty && Boolean.FALSE.equals(evt.getNewValue()) && Boolean.FALSE.equals((Boolean)this.isManagedConnectionProperty.getValue())) {
            throw new PropertyVetoException(MessageResource.ERR_CONNECTION_OPTIONS_UNCHECKED, (java.beans.PropertyChangeEvent)evt);
        }
    }

    public String getJndiTarget() {
        return this.jndiTarget.getValueAsString();
    }

    public PropertyGroupWrapper getConnectionPropertiesWrapper() {
        return this.connectionPropertiesWrapper;
    }

    public J2CServiceDescription getJ2CServiceDescription() {
        return this.definition;
    }
}

