/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.properties.wrapper;

import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.propertygroup.spi.common.SchemaTypeProperty;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.properties.PropertyChangeListener;
import commonj.connector.metadata.discovery.properties.PropertyEvent;
import java.lang.reflect.Method;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SchemaTypePropertyWrapper
extends SchemaTypeProperty
implements PropertyChangeListener {
    protected commonj.connector.metadata.discovery.properties.extensions.SchemaTypeProperty emdProperty;
    String emdVersion = null;

    public SchemaTypePropertyWrapper(commonj.connector.metadata.discovery.properties.extensions.SchemaTypeProperty emdProperty, String emdVersion) throws CoreException {
        super(emdProperty.getName(), emdProperty.getDisplayName(), emdProperty.getDescription(), null);
        this.emdVersion = emdVersion;
        if (emdProperty.getID() != null) {
            this.propertyID = emdProperty.getID();
        }
        try {
            this.emdProperty = emdProperty;
            this.setExpert(emdProperty.getPropertyType().isExpert());
            this.setEnabled(emdProperty.isEnabled());
            this.setHidden(emdProperty.getPropertyType().isHidden());
            this.setSensitive(emdProperty.getPropertyType().isSensitive());
            this.setReadOnly(emdProperty.getPropertyType().isReadOnly());
            this.setRequired(emdProperty.getPropertyType().isRequired());
            Object defaultValue = emdProperty.getPropertyType().getDefaultValue();
            if (defaultValue != null) {
                this.setDefaultValue(defaultValue);
            }
            Object[] validValues = emdProperty.getPropertyType().getValidValues();
            this.setValidValues(validValues);
            if (emdProperty.getValue() != null) {
                this.setValue(emdProperty.getValue());
            }
            emdProperty.addPropertyChangeListener((PropertyChangeListener)this);
        }
        catch (Throwable e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
    }

    public void propertyChange(PropertyEvent evt) {
        if (evt.getSource() == this.emdProperty) {
            int propertyChangeType = evt.getPropertyChangeType();
            if (propertyChangeType == 0) {
                try {
                    this.setValue(evt.getNewValue());
                }
                catch (CoreException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                }
            } else if (propertyChangeType == 2) {
                this.setEnabled(false);
            } else if (propertyChangeType == 1) {
                this.setEnabled(true);
            } else if (propertyChangeType == 3) {
                try {
                    this.setValidValues((Object[])evt.getNewValue());
                }
                catch (CoreException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                }
            } else if (propertyChangeType == 4) {
                this.setValid(true, null);
            } else if (propertyChangeType == 5) {
                this.setValid(false, this.emdProperty.getValidationMessage());
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            SchemaTypePropertyWrapper clone = (SchemaTypePropertyWrapper)((Object)super.clone());
            clone.emdProperty = (commonj.connector.metadata.discovery.properties.extensions.SchemaTypeProperty)this.emdProperty.clone();
            clone.emdProperty.addPropertyChangeListener((PropertyChangeListener)clone);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw new CloneNotSupportedException(e.getLocalizedMessage());
        }
    }

    public void setValue(Object newValue) throws CoreException {
        try {
            this.emdProperty.setValue(newValue);
        }
        catch (MetadataException e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, NLS.bind((String)MessageResource.MSG_ERROR_ANNONYMOUS_EMD_ERROR, (Object)e.getLocalizedMessage()), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        super.setValue(newValue);
    }

    public void setLocation(URI uri) throws CoreException {
        try {
            this.emdProperty.setLocation(uri);
        }
        catch (MetadataException e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, NLS.bind((String)MessageResource.MSG_ERROR_ANNONYMOUS_EMD_ERROR, (Object)e.getLocalizedMessage()), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        super.setLocation(uri);
    }

    public void setType(boolean isType) {
        super.setType(isType);
        try {
            Method method = this.emdProperty.getClass().getMethod("setType", Boolean.TYPE);
            method.invoke((Object)this.emdProperty, isType);
        }
        catch (Exception exception) {}
    }
}

