/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.properties.wrapper;

import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.internal.discovery.EMDDescriptor;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.properties.PropertyChangeListener;
import commonj.connector.metadata.discovery.properties.PropertyDescriptor;
import commonj.connector.metadata.discovery.properties.PropertyEvent;
import commonj.connector.metadata.discovery.properties.PropertyGroup;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PropertyGroupWrapper
extends BasePropertyGroup
implements PropertyChangeListener {
    private PropertyGroup wrappedPropertyGroup;
    private String emdVersion = null;
    private boolean hideProperties;
    private static final String EMD_VERSION_INDETERMINATE = "EMD_VERSION_INDETERMINATE";

    public PropertyGroupWrapper(String groupName, String displayName, String groupDescription) throws CoreException {
        this(groupName, displayName, groupDescription, null);
    }

    public PropertyGroupWrapper(String groupName, String displayName, String groupDescription, boolean hideProperties) throws CoreException {
        this(groupName, displayName, groupDescription, null, hideProperties);
    }

    public PropertyGroupWrapper(String groupName, String displayName, String groupDescription, String emdVersion) throws CoreException {
        this(groupName, displayName, groupDescription, emdVersion, false);
    }

    public PropertyGroupWrapper(String groupName, String displayName, String groupDescription, String emdVersion, boolean hideProperties) throws CoreException {
        super(groupName, displayName, groupDescription);
        if (emdVersion == null) {
            emdVersion = EMD_VERSION_INDETERMINATE;
        }
        this.emdVersion = emdVersion;
        this.hideProperties = hideProperties;
        this.propertyID = "DEFAULT_PROPERTY_IDENTIFIER";
    }

    public void addPropertiesToPropertyGroup(PropertyGroup emdPropertyGroup) {
        if (this.wrappedPropertyGroup != null) {
            this.wrappedPropertyGroup.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (EMD_VERSION_INDETERMINATE.equals(this.emdVersion)) {
            this.calculateEMDVersion(emdPropertyGroup);
        }
        this.wrappedPropertyGroup = emdPropertyGroup;
        if (!EMDDescriptor.EMD_SPEC_VERSION_1_0.equals(this.emdVersion) && this.wrappedPropertyGroup.getID() != null) {
            this.propertyID = this.wrappedPropertyGroup.getID();
        }
        this.wrappedPropertyGroup.addPropertyChangeListener((PropertyChangeListener)this);
        PropertyDescriptor[] properties = emdPropertyGroup.getProperties();
        IPropertyDescriptor[] wrappedProperties = new IPropertyDescriptor[properties.length];
        int i = 0;
        while (i < properties.length) {
            try {
                IPropertyDescriptor wrappedProperty = this.wrapProperty(properties[i]);
                if (wrappedProperty != null) {
                    wrappedProperties[i] = wrappedProperty;
                }
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
            ++i;
        }
        this.replaceAll(wrappedProperties);
    }

    /*
     * Exception decompiling
     */
    private IPropertyDescriptor wrapProperty(PropertyDescriptor emdProperty) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 9[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public PropertyGroup getWrappedPropertyGroup() {
        return this.wrappedPropertyGroup;
    }

    public void propertyChange(PropertyEvent event) {
        if (event.getSource() == this.wrappedPropertyGroup) {
            int propertyChangeType = event.getPropertyChangeType();
            if (propertyChangeType == 6) {
                PropertyDescriptor newProperty = (PropertyDescriptor)event.getNewValue();
                IPropertyDescriptor wrappedProperty = this.wrapProperty(newProperty);
                this.addProperty(wrappedProperty);
            } else if (propertyChangeType == 9) {
                this.removeAll();
            } else if (propertyChangeType == 7) {
                PropertyDescriptor childProperty = (PropertyDescriptor)event.getOldValue();
                IPropertyDescriptor wrappedChildProperty = this.getProperty(childProperty.getName());
                if (wrappedChildProperty != null) {
                    this.remove(wrappedChildProperty);
                }
            } else if (propertyChangeType == 8) {
                PropertyDescriptor[] newProperties = (PropertyDescriptor[])event.getNewValue();
                IPropertyDescriptor[] wrappedProperties = new IPropertyDescriptor[newProperties.length];
                int i = newProperties.length;
                while (--i >= 0) {
                    try {
                        IPropertyDescriptor wrappedProperty = this.wrapProperty(newProperties[i]);
                        if (wrappedProperty == null) continue;
                        wrappedProperties[i] = wrappedProperty;
                    }
                    catch (RuntimeException e) {
                        LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    }
                    catch (Throwable e) {
                        LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                this.replaceAll(wrappedProperties);
            }
        }
    }

    public void assignID(String id) throws CoreException {
        if (!"DEFAULT_PROPERTY_IDENTIFIER".equals(this.getID())) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, MessageResource.ERR_ID_SET, null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        super.assignID(id);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            PropertyGroupWrapper clone = (PropertyGroupWrapper)((Object)super.clone());
            if (this.wrappedPropertyGroup != null) {
                clone.wrappedPropertyGroup = (PropertyGroup)this.wrappedPropertyGroup.clone();
                clone.addPropertiesToPropertyGroup(clone.wrappedPropertyGroup);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw new CloneNotSupportedException(e.getLocalizedMessage());
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw new CloneNotSupportedException(e.getLocalizedMessage());
        }
    }

    public String convertToString() {
        if (this.getWrappedPropertyGroup() == null) {
            return null;
        }
        if (EMDDescriptor.EMD_SPEC_VERSION_1_0.equals(this.emdVersion)) {
            return super.convertToString();
        }
        return this.wrappedPropertyGroup.convertToString();
    }

    public void populateFromString(String value) throws CoreException {
        if (this.getWrappedPropertyGroup() == null) {
            return;
        }
        if (EMDDescriptor.EMD_SPEC_VERSION_1_0.equals(this.emdVersion)) {
            super.populateFromString(value);
        } else {
            try {
                this.wrappedPropertyGroup.populateFromString(value);
            }
            catch (MetadataException e) {
                Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
    }

    private void calculateEMDVersion(PropertyGroup emdPG) {
        String emdVersion = EMDDescriptor.EMD_SPEC_VERSION_1_0;
        try {
            emdPG.getID();
            emdVersion = EMDDescriptor.LATEST_EMD_SPEC_VERSION;
        }
        catch (Throwable throwable) {}
        this.emdVersion = emdVersion;
    }
}

