/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.properties.wrapper;

import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.internal.discovery.EMDDescriptor;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.common.MultiFolderProperty;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.properties.MultiValuedProperty;
import commonj.connector.metadata.discovery.properties.PropertyChangeListener;
import commonj.connector.metadata.discovery.properties.PropertyEvent;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.util.NLS;

public class MultiFolderPropertyWrapper
extends MultiFolderProperty
implements PropertyChangeListener {
    protected MultiValuedProperty emdProperty;
    private String emdVersion = null;

    public MultiFolderPropertyWrapper(commonj.connector.metadata.discovery.properties.extensions.MultiFolderProperty emdProperty, BasePropertyGroup parentGroup, String emdVersion) throws CoreException {
        this((MultiValuedProperty)emdProperty, parentGroup, emdProperty.mustExist(), emdVersion);
        if (emdProperty.getID() != null) {
            this.propertyID = emdProperty.getID();
        }
    }

    public MultiFolderPropertyWrapper(MultiValuedProperty emdProperty, BasePropertyGroup parentGroup) throws CoreException {
        this(emdProperty, parentGroup, true, EMDDescriptor.EMD_SPEC_VERSION_1_0);
    }

    public MultiFolderPropertyWrapper(MultiValuedProperty emdProperty, BasePropertyGroup parentGroup, boolean mustExist, String emdVersion) throws CoreException {
        super(emdProperty.getName(), emdProperty.getDisplayName(), emdProperty.getDescription(), parentGroup, mustExist);
        this.emdVersion = emdVersion;
        try {
            this.emdProperty = emdProperty;
            if (emdProperty.getPropertyType().getType() != File.class) {
                Status status = new Status(4, "com.ibm.adapter.emd", 4, MessageResource.MSG_ERROR_NOT_FILE_PROP, null);
                LogFacility.logErrorMessage((IStatus)status);
                throw new CoreException((IStatus)status);
            }
            this.setExpert(emdProperty.getPropertyType().isExpert());
            this.setEnabled(emdProperty.isEnabled());
            this.setHidden(emdProperty.getPropertyType().isHidden());
            this.setSensitive(emdProperty.getPropertyType().isSensitive());
            this.setReadOnly(emdProperty.getPropertyType().isReadOnly());
            this.setRequired(emdProperty.getPropertyType().isRequired());
            Object defaultValue = emdProperty.getPropertyType().getDefaultValue();
            if (defaultValue != null) {
                this.setDefaultValue(URI.createFileURI((String)defaultValue.toString()));
            }
            Object[] validValues = emdProperty.getPropertyType().getValidValues();
            this.setValidValues(validValues);
            if (!EMDDescriptor.EMD_SPEC_VERSION_1_0.equals(emdVersion)) {
                this.setAllowDuplicateValues(emdProperty.allowDuplicateValues());
                if (emdProperty.getSelectionStyle() == 0) {
                    this.setSelectionStyle(0);
                } else {
                    this.setSelectionStyle(1);
                }
            }
            Object[] values = emdProperty.getValues();
            int i = 0;
            while (i < values.length) {
                File f = (File)values[i];
                this.addValue(URI.createFileURI((String)f.getPath()));
                ++i;
            }
            emdProperty.addPropertyChangeListener((PropertyChangeListener)this);
        }
        catch (Throwable e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
    }

    public void propertyChange(PropertyEvent evt) {
        if (evt.getSource() == this.emdProperty) {
            int propertyChangeType = evt.getPropertyChangeType();
            if (propertyChangeType == 2) {
                this.setEnabled(false);
            } else if (propertyChangeType == 1) {
                this.setEnabled(true);
            } else if (propertyChangeType == 3) {
                try {
                    this.setValidValues((Object[])evt.getNewValue());
                }
                catch (CoreException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                }
            } else if (propertyChangeType == 4) {
                this.setValid(true, null);
            } else if (propertyChangeType == 5) {
                this.setValid(false, this.emdProperty.getValidationMessage());
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            MultiFolderPropertyWrapper clone = (MultiFolderPropertyWrapper)((Object)super.clone());
            clone.emdProperty = (MultiValuedProperty)this.emdProperty.clone();
            clone.emdProperty.addPropertyChangeListener((PropertyChangeListener)clone);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw new CloneNotSupportedException(e.getLocalizedMessage());
        }
    }

    public void addValue(Object value, int index) throws CoreException, IndexOutOfBoundsException {
        try {
            URI fileURI = (URI)value;
            String fileLocation = null;
            if (fileURI != null) {
                fileLocation = fileURI.toFileString();
            }
            File file = null;
            if (fileLocation != null) {
                file = new File(fileLocation);
            }
            this.emdProperty.addValue((Object)file, index);
        }
        catch (MetadataException e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, NLS.bind((String)MessageResource.MSG_ERROR_ANNONYMOUS_EMD_ERROR, (Object)e.getLocalizedMessage()), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        super.addValue(value, index);
    }

    public Object removeValue(int index) {
        this.emdProperty.removeValue(index);
        Object obj = super.removeValue(index);
        return obj;
    }

    public boolean removeValue(Object value) {
        boolean removed = super.removeValue(value);
        if (value == null) {
            return removed;
        }
        Object[] values = this.emdProperty.getValues();
        URI fileURI = (URI)value;
        File file = new File(fileURI.toFileString());
        File f = null;
        boolean found = false;
        int i = 0;
        while (i < values.length) {
            f = (File)values[i];
            if (f != null && f.equals(file)) {
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            this.emdProperty.removeValue((Object)f);
        }
        return removed;
    }

    public boolean removeValueAsString(String value) throws CoreException {
        this.emdProperty.removeValueAsString(value);
        boolean removed = super.removeValueAsString(value);
        return removed;
    }

    public void setSelection(int[] indices) {
        this.emdProperty.setSelection(indices);
        super.setSelection(indices);
    }

    public void unSet() {
        this.emdProperty.unSet();
        super.unSet();
    }
}

