/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.properties;

import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.discovery.EMDDescriptor;
import com.ibm.adapter.emd.internal.discovery.MessageUtil;
import com.ibm.adapter.emd.internal.properties.AdapterTypeConnectionTypePropertyGroup;
import com.ibm.adapter.emd.internal.properties.ConnectionTypeProperty;
import com.ibm.adapter.emd.internal.properties.LogFileProperty;
import com.ibm.adapter.emd.internal.properties.LoggingLevelProperty;
import com.ibm.adapter.emd.properties.wrapper.PropertyGroupWrapper;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import commonj.connector.metadata.discovery.MetadataDiscovery;
import commonj.connector.metadata.discovery.connection.OutboundConnectionConfiguration;
import commonj.connector.metadata.discovery.connection.OutboundConnectionType;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;

public class DiscoveryConnectionPropertyGroup
extends BasePropertyGroup {
    private static final String CONNECTION_PROPS = "connectionProperties";
    private static final String LOGGING_CHOICE = "LOGGING_CHOICE";
    private AdapterTypeConnectionTypePropertyGroup adapterTypeConnectionTypePG = null;
    private PropertyGroupWrapper connectionConfigurationProperties = null;
    private BaseSingleValuedProperty loggingChoiceProperty = null;
    private LogFileProperty logFileProperty = null;
    private LoggingLevelProperty loggingLevelProperty = null;
    private OutboundConnectionConfiguration connectionConfiguration;

    public DiscoveryConnectionPropertyGroup(String groupName, String displayName, String groupDescription, EMDDescriptor emdDescriptor, MessageUtil messageUtil) throws CoreException {
        super(groupName, displayName, groupDescription);
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        MetadataDiscovery discovery = emdDescriptor.getDiscoveryService();
        this.adapterTypeConnectionTypePG = new AdapterTypeConnectionTypePropertyGroup(discovery, messageUtil);
        this.addProperty((IPropertyDescriptor)this.adapterTypeConnectionTypePG);
        this.connectionConfigurationProperties = new PropertyGroupWrapper(CONNECTION_PROPS, messageUtil.getMessage("CONNECTION_PROPS_DISPLAY_NAME"), messageUtil.getMessage("CONNECTION_PROPS_DESCRIPTION"), emdDescriptor.getSpecVersion()){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() instanceof ConnectionTypeProperty && evt.getPropertyChangeType() == 0 && evt.getNewValue() != null) {
                    this.removeAll();
                    this.setEnabled(true);
                    DiscoveryConnectionPropertyGroup.this.connectionConfiguration = ((OutboundConnectionType)evt.getNewValue()).createOutboundConnectionConfiguration();
                    this.addPropertiesToPropertyGroup(DiscoveryConnectionPropertyGroup.this.connectionConfiguration.createUnifiedProperties());
                }
            }
        };
        this.connectionConfigurationProperties.setEnabled(true);
        this.connectionConfigurationProperties.assignID("com.ibm.propertygroup.ui.PropertyUINestedLayoutID");
        this.addProperty((IPropertyDescriptor)this.connectionConfigurationProperties);
        this.adapterTypeConnectionTypePG.addPropertyChangeListener((IPropertyChangeListener)this.connectionConfigurationProperties);
        this.loggingChoiceProperty = new BaseSingleValuedProperty(LOGGING_CHOICE, messageUtil.getMessage("LOG_LEVEL_DESCRIPTION"), messageUtil.getMessage("LOG_LEVEL_DESCRIPTION"), Boolean.class, (BasePropertyGroup)this);
        this.loggingChoiceProperty.setDefaultValue((Object)Boolean.FALSE);
        this.loggingChoiceProperty.setValue((Object)Boolean.FALSE);
        this.loggingChoiceProperty.addPropertyChangeListener((IPropertyChangeListener)this);
        this.logFileProperty = new LogFileProperty(discovery.getClass().getName(), messageUtil);
        this.loggingLevelProperty = new LoggingLevelProperty(messageUtil);
        this.adapterTypeConnectionTypePG.adapterTypeProperty.setValue(this.adapterTypeConnectionTypePG.adapterTypeProperty.getPropertyType().getDefaultValue());
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            DiscoveryConnectionPropertyGroup clone = (DiscoveryConnectionPropertyGroup)((Object)super.clone());
            clone.adapterTypeConnectionTypePG = (AdapterTypeConnectionTypePropertyGroup)clone.getProperty("adapterTypePG");
            clone.connectionConfigurationProperties = (PropertyGroupWrapper)clone.getProperty(CONNECTION_PROPS);
            clone.loggingChoiceProperty = (BaseSingleValuedProperty)clone.getProperty(LOGGING_CHOICE);
            clone.logFileProperty = (LogFileProperty)clone.getProperty("logFileLocation");
            clone.loggingLevelProperty = (LoggingLevelProperty)clone.getProperty("loggingLevel");
            clone.adapterTypeConnectionTypePG.addPropertyChangeListener((IPropertyChangeListener)clone.connectionConfigurationProperties);
            clone.loggingChoiceProperty.addPropertyChangeListener((IPropertyChangeListener)clone);
            return clone;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getLogFileLocation() {
        return this.logFileProperty.getFileLocation();
    }

    public Level getLoggingLevel() {
        String levelName = this.loggingLevelProperty.getValueAsString();
        Level level = Level.parse(levelName);
        return level;
    }

    public OutboundConnectionConfiguration getConnectionConfiguration() {
        this.connectionConfiguration.applyUnifiedProperties(this.connectionConfigurationProperties.getWrappedPropertyGroup());
        return this.connectionConfiguration;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.loggingChoiceProperty) {
            Boolean choice = (Boolean)evt.getNewValue();
            if (choice.booleanValue()) {
                this.addProperty((IPropertyDescriptor)this.logFileProperty);
                this.addProperty((IPropertyDescriptor)this.loggingLevelProperty);
            } else {
                this.remove((IPropertyDescriptor)this.logFileProperty);
                this.remove((IPropertyDescriptor)this.loggingLevelProperty);
            }
        }
    }
}

