/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.properties;

import com.ibm.adapter.emd.extension.description.J2CServiceDescription;
import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.discovery.MessageUtil;
import com.ibm.adapter.emd.util.EMDUtil;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ISingleTypedProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.spi.BaseMultiValuedProperty;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import com.ibm.propertygroup.spi.common.BindingTypeProperty;
import com.ibm.propertygroup.spi.common.SchemaTypeProperty;
import commonj.connector.metadata.build.FunctionBuilder;
import commonj.connector.metadata.build.tool.DataDescription;
import commonj.connector.metadata.description.SchemaDefinition;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.CoreException;

public class DataTypeBindingTypePropertyGroup
extends BasePropertyGroup {
    public static final String DATA_TYPE_NAME = "DataTypeProperty";
    public static final String DATA_BINDING_NAME = "DataBindingProperty";
    public static final String CUSTOM_PROPERTY = "CustomProperty";
    public static final String METHOD_LEVEL_BINDING_SELECTOR = "MethodLevelBindingLevel";
    public static final String SCHEMA_DEFINITIONS = "SchemaDefinitions";
    public static final String GENERIC_DATA_BINDING_CLASS_NAME = "GenericDataBindingClassName";
    public static final String GENERIC_DATA_BINDING_CLASS_NAME_READ_ONLY = "GenericDataBindingClassNameReadOnly";
    SchemaTypeProperty dataTypeProperty;
    BaseSingleValuedProperty bindingTypeProperty;
    BaseSingleValuedProperty customProperty;
    BaseMultiValuedProperty schemaDefinitions;
    BaseSingleValuedProperty genericDataBindingClassNameProperty;
    BaseSingleValuedProperty genericDataBindingClassNameReadOnlyProperty;
    BaseSingleValuedProperty bindingSelectionProperty;
    boolean isInput = true;
    private MessageUtil messageUtil;
    private String myDisplayName;
    IPropertyChangeListener customSameAsInputSwitchListener;

    DataTypeBindingTypePropertyGroup(String name, boolean isInput, String eisType, FunctionBuilder functionBuilder, MessageUtil messageUtil) throws CoreException {
        super(name, isInput ? messageUtil.getMessage("DATA_TYPE_BINDING_INPUT_DISPLAY_NAME") : messageUtil.getMessage("DATA_TYPE_BINDING_OUTPUT_DISPLAY_NAME"), messageUtil.getMessage("DATA_TYPE_BINDING_DESCRIPTION"));
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        this.messageUtil = messageUtil;
        this.isInput = isInput;
        if (!isInput) {
            this.customProperty = new BaseSingleValuedProperty(CUSTOM_PROPERTY, messageUtil.getMessage("OUTPUT_TYPE_CUSTOM_DISPLAY_NAME"), messageUtil.getMessage("OUTPUT_TYPE_CUSTOM_DESCRIPTION"), String.class, (BasePropertyGroup)this);
            this.customProperty.setEnabled(true);
            this.customProperty.setRequired(true);
            Object[] output_operation_values = new String[]{messageUtil.getMessage("SAME_AS_INPUT_DISPLAY_NAME"), messageUtil.getMessage("CUSTOM_DISPLAY_NAME")};
            this.customProperty.setValidValues(output_operation_values);
            this.addProperty((IPropertyDescriptor)this.customProperty);
            this.customProperty.addPropertyChangeListener((IPropertyChangeListener)this);
        }
        this.dataTypeProperty = new SchemaTypeProperty(DATA_TYPE_NAME, isInput ? messageUtil.getMessage("INPUT_DATA_TYPE_NAME_DISPLAY_NAME") : messageUtil.getMessage("OUTPUT_DATA_TYPE_NAME_DISPLAY_NAME"), isInput ? messageUtil.getMessage("INPUT_DATA_TYPE_NAME_DESCRIPTION") : messageUtil.getMessage("OUTPUT_DATA_TYPE_NAME_DESCRIPTION"), (BasePropertyGroup)this);
        this.dataTypeProperty.setEnabled(true);
        this.dataTypeProperty.setRequired(true);
        this.addProperty((IPropertyDescriptor)this.dataTypeProperty);
        this.schemaDefinitions = new BaseMultiValuedProperty(SCHEMA_DEFINITIONS, null, null, SchemaDefinition.class, (BasePropertyGroup)this);
        this.schemaDefinitions.setRequired(false);
        this.schemaDefinitions.setHidden(true);
        this.addProperty((IPropertyDescriptor)this.schemaDefinitions);
        this.bindingSelectionProperty = new BaseSingleValuedProperty(METHOD_LEVEL_BINDING_SELECTOR, messageUtil.getMessage("SERVICE_LEVEL_DATA_BINDING_SELECTION_DISPLAY_NAME"), null, String.class, (BasePropertyGroup)this);
        this.bindingSelectionProperty.setRequired(true);
        Object[] values = new String[]{messageUtil.getMessage("METHOD_LEVEL_USE_DEFAULT_DATA_BINDING"), messageUtil.getMessage("METHOD_LEVEL_USE_ALREADY_CONFIGURED_DATA_BINDING"), messageUtil.getMessage("METHOD_LEVEL_USE_CONFIGURED_DATA_BINDING")};
        this.bindingSelectionProperty.setValidValues(values);
        this.bindingSelectionProperty.addPropertyChangeListener((IPropertyChangeListener)this);
        String[] tags = new String[]{"BindingKind_DataBinding"};
        if (eisType != null) {
            tags = new String[]{"BindingKind_DataBinding", "BindingType_EIS/" + eisType};
        }
        this.bindingTypeProperty = new BindingTypeProperty(DATA_BINDING_NAME, messageUtil.getMessage("DATA_BINDING_NAME_DISPLAY_NAME"), messageUtil.getMessage("DATA_BINDING_NAME_DESCRIPTION"), (BasePropertyGroup)this, tags);
        this.bindingTypeProperty.setEnabled(true);
        this.bindingTypeProperty.setRequired(true);
        this.addProperty((IPropertyDescriptor)this.bindingTypeProperty);
        this.genericDataBindingClassNameProperty = new BaseSingleValuedProperty(GENERIC_DATA_BINDING_CLASS_NAME, null, null, String.class, (BasePropertyGroup)this);
        this.genericDataBindingClassNameProperty.setRequired(false);
        this.genericDataBindingClassNameProperty.setHidden(true);
        this.addProperty((IPropertyDescriptor)this.genericDataBindingClassNameProperty);
        this.genericDataBindingClassNameReadOnlyProperty = new BaseSingleValuedProperty(GENERIC_DATA_BINDING_CLASS_NAME_READ_ONLY, null, null, Boolean.TYPE, (BasePropertyGroup)this);
        this.genericDataBindingClassNameReadOnlyProperty.setRequired(false);
        this.genericDataBindingClassNameReadOnlyProperty.setHidden(true);
        this.addProperty((IPropertyDescriptor)this.genericDataBindingClassNameReadOnlyProperty);
        if (!isInput) {
            this.customSameAsInputSwitchListener = new CustomSameAsInputSwitchListener((BaseSingleValuedProperty)this.dataTypeProperty, this.bindingTypeProperty, messageUtil);
            this.customProperty.addPropertyChangeListener(this.customSameAsInputSwitchListener);
            this.customProperty.addPropertyChangeListener((IPropertyChangeListener)this);
            this.customProperty.setValue((Object)messageUtil.getMessage("CUSTOM_DISPLAY_NAME"));
        }
    }

    private IPropertyDescriptor getTopMostParent(IPropertyDescriptor property) {
        if (property.getParent() == null) {
            return property;
        }
        return this.getTopMostParent(property.getParent());
    }

    private boolean isLanguageDataBinding() {
        Object[] context;
        IPropertyDescriptor descriptor = this.getTopMostParent((IPropertyDescriptor)this);
        if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)descriptor) && (context = ((IPropertyGroup)descriptor).getPropertyGroupContext()) != null) {
            Object[] objectArray = context;
            int n = context.length;
            int n2 = 0;
            while (n2 < n) {
                Object c = objectArray[n2];
                if ("IS_LANGUAGE_DATA_BINDING_CONFIGURED".equals(c.toString())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    void initializeFromModel(DataDescription data_description, ClassLoader emdClassLoader, J2CServiceDescription j2cServiceDescription) throws CoreException {
        String systemLevelBindingName = j2cServiceDescription.getBindingClassName();
        String systemLevelBindingReferenceName = j2cServiceDescription.getBindingConfigurationName();
        Object bindingSelectionValue = this.bindingSelectionProperty.getValue();
        this.dataTypeProperty.setEnabled(true);
        this.bindingSelectionProperty.setEnabled(true);
        this.bindingTypeProperty.setEnabled(true);
        this.dataTypeProperty.setValue(null);
        this.bindingTypeProperty.setValue(null);
        this.bindingSelectionProperty.setValidValues((Object[])new String[0]);
        this.schemaDefinitions.unSet();
        this.genericDataBindingClassNameProperty.setValue(null);
        this.genericDataBindingClassNameReadOnlyProperty.setValue((Object)false);
        this.dataTypeProperty.setEnabled(false);
        this.bindingTypeProperty.setEnabled(false);
        if (!this.isInput) {
            this.customProperty.setEnabled(false);
        }
        if (data_description != null) {
            boolean localDataDescriptionReadOnly = data_description.isReadOnly();
            String methodLevelDataBindingName = data_description.getGenericDataBindingClassName();
            String methodLevelBindingConfigurationName = data_description.getBindingConfigurationName();
            this.dataTypeProperty.setEnabled(true);
            this.bindingSelectionProperty.setEnabled(true);
            this.bindingTypeProperty.setEnabled(true);
            this.dataTypeProperty.setValue((Object)data_description.getName());
            this.bindingTypeProperty.setValue((Object)(methodLevelBindingConfigurationName != null ? QName.valueOf(methodLevelBindingConfigurationName) : null));
            SchemaDefinition[] schemaDefinitionsArray = data_description.getSchemaDefinitions();
            if (schemaDefinitionsArray != null) {
                int i = 0;
                while (i < schemaDefinitionsArray.length) {
                    this.schemaDefinitions.addValue((Object)schemaDefinitionsArray[i]);
                    ++i;
                }
            }
            this.genericDataBindingClassNameProperty.setValue((Object)methodLevelDataBindingName);
            this.genericDataBindingClassNameReadOnlyProperty.setValue((Object)false);
            this.remove((IPropertyDescriptor)this.bindingSelectionProperty);
            this.remove((IPropertyDescriptor)this.bindingTypeProperty);
            Object[] values = null;
            boolean configurationNeeded = false;
            ArrayList<String> stringDescription = new ArrayList<String>();
            try {
                if (methodLevelDataBindingName != null) {
                    configurationNeeded = !EMDUtil.isConfigurationOptional(emdClassLoader, methodLevelDataBindingName);
                }
            }
            catch (Exception exception) {}
            if (localDataDescriptionReadOnly) {
                this.genericDataBindingClassNameReadOnlyProperty.setValue((Object)true);
                if (methodLevelDataBindingName != null && !configurationNeeded) {
                    stringDescription.add(this.messageUtil.getMessage("METHOD_LEVEL_USE_SUGGESTED_DATA_BINDING", new Object[]{methodLevelDataBindingName.substring(methodLevelDataBindingName.lastIndexOf(".") + 1)}));
                }
                if (methodLevelBindingConfigurationName != null) {
                    stringDescription.add(this.messageUtil.getMessage("METHOD_LEVEL_USE_SUGGESTED_CONFIGURED_DATA_BINDING", new Object[]{QName.valueOf(methodLevelBindingConfigurationName).getLocalPart()}));
                }
            } else {
                if (systemLevelBindingName != null) {
                    stringDescription.add(this.messageUtil.getMessage("METHOD_LEVEL_USE_DEFAULT_DATA_BINDING", new Object[]{systemLevelBindingName.substring(systemLevelBindingName.lastIndexOf(".") + 1)}));
                }
                if (systemLevelBindingReferenceName != null) {
                    stringDescription.add(this.messageUtil.getMessage("METHOD_LEVEL_USE_ALREADY_CONFIGURED_DATA_BINDING", new Object[]{QName.valueOf(systemLevelBindingReferenceName).getLocalPart()}));
                }
                if (methodLevelDataBindingName != null && !configurationNeeded && !methodLevelDataBindingName.equals(systemLevelBindingName)) {
                    stringDescription.add(this.messageUtil.getMessage("METHOD_LEVEL_USE_SUGGESTED_DATA_BINDING", new Object[]{methodLevelDataBindingName.substring(methodLevelDataBindingName.lastIndexOf(".") + 1)}));
                }
                if (methodLevelBindingConfigurationName != null) {
                    stringDescription.add(this.messageUtil.getMessage("METHOD_LEVEL_USE_SUGGESTED_CONFIGURED_DATA_BINDING", new Object[]{QName.valueOf(methodLevelBindingConfigurationName).getLocalPart()}));
                }
            }
            if (stringDescription.size() > 0) {
                stringDescription.add(this.messageUtil.getMessage("METHOD_LEVEL_USE_CONFIGURED_DATA_BINDING"));
                values = stringDescription.toArray(new String[0]);
            }
            if (values != null) {
                this.bindingSelectionProperty.setValidValues(values);
                this.bindingSelectionProperty.setValue(bindingSelectionValue != null ? bindingSelectionValue : values[0]);
                if (values.length > 1) {
                    this.addProperty((IPropertyDescriptor)this.bindingSelectionProperty);
                }
            }
            this.addProperty((IPropertyDescriptor)this.bindingTypeProperty);
            if (data_description.isReadOnly()) {
                this.dataTypeProperty.setEnabled(false);
                if (!this.isInput) {
                    this.customProperty.setEnabled(false);
                }
            }
        }
        if (this.isLanguageDataBinding()) {
            this.bindingSelectionProperty.setValidValues((Object[])new String[]{this.messageUtil.getMessage("LANGUAGE_DATA_BINDING")});
            this.bindingSelectionProperty.setValue((Object)this.messageUtil.getMessage("LANGUAGE_DATA_BINDING"));
            this.remove((IPropertyDescriptor)this.bindingSelectionProperty);
            this.remove((IPropertyDescriptor)this.bindingTypeProperty);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            DataTypeBindingTypePropertyGroup clone = (DataTypeBindingTypePropertyGroup)((Object)super.clone());
            clone.bindingTypeProperty = (BindingTypeProperty)clone.getProperty(DATA_BINDING_NAME) != null ? (BaseSingleValuedProperty)clone.getProperty(DATA_BINDING_NAME) : (BaseSingleValuedProperty)this.bindingTypeProperty.clone();
            clone.dataTypeProperty = (SchemaTypeProperty)clone.getProperty(DATA_TYPE_NAME) != null ? (SchemaTypeProperty)clone.getProperty(DATA_TYPE_NAME) : (SchemaTypeProperty)this.dataTypeProperty.clone();
            clone.schemaDefinitions = (BaseMultiValuedProperty)clone.getProperty(SCHEMA_DEFINITIONS);
            clone.genericDataBindingClassNameProperty = (BaseSingleValuedProperty)clone.getProperty(GENERIC_DATA_BINDING_CLASS_NAME);
            clone.genericDataBindingClassNameReadOnlyProperty = (BaseSingleValuedProperty)clone.getProperty(GENERIC_DATA_BINDING_CLASS_NAME_READ_ONLY);
            clone.bindingSelectionProperty = (BaseSingleValuedProperty)clone.getProperty(METHOD_LEVEL_BINDING_SELECTOR) != null ? (BaseSingleValuedProperty)clone.getProperty(METHOD_LEVEL_BINDING_SELECTOR) : (BaseSingleValuedProperty)this.bindingSelectionProperty.clone();
            clone.bindingSelectionProperty.addPropertyChangeListener((IPropertyChangeListener)clone);
            if (!this.isInput) {
                clone.customProperty = clone.getProperty(CUSTOM_PROPERTY) != null ? (BaseSingleValuedProperty)clone.getProperty(CUSTOM_PROPERTY) : (BaseSingleValuedProperty)this.customProperty.clone();
                clone.customSameAsInputSwitchListener = new CustomSameAsInputSwitchListener((BaseSingleValuedProperty)clone.dataTypeProperty, clone.bindingTypeProperty, this.messageUtil);
                clone.customProperty.addPropertyChangeListener(clone.customSameAsInputSwitchListener);
                clone.customProperty.addPropertyChangeListener((IPropertyChangeListener)clone);
            }
            return clone;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.bindingSelectionProperty == evt.getSource() && (evt.getPropertyChangeType() == 0 || evt.getPropertyChangeType() == 3)) {
            this.bindingTypeProperty.setEnabled(this.messageUtil.getMessage("METHOD_LEVEL_USE_CONFIGURED_DATA_BINDING").equals(this.bindingSelectionProperty.getValueAsString()));
        } else {
            this.propertyChanges.firePropertyChange(evt);
        }
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    protected void setDisplayName(String displayName) {
        this.myDisplayName = displayName;
    }

    static class CustomSameAsInputSwitchListener
    implements IPropertyChangeListener {
        BaseSingleValuedProperty dataTypeProperty;
        BaseSingleValuedProperty bindingTypeProperty;
        MessageUtil messageUtil;

        public CustomSameAsInputSwitchListener(BaseSingleValuedProperty dataTypeProperty, BaseSingleValuedProperty bindingTypeProperty, MessageUtil messageUtil) {
            this.dataTypeProperty = dataTypeProperty;
            this.bindingTypeProperty = bindingTypeProperty;
            this.messageUtil = messageUtil;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof ISingleTypedProperty && DataTypeBindingTypePropertyGroup.CUSTOM_PROPERTY.equals(((ISingleTypedProperty)evt.getSource()).getName()) && evt.getPropertyChangeType() == 0 && evt.getNewValue() != null) {
                if (this.messageUtil.getMessage("SAME_AS_INPUT_DISPLAY_NAME").equals(evt.getNewValue())) {
                    this.dataTypeProperty.setEnabled(false);
                    this.bindingTypeProperty.setEnabled(false);
                } else {
                    this.dataTypeProperty.setEnabled(true);
                    this.bindingTypeProperty.setEnabled(true);
                }
            }
        }
    }
}

