/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.extension.discovery.connection;

import com.ibm.adapter.emd.extension.discovery.connection.spi.OutboundConnectionConfiguration;
import com.ibm.adapter.emd.extension.discovery.spi.AdapterType;
import com.ibm.adapter.emd.extension.properties.PropertyGroupImpl;
import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.util.EMDUtil;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.connection.ConnectionType;
import commonj.connector.metadata.discovery.connection.OutboundConnectionType;
import commonj.connector.metadata.discovery.properties.PropertyDescriptor;
import commonj.connector.metadata.discovery.properties.PropertyGroup;

public class OutboundConnectionConfigurationImpl
implements OutboundConnectionConfiguration {
    private String name;
    private String description;
    private com.ibm.adapter.emd.extension.discovery.connection.spi.OutboundConnectionType outboundConnectionType;
    private PropertyGroup mcfPG;
    private PropertyGroup raPG;
    private PropertyGroup pg;

    public OutboundConnectionType getOutboundConnectionType() {
        return this.outboundConnectionType;
    }

    @Override
    public void setOutboundConnectionType(com.ibm.adapter.emd.extension.discovery.connection.spi.OutboundConnectionType outboundConnectionType) {
        this.outboundConnectionType = outboundConnectionType;
    }

    public PropertyGroup createManagedConnectionFactoryProperties() {
        try {
            AdapterType adapterType = (AdapterType)this.outboundConnectionType.getAdapterType();
            PropertyGroup propertyGroup = EMDUtil.getOutboundConnectionTypePropertyGroup(this.outboundConnectionType.getManagedConnectionFactoryName(), adapterType.getResourceAdapterDescriptor());
            if (this.mcfPG != null) {
                EMDUtil.copyValues(this.mcfPG, propertyGroup);
            }
            return propertyGroup;
        }
        catch (MetadataException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean applyManagedConnectionFactoryProperties(PropertyGroup propertyGroup) {
        this.mcfPG = propertyGroup;
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ConnectionType getConnectionType() {
        return this.outboundConnectionType;
    }

    public PropertyGroup createResourceAdapterProperties() {
        try {
            AdapterType adapterType = (AdapterType)this.outboundConnectionType.getAdapterType();
            PropertyGroup propertyGroup = EMDUtil.getOutboundResourceAdapterPropertyGroup(this.outboundConnectionType.getManagedConnectionFactoryName(), adapterType.getResourceAdapterDescriptor());
            if (this.raPG != null) {
                EMDUtil.copyValues(this.raPG, propertyGroup);
            }
            return propertyGroup;
        }
        catch (MetadataException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean applyResourceAdapterProperties(PropertyGroup propertyGroup) {
        this.raPG = propertyGroup;
        return true;
    }

    public PropertyGroup createUnifiedProperties() {
        try {
            AdapterType adapterType = (AdapterType)this.outboundConnectionType.getAdapterType();
            StringBuffer pgName = new StringBuffer().append(adapterType.getDisplayName()).append(" ").append(adapterType.getVendor()).append(" ").append(adapterType.getVersion()).append(" ").append(MessageResource.ADAPTER_UNIFIED_PROPERTIES);
            PropertyGroupImpl propertyGroup = new PropertyGroupImpl(pgName.toString());
            propertyGroup.setDisplayName(pgName.toString());
            propertyGroup.setDescription(pgName.toString());
            PropertyGroup mcfProperties = this.createManagedConnectionFactoryProperties();
            propertyGroup.addProperty((PropertyDescriptor)mcfProperties);
            PropertyGroup raProp = this.createResourceAdapterProperties();
            propertyGroup.addProperty((PropertyDescriptor)raProp);
            if (this.pg != null) {
                EMDUtil.copyValues(this.pg, propertyGroup);
            }
            return propertyGroup;
        }
        catch (MetadataException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean applyUnifiedProperties(PropertyGroup propertyGroup) {
        try {
            this.pg = propertyGroup;
            if (this.raPG != null) {
                EMDUtil.copyValues(this.pg, this.raPG);
            }
            if (this.mcfPG != null) {
                EMDUtil.copyValues(this.pg, this.mcfPG);
            }
        }
        catch (Exception e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        return true;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

