/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.discovery;

import com.ibm.adapter.emd.internal.EmdPlugin;
import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.framework.IEnvironment;
import commonj.connector.tool.ToolContext;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.XMLFormatter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class EMDToolContext
implements ToolContext {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private IEnvironment importEnvironment;
    private Logger activeLog;
    private EMDProgressMonitor activeProgressMonitor;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EMDToolContext(String logFile, String metadataDiscovery, Level loggingLevel) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            try {
                this.activeLog = metadataDiscovery != null ? Logger.getLogger("com.ibm.adapter.emd.discovery." + metadataDiscovery) : Logger.getLogger("com.ibm.adapter.emd.discovery");
                Handler[] currentHandlers = this.activeLog.getHandlers();
                if (currentHandlers != null) {
                    int i = currentHandlers.length;
                    while (--i >= 0) {
                        currentHandlers[i].close();
                        this.activeLog.removeHandler(currentHandlers[i]);
                    }
                }
                this.activeLog.setUseParentHandlers(false);
                this.activeLog.setLevel(loggingLevel);
                if (logFile != null) {
                    FileHandler loggingFileHandler = null;
                    try {
                        loggingFileHandler = new FileHandler(logFile, true);
                    }
                    catch (IOException exc) {
                        LogFacility.logErrorMessage((String)exc.getLocalizedMessage(), (Throwable)exc);
                    }
                    if (loggingFileHandler == null) {
                        EclipseLogHandler eclipseHandler = new EclipseLogHandler();
                        this.activeLog.addHandler(eclipseHandler);
                    } else {
                        loggingFileHandler.setFormatter(new XMLFormatter());
                        loggingFileHandler.setLevel(loggingLevel);
                        this.activeLog.addHandler(loggingFileHandler);
                    }
                } else {
                    EclipseLogHandler eclipseHandler = new EclipseLogHandler();
                    this.activeLog.addHandler(eclipseHandler);
                }
                this.activeProgressMonitor = new EMDProgressMonitor();
                ImportEnvironmentLogHandler importEnvironmentLogHandler = new ImportEnvironmentLogHandler();
                importEnvironmentLogHandler.setLevel(loggingLevel);
                this.activeLog.addHandler(importEnvironmentLogHandler);
                if (!LogFacility.trace) return;
                Handler[] handlers = LogFacility.traceLogger.getHandlers();
                int i = handlers.length;
                while (--i >= 0) {
                    this.activeLog.addHandler(handlers[i]);
                }
                return;
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                if (!LogFacility.trace) return;
                LogFacility.TrcExit();
                return;
            }
            catch (Throwable e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                if (!LogFacility.trace) return;
                LogFacility.TrcExit();
                return;
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public Logger getLogger() {
        return this.activeLog;
    }

    public ToolContext.ProgressMonitor getProgressMonitor() {
        return this.activeProgressMonitor;
    }

    public void setImportEnvironment(IEnvironment env) {
        this.importEnvironment = env;
        if (this.activeProgressMonitor != null) {
            this.activeProgressMonitor.setMaximum(-1);
            this.activeProgressMonitor.setMinimum(0);
            this.activeProgressMonitor.setNote("");
        }
    }

    public void close() {
        try {
            Handler[] handlers = this.activeLog.getHandlers();
            int i = handlers.length;
            while (--i >= 0) {
                handlers[i].close();
            }
        }
        catch (SecurityException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private class EMDProgressMonitor
    implements ToolContext.ProgressMonitor {
        private int min;
        private int max;
        private String note;
        private int currentWorked = 0;

        private EMDProgressMonitor() {
        }

        public void close() {
            try {
                if (EMDToolContext.this.importEnvironment != null) {
                    EMDToolContext.this.importEnvironment.getProgressMonitor().done();
                }
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }

        public int getMaximum() {
            return this.max;
        }

        public int getMinimum() {
            return this.min;
        }

        public String getNote() {
            return this.note;
        }

        public boolean isCanceled() {
            try {
                if (EMDToolContext.this.importEnvironment != null) {
                    return EMDToolContext.this.importEnvironment.getProgressMonitor().isCanceled();
                }
                return false;
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                return false;
            }
            catch (Throwable e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                return false;
            }
        }

        public void setMaximum(int arg0) {
            if (arg0 == -1) {
                return;
            }
            this.max = arg0;
            this.currentWorked = 0;
            try {
                if (EMDToolContext.this.importEnvironment != null) {
                    EMDToolContext.this.importEnvironment.getProgressMonitor().beginTask("", arg0);
                }
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }

        public void setMinimum(int arg0) {
            this.min = arg0;
        }

        public void setNote(String arg0) {
            this.note = arg0;
            try {
                if (EMDToolContext.this.importEnvironment != null) {
                    EMDToolContext.this.importEnvironment.getProgressMonitor().subTask(arg0);
                }
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }

        public void setProgress(int arg0) {
            if (arg0 <= this.currentWorked) {
                return;
            }
            int numTicks = arg0 - this.currentWorked;
            this.currentWorked = arg0;
            try {
                if (EMDToolContext.this.importEnvironment != null) {
                    EMDToolContext.this.importEnvironment.getProgressMonitor().worked(numTicks);
                }
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private class EclipseLogHandler
    extends Handler {
        private EclipseLogHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            int severity = 1;
            if (Level.SEVERE.equals(record.getLevel())) {
                severity = 4;
            } else if (Level.WARNING.equals(record.getLevel())) {
                severity = 2;
            }
            Status status = new Status(severity, record.getSourceClassName(), record.getLevel().intValue(), record.getMessage() == null ? "" : record.getMessage(), record.getThrown());
            EmdPlugin.getDefault().getLog().log((IStatus)status);
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }
    }

    private class ImportEnvironmentLogHandler
    extends Handler {
        private ImportEnvironmentLogHandler() {
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        private int getSeverity(Level loggingLevel) {
            if (loggingLevel.equals(Level.SEVERE)) {
                return 4;
            }
            if (loggingLevel.equals(Level.WARNING)) {
                return 2;
            }
            if (loggingLevel.equals(Level.INFO)) {
                return 1;
            }
            return 0;
        }

        @Override
        public void publish(LogRecord record) {
            try {
                if (this.isLoggable(record) && EMDToolContext.this.importEnvironment != null) {
                    EMDToolContext.this.importEnvironment.getLog().log(record.getLevel(), record.getSourceMethodName(), new Status(this.getSeverity(record.getLevel()), "com.ibm.adapter.emd", record.getLevel().intValue(), record.getMessage() == null ? "" : record.getMessage(), record.getThrown()));
                }
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

