/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.discovery;

import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.internal.discovery.EMDDescriptor;
import com.ibm.adapter.emd.internal.discovery.EMDNodeProperties;
import com.ibm.adapter.emd.internal.discovery.EMDResultNode;
import com.ibm.adapter.emd.properties.wrapper.PropertyGroupWrapper;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IResultNode;
import com.ibm.adapter.framework.IResultNodeSelection;
import com.ibm.propertygroup.IPropertyGroup;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.MetadataImportConfiguration;
import commonj.connector.metadata.discovery.MetadataObject;
import commonj.connector.metadata.discovery.MetadataSelection;
import commonj.connector.metadata.discovery.properties.PropertyGroup;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class EMDResultNodeSelection
implements IResultNodeSelection {
    private MetadataSelection emdMetadataSelection;
    private ArrayList selectedNodes = new ArrayList();
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private String emdVersion = null;

    public EMDResultNodeSelection(MetadataSelection selection, String emdVersion) throws BaseException {
        if (selection == null) {
            BaseException e = BaseException.createException((String)MessageResource.MSG_ERROR_METADATA_SEL_NULL, null);
            throw e;
        }
        this.emdMetadataSelection = selection;
        this.emdVersion = emdVersion;
    }

    public void add(IResultNode node) throws BaseException {
        block7: {
            try {
                if (node instanceof EMDResultNode) {
                    MetadataImportConfiguration configuration = ((EMDResultNode)node).getEmdConfiguration();
                    this.emdMetadataSelection.add(configuration);
                    this.selectedNodes.add(node);
                    IPropertyGroup pg = ((EMDResultNode)node).getActiveConfigurationParameters();
                    if (pg != null) {
                        ((PropertyGroupWrapper)pg).setEnabled(false);
                    }
                    break block7;
                }
                BaseException e = BaseException.createException((String)MessageResource.MSG_ERROR_INVALID_NODE_ADD, null);
                LogFacility.logErrorMessage((IStatus)e.getStatus());
                throw e;
            }
            catch (MetadataException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                throw BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_ANNONYMOUS_EMD_ERROR, (Object)e.getLocalizedMessage()), (Throwable)e);
            }
            catch (BaseException e) {
                throw e;
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public void applySelectionProperties(IPropertyGroup properties) {
        try {
            if (properties != null) {
                if (properties instanceof PropertyGroupWrapper) {
                    PropertyGroup pg = ((PropertyGroupWrapper)properties).getWrappedPropertyGroup();
                    this.emdMetadataSelection.applySelectionProperties(pg);
                } else {
                    LogFacility.logErrorMessage((String)MessageResource.MSG_ERROR_INVALID_SELECTION_PROPS, null);
                }
            }
        }
        catch (MetadataException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public boolean canAdd(IResultNode node) {
        block4: {
            if (!(node instanceof EMDResultNode)) break block4;
            MetadataImportConfiguration configuration = this.emdMetadataSelection.canAdd(((EMDResultNode)node).getMetadataObject());
            return configuration != null;
        }
        try {
            IllegalArgumentException ex = new IllegalArgumentException(MessageResource.MSG_ERROR_INVALID_NODE_ADD);
            LogFacility.logErrorMessage((String)ex.getLocalizedMessage(), (Throwable)ex);
            throw ex;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            IllegalArgumentException ex = new IllegalArgumentException(e.getLocalizedMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            IllegalArgumentException ex = new IllegalArgumentException(e.getLocalizedMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public IPropertyGroup createSelectionProperties() {
        try {
            PropertyGroup group = this.emdMetadataSelection.createSelectionProperties();
            if (group != null) {
                PropertyGroupWrapper wrapper = new PropertyGroupWrapper(group.getName(), group.getDisplayName(), group.getDescription(), this.emdVersion);
                wrapper.addPropertiesToPropertyGroup(group);
                return wrapper;
            }
            return null;
        }
        catch (CoreException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    public MetadataSelection getMetadataSelection() {
        return this.emdMetadataSelection;
    }

    public IResultNode[] getSelection() {
        return this.selectedNodes.toArray(new IResultNode[0]);
    }

    public void remove(IResultNode node) {
        if (this.selectedNodes.remove(node)) {
            MetadataImportConfiguration configuration = ((EMDResultNode)node).getEmdConfiguration();
            this.emdMetadataSelection.remove(configuration);
            IPropertyGroup pg = ((EMDResultNode)node).getActiveConfigurationParameters();
            if (pg != null) {
                ((PropertyGroupWrapper)pg).setEnabled(true);
            }
        }
    }

    public boolean canAdd(IResultNode[] nodes) {
        if (nodes == null) {
            IllegalArgumentException ex = new IllegalArgumentException(MessageResource.MSG_ERROR_INVALID_NODE_ADD);
            LogFacility.logErrorMessage((String)ex.getLocalizedMessage(), (Throwable)ex);
            throw ex;
        }
        if (EMDDescriptor.EMD_SPEC_VERSION_1_0.equals(this.emdVersion)) {
            int i = 0;
            while (i < nodes.length) {
                if (!this.canAdd(nodes[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        try {
            MetadataObject[] metadataObjects = new MetadataObject[nodes.length];
            int i = 0;
            while (i < nodes.length) {
                if (!(nodes[i] instanceof EMDResultNode)) {
                    IllegalArgumentException ex = new IllegalArgumentException(MessageResource.MSG_ERROR_INVALID_NODE_ADD);
                    LogFacility.logErrorMessage((String)ex.getLocalizedMessage(), (Throwable)ex);
                    throw ex;
                }
                metadataObjects[i] = ((EMDResultNode)nodes[i]).getMetadataObject();
                ++i;
            }
            MetadataImportConfiguration[] configuration = this.emdMetadataSelection.canAdd(metadataObjects);
            return configuration != null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            IllegalArgumentException ex = new IllegalArgumentException(e.getLocalizedMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            IllegalArgumentException ex = new IllegalArgumentException(e.getLocalizedMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public IPropertyGroup edit(IResultNode node) {
        MetadataImportConfiguration configuration;
        PropertyGroup group;
        if (EMDDescriptor.EMD_SPEC_VERSION_1_0.equals(this.emdVersion)) {
            return null;
        }
        if (node instanceof EMDResultNode && (group = this.emdMetadataSelection.edit(configuration = ((EMDResultNode)node).getEmdConfiguration())) != null) {
            try {
                EMDNodeProperties wrapper = new EMDNodeProperties(group, this.emdVersion);
                wrapper.setMetadataConfiguration(configuration);
                return wrapper;
            }
            catch (CoreException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public String getMessage() {
        if (EMDDescriptor.EMD_SPEC_VERSION_1_0.equals(this.emdVersion)) {
            return null;
        }
        return this.emdMetadataSelection.getMessage();
    }

    public boolean isSelectionComplete() {
        if (EMDDescriptor.EMD_SPEC_VERSION_1_0.equals(this.emdVersion)) {
            return true;
        }
        return this.emdMetadataSelection.isSelectionComplete();
    }
}

