/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.build.j2c;

import com.ibm.adapter.emd.extension.description.J2CServiceDescription;
import com.ibm.adapter.emd.extension.description.spi.ServiceDescription;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.internal.build.j2c.J2CBuildContext;
import com.ibm.adapter.emd.internal.build.j2c.J2COperation;
import com.ibm.adapter.emd.internal.build.j2c.J2COperationContainer;
import com.ibm.adapter.emd.internal.build.j2c.NonGeneratedDataFile;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IImportResult;
import com.ibm.adapter.framework.internal.build.IOperation;
import com.ibm.adapter.framework.internal.build.IOperationContainer;
import com.ibm.adapter.framework.internal.build.IServiceBuilder;
import commonj.connector.metadata.description.DataDescription;
import commonj.connector.metadata.description.DataFile;
import commonj.connector.metadata.description.FunctionDescription;
import org.eclipse.core.runtime.IProgressMonitor;

public class J2CServiceBuilder
implements IServiceBuilder {
    J2CBuildContext context;
    J2COperationContainer operationContainer = null;

    J2CServiceBuilder(J2CBuildContext context) {
        this.context = context;
    }

    public IOperationContainer createOperationContainer() {
        if (this.operationContainer == null) {
            this.operationContainer = new J2COperationContainer(this.context);
        }
        return this.operationContainer;
    }

    public IImportResult completeBuildProcess(IEnvironment environment) throws BaseException {
        IOperation[] operations;
        IProgressMonitor monitor = null;
        if (environment != null) {
            monitor = environment.getProgressMonitor();
        }
        if (monitor != null) {
            monitor.beginTask(MessageResource.MSG_COMPLETING_BUILD_PROCESS, 1);
        }
        if ((operations = this.operationContainer.getOperations()) != null) {
            int i = 0;
            while (i < operations.length) {
                J2COperation op = (J2COperation)operations[i];
                op.finalizeOperation();
                ++i;
            }
        }
        ServiceDescription description = this.getServiceDescriptionModel();
        FunctionDescription[] functionDescriptions = description.getFunctionDescriptions();
        int i = 0;
        while (i < functionDescriptions.length) {
            DataDescription outData;
            DataDescription inData = functionDescriptions[i].getInputDataDescription();
            if (inData != null) {
                DataFile[] dataFiles = inData.getDataFiles();
                int j = 0;
                while (j < dataFiles.length) {
                    try {
                        if (monitor != null && monitor.isCanceled()) {
                            throw BaseException.createException((String)MessageResource.MSG_OPERATION_CANCELLED, null);
                        }
                        NonGeneratedDataFile f = (NonGeneratedDataFile)dataFiles[j];
                        f.generateFileFromWriter(environment);
                    }
                    catch (ClassCastException classCastException) {}
                    ++j;
                }
            }
            if ((outData = functionDescriptions[i].getOutputDataDescription()) != null) {
                DataFile[] dataFiles = outData.getDataFiles();
                int j = 0;
                while (j < dataFiles.length) {
                    try {
                        if (monitor != null && monitor.isCanceled()) {
                            throw BaseException.createException((String)MessageResource.MSG_OPERATION_CANCELLED, null);
                        }
                        NonGeneratedDataFile f = (NonGeneratedDataFile)dataFiles[j];
                        f.generateFileFromWriter(environment);
                    }
                    catch (ClassCastException classCastException) {}
                    ++j;
                }
            }
            ++i;
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        return this.context.result;
    }

    private ServiceDescription getServiceDescriptionModel() {
        Object data = this.context.result.getImportData();
        return (ServiceDescription)((J2CServiceDescription)data).getServiceDescription();
    }
}

