/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal;

import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.internal.discovery.EMDDescriptor;
import com.ibm.adapter.emd.internal.discovery.EMDHelper;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.adapter.j2ca.IResourceAdapterListener;
import com.ibm.adapter.j2ca.ResourceAdapterEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class ResourceAdapterListener
implements IResourceAdapterListener {
    public void notify(ResourceAdapterEvent event) {
        block26: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                if (event.getEventType() == 0) {
                    IResourceAdapterDescriptor resourceAdapter = event.getResourceAdapter();
                    if (resourceAdapter != null) {
                        IFile descriptorFile = EMDHelper.getDescoveryServiceXML(resourceAdapter.getConnectorProject());
                        if (descriptorFile == null) {
                            if (LogFacility.trace) {
                                LogFacility.logInfoMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_NO_DESC_XML, (Object)event.getResourceAdapter().getConnectorProject().getName()));
                            }
                            return;
                        }
                        EMDDescriptor descriptor = EMDHelper.parseDiscoveryServiceXML(descriptorFile);
                        EMDHelper.registerDescriptor(descriptor, resourceAdapter);
                    }
                    break block26;
                }
                if (event.getEventType() == 1) {
                    EMDDescriptor descriptor = (EMDDescriptor)EMDDescriptor.getDescriptors().get(event.getResourceAdapter().getConnectorProject().getName());
                    if (descriptor != null) {
                        EMDHelper.removeDescriptor(descriptor);
                    }
                    break block26;
                }
                if (event.getEventType() != 2) break block26;
                if (event.getChangedResource() != null && "discovery-service.xml".equalsIgnoreCase(event.getChangedResource().getName())) {
                    IFile descriptorFile = EMDHelper.getDescoveryServiceXML(event.getResourceAdapter().getConnectorProject());
                    if (descriptorFile == null) {
                        EMDDescriptor descriptor;
                        if (LogFacility.trace) {
                            LogFacility.logInfoMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_NO_DESC_XML, (Object)event.getResourceAdapter().getConnectorProject().getName()));
                        }
                        if ((descriptor = (EMDDescriptor)EMDDescriptor.getDescriptors().get(event.getResourceAdapter().getConnectorProject().getName())) != null) {
                            EMDHelper.removeDescriptor(descriptor);
                        }
                        return;
                    }
                    EMDDescriptor newDescriptor = EMDHelper.parseDiscoveryServiceXML(descriptorFile);
                    EMDDescriptor oldDescriptor = (EMDDescriptor)EMDDescriptor.getDescriptors().get(event.getResourceAdapter().getConnectorProject().getName());
                    if (oldDescriptor != null) {
                        EMDHelper.removeDescriptor(oldDescriptor);
                    }
                    EMDHelper.registerDescriptor(newDescriptor, event.getResourceAdapter());
                    return;
                }
                try {
                    EMDDescriptor descriptor = (EMDDescriptor)EMDDescriptor.getDescriptors().get(event.getResourceAdapter().getConnectorProject().getName());
                    if (descriptor != null) {
                        descriptor.reset();
                    }
                }
                catch (BaseException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (Throwable e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            finally {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
    }
}

