/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.cobol.spi.properties;

import com.ibm.adapter.cobol.CobolMessageResource;
import com.ibm.adapter.cobol.ICobolConstants;
import com.ibm.adapter.cobol.spi.properties.CobolBaseProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.PropertyVetoException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CobolFloatingPointFormatProperty
extends CobolBaseProperty {
    private static String[] validValuesArray = null;
    private static String defaultFloatPointFormat = null;
    private static String defaultZosFloatPointFormat = null;

    public CobolFloatingPointFormatProperty() throws CoreException {
        super(CobolMessageResource.FLOATING_POINT_FORMAT_PROP_NAME, CobolMessageResource.FLOATING_POINT_FORMAT_PROP_DISPLAY_NAME, CobolMessageResource.FLOATING_POINT_FORMAT_PROP_DESC);
        this.initializeProperty();
    }

    private void initializeProperty() {
        try {
            this.cobolKey = "com.ibm.etools.cobol.COBOL_FLOATING_POINT_FORMAT";
            validValuesArray = new String[]{ICobolConstants.FLOAT_IEEE, ICobolConstants.FLOAT_IBM390};
            defaultFloatPointFormat = ICobolConstants.FLOAT_IEEE;
            defaultZosFloatPointFormat = ICobolConstants.FLOAT_IBM390;
            super.setValidValues((Object[])validValuesArray);
            this.setDefaultValue(defaultFloatPointFormat);
            this.setValue(defaultFloatPointFormat);
            this.setExpert(true);
        }
        catch (CoreException ex) {
            this.envStatus = new Status(4, "com.ibm.adapter.cobol", 4, ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (((String)evt.getNewValue()).equalsIgnoreCase(ICobolConstants.PLATFORM_ZOS)) {
            try {
                this.setValue(defaultZosFloatPointFormat);
                this.setDefaultValue(defaultZosFloatPointFormat);
            }
            catch (CoreException e) {
                this.envStatus = new Status(4, "com.ibm.adapter.cobol", 4, e.getMessage(), (Throwable)e);
            }
        } else if (((String)evt.getNewValue()).equalsIgnoreCase(ICobolConstants.PLATFORM_WIN) || ((String)evt.getNewValue()).equalsIgnoreCase(ICobolConstants.PLATFORM_AIX)) {
            try {
                this.setValue(defaultFloatPointFormat);
                this.setDefaultValue(defaultFloatPointFormat);
            }
            catch (CoreException e) {
                this.envStatus = new Status(4, "com.ibm.adapter.cobol", 4, e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        boolean valid = false;
        int i = 0;
        while (i < validValuesArray.length) {
            if (((String)evt.getNewValue()).equalsIgnoreCase(validValuesArray[i])) {
                valid = true;
                break;
            }
            ++i;
        }
        if (!valid) {
            throw new PropertyVetoException(CobolMessageResource.INVALID_PROPERTY_VALUE, (java.beans.PropertyChangeEvent)evt);
        }
    }

    public void setValidValues(Object[] values) throws CoreException {
        Status status = new Status(4, ((Object)((Object)this)).getClass().getName(), 4, CobolMessageResource.ERROR_METHOD_NOT_IMPLEMENTED, (Throwable)new Exception(CobolMessageResource.ERROR_METHOD_NOT_IMPLEMENTED));
        throw new CoreException((IStatus)status);
    }
}

