/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.cobol;

import com.ibm.adapter.cobol.CobolMessageResource;
import com.ibm.adapter.cobol.CobolQueryResultNode;
import com.ibm.adapter.cobol.CobolResultSelection;
import com.ibm.adapter.cobol.spi.properties.CobolBaseProperty;
import com.ibm.adapter.cobol.spi.properties.CobolDiscoveryAgentPropertyGroup;
import com.ibm.adapter.cobol.spi.properties.CobolPropertyConverter;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IResultNode;
import com.ibm.adapter.framework.IResultNodeResponse;
import com.ibm.adapter.framework.IResultNodeSelection;
import com.ibm.adapter.framework.spi.BaseResultNodeResponse;
import com.ibm.adapter.framework.spi.BaseSearchTree;
import com.ibm.etools.cobol.COBOLClassifier;
import com.ibm.etools.cobol.COBOLComposedType;
import com.ibm.etools.cobol.COBOLElement;
import com.ibm.etools.cobol.importer.CobolException;
import com.ibm.etools.cobol.importer.ErrorMessageInfo;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class CobolSearchTree
extends BaseSearchTree {
    private boolean isJava = false;
    private Resource importerResource;
    private ArrayList searchResult;

    public CobolSearchTree(Resource resource) throws BaseException {
        try {
            this.importerResource = resource;
            if (resource.getURI().toFileString().toLowerCase().endsWith(".java")) {
                this.isJava = true;
            }
            CobolDiscoveryAgentPropertyGroup group = null;
            group = this.isJava ? new BasePropertyGroup(CobolMessageResource.COBOL_AGENT_PROP_GROUP_NAME, CobolMessageResource.COBOL_AGENT_PROP_GROUP_DISPLAY_NAME, CobolMessageResource.COBOL_AGENT_PROP_GROUP_DESC) : new CobolDiscoveryAgentPropertyGroup();
            this.setFilterProperties((IPropertyGroup)group);
            this.setSelectionStyle(0);
        }
        catch (CoreException e) {
            throw new BaseException(e.getStatus());
        }
    }

    public IResultNodeSelection createResultNodeSelection() {
        return new CobolResultSelection(this.importerResource);
    }

    public IResultNode getResultNode(String location, IEnvironment environment) throws BaseException {
        return null;
    }

    public IResultNodeResponse performQuery(IPropertyGroup searchParameters, IEnvironment environment) throws BaseException {
        if (this.isJava) {
            this.convertJavaFile2QueryResultNodeTree();
        } else {
            Map importProperties = this.convertSearchParams2HashMap(searchParameters);
            this.importCobol(importProperties);
            this.convertCobolModel2QueryResultNodeTree();
        }
        return new BaseResultNodeResponse((List)this.searchResult, "");
    }

    private void convertCobolModel2QueryResultNodeTree() throws BaseException {
        this.searchResult = new ArrayList();
        Iterator typeIterator = this.importerResource.getContents().iterator();
        try {
            while (typeIterator.hasNext()) {
                Object possibleType = typeIterator.next();
                if (!(possibleType instanceof COBOLElement)) continue;
                COBOLElement element = (COBOLElement)possibleType;
                COBOLClassifier classifier = element.getSharedType();
                CobolQueryResultNode node = new CobolQueryResultNode();
                node.setData(this.importerResource.getURIFragment((EObject)element));
                node.setName(element.getName());
                node.setDescription(element.getName());
                node.setSelectable(true);
                this.searchResult.add(node);
                if (!(classifier instanceof COBOLComposedType)) continue;
                this.visitCobolElement((COBOLComposedType)classifier, node);
            }
        }
        catch (Exception e) {
            Status newStatus = new Status(4, "com.ibm.adapter.cobol", 4, String.valueOf(CobolMessageResource.ERROR_WALKING_COBOL_MODEL) + e.getMessage(), (Throwable)e);
            throw new BaseException((IStatus)newStatus);
        }
    }

    private Map convertSearchParams2HashMap(IPropertyGroup searchParameters) {
        HashMap importProperties = new HashMap();
        this.convertSearchParams2HashMap(searchParameters, importProperties);
        return importProperties;
    }

    private void convertSearchParams2HashMap(IPropertyGroup searchParameters, Map importProperties) {
        IPropertyDescriptor[] searchParametersArg = searchParameters.getProperties();
        int arraySize = searchParametersArg.length;
        int i = 0;
        while (i < arraySize) {
            IPropertyDescriptor obj = searchParametersArg[i];
            if (obj instanceof IPropertyGroup) {
                this.convertSearchParams2HashMap((IPropertyGroup)obj, importProperties);
            } else {
                String cobolKey = ((CobolBaseProperty)obj).getCobolKey();
                String cobolValue = (String)((CobolBaseProperty)obj).getValue();
                importProperties.put(cobolKey, CobolPropertyConverter.getCobolValue(cobolValue));
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void importCobol(Map importProperties) throws BaseException {
        block5: {
            block7: {
                block6: {
                    path = new Path(this.importerResource.getURI().toFileString());
                    ifile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                    if (ifile == null) {
                        importProperties.put("com.ibm.etools.cobol.PRE_COBOL_ERRORS_VIEW_NAME", CobolMessageResource.DETAILS_SECTION);
                    }
                    try {
                        this.importerResource.unload();
                        this.importerResource.load(importProperties);
                        break block5;
                    }
                    catch (Exception e) {
                        sb = new StringBuffer();
                        if (!(e instanceof CobolException)) break block6;
                        x = (CobolException)e;
                        sb.append(x.getMessage()).append("\n").append(x.getMessageNote());
                        errorMessageVector = x.getErrorMessagesVector();
                        if (errorMessageVector.size() > 0) {
                            sb.append("\n").append("\n").append(CobolMessageResource.COMPILER_ERRORS);
                        }
                        i = 0;
                        ** while (i < errorMessageVector.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        info = (ErrorMessageInfo)errorMessageVector.get(i);
                        sb.append("\n").append(i + 1).append(". ").append(info.getMessageString());
                        ++i;
                        continue;
lbl27:
                        // 1 sources

                        break block7;
                    }
                }
                sb.append(CobolMessageResource.ERROR_IMPORTING_COBOL_FILE).append(". ").append(e.getMessage());
            }
            newStatus = new Status(4, "com.ibm.adapter.cobol", 4, sb.toString(), (Throwable)e);
            throw new BaseException((IStatus)newStatus);
        }
    }

    private void visitCobolElement(COBOLComposedType composedType, CobolQueryResultNode parentNode) {
        EList elements = composedType.getElement();
        int i = 0;
        while (i < elements.size()) {
            COBOLElement cobolElement;
            COBOLClassifier childClassifier;
            Object childElement = elements.get(i);
            if (childElement instanceof COBOLElement && (childClassifier = (cobolElement = (COBOLElement)childElement).getSharedType()) instanceof COBOLComposedType && cobolElement.getArray() == null) {
                CobolQueryResultNode childNode = new CobolQueryResultNode();
                childNode.setData(this.importerResource.getURIFragment((EObject)cobolElement));
                childNode.setName(cobolElement.getName());
                childNode.setDescription(cobolElement.getName());
                childNode.setSelectable(true);
                parentNode.addChild((IResultNode)childNode);
                this.visitCobolElement((COBOLComposedType)childClassifier, childNode);
            }
            ++i;
        }
    }

    private void convertJavaFile2QueryResultNodeTree() {
        this.searchResult = new ArrayList();
        File file = new File(this.importerResource.getURI().toFileString());
        CobolQueryResultNode node = new CobolQueryResultNode();
        node.setName(file.getName());
        node.setSelectable(true);
        this.searchResult.add(node);
    }
}

