/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.c.ui.preferencepage;

import com.ibm.adapter.c.common.CCodepageHelper;
import com.ibm.adapter.c.common.ICConstants;
import com.ibm.adapter.c.messages.Messages;
import com.ibm.adapter.c.plugin.CDiscoveryAgentPlugin;
import com.ibm.adapter.c.ui.preferencepage.CCodePageSelectionDialog;
import com.ibm.adapter.c.ui.preferencepage.CPreferencePage;
import com.ibm.etools.c.plugin.CPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CPropertiesPage
implements SelectionListener,
ModifyListener {
    public static final String copyright = "Licensed Material - Property of IBM\n com.ibm.adapter.c\n(C) Copyright IBM Corp. 2004 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Combo comboCompiler;
    private org.eclipse.swt.widgets.List listIncldPath;
    private Button buttonCPSelect;
    private Button buttonAdd;
    private Button buttonRemove;
    private Button radioBOLittle;
    private Button radioBOBig;
    private Button radioAS32bit;
    private Button radioAS64bit;
    private Button radioSLD64bit;
    private Button radioSLD128bit;
    private Button radioARNatural;
    private Button radioARPower;
    private Button radioARPacked;
    private Button radioPL1;
    private Button radioPL2;
    private Button radioPL4;
    private Button radioPL8;
    private Button radioPL16;
    private Button checkboxUSArray;
    private Button radioSECompact;
    private Button radioSE1;
    private Button radioSE2;
    private Button radioSE4;
    private Button radioSW2;
    private Button radioSW4;
    private Text textCP;
    private Combo comboFPF;
    private Button radioSENull;
    private Button radioSESpace;
    private final Map<Button, String> STRING_ENCODING_VALUES = new HashMap<Button, String>(2);
    private final Map<Button, String> ADDRESS_SIZE_VALUES = new HashMap<Button, String>(2);
    private final Map<Button, String> LONG_DOUBLE_SIZE_VALUES = new HashMap<Button, String>(2);
    private final Map<Button, String> BYTE_ORDER_VALUES = new HashMap<Button, String>(2);
    private final Map<Button, String> ALIGNMENT_RULE_VALUES = new HashMap<Button, String>(3);
    private final Map<Button, String> PACK_LEVEL_VALUES = new HashMap<Button, String>(5);
    private final Map<Button, String> SIZE_ENUM_VALUES = new HashMap<Button, String>(4);
    private final Map<Button, String> SIZE_WCHAR_VALUES = new HashMap<Button, String>(2);
    private static final List<String> COMPILER_VALUES = new ArrayList<String>(6);
    private static final List<String> FLOATING_PT_VALUES = new ArrayList<String>(7);
    private DialogPage parentPage;
    private Map<String, String> compilerDefaults = null;
    private boolean controlsCreated = false;

    public CPropertiesPage(DialogPage page) {
        this.parentPage = page;
    }

    public Text getCodePageField() {
        return this.textCP;
    }

    private void initializePreferenceStoreValuesPage1() {
        COMPILER_VALUES.add("(Unspecified)");
        COMPILER_VALUES.add("Msvc");
        COMPILER_VALUES.add("icc");
        COMPILER_VALUES.add("AIXgcc");
        COMPILER_VALUES.add("AIXxlc");
        COMPILER_VALUES.add("OS390");
        FLOATING_PT_VALUES.add("IEEE Extended INTEL");
        FLOATING_PT_VALUES.add("IEEE Extended AIX");
        FLOATING_PT_VALUES.add("IEEE Extended OS/390");
        FLOATING_PT_VALUES.add("IEEE Non-Extended");
        FLOATING_PT_VALUES.add("IBM 390 Hexadecimal");
        this.STRING_ENCODING_VALUES.put(this.radioSENull, "NULL");
        this.STRING_ENCODING_VALUES.put(this.radioSESpace, "SPACE");
        this.BYTE_ORDER_VALUES.put(this.radioBOLittle, "Little Endian");
        this.BYTE_ORDER_VALUES.put(this.radioBOBig, "Big Endian");
    }

    private void initializePreferenceStoreValuesPage2() {
        this.ADDRESS_SIZE_VALUES.put(this.radioAS32bit, "32");
        this.ADDRESS_SIZE_VALUES.put(this.radioAS64bit, "64");
        this.LONG_DOUBLE_SIZE_VALUES.put(this.radioSLD64bit, "64");
        this.LONG_DOUBLE_SIZE_VALUES.put(this.radioSLD128bit, "128");
        this.ALIGNMENT_RULE_VALUES.put(this.radioARNatural, "Natural");
        this.ALIGNMENT_RULE_VALUES.put(this.radioARPower, "Power");
        this.ALIGNMENT_RULE_VALUES.put(this.radioARPacked, "Packed");
        this.PACK_LEVEL_VALUES.put(this.radioPL1, "1");
        this.PACK_LEVEL_VALUES.put(this.radioPL2, "2");
        this.PACK_LEVEL_VALUES.put(this.radioPL4, "4");
        this.PACK_LEVEL_VALUES.put(this.radioPL8, "8");
        this.PACK_LEVEL_VALUES.put(this.radioPL16, "16");
        this.SIZE_ENUM_VALUES.put(this.radioSE1, "1");
        this.SIZE_ENUM_VALUES.put(this.radioSE2, "2");
        this.SIZE_ENUM_VALUES.put(this.radioSE4, "4");
        this.SIZE_ENUM_VALUES.put(this.radioSECompact, "5");
        this.SIZE_WCHAR_VALUES.put(this.radioSW2, "2");
        this.SIZE_WCHAR_VALUES.put(this.radioSW4, "4");
    }

    public Control createContents(Composite parent) {
        Composite composite = this.createComposite(parent, 1, true);
        this.createTabControl(composite);
        composite.pack(true);
        composite.layout(true);
        return composite;
    }

    private void createTabControl(Composite parent) {
        TabFolder folder = new TabFolder(parent, 0);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        folder.setLayoutData((Object)data);
        TabItem item = new TabItem(folder, 0);
        item.setText(Messages.getString("TAB1_LABEL"));
        item.setControl(this.createPage1Contents((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(Messages.getString("TAB2_LABEL"));
        item.setControl(this.createPage2Contents((Composite)folder));
    }

    public Control createPage1Contents(Composite parent) {
        Composite main = this.createComposite(parent, 1, false);
        Composite comboComposit = this.createComposite(main, 2, false);
        this.comboCompiler = this.createCombo(comboComposit, Messages.getString("PLATFORM_DISPLAY_NAME"));
        this.comboCompiler.setToolTipText(Messages.getString("PLATFORM_DESCRIPTION"));
        this.comboFPF = this.createCombo(comboComposit, Messages.getString("FLOATING_POINT_FORMAT_DISPLAY_NAME"));
        this.comboFPF.setToolTipText(Messages.getString("FLOATING_POINT_FORMAT_DESCRIPTION"));
        Composite textComposit = this.createComposite(main, 3, false);
        this.textCP = this.createText(textComposit, Messages.getString("CODEPAGE_DISPLAY_NAME"));
        this.textCP.setToolTipText(Messages.getString("CODEPAGE_DESCRIPTION"));
        this.buttonCPSelect = this.createPushButton(textComposit, Messages.getString("SELECT_BUTTON"));
        this.buttonCPSelect.setToolTipText(Messages.getString("CODEPAGE_DESCRIPTION"));
        this.checkboxUSArray = this.createCheckBox(main, Messages.getString("US_SHORT_ARRAYS_DBCS_DISPLAY_NAME"));
        this.checkboxUSArray.setToolTipText(Messages.getString("US_SHORT_ARRAYS_DBCS_DESCRIPTION"));
        this.createStringEncoding(main);
        this.createByteOrder(main);
        main.pack(true);
        main.layout(true);
        this.initializePreferenceStoreValuesPage1();
        this.initializeValuesPage1();
        return main;
    }

    public Control createPage2Contents(Composite parent) {
        Composite main = this.createComposite(parent, 1, false);
        Label lbl1 = new Label(main, 0);
        lbl1.setText(Messages.getString("INCLUDE_PATH_DISPLAY_NAME"));
        lbl1.setToolTipText(Messages.getString("INCLUDE_PATH_DESCRIPTION"));
        Composite listComposit = this.createComposite(main, 2, false);
        this.listIncldPath = this.createListBox(listComposit);
        this.listIncldPath.setToolTipText(Messages.getString("INCLUDE_PATH_DESCRIPTION"));
        Composite buttonComposit = this.createComposite(listComposit, 1, true);
        this.buttonAdd = this.createPushButton(buttonComposit, Messages.getString("ADD_BUTTON"));
        this.buttonAdd.setToolTipText(Messages.getString("INCLUDE_PATH_DESCRIPTION"));
        this.buttonRemove = this.createPushButton(buttonComposit, Messages.getString("REMOVE_BUTTON"));
        this.buttonRemove.setToolTipText(Messages.getString("INCLUDE_PATH_DESCRIPTION"));
        this.createAddressSize(listComposit);
        this.createSizeOfLongDouble(listComposit);
        this.createAlignRule(listComposit);
        this.createPackLevel(listComposit);
        this.createSizeOfEnumConstant(listComposit);
        this.createSizeOfWChar(listComposit);
        this.controlsCreated = true;
        main.pack(true);
        main.layout(true);
        this.initializePreferenceStoreValuesPage2();
        this.initializeValuesPage2();
        if (this.compilerDefaults != null) {
            this.setPage2Values(this.compilerDefaults);
        }
        return main;
    }

    private Composite createComposite(Composite parent, int numColumns, boolean bGrabExcessVert) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginHeight = 3;
        layout.marginWidth = 5;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        if (bGrabExcessVert) {
            data.grabExcessVerticalSpace = true;
        }
        composite.setLayoutData((Object)data);
        return composite;
    }

    private Group createGroup(Composite parent, int numColumns, String label) {
        Group composite = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        composite.setText(label);
        return composite;
    }

    private Text createText(Composite parent, String label) {
        Label lbl = new Label(parent, 0);
        lbl.setText(label);
        Text textField = new Text(parent, 2052);
        GridData gd = new GridData(768);
        textField.setLayoutData((Object)gd);
        textField.addSelectionListener((SelectionListener)this);
        textField.addModifyListener((ModifyListener)this);
        return textField;
    }

    private Combo createCombo(Composite parent, String label) {
        Label lbl = new Label(parent, 0);
        lbl.setText(label);
        Combo combo = new Combo(parent, 12);
        combo.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(768);
        combo.setLayoutData((Object)gd);
        combo.addSelectionListener((SelectionListener)this);
        return combo;
    }

    private Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.addSelectionListener((SelectionListener)this);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    private Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16);
        button.setText(label);
        button.addSelectionListener((SelectionListener)this);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    private Button createCheckBox(Composite parent, String label) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.addSelectionListener((SelectionListener)this);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    private void createStringEncoding(Composite parent) {
        Group group = this.createGroup(parent, 2, Messages.getString("STRING_ENCODING_DISPLAY_NAME"));
        group.setToolTipText(Messages.getString("STRING_ENCODING_DESCRIPTION"));
        this.radioSENull = this.createRadioButton((Composite)group, Messages.getString("STRING_ENCODING_NULL_NAME"));
        this.radioSESpace = this.createRadioButton((Composite)group, Messages.getString("STRING_ENCODING_SPACE_NAME"));
    }

    private org.eclipse.swt.widgets.List createListBox(Composite parent) {
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(parent, 2820);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        list.setLayoutData((Object)data);
        list.addSelectionListener((SelectionListener)this);
        return list;
    }

    private void createAddressSize(Composite parent) {
        Group group = this.createGroup(parent, 2, Messages.getString("ADDRESS_SIZE_DISPLAY_NAME"));
        group.setToolTipText(Messages.getString("ADDRESS_SIZE_DESCRIPTION"));
        this.radioAS32bit = this.createRadioButton((Composite)group, Messages.getString("ADDRESS_SIZE_MODE_32_NAME"));
        this.radioAS64bit = this.createRadioButton((Composite)group, Messages.getString("ADDRESS_SIZE_MODE_64_NAME"));
    }

    private void createSizeOfLongDouble(Composite parent) {
        Group group = this.createGroup(parent, 2, Messages.getString("SIZE_OF_LONG_DOUBLE_DISPLAY_NAME"));
        group.setToolTipText(Messages.getString("SIZE_OF_LONG_DOUBLE_DESCRIPTION"));
        this.radioSLD64bit = this.createRadioButton((Composite)group, Messages.getString("SIZE_OF_LONG_DOUBLE_64_BIT_NAME"));
        this.radioSLD128bit = this.createRadioButton((Composite)group, Messages.getString("SIZE_OF_LONG_DOUBLE_128_BIT_NAME"));
    }

    private void createByteOrder(Composite parent) {
        Group group = this.createGroup(parent, 2, Messages.getString("ENDIAN_DISPLAY_NAME"));
        group.setToolTipText(Messages.getString("ENDIAN_DESCRIPTION"));
        this.radioBOLittle = this.createRadioButton((Composite)group, Messages.getString("ENDIAN_LITTLE_NAME"));
        this.radioBOBig = this.createRadioButton((Composite)group, Messages.getString("ENDIAN_BIG_NAME"));
    }

    private void createSizeOfEnumConstant(Composite parent) {
        Group group = this.createGroup(parent, 4, Messages.getString("SIZE_OF_ENUM_DISPLAY_NAME"));
        group.setToolTipText(Messages.getString("SIZE_OF_ENUM_DESCRIPTION"));
        this.radioSECompact = this.createRadioButton((Composite)group, Messages.getString("SIZE_OF_ENUM_COMPACT_NAME"));
        this.radioSE1 = this.createRadioButton((Composite)group, Messages.getString("SIZE_OF_ENUM_1_NAME"));
        this.radioSE2 = this.createRadioButton((Composite)group, Messages.getString("SIZE_OF_ENUM_2_NAME"));
        this.radioSE4 = this.createRadioButton((Composite)group, Messages.getString("SIZE_OF_ENUM_4_NAME"));
    }

    private void createSizeOfWChar(Composite parent) {
        Group group = this.createGroup(parent, 2, Messages.getString("SIZE_OF_WCHAR_DISPLAY_NAME"));
        group.setToolTipText(Messages.getString("SIZE_OF_WCHAR_DESCRIPTION"));
        this.radioSW2 = this.createRadioButton((Composite)group, Messages.getString("SIZE_OF_WCHAR_2_BYTES_NAME"));
        this.radioSW4 = this.createRadioButton((Composite)group, Messages.getString("SIZE_OF_WCHAR_4_BYTES_NAME"));
    }

    private void createAlignRule(Composite parent) {
        Group group = this.createGroup(parent, 3, Messages.getString("ALIGNMENT_RULE_DISPLAY_NAME"));
        group.setToolTipText(Messages.getString("ALIGNMENT_RULE_DESCRIPTION"));
        this.radioARNatural = this.createRadioButton((Composite)group, Messages.getString("ALIGNMENT_RULE_NATURAL_NAME"));
        this.radioARPower = this.createRadioButton((Composite)group, Messages.getString("ALIGNMENT_RULE_POWER_NAME"));
        this.radioARPacked = this.createRadioButton((Composite)group, Messages.getString("ALIGNMENT_RULE_PACKED_NAME"));
    }

    private void createPackLevel(Composite parent) {
        Group group = this.createGroup(parent, 5, Messages.getString("PACK_LEVEL_DISPLAY_NAME"));
        group.setToolTipText(Messages.getString("PACK_LEVEL_DESCRIPTION"));
        this.radioPL1 = this.createRadioButton((Composite)group, Messages.getString("PACK_LEVEL_1_NAME"));
        this.radioPL2 = this.createRadioButton((Composite)group, Messages.getString("PACK_LEVEL_2_NAME"));
        this.radioPL4 = this.createRadioButton((Composite)group, Messages.getString("PACK_LEVEL_4_NAME"));
        this.radioPL8 = this.createRadioButton((Composite)group, Messages.getString("PACK_LEVEL_8_NAME"));
        this.radioPL16 = this.createRadioButton((Composite)group, Messages.getString("PACK_LEVEL_16_NAME"));
    }

    public void widgetSelected(SelectionEvent e) {
        this.parentPage.setErrorMessage(null);
        Object source = e.getSource();
        if (source == this.buttonAdd) {
            String work = this.displayDirectoryDialog();
            this.addToList(this.listIncldPath, work);
            this.setRemoveButtonState();
        } else if (source == this.buttonRemove) {
            this.removeFromList();
        } else if (source == this.buttonCPSelect) {
            this.selectCP(this.textCP);
        } else if (source == this.radioARNatural || source == this.radioARPower || source == this.radioARPacked) {
            this.setPackLevelEnabled(this.radioARPacked.getSelection());
        } else if (source == this.comboCompiler) {
            this.setCompilerDefaults(this.comboCompiler.getSelectionIndex());
        } else if (source == this.listIncldPath) {
            this.setRemoveButtonState();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource() == this.textCP && this.parentPage instanceof CPreferencePage) {
            ((CPreferencePage)this.parentPage).validate();
        }
    }

    private void setCompilerDefaults(int selection) {
        this.setCompilerDefaultsPage1(selection);
        this.setCompilerDefaultsPage2(selection);
    }

    private void setCompilerDefaultsPage1(int selection) {
        switch (selection) {
            case 1: {
                this.radioSENull.setSelection(true);
                this.radioSESpace.setSelection(false);
                this.comboFPF.select(0);
                this.radioBOLittle.setSelection(true);
                this.radioBOBig.setSelection(false);
                this.textCP.setText(Messages.getString("CODEPAGE_DEFAULT_VALUE_WIN"));
                break;
            }
            case 2: {
                this.radioSENull.setSelection(true);
                this.radioSESpace.setSelection(false);
                this.comboFPF.select(0);
                this.radioBOLittle.setSelection(true);
                this.radioBOBig.setSelection(false);
                this.textCP.setText(Messages.getString("CODEPAGE_DEFAULT_VALUE_WIN"));
                break;
            }
            case 3: {
                this.radioSENull.setSelection(true);
                this.radioSESpace.setSelection(false);
                this.comboFPF.select(1);
                this.radioBOLittle.setSelection(false);
                this.radioBOBig.setSelection(true);
                this.textCP.setText(Messages.getString("CODEPAGE_DEFAULT_VALUE_AIX"));
                break;
            }
            case 4: {
                this.radioSENull.setSelection(true);
                this.radioSESpace.setSelection(false);
                this.comboFPF.select(1);
                this.radioBOLittle.setSelection(false);
                this.radioBOBig.setSelection(true);
                this.textCP.setText(Messages.getString("CODEPAGE_DEFAULT_VALUE_AIX"));
                break;
            }
            case 5: {
                this.radioSENull.setSelection(false);
                this.radioSESpace.setSelection(true);
                this.comboFPF.select(4);
                this.radioBOLittle.setSelection(false);
                this.radioBOBig.setSelection(true);
                this.textCP.setText(Messages.getString("CODEPAGE_DEFAULT_VALUE_OS390"));
            }
        }
    }

    public void setCompilerDefaultsPage2(int selection) {
        if (this.compilerDefaults == null) {
            this.compilerDefaults = new HashMap<String, String>();
        }
        switch (selection) {
            case 1: {
                this.compilerDefaults.put("com.ibm.etools.c.C_SIZE_OF_LONG_DOUBLE", "64");
                this.compilerDefaults.put("com.ibm.etools.c.C_ALIGNMENT_RULE", "Packed");
                this.compilerDefaults.put("com.ibm.etools.c.C_PACK_LEVEL", "8");
                this.compilerDefaults.put("com.ibm.etools.c.C_SIZE_OF_ENUM", "4");
                this.compilerDefaults.put("com.ibm.etools.c.C_SIZE_OF_WCHAR", "2");
                break;
            }
            case 2: {
                this.compilerDefaults.put("com.ibm.etools.c.C_SIZE_OF_LONG_DOUBLE", "128");
                this.compilerDefaults.put("com.ibm.etools.c.C_ALIGNMENT_RULE", "Packed");
                this.compilerDefaults.put("com.ibm.etools.c.C_PACK_LEVEL", "8");
                this.compilerDefaults.put("com.ibm.etools.c.C_SIZE_OF_ENUM", "5");
                this.compilerDefaults.put("com.ibm.etools.c.C_SIZE_OF_WCHAR", "2");
                break;
            }
            case 3: {
                this.compilerDefaults.put("com.ibm.etools.c.C_SIZE_OF_LONG_DOUBLE", "64");
                this.compilerDefaults.put("com.ibm.etools.c.C_ALIGNMENT_RULE", "Packed");
                this.compilerDefaults.put("com.ibm.etools.c.C_PACK_LEVEL", "4");
                this.compilerDefaults.put("com.ibm.etools.c.C_SIZE_OF_ENUM", "4");
                this.compilerDefaults.put("com.ibm.etools.c.C_SIZE_OF_WCHAR", "2");
                break;
            }
            case 4: {
                this.compilerDefaults.put("com.ibm.etools.c.C_SIZE_OF_LONG_DOUBLE", "64");
                this.compilerDefaults.put("com.ibm.etools.c.C_ALIGNMENT_RULE", "Power");
                this.compilerDefaults.put("com.ibm.etools.c.C_SIZE_OF_ENUM", "4");
                this.compilerDefaults.put("com.ibm.etools.c.C_SIZE_OF_WCHAR", "2");
                break;
            }
            case 5: {
                this.compilerDefaults.put("com.ibm.etools.c.C_SIZE_OF_LONG_DOUBLE", "64");
                this.compilerDefaults.put("com.ibm.etools.c.C_ALIGNMENT_RULE", "Packed");
                this.compilerDefaults.put("com.ibm.etools.c.C_PACK_LEVEL", "1");
                this.compilerDefaults.put("com.ibm.etools.c.C_SIZE_OF_ENUM", "4");
                this.compilerDefaults.put("com.ibm.etools.c.C_SIZE_OF_WCHAR", "2");
            }
        }
        if (this.controlsCreated) {
            this.setPage2Values(this.compilerDefaults);
        }
    }

    private void setPage2Values(Map<String, String> values) {
        String work = values.get("com.ibm.etools.c.C_ADDRESS_SIZE");
        if (work != null) {
            if (work.equals("64")) {
                this.radioAS32bit.setSelection(false);
                this.radioAS64bit.setSelection(true);
            } else {
                this.radioAS32bit.setSelection(true);
                this.radioAS64bit.setSelection(false);
            }
        }
        if ((work = values.get("com.ibm.etools.c.C_SIZE_OF_LONG_DOUBLE")) != null) {
            if (work.equals("128")) {
                this.radioSLD64bit.setSelection(false);
                this.radioSLD128bit.setSelection(true);
            } else {
                this.radioSLD64bit.setSelection(true);
                this.radioSLD128bit.setSelection(false);
            }
        }
        if ((work = values.get("com.ibm.etools.c.C_ALIGNMENT_RULE")) != null) {
            this.disableAlignmentButtons();
            if (work.equals("Power")) {
                this.radioARPower.setSelection(true);
            } else if (work.equals("Packed")) {
                this.radioARPacked.setSelection(true);
            } else {
                this.radioARNatural.setSelection(true);
            }
        }
        this.setPackLevelEnabled(this.radioARPacked.getSelection());
        work = values.get("com.ibm.etools.c.C_PACK_LEVEL");
        if (work != null) {
            this.disablePackButtons();
            if (work.equals("2")) {
                this.radioPL2.setSelection(true);
            } else if (work.equals("4")) {
                this.radioPL4.setSelection(true);
            } else if (work.equals("8")) {
                this.radioPL8.setSelection(true);
            } else if (work.equals("16")) {
                this.radioPL16.setSelection(true);
            } else {
                this.radioPL1.setSelection(true);
            }
        }
        if ((work = values.get("com.ibm.etools.c.C_SIZE_OF_ENUM")) != null) {
            this.disableSizeEnumButtons();
            if (work.equals("1")) {
                this.radioSE1.setSelection(true);
            } else if (work.equals("2")) {
                this.radioSE2.setSelection(true);
            } else if (work.equals("5")) {
                this.radioSECompact.setSelection(true);
            } else {
                this.radioSE4.setSelection(true);
            }
        }
        if ((work = values.get("com.ibm.etools.c.C_SIZE_OF_WCHAR")) != null) {
            if (work.equals("4")) {
                this.radioSW2.setSelection(false);
                this.radioSW4.setSelection(true);
            } else {
                this.radioSW2.setSelection(true);
                this.radioSW4.setSelection(false);
            }
        }
    }

    private void disablePackButtons() {
        this.radioPL1.setSelection(false);
        this.radioPL2.setSelection(false);
        this.radioPL4.setSelection(false);
        this.radioPL8.setSelection(false);
        this.radioPL16.setSelection(false);
    }

    private void disableAlignmentButtons() {
        this.radioARNatural.setSelection(false);
        this.radioARPacked.setSelection(false);
        this.radioARPower.setSelection(false);
    }

    private void disableStringEncodingButtons() {
        this.radioSENull.setSelection(false);
        this.radioSESpace.setSelection(false);
    }

    private void disableByteOrderButtons() {
        this.radioBOLittle.setSelection(false);
        this.radioBOBig.setSelection(false);
    }

    private void disableSizeEnumButtons() {
        this.radioSE1.setSelection(false);
        this.radioSE2.setSelection(false);
        this.radioSE4.setSelection(false);
        this.radioSECompact.setSelection(false);
    }

    private IPreferenceStore getPreferenceStore() {
        return CPlugin.getDefault().getPreferenceStore();
    }

    private void initializeValuesPage1() {
        IPreferenceStore store = this.getPreferenceStore();
        String work = new String(store.getString("com.ibm.etools.c.C_COMPILER_NAME"));
        int i = 0;
        while (i < ICConstants.COMPILER_DISPLAY_VALUES.length) {
            this.comboCompiler.add(ICConstants.COMPILER_DISPLAY_VALUES[i]);
            ++i;
        }
        int match = COMPILER_VALUES.indexOf(work);
        if (match < 0) {
            match = 0;
        }
        this.comboCompiler.select(match);
        work = new String(store.getString("com.ibm.etools.c.C_FLOATING_POINT_FORMAT"));
        int i2 = 0;
        while (i2 < ICConstants.FPF_DISPLAY_VALUES.length) {
            this.comboFPF.add(ICConstants.FPF_DISPLAY_VALUES[i2]);
            ++i2;
        }
        match = FLOATING_PT_VALUES.indexOf(work);
        if (match < 0) {
            match = 0;
        }
        this.comboFPF.select(match);
        work = new String(store.getString("com.ibm.etools.c.C_CODEPAGE"));
        if (work != null && work.length() > 0) {
            this.textCP.setText(work);
        } else {
            this.textCP.setText(Messages.getString("CODEPAGE_DEFAULT_VALUE"));
        }
        this.disableStringEncodingButtons();
        work = new String(store.getString("com.ibm.etools.c.C_STRING_ENCODING"));
        if (work != null) {
            Button b = (Button)this.getKey(this.STRING_ENCODING_VALUES, work);
            if (b != null) {
                b.setSelection(true);
            } else {
                this.radioSENull.setSelection(true);
            }
        }
        if ((work = new String(store.getString("com.ibm.etools.c.C_US_SHORT_ARRAYS_DBCS"))) != null && work.equals("TRUE")) {
            this.checkboxUSArray.setSelection(true);
        } else {
            this.checkboxUSArray.setSelection(false);
        }
        this.disableByteOrderButtons();
        work = new String(store.getString("com.ibm.etools.c.C_BYTE_ORDER"));
        if (work != null) {
            Button b = (Button)this.getKey(this.BYTE_ORDER_VALUES, work);
            if (b != null) {
                b.setSelection(true);
            } else {
                this.radioBOLittle.setSelection(true);
            }
        }
    }

    private void initializeValuesPage2() {
        Button b;
        int iValue = 0;
        IPreferenceStore store = this.getPreferenceStore();
        String work = new String(store.getString("com.ibm.etools.c.C_INCLUDE_PATH"));
        this.loadList(this.listIncldPath, work);
        this.setRemoveButtonState();
        iValue = store.getInt("com.ibm.etools.c.C_ADDRESS_SIZE");
        switch (iValue) {
            case 32: {
                this.radioAS32bit.setSelection(true);
                this.radioAS64bit.setSelection(false);
                break;
            }
            case 64: {
                this.radioAS32bit.setSelection(false);
                this.radioAS64bit.setSelection(true);
                break;
            }
            default: {
                this.radioAS32bit.setSelection(true);
                this.radioAS64bit.setSelection(false);
            }
        }
        iValue = store.getInt("com.ibm.etools.c.C_SIZE_OF_LONG_DOUBLE");
        switch (iValue) {
            case 64: {
                this.radioSLD64bit.setSelection(true);
                this.radioSLD128bit.setSelection(false);
                break;
            }
            case 128: {
                this.radioSLD64bit.setSelection(false);
                this.radioSLD128bit.setSelection(true);
                break;
            }
            default: {
                this.radioSLD64bit.setSelection(true);
                this.radioSLD128bit.setSelection(false);
            }
        }
        this.disableAlignmentButtons();
        work = new String(store.getString("com.ibm.etools.c.C_ALIGNMENT_RULE"));
        if (work != null) {
            b = (Button)this.getKey(this.ALIGNMENT_RULE_VALUES, work);
            if (b != null) {
                b.setSelection(true);
            } else {
                this.radioARNatural.setSelection(true);
            }
        }
        this.disablePackButtons();
        work = new String(store.getString("com.ibm.etools.c.C_PACK_LEVEL"));
        if (work != null) {
            b = (Button)this.getKey(this.PACK_LEVEL_VALUES, work);
            if (b != null) {
                b.setSelection(true);
            } else {
                this.radioPL1.setSelection(true);
            }
        }
        this.setPackLevelEnabled(this.radioARPacked.getSelection());
        this.disableSizeEnumButtons();
        work = new String(store.getString("com.ibm.etools.c.C_SIZE_OF_ENUM"));
        if (work != null) {
            b = (Button)this.getKey(this.SIZE_ENUM_VALUES, work);
            if (b != null) {
                b.setSelection(true);
            } else {
                this.radioSE4.setSelection(true);
            }
        }
        if ((work = new String(store.getString("com.ibm.etools.c.C_SIZE_OF_WCHAR"))) != null) {
            b = (Button)this.getKey(this.SIZE_WCHAR_VALUES, work);
            if (b == this.radioSW4) {
                this.radioSW4.setSelection(true);
                this.radioSW2.setSelection(false);
            } else {
                this.radioSW2.setSelection(true);
                this.radioSW4.setSelection(false);
            }
        }
    }

    private void addToList(org.eclipse.swt.widgets.List listIncldPath, String aString) {
        String work = new String("");
        int itemCount = 0;
        if (listIncldPath != null && aString != null && aString.length() > 0) {
            boolean bItemExist = false;
            itemCount = listIncldPath.getItemCount();
            int i = 0;
            while (i < itemCount) {
                work = listIncldPath.getItem(i);
                if (work.compareToIgnoreCase(aString) == 0) {
                    bItemExist = true;
                }
                ++i;
            }
            if (!bItemExist) {
                listIncldPath.add(aString);
            }
        }
    }

    private void loadList(org.eclipse.swt.widgets.List listIncldPath, String aString) {
        int startix = 0;
        int endix = 0;
        int count = 0;
        if (listIncldPath != null && aString != null && aString.length() > 0) {
            int ix = aString.indexOf(ICConstants.INCLUDE_PATH_SEPARATOR);
            if (ix < 0) {
                listIncldPath.add(aString.substring(startix));
            }
            while (ix > 0) {
                endix = ix;
                listIncldPath.add(aString.substring(startix, endix));
                startix = ix + 1;
                ix = aString.indexOf(ICConstants.INCLUDE_PATH_SEPARATOR, startix);
                if (ix < 1 && endix < aString.length()) {
                    endix = aString.length();
                    listIncldPath.add(aString.substring(startix, endix));
                }
                if (++count <= 1000) continue;
                ix = -1;
            }
        }
    }

    private Object getKey(Map map, Object value) {
        Object obj = null;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext() && obj == null) {
            obj = iterator.next();
            if (map.get(obj).equals(value)) continue;
            obj = null;
        }
        return obj;
    }

    private String displayDirectoryDialog() {
        String work = new String("");
        DirectoryDialog myDirectoryDialog = new DirectoryDialog(this.listIncldPath.getShell());
        work = myDirectoryDialog.open();
        return work;
    }

    private void selectCP(Text textCP) {
        int rtnBtn;
        CCodePageSelectionDialog ccpsd;
        if (textCP != null && (ccpsd = new CCodePageSelectionDialog(new Shell(), textCP.getText())) != null && (rtnBtn = ccpsd.open()) == 0) {
            textCP.setText((String)ccpsd.getSelectedObject());
        }
    }

    private void setPackLevelEnabled(boolean enabled) {
        this.radioPL1.setEnabled(enabled);
        this.radioPL2.setEnabled(enabled);
        this.radioPL4.setEnabled(enabled);
        this.radioPL8.setEnabled(enabled);
        this.radioPL16.setEnabled(enabled);
    }

    public void performDefaults() {
        this.performDefaultsPage1();
        this.performDefaultsPage2();
    }

    public void performDefaultsPage1() {
        this.comboCompiler.select(0);
        this.comboFPF.select(0);
        this.textCP.setText(Messages.getString("CODEPAGE_DEFAULT_VALUE"));
        this.radioSENull.setSelection(true);
        this.radioSESpace.setSelection(false);
        this.checkboxUSArray.setSelection(false);
        this.radioBOLittle.setSelection(true);
        this.radioBOBig.setSelection(false);
        this.parentPage.setErrorMessage(null);
    }

    public void performDefaultsPage2() {
        this.listIncldPath.removeAll();
        this.radioAS32bit.setSelection(true);
        this.radioAS64bit.setSelection(false);
        this.radioSLD64bit.setSelection(true);
        this.radioSLD128bit.setSelection(false);
        this.radioARNatural.setSelection(true);
        this.radioARPower.setSelection(false);
        this.radioARPacked.setSelection(false);
        this.radioPL1.setSelection(true);
        this.radioPL2.setSelection(false);
        this.radioPL4.setSelection(false);
        this.radioPL8.setSelection(false);
        this.radioPL16.setSelection(false);
        this.setPackLevelEnabled(false);
        this.radioSE1.setSelection(false);
        this.radioSE2.setSelection(false);
        this.radioSE4.setSelection(true);
        this.radioSECompact.setSelection(false);
        this.radioSW2.setSelection(true);
        this.radioSW4.setSelection(false);
        this.parentPage.setErrorMessage(null);
        this.setRemoveButtonState();
    }

    public Vector getValidationErrorMessages() {
        Vector<Object> errorMessages = new Vector(50);
        errorMessages = this.getCodepageValidationErrorMessages();
        return errorMessages;
    }

    public Vector<String> getCodepageValidationErrorMessages() {
        Vector<String> errorMessages = new Vector<String>(1);
        String[] sa = CCodepageHelper.getInstance().findCCodePages();
        boolean match = false;
        int i = 0;
        while (i < sa.length) {
            if (this.textCP.getText().equals(sa[i])) {
                match = true;
                break;
            }
            ++i;
        }
        if (!match) {
            errorMessages.add(Messages.getString("ERROR_INVALID_CODEPAGE"));
        }
        return errorMessages;
    }

    private void removeFromList() {
        if (this.listIncldPath != null) {
            int selection = this.listIncldPath.getSelectionCount();
            if (selection < 1) {
                this.parentPage.setErrorMessage(CDiscoveryAgentPlugin.getResourceString("WARNING_INCLUDE_PATH_SELECTION"));
            } else {
                selection = this.listIncldPath.getSelectionIndex();
                this.listIncldPath.remove(selection);
                this.setRemoveButtonState();
            }
        }
    }

    protected void setRemoveButtonState() {
        if (this.listIncldPath != null) {
            int itemCount = this.listIncldPath.getSelectionCount();
            if (itemCount > 0) {
                this.buttonRemove.setEnabled(true);
            } else {
                this.buttonRemove.setEnabled(false);
            }
        }
    }

    public Map<String, String> getValues() {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        this.getValuesPage1(propertyMap);
        return this.getValuesPage2(propertyMap);
    }

    public Map<String, String> getValuesPage1(Map<String, String> propertyMap) {
        if (this.comboCompiler.getSelectionIndex() >= 0) {
            propertyMap.put("com.ibm.etools.c.C_COMPILER_NAME", COMPILER_VALUES.get(this.comboCompiler.getSelectionIndex()));
        } else {
            propertyMap.put("com.ibm.etools.c.C_COMPILER_NAME", COMPILER_VALUES.get(0));
        }
        propertyMap.put("com.ibm.etools.c.C_CODEPAGE", this.textCP.getText());
        if (this.comboFPF.getSelectionIndex() >= 0) {
            propertyMap.put("com.ibm.etools.c.C_FLOATING_POINT_FORMAT", FLOATING_PT_VALUES.get(this.comboFPF.getSelectionIndex()));
        } else {
            propertyMap.put("com.ibm.etools.c.C_FLOATING_POINT_FORMAT", FLOATING_PT_VALUES.get(0));
        }
        if (this.radioSENull.getSelection()) {
            propertyMap.put("com.ibm.etools.c.C_STRING_ENCODING", this.STRING_ENCODING_VALUES.get(this.radioSENull));
        } else {
            propertyMap.put("com.ibm.etools.c.C_STRING_ENCODING", this.STRING_ENCODING_VALUES.get(this.radioSESpace));
        }
        if (this.checkboxUSArray.getSelection()) {
            propertyMap.put("com.ibm.etools.c.C_US_SHORT_ARRAYS_DBCS", "TRUE");
        } else {
            propertyMap.put("com.ibm.etools.c.C_US_SHORT_ARRAYS_DBCS", "FALSE");
        }
        if (this.radioBOBig.getSelection()) {
            propertyMap.put("com.ibm.etools.c.C_BYTE_ORDER", this.BYTE_ORDER_VALUES.get(this.radioBOBig));
        } else {
            propertyMap.put("com.ibm.etools.c.C_BYTE_ORDER", this.BYTE_ORDER_VALUES.get(this.radioBOLittle));
        }
        return propertyMap;
    }

    public Map<String, String> getValuesPage2(Map<String, String> propertyMap) {
        int itemCount = 0;
        int iValue = 0;
        if (this.listIncldPath != null && propertyMap != null) {
            String work = new String("");
            itemCount = this.listIncldPath.getItemCount();
            int i = 0;
            while (i < itemCount) {
                if (i == itemCount - 1) {
                    work = String.valueOf(work) + this.listIncldPath.getItem(i);
                } else {
                    work = String.valueOf(work) + this.listIncldPath.getItem(i);
                    work = String.valueOf(work) + ICConstants.INCLUDE_PATH_SEPARATOR;
                }
                ++i;
            }
            propertyMap.put("com.ibm.etools.c.C_INCLUDE_PATH", work);
            if (this.radioAS32bit.getSelection()) {
                propertyMap.put("com.ibm.etools.c.C_ADDRESS_SIZE", this.ADDRESS_SIZE_VALUES.get(this.radioAS32bit));
            } else {
                propertyMap.put("com.ibm.etools.c.C_ADDRESS_SIZE", this.ADDRESS_SIZE_VALUES.get(this.radioAS64bit));
            }
            if (this.radioSLD128bit.getSelection()) {
                propertyMap.put("com.ibm.etools.c.C_SIZE_OF_LONG_DOUBLE", this.LONG_DOUBLE_SIZE_VALUES.get(this.radioSLD128bit));
            } else {
                propertyMap.put("com.ibm.etools.c.C_SIZE_OF_LONG_DOUBLE", this.LONG_DOUBLE_SIZE_VALUES.get(this.radioSLD64bit));
            }
            if (this.radioARNatural.getSelection()) {
                propertyMap.put("com.ibm.etools.c.C_ALIGNMENT_RULE", this.ALIGNMENT_RULE_VALUES.get(this.radioARNatural));
            } else if (this.radioARPower.getSelection()) {
                propertyMap.put("com.ibm.etools.c.C_ALIGNMENT_RULE", this.ALIGNMENT_RULE_VALUES.get(this.radioARPower));
            } else {
                propertyMap.put("com.ibm.etools.c.C_ALIGNMENT_RULE", this.ALIGNMENT_RULE_VALUES.get(this.radioARPacked));
            }
            iValue = this.radioPL1.getSelection() ? 1 : (this.radioPL2.getSelection() ? 2 : (this.radioPL4.getSelection() ? 4 : (this.radioPL8.getSelection() ? 8 : 16)));
            propertyMap.put("com.ibm.etools.c.C_PACK_LEVEL", String.valueOf(iValue));
            if (this.radioSECompact.getSelection()) {
                propertyMap.put("com.ibm.etools.c.C_SIZE_OF_ENUM", this.SIZE_ENUM_VALUES.get(this.radioSECompact));
            } else if (this.radioSE1.getSelection()) {
                propertyMap.put("com.ibm.etools.c.C_SIZE_OF_ENUM", this.SIZE_ENUM_VALUES.get(this.radioSE1));
            } else if (this.radioSE2.getSelection()) {
                propertyMap.put("com.ibm.etools.c.C_SIZE_OF_ENUM", this.SIZE_ENUM_VALUES.get(this.radioSE2));
            } else {
                propertyMap.put("com.ibm.etools.c.C_SIZE_OF_ENUM", this.SIZE_ENUM_VALUES.get(this.radioSE4));
            }
            if (this.radioSW2.getSelection()) {
                propertyMap.put("com.ibm.etools.c.C_SIZE_OF_WCHAR", this.SIZE_WCHAR_VALUES.get(this.radioSW2));
            } else {
                propertyMap.put("com.ibm.etools.c.C_SIZE_OF_WCHAR", this.SIZE_WCHAR_VALUES.get(this.radioSW4));
            }
            propertyMap.put("com.ibm.etools.c.C_THROW_EXCEPTION_AT_PARSE_ERROR", Messages.getString("THROW_EXCEPTION_ON_ERROR_TRUE_VALUE"));
            propertyMap.put("com.ibm.etools.c.C_TREAT_UNKNOWN_TYPE_AS_ERROR", Messages.getString("TREAT_UNKNOWN_TYPE_AS_ERR_FALSE_VALUE"));
        }
        return propertyMap;
    }

    public void setHelpContextIds() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.parentPage.getControl(), "com.ibm.adapter.c.pccp0010");
        this.setHelpContextIdsPage1();
        this.setHelpContextIdsPage2();
    }

    public void setHelpContextIdsPage1() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.comboCompiler, "com.ibm.adapter.c.pccp0020");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.textCP, "com.ibm.adapter.c.pccp0040");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.comboFPF, "com.ibm.adapter.c.pccp0050");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioSENull, "com.ibm.adapter.c.pccp0060");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioSESpace, "com.ibm.adapter.c.pccp0070");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioBOLittle, "com.ibm.adapter.c.pccp0130");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioBOBig, "com.ibm.adapter.c.pccp0140");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.checkboxUSArray, "com.ibm.adapter.c.pccp0230");
    }

    public void setHelpContextIdsPage2() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.listIncldPath, "com.ibm.adapter.c.pccp0080");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioAS32bit, "com.ibm.adapter.c.pccp0090");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioAS64bit, "com.ibm.adapter.c.pccp0100");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioSLD64bit, "com.ibm.adapter.c.pccp0110");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioSLD128bit, "com.ibm.adapter.c.pccp0120");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioARNatural, "com.ibm.adapter.c.pccp0150");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioARPower, "com.ibm.adapter.c.pccp0160");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioARPacked, "com.ibm.adapter.c.pccp0170");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioPL1, "com.ibm.adapter.c.pccp0180");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioPL2, "com.ibm.adapter.c.pccp0190");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioPL4, "com.ibm.adapter.c.pccp0200");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioPL8, "com.ibm.adapter.c.pccp0210");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioPL16, "com.ibm.adapter.c.pccp0220");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioSECompact, "com.ibm.adapter.c.pccp0240");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioSE1, "com.ibm.adapter.c.pccp0250");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioSE2, "com.ibm.adapter.c.pccp0260");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioSE4, "com.ibm.adapter.c.pccp0270");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioSW2, "com.ibm.adapter.c.pccp0280");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioSW4, "com.ibm.adapter.c.pccp0290");
    }
}

