/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.binding.registry.util;

import javax.xml.namespace.QName;

public class QNameUtil {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2006 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private static final String NS_DELIM_1 = "{";
    private static final String NS_DELIM_2 = "}";

    public static QName qnameFromString(String qnameString) throws IllegalArgumentException {
        String namespace = null;
        String localName = null;
        if (qnameString == null || qnameString.length() == 0) {
            return new QName(namespace, localName);
        }
        if (qnameString.startsWith(NS_DELIM_1)) {
            int index = qnameString.indexOf(NS_DELIM_2);
            if (index == -1) {
                throw new IllegalArgumentException("qnameString = " + qnameString);
            }
            namespace = qnameString.substring(1, index);
            localName = qnameString.substring(index + 1);
        } else {
            localName = qnameString;
        }
        return new QName(namespace, localName);
    }

    public static String toString(QName qname) {
        String namespace = qname.getNamespaceURI();
        String localName = qname.getLocalPart();
        return QNameUtil.appendStrings(new String[]{NS_DELIM_1, namespace, NS_DELIM_2, localName});
    }

    public static String appendStrings(String[] strings) {
        String result = null;
        if (strings != null) {
            StringBuffer tokenBuffer = new StringBuffer();
            int maxCount = strings.length;
            int i = 0;
            while (i < maxCount) {
                String string = strings[i];
                if (string != null && string.length() > 0) {
                    tokenBuffer.append(string);
                }
                ++i;
            }
            result = tokenBuffer.toString();
        }
        return result;
    }
}

