/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.binding.registry.util;

import com.ibm.adapter.binding.registry.internal.BindingRegistryActivator;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.adapter.j2ca.RegistryFactory;
import com.ibm.adapter.j2ca.spi.util.BundleClassLoader;
import com.ibm.adapter.j2ca.spi.util.ConnectorProjectHelper;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;

public class BindingRegistryHelper {
    public static BundleClassLoader getClassLoader(IProject project) throws CoreException {
        URL[] projectURLs = null;
        try {
            projectURLs = ConnectorProjectHelper.getURLsFromProject((IProject)project, (boolean)true);
        }
        catch (MalformedURLException exc) {
            Status status = new Status(4, "com.ibm.adapter.binding.registry", 4, exc.getLocalizedMessage() == null ? "" : exc.getLocalizedMessage(), (Throwable)exc);
            throw new CoreException((IStatus)status);
        }
        return new BundleClassLoader(BindingRegistryActivator.getDefault().getBundle(), projectURLs);
    }

    public static Object getBindingConfiguartionObject(IProject project, String className, int linkage) throws CoreException {
        IJavaProject javaProject;
        if (project != null && className != null && (javaProject = JavaCore.create((IProject)project)) != null && javaProject.exists()) {
            Object classLoader = null;
            if (1 == linkage) {
                IResourceAdapterDescriptor resourceAdapter = RegistryFactory.getFactory().getAPIResourceAdapterRegistry().getResourceAdapterForProject(project);
                classLoader = resourceAdapter.getClassLoader();
            } else if (2 == linkage) {
                classLoader = BindingRegistryHelper.getClassLoader(project);
            }
            IType type = javaProject.findType(className);
            if (type == null) {
                return null;
            }
            if (classLoader != null) {
                Class<?> configurationClass = null;
                try {
                    configurationClass = ((ClassLoader)classLoader).loadClass(className);
                }
                catch (ClassNotFoundException exc) {
                    Status status = new Status(4, "com.ibm.adapter.binding.registry", 4, exc.getLocalizedMessage() == null ? "" : exc.getLocalizedMessage(), (Throwable)exc);
                    throw new CoreException((IStatus)status);
                }
                Object configurationObjectInstance = null;
                try {
                    configurationObjectInstance = configurationClass.newInstance();
                }
                catch (Exception exc) {
                    Status status = new Status(4, "com.ibm.adapter.binding.registry", 4, exc.getLocalizedMessage() == null ? "" : exc.getLocalizedMessage(), (Throwable)exc);
                    throw new CoreException((IStatus)status);
                }
                return configurationObjectInstance;
            }
        }
        return null;
    }
}

