/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdks.manager;

import com.businessobjects.integration.capabilities.librarycomponents.ILibraryDefinitionProvider;
import com.businessobjects.integration.capabilities.librarycomponents.model.ContextParam;
import com.businessobjects.integration.capabilities.librarycomponents.model.Resource;
import com.businessobjects.integration.capabilities.librarycomponents.model.Servlet;
import com.businessobjects.integration.capabilities.librarycomponents.model.Taglib;
import com.businessobjects.integration.capabilities.librarycomponents.model.spi.Ref;
import com.businessobjects.integration.capabilities.librarycomponents.model.spi.Version;
import com.businessobjects.integration.capabilities.librarycomponents.model.spi.WebXmlChanges;
import com.businessobjects.integration.capabilities.logging.LogManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public class RuntimeLibraryManager
implements ILibraryDefinitionProvider {
    private static final String IS_WEB = "isWeb";
    private static final String LIBRARY = "library";
    private static final String MAPPING = "mapping";
    private static final String LOAD_ON_STARTUP = "loadOnStartup";
    private static final String DESCRIPTION = "description";
    private static final String CLASSNAME = "classname";
    private static final String SERVLET = "servlet";
    private static final String LOCATION = "location";
    private static final String URI = "uri";
    private static final String TAGLIB = "taglib";
    private static final String VALUE = "value";
    private static final String NAME = "name";
    private static final String CONTEXT_PARAM = "context-param";
    private static final String WEB_XML_CONFIG = "web-xml-config";
    private static final String LIBRARY_ID = "libraryId";
    private static final String REF = "ref";
    private static final String DESTINATION = "destination";
    private static final String PATH = "path";
    private static final String RESOURCES = "resource";
    private static final String DEFAULT = "default";
    private static final String EXTERNAL_JAR = "external-jar";
    private static final String BUSINESSOBJECTS_JAR = "businessobjects-jar";
    private static final String VERSION = "version";
    private static final String ID = "id";
    private static Map librariesToVersionsMap = new HashMap();
    private static Map libraryIdsToNameMap = new HashMap();
    private static Set webLibraryIds = new HashSet();
    public static final String POINT_ID = "com.businessobjects.sdks.manager.LibraryDefinition";
    private static ILibraryDefinitionProvider instance;
    static /* synthetic */ Class class$com$businessobjects$sdks$manager$RuntimeLibraryManager;

    private RuntimeLibraryManager() {
    }

    public static ILibraryDefinitionProvider getInstance() {
        return instance;
    }

    private static void processLibraries(IConfigurationElement[] iConfigurationElementArray, Map map) {
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement;
            if (LIBRARY.equals(iConfigurationElementArray[n].getName()) && (iConfigurationElement = iConfigurationElementArray[n]).isValid()) {
                String string = iConfigurationElementArray[n].getAttribute(ID);
                String string2 = iConfigurationElementArray[n].getAttribute(NAME);
                boolean bl = Boolean.valueOf(iConfigurationElementArray[n].getAttribute(IS_WEB));
                libraryIdsToNameMap.put(string, string2);
                if (bl) {
                    webLibraryIds.add(string);
                }
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElement.getChildren(VERSION);
                RuntimeLibraryManager.processVersions(string, iConfigurationElementArray2, map);
            }
            ++n;
        }
    }

    private static void processVersions(String string, IConfigurationElement[] iConfigurationElementArray, Map map) {
        Map<String, Version> map2 = new HashMap();
        if (map.containsKey(string)) {
            map2 = (Map)map.get(string);
        }
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.isValid()) {
                String string2 = iConfigurationElement.getAttribute(ID);
                boolean bl = Boolean.valueOf(iConfigurationElement.getAttribute(DEFAULT));
                ArrayList arrayList = new ArrayList();
                RuntimeLibraryManager.processSDKLibraries(iConfigurationElement.getChildren(BUSINESSOBJECTS_JAR), arrayList);
                ArrayList arrayList2 = new ArrayList();
                RuntimeLibraryManager.processSDKLibraries(iConfigurationElement.getChildren(EXTERNAL_JAR), arrayList2);
                ArrayList arrayList3 = new ArrayList();
                RuntimeLibraryManager.processResources(iConfigurationElement.getChildren(RESOURCES), arrayList3);
                ArrayList arrayList4 = new ArrayList();
                RuntimeLibraryManager.processWebXmlChanges(iConfigurationElement.getChildren(WEB_XML_CONFIG), arrayList4);
                ArrayList arrayList5 = new ArrayList();
                RuntimeLibraryManager.processRefs(iConfigurationElement.getChildren(REF), arrayList5);
                map2.put(string2, new Version(arrayList, arrayList2, arrayList3, arrayList4, arrayList5, bl));
            }
            ++n;
        }
        map.put(string, map2);
    }

    private static void processSDKLibraries(IConfigurationElement[] iConfigurationElementArray, List list) {
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.isValid()) {
                String string = iConfigurationElement.getDeclaringExtension().getNamespace();
                String string2 = iConfigurationElement.getAttribute(PATH);
                URL uRL = Platform.getBundle((String)string).getEntry(string2);
                if (uRL == null) {
                    LogManager.getInstance().message(1000, (class$com$businessobjects$sdks$manager$RuntimeLibraryManager == null ? RuntimeLibraryManager.class$("com.businessobjects.sdks.manager.RuntimeLibraryManager") : class$com$businessobjects$sdks$manager$RuntimeLibraryManager).getName(), "Missing : Plugin = " + string + ";path=" + string2);
                } else {
                    try {
                        uRL = FileLocator.toFileURL((URL)uRL);
                        File file = new File(uRL.getPath());
                        list.add(file.getAbsolutePath());
                    }
                    catch (IOException iOException) {
                        LogManager.getInstance().message(1000, (class$com$businessobjects$sdks$manager$RuntimeLibraryManager == null ? RuntimeLibraryManager.class$("com.businessobjects.sdks.manager.RuntimeLibraryManager") : class$com$businessobjects$sdks$manager$RuntimeLibraryManager).getName(), (Exception)iOException);
                    }
                }
            }
            ++n;
        }
    }

    private static void processResources(IConfigurationElement[] iConfigurationElementArray, List list) {
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.isValid()) {
                String string = iConfigurationElement.getDeclaringExtension().getNamespace();
                String string2 = iConfigurationElement.getAttribute(PATH);
                String string3 = iConfigurationElement.getAttribute(DESTINATION);
                RuntimeLibraryManager.processResourcePaths(string, string2, string3, list);
            }
            ++n;
        }
    }

    private static void processResourcePaths(String string, String string2, String string3, List list) {
        block3: {
            URL uRL = Platform.getBundle((String)string).getEntry(string2);
            if (uRL == null) break block3;
            try {
                URL uRL2 = FileLocator.toFileURL((URL)uRL);
                if (uRL2 == null) {
                    LogManager.getInstance().message(1000, (class$com$businessobjects$sdks$manager$RuntimeLibraryManager == null ? (class$com$businessobjects$sdks$manager$RuntimeLibraryManager = RuntimeLibraryManager.class$("com.businessobjects.sdks.manager.RuntimeLibraryManager")) : class$com$businessobjects$sdks$manager$RuntimeLibraryManager).getName(), "Missing : Plugin = " + string + ";path=" + string2);
                    break block3;
                }
                list.add(new Resource(new File(uRL2.getPath()).getAbsolutePath(), string3));
            }
            catch (IOException iOException) {
                LogManager.getInstance().message(1000, (class$com$businessobjects$sdks$manager$RuntimeLibraryManager == null ? (class$com$businessobjects$sdks$manager$RuntimeLibraryManager = RuntimeLibraryManager.class$("com.businessobjects.sdks.manager.RuntimeLibraryManager")) : class$com$businessobjects$sdks$manager$RuntimeLibraryManager).getName(), (Exception)iOException);
            }
        }
    }

    private static void processRefs(IConfigurationElement[] iConfigurationElementArray, List list) {
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.isValid()) {
                String string = iConfigurationElement.getAttribute(LIBRARY_ID);
                String string2 = iConfigurationElement.getAttribute(VERSION);
                list.add(new Ref(string, string2));
            }
            ++n;
        }
    }

    private static void processWebXmlChanges(IConfigurationElement[] iConfigurationElementArray, List list) {
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.isValid()) {
                ArrayList arrayList = new ArrayList();
                RuntimeLibraryManager.processContextParam(iConfigurationElement.getChildren(CONTEXT_PARAM), arrayList);
                ArrayList arrayList2 = new ArrayList();
                RuntimeLibraryManager.processTaglib(iConfigurationElement.getChildren(TAGLIB), arrayList2);
                ArrayList arrayList3 = new ArrayList();
                RuntimeLibraryManager.processServlets(iConfigurationElement.getChildren(SERVLET), arrayList3);
                list.add(new WebXmlChanges(arrayList, arrayList2, arrayList3));
            }
            ++n;
        }
    }

    private static void processContextParam(IConfigurationElement[] iConfigurationElementArray, List list) {
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.isValid()) {
                String string = iConfigurationElement.getAttribute(NAME);
                String string2 = iConfigurationElement.getAttribute(VALUE);
                list.add(new ContextParam(string, string2));
            }
            ++n;
        }
    }

    private static void processTaglib(IConfigurationElement[] iConfigurationElementArray, List list) {
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.isValid()) {
                String string = iConfigurationElement.getAttribute(URI);
                String string2 = iConfigurationElement.getAttribute(LOCATION);
                list.add(new Taglib(string, string2));
            }
            ++n;
        }
    }

    private static void processServlets(IConfigurationElement[] iConfigurationElementArray, List list) {
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.isValid()) {
                String string = iConfigurationElement.getAttribute(NAME);
                String string2 = iConfigurationElement.getAttribute(CLASSNAME);
                String string3 = iConfigurationElement.getAttribute(DESCRIPTION);
                Integer n2 = null;
                try {
                    n2 = Integer.valueOf(iConfigurationElement.getAttribute(LOAD_ON_STARTUP));
                }
                catch (NumberFormatException numberFormatException) {
                    LogManager.getInstance().message(1000, (class$com$businessobjects$sdks$manager$RuntimeLibraryManager == null ? RuntimeLibraryManager.class$("com.businessobjects.sdks.manager.RuntimeLibraryManager") : class$com$businessobjects$sdks$manager$RuntimeLibraryManager).getName(), (Exception)numberFormatException);
                }
                String string4 = iConfigurationElement.getAttribute(MAPPING);
                list.add(new Servlet(string, string2, string3, n2, string4));
            }
            ++n;
        }
    }

    public Set getLibraries() {
        return librariesToVersionsMap.keySet();
    }

    public Set getVersions(String string) {
        Map map;
        if (librariesToVersionsMap.containsKey(string) && (map = (Map)librariesToVersionsMap.get(string)) != null && map.size() > 0) {
            TreeSet treeSet = new TreeSet(new VersionComparator());
            Set set = map.keySet();
            treeSet.addAll(set);
            return treeSet;
        }
        return new HashSet();
    }

    public String getDefaultVersion(String string) {
        Set set = this.getVersions(string);
        if (set.isEmpty()) {
            return null;
        }
        Map map = (Map)librariesToVersionsMap.get(string);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Version version = (Version)map.get(string2);
            if (version == null || !version.isDefault()) continue;
            return string2;
        }
        return (String)set.toArray()[0];
    }

    public String getLatestVersion(String string) {
        Set set = this.getVersions(string);
        if (set.size() > 0) {
            return null;
        }
        return (String)set.toArray()[set.size() - 1];
    }

    public String getOldestVersion(String string) {
        Set set = this.getVersions(string);
        if (set.size() > 0) {
            return null;
        }
        return (String)set.toArray()[0];
    }

    public List getBusinessObjectsLibraries(String string, String string2) {
        Version version;
        Map map;
        ArrayList arrayList = new ArrayList();
        if (librariesToVersionsMap.containsKey(string) && (map = (Map)librariesToVersionsMap.get(string)) != null && map.size() > 0 && (version = (Version)map.get(string2)) != null) {
            arrayList.addAll(version.getBusinessObjectJarFileUrls());
            List list = version.getRefs();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Ref ref = (Ref)iterator.next();
                arrayList.addAll(this.getBusinessObjectsLibraries(ref.getLibraryId(), ref.getVersion()));
            }
        }
        return arrayList;
    }

    public List getExternalLibraries(String string, String string2) {
        Version version;
        Map map;
        ArrayList arrayList = new ArrayList();
        if (librariesToVersionsMap.containsKey(string) && (map = (Map)librariesToVersionsMap.get(string)) != null && map.size() > 0 && (version = (Version)map.get(string2)) != null) {
            arrayList.addAll(version.getExternalJarFileUrls());
            List list = version.getRefs();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Ref ref = (Ref)iterator.next();
                arrayList.addAll(this.getExternalLibraries(ref.getLibraryId(), ref.getVersion()));
            }
        }
        return arrayList;
    }

    public List getResources(String string, String string2) {
        Version version;
        Map map;
        ArrayList arrayList = new ArrayList();
        if (librariesToVersionsMap.containsKey(string) && (map = (Map)librariesToVersionsMap.get(string)) != null && map.size() > 0 && (version = (Version)map.get(string2)) != null) {
            arrayList.addAll(version.getResources());
            List list = version.getRefs();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Ref ref = (Ref)iterator.next();
                arrayList.addAll(this.getResources(ref.getLibraryId(), ref.getVersion()));
            }
        }
        return arrayList;
    }

    public List getServlets(String string, String string2) {
        Version version;
        Map map;
        ArrayList arrayList = new ArrayList();
        if (librariesToVersionsMap.containsKey(string) && (map = (Map)librariesToVersionsMap.get(string)) != null && map.size() > 0 && (version = (Version)map.get(string2)) != null) {
            List list = version.getWebXmlChanges();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                WebXmlChanges webXmlChanges = (WebXmlChanges)iterator.next();
                arrayList.addAll(webXmlChanges.getServlets());
            }
        }
        return arrayList;
    }

    public List getContextParams(String string, String string2) {
        Version version;
        Map map;
        ArrayList arrayList = new ArrayList();
        if (librariesToVersionsMap.containsKey(string) && (map = (Map)librariesToVersionsMap.get(string)) != null && map.size() > 0 && (version = (Version)map.get(string2)) != null) {
            List list = version.getWebXmlChanges();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                WebXmlChanges webXmlChanges = (WebXmlChanges)iterator.next();
                arrayList.addAll(webXmlChanges.getContextParams());
            }
        }
        return arrayList;
    }

    public List getTaglibs(String string, String string2) {
        Version version;
        Map map;
        ArrayList arrayList = new ArrayList();
        if (librariesToVersionsMap.containsKey(string) && (map = (Map)librariesToVersionsMap.get(string)) != null && map.size() > 0 && (version = (Version)map.get(string2)) != null) {
            List list = version.getWebXmlChanges();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                WebXmlChanges webXmlChanges = (WebXmlChanges)iterator.next();
                arrayList.addAll(webXmlChanges.getTaglibs());
            }
        }
        return arrayList;
    }

    public String getName(String string) {
        return (String)libraryIdsToNameMap.get(string);
    }

    public Set getWebLibraryIds() {
        return webLibraryIds;
    }

    public Set getWebLibraryCommonVersions() {
        Iterator iterator = webLibraryIds.iterator();
        Set set = null;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (set == null) {
                set = this.getVersions(string);
                continue;
            }
            set.retainAll(this.getVersions(string));
        }
        if (set == null) {
            set = new HashSet();
        }
        return set;
    }

    private static final int convertVersionToInt(String string) {
        int n = 0;
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 3) {
            n = Integer.parseInt(stringArray[0]) * 100 + Integer.parseInt(stringArray[1]) * 10 + Integer.parseInt(stringArray[2]);
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint(POINT_ID).getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            if (iExtensionArray[n].isValid()) {
                IExtension iExtension = iExtensionArray[n];
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                RuntimeLibraryManager.processLibraries(iConfigurationElementArray, librariesToVersionsMap);
            }
            ++n;
        }
        instance = new RuntimeLibraryManager();
    }

    private static class VersionComparator
    implements Comparator {
        private VersionComparator() {
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof String) || !(object2 instanceof String)) {
                return 0;
            }
            String string = (String)object;
            String string2 = (String)object2;
            return RuntimeLibraryManager.convertVersionToInt(string2) - RuntimeLibraryManager.convertVersionToInt(string);
        }
    }
}

