/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.license.manager.ui.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class UpdateSiteGenerator {
    private static final String ENCODING = "UTF-8";
    static final String JRC_KEYCODE_ID_PREFIX = "com.businessobjects.keycodes.jrc.11.8.0.";
    static final String VERSION = "11.8.0";
    private static final String PLUGIN = "plugin";
    private static final String HTML = ".html";
    private static final String PROPERTIES = ".properties";
    private static final String LICENSE = "license";
    private static final String FEATURE = "feature";
    private static final String RES_UPDATE_SITE_PLUGINS = "/res/update_site/plugins/";
    private static final String RES_UPDATE_SITE_FEATURES = "/res/update_site/features/";
    private static final String MANIFEST_LOCATION = "/res/update_site/plugins/META-INF/Manifest.mf";
    private static final String PLUGIN_XML_LOCATION = "/res/update_site/plugins/plugin.xml";
    private static final String FEATURE_XML_LOCATION = "/res/update_site/features/feature.xml";
    private static final String SITE_XML_LOCATION = "/res/update_site/site.xml";
    private static final String SITE_XML = "site.xml";
    private static final String DATE_FORMAT = "yyyyMMdd";
    private static final String META_INF_MANIFEST_MF = "META-INF/MANIFEST.MF";
    private static final String PLUGIN_XML = "plugin.xml";
    private static final String SEPARATOR = ".";
    private static final String FEATURE_XML = "feature.xml";
    private static final String FEATURES = "features";
    private static final String PLUGINS = "plugins";
    private static final String[] LANGUAGE_SUFFIX = new String[]{"_cs", "_de", "_es", "_fr", "_hu", "_it", "_ja", "_ko", "_pl", "_pt", "_ru", "_zh_TW", "_zh", ""};
    private static Random r = new Random();
    static /* synthetic */ Class class$com$businessobjects$license$manager$ui$internal$UpdateSiteGenerator;

    static final String getUniqueId() {
        Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        return simpleDateFormat.format(calendar.getTime()) + SEPARATOR + Long.toString(r.nextLong(), 36);
    }

    static void createUpdateSite(File file, String string, String string2, String string3) throws IOException {
        file.mkdirs();
        UpdateSiteGenerator.createSiteXml(file, string, string2);
        File file2 = new File(file, PLUGINS);
        file2.mkdirs();
        UpdateSiteGenerator.generatePluginJar(file2, string, string2, string3);
        File file3 = new File(file, FEATURES);
        file3.mkdirs();
        UpdateSiteGenerator.createFeature(file3, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createSiteXml(File file, String string, String string2) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((class$com$businessobjects$license$manager$ui$internal$UpdateSiteGenerator == null ? (class$com$businessobjects$license$manager$ui$internal$UpdateSiteGenerator = UpdateSiteGenerator.class$("com.businessobjects.license.manager.ui.internal.UpdateSiteGenerator")) : class$com$businessobjects$license$manager$ui$internal$UpdateSiteGenerator).getResourceAsStream(SITE_XML_LOCATION), ENCODING));
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(file, SITE_XML)));
        try {
            String string3;
            StringBuffer stringBuffer = new StringBuffer();
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3).append("\n");
            }
            bufferedWriter.write(MessageFormat.format(stringBuffer.toString(), string, string2));
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            bufferedReader.close();
            bufferedWriter.close();
            throw throwable;
        }
        bufferedReader.close();
        bufferedWriter.close();
    }

    private static final String getJarFileName(String string, String string2) {
        return string + "_" + string2 + ".jar";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void createFeature(File file, String string, String string2) throws IOException {
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(new File(file, UpdateSiteGenerator.getJarFileName(string, string2))));
            UpdateSiteGenerator.copyFeatureResources(zipOutputStream);
            UpdateSiteGenerator.generateFeatureXml(zipOutputStream, string, string2);
            Object var5_4 = null;
            if (zipOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (zipOutputStream == null) throw throwable;
            zipOutputStream.close();
            throw throwable;
        }
        zipOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateFeatureXml(ZipOutputStream zipOutputStream, String string, String string2) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((class$com$businessobjects$license$manager$ui$internal$UpdateSiteGenerator == null ? (class$com$businessobjects$license$manager$ui$internal$UpdateSiteGenerator = UpdateSiteGenerator.class$("com.businessobjects.license.manager.ui.internal.UpdateSiteGenerator")) : class$com$businessobjects$license$manager$ui$internal$UpdateSiteGenerator).getResourceAsStream(FEATURE_XML_LOCATION), ENCODING));
        BufferedWriter bufferedWriter = new BufferedWriter(new PrintWriter(zipOutputStream));
        try {
            String string3;
            StringBuffer stringBuffer = new StringBuffer();
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3).append("\n");
            }
            zipOutputStream.putNextEntry(new ZipEntry(FEATURE_XML));
            bufferedWriter.write(MessageFormat.format(stringBuffer.toString(), string, string2));
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            bufferedReader.close();
            bufferedWriter.flush();
            zipOutputStream.closeEntry();
            throw throwable;
        }
        bufferedReader.close();
        bufferedWriter.flush();
        zipOutputStream.closeEntry();
    }

    private static void copyFeatureResources(ZipOutputStream zipOutputStream) throws IOException {
        int n = 0;
        while (n < LANGUAGE_SUFFIX.length) {
            UpdateSiteGenerator.copyFeatureResourceFile(zipOutputStream, FEATURE + LANGUAGE_SUFFIX[n] + PROPERTIES);
            UpdateSiteGenerator.copyFeatureResourceFile(zipOutputStream, LICENSE + LANGUAGE_SUFFIX[n] + HTML);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFeatureResourceFile(ZipOutputStream zipOutputStream, String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((class$com$businessobjects$license$manager$ui$internal$UpdateSiteGenerator == null ? (class$com$businessobjects$license$manager$ui$internal$UpdateSiteGenerator = UpdateSiteGenerator.class$("com.businessobjects.license.manager.ui.internal.UpdateSiteGenerator")) : class$com$businessobjects$license$manager$ui$internal$UpdateSiteGenerator).getResourceAsStream(RES_UPDATE_SITE_FEATURES + string), ENCODING));
        BufferedWriter bufferedWriter = new BufferedWriter(new PrintWriter(zipOutputStream));
        try {
            String string2;
            StringBuffer stringBuffer = new StringBuffer();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2).append("\n");
            }
            zipOutputStream.putNextEntry(new ZipEntry(string));
            bufferedWriter.write(stringBuffer.toString());
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            bufferedReader.close();
            bufferedWriter.flush();
            zipOutputStream.closeEntry();
            throw throwable;
        }
        bufferedReader.close();
        bufferedWriter.flush();
        zipOutputStream.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void generatePluginJar(File file, String string, String string2, String string3) throws IOException {
        ZipOutputStream zipOutputStream = null;
        try {
            File file2 = new File(file, UpdateSiteGenerator.getJarFileName(string, string2));
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            UpdateSiteGenerator.generatePluginXml(zipOutputStream, string, string3);
            UpdateSiteGenerator.generateManifest(zipOutputStream, string, string2);
            UpdateSiteGenerator.copyPluginResources(zipOutputStream);
            Object var7_6 = null;
            if (zipOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (zipOutputStream == null) throw throwable;
            zipOutputStream.close();
            throw throwable;
        }
        zipOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyPluginResources(ZipOutputStream zipOutputStream) throws IOException {
        int n = 0;
        while (n < LANGUAGE_SUFFIX.length) {
            Object var8_7;
            String string = PLUGIN + LANGUAGE_SUFFIX[n] + PROPERTIES;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((class$com$businessobjects$license$manager$ui$internal$UpdateSiteGenerator == null ? UpdateSiteGenerator.class$("com.businessobjects.license.manager.ui.internal.UpdateSiteGenerator") : class$com$businessobjects$license$manager$ui$internal$UpdateSiteGenerator).getResourceAsStream(RES_UPDATE_SITE_PLUGINS + string), ENCODING));
            BufferedWriter bufferedWriter = new BufferedWriter(new PrintWriter(zipOutputStream));
            try {
                String string2;
                StringBuffer stringBuffer = new StringBuffer();
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2).append("\n");
                }
                zipOutputStream.putNextEntry(new ZipEntry(string));
                bufferedWriter.write(stringBuffer.toString());
                var8_7 = null;
            }
            catch (Throwable throwable) {
                var8_7 = null;
                bufferedReader.close();
                bufferedWriter.flush();
                zipOutputStream.closeEntry();
                throw throwable;
            }
            bufferedReader.close();
            bufferedWriter.flush();
            zipOutputStream.closeEntry();
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generatePluginXml(ZipOutputStream zipOutputStream, String string, String string2) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((class$com$businessobjects$license$manager$ui$internal$UpdateSiteGenerator == null ? (class$com$businessobjects$license$manager$ui$internal$UpdateSiteGenerator = UpdateSiteGenerator.class$("com.businessobjects.license.manager.ui.internal.UpdateSiteGenerator")) : class$com$businessobjects$license$manager$ui$internal$UpdateSiteGenerator).getResourceAsStream(PLUGIN_XML_LOCATION), ENCODING));
        BufferedWriter bufferedWriter = new BufferedWriter(new PrintWriter(zipOutputStream));
        try {
            String string3;
            StringBuffer stringBuffer = new StringBuffer();
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3).append("\n");
            }
            zipOutputStream.putNextEntry(new ZipEntry(PLUGIN_XML));
            bufferedWriter.write(MessageFormat.format(stringBuffer.toString(), string2));
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            bufferedReader.close();
            bufferedWriter.flush();
            zipOutputStream.closeEntry();
            throw throwable;
        }
        bufferedReader.close();
        bufferedWriter.flush();
        zipOutputStream.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateManifest(ZipOutputStream zipOutputStream, String string, String string2) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((class$com$businessobjects$license$manager$ui$internal$UpdateSiteGenerator == null ? (class$com$businessobjects$license$manager$ui$internal$UpdateSiteGenerator = UpdateSiteGenerator.class$("com.businessobjects.license.manager.ui.internal.UpdateSiteGenerator")) : class$com$businessobjects$license$manager$ui$internal$UpdateSiteGenerator).getResourceAsStream(MANIFEST_LOCATION), ENCODING));
        BufferedWriter bufferedWriter = new BufferedWriter(new PrintWriter(zipOutputStream));
        try {
            String string3;
            StringBuffer stringBuffer = new StringBuffer();
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3).append("\n");
            }
            zipOutputStream.putNextEntry(new ZipEntry(META_INF_MANIFEST_MF));
            bufferedWriter.write(MessageFormat.format(stringBuffer.toString(), string, string2));
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            bufferedReader.close();
            bufferedWriter.flush();
            zipOutputStream.closeEntry();
            throw throwable;
        }
        bufferedReader.close();
        bufferedWriter.flush();
        zipOutputStream.closeEntry();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

