/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.license.manager.ui.internal;

import com.businessobjects.license.manager.ui.internal.UpdateSiteGenerator;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.standalone.InstallCommand;

public class KeycodeInstaller {
    private static final String SEPARATOR = ".";
    private static final String TEMP_FILE_PREFIX = "cr4e";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void installKeycode(String string, IProgressMonitor iProgressMonitor) throws Exception {
        File file = null;
        try {
            String string2 = KeycodeInstaller.generateId();
            file = KeycodeInstaller.getUpdateSiteLocation(string2);
            UpdateSiteGenerator.createUpdateSite(file, string2, "11.8.0", string);
            KeycodeInstaller.installBundle(file, string2, "11.8.0", iProgressMonitor);
            Object var5_4 = null;
            if (file == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (file == null) throw throwable;
            KeycodeInstaller.deleteDir(file);
            throw throwable;
        }
        KeycodeInstaller.deleteDir(file);
    }

    static File getUpdateSiteLocation(String string) throws IOException {
        File file = File.createTempFile(TEMP_FILE_PREFIX, null);
        if (file.exists()) {
            file.delete();
        }
        return file;
    }

    private static String generateId() throws Exception {
        String string = null;
        int n = 1;
        String string2 = UpdateSiteGenerator.getUniqueId();
        do {
            string = "com.businessobjects.keycodes.jrc.11.8.0." + string2;
            if (n > 1) {
                string = string + SEPARATOR + n;
            }
            ++n;
        } while (KeycodeInstaller.isFeatureConfigured(string));
        return string;
    }

    private static boolean isFeatureConfigured(String string) throws CoreException {
        ILocalSite iLocalSite = SiteManager.getLocalSite();
        IInstallConfiguration iInstallConfiguration = iLocalSite.getCurrentConfiguration();
        IConfiguredSite[] iConfiguredSiteArray = iInstallConfiguration.getConfiguredSites();
        int n = 0;
        while (n < iConfiguredSiteArray.length) {
            IConfiguredSite iConfiguredSite = iConfiguredSiteArray[n];
            IFeatureReference[] iFeatureReferenceArray = iConfiguredSite.getFeatureReferences();
            int n2 = 0;
            while (n2 < iFeatureReferenceArray.length) {
                if (string.equals(iFeatureReferenceArray[n2].getVersionedIdentifier().getIdentifier())) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    private static boolean deleteDir(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                boolean bl = KeycodeInstaller.deleteDir(new File(file, stringArray[n]));
                if (!bl) {
                    return false;
                }
                ++n;
            }
        }
        return file.delete();
    }

    private static String getTargetConfigurationLocation() throws Exception {
        ILocalSite iLocalSite = SiteManager.getLocalSite();
        IInstallConfiguration iInstallConfiguration = iLocalSite.getCurrentConfiguration();
        IConfiguredSite[] iConfiguredSiteArray = iInstallConfiguration.getConfiguredSites();
        int n = 0;
        while (n < iConfiguredSiteArray.length) {
            String string;
            File file;
            IConfiguredSite iConfiguredSite = iConfiguredSiteArray[n];
            URL uRL = iConfiguredSite.getSite().getURL();
            if (uRL != null && "file".equalsIgnoreCase(uRL.getProtocol()) && (file = new File(string = uRL.getFile())).canWrite() && iConfiguredSite.isEnabled()) {
                return iConfiguredSite.getSite().getURL().getFile();
            }
            ++n;
        }
        return null;
    }

    private static void installBundle(File file, String string, String string2, IProgressMonitor iProgressMonitor) throws Exception {
        String string3 = KeycodeInstaller.getTargetConfigurationLocation();
        if (string3 == null) {
            throw new IOException();
        }
        InstallCommand installCommand = new InstallCommand(string, string2, file.toURL().toExternalForm(), string3, Boolean.FALSE.toString());
        if (!installCommand.run(iProgressMonitor)) {
            throw new IOException(file.toURL().toExternalForm());
        }
    }
}

