/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.license.manager.ui;

import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.license.manager.ui.LicenseMessages;
import com.businessobjects.license.manager.ui.LicensePreferencePage;
import com.businessobjects.license.manager.ui.internal.KeycodeInstaller;
import com.businessobjects.license.manager.ui.internal.KeycodeValidator;
import com.businessobjects.license.manager.ui.internal.ValidationException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class LicensePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String DASH = "-";
    private Text kcSet2;
    private Text kcSet1;
    private Text kcSet3;
    private Text kcSet4;
    private Map fieldInfoMap = new HashMap(4);
    private FieldKeyListener keyListener = new FieldKeyListener();
    private FieldModifyListener modifyListener = new FieldModifyListener();
    private Button generateBtn;
    private static final int KEYCODE_LENGTH = 26;
    private static final String HELP_CONTEXT_ID = "com.businessobjects.license.manager.ui.keycode_entry";
    private static final int PREFERRED_WIDTH_PER_CHAR_IN_PIXEL = 10;

    public LicensePreferencePage() {
        this.noDefaultAndApplyButton();
        this.setTitle(LicenseMessages.licensePreferencePage_message);
        this.setMessage(LicenseMessages.licensePreferencePage_message);
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FormLayout());
        IWorkbenchHelpSystem iWorkbenchHelpSystem = UIUtilities.getHelpSystem();
        if (iWorkbenchHelpSystem != null) {
            iWorkbenchHelpSystem.setHelp((Control)composite, HELP_CONTEXT_ID);
        }
        Label label = new Label(composite2, 64);
        label.setText(LicenseMessages.licensePreferencePage_instruction);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 10);
        formData.left = new FormAttachment(0, 10);
        formData.right = new FormAttachment(100, -10);
        label.setLayoutData((Object)formData);
        this.kcSet1 = new Text(composite2, 2048);
        this.kcSet1.setTextLimit(5);
        formData = new FormData();
        formData.top = new FormAttachment((Control)label, 10);
        formData.left = new FormAttachment(0, 10);
        formData.width = 50;
        this.kcSet1.setLayoutData((Object)formData);
        this.kcSet1.addModifyListener((ModifyListener)this.modifyListener);
        this.kcSet1.addKeyListener((KeyListener)this.keyListener);
        formData = new Label(composite2, 0);
        formData.setText(DASH);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment((Control)label, 10);
        formData2.left = new FormAttachment((Control)this.kcSet1, 5);
        formData.setLayoutData((Object)formData2);
        this.kcSet2 = new Text(composite2, 2048);
        this.kcSet2.setTextLimit(7);
        formData2 = new FormData();
        formData2.top = new FormAttachment((Control)label, 10);
        formData2.left = new FormAttachment((Control)formData, 5);
        formData2.width = 70;
        this.kcSet2.setLayoutData((Object)formData2);
        this.kcSet2.addModifyListener((ModifyListener)this.modifyListener);
        this.kcSet2.addKeyListener((KeyListener)this.keyListener);
        formData2 = new Label(composite2, 0);
        formData2.setText(DASH);
        FormData formData3 = new FormData();
        formData3.top = new FormAttachment((Control)label, 10);
        formData3.left = new FormAttachment((Control)this.kcSet2, 5);
        formData2.setLayoutData((Object)formData3);
        this.kcSet3 = new Text(composite2, 2048);
        this.kcSet3.setTextLimit(7);
        formData3 = new FormData();
        formData3.top = new FormAttachment((Control)label, 10);
        formData3.left = new FormAttachment((Control)formData2, 5);
        formData3.width = 70;
        this.kcSet3.setLayoutData((Object)formData3);
        this.kcSet3.addModifyListener((ModifyListener)this.modifyListener);
        this.kcSet3.addKeyListener((KeyListener)this.keyListener);
        formData3 = new Label(composite2, 0);
        formData3.setText(DASH);
        FormData formData4 = new FormData();
        formData4.top = new FormAttachment((Control)label, 10);
        formData4.left = new FormAttachment((Control)this.kcSet3, 5);
        formData3.setLayoutData((Object)formData4);
        this.kcSet4 = new Text(composite2, 2048);
        this.kcSet4.setTextLimit(4);
        formData4 = new FormData();
        formData4.top = new FormAttachment((Control)label, 10);
        formData4.left = new FormAttachment((Control)formData3, 5);
        formData4.width = 40;
        this.kcSet4.setLayoutData((Object)formData4);
        this.kcSet4.addModifyListener((ModifyListener)this.modifyListener);
        this.kcSet4.addKeyListener((KeyListener)this.keyListener);
        this.generateBtn = new Button(composite2, 8);
        this.generateBtn.setText(LicenseMessages.licensePreferencePage_unlock);
        formData4 = new FormData();
        formData4.top = new FormAttachment((Control)label, 10);
        formData4.right = new FormAttachment(100, -10);
        formData4.left = new FormAttachment((Control)this.kcSet4, 5);
        this.generateBtn.setLayoutData((Object)formData4);
        this.generateBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = LicensePreferencePage.this.validateKeycode();
                if (string != null) {
                    MessageDialog.openError((Shell)LicensePreferencePage.this.generateBtn.getShell(), (String)LicenseMessages.invalid_keycode_title, (String)string);
                } else {
                    IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                            UIUtilities.getDisplay().syncExec(new Runnable(this){
                                private final /* synthetic */ 2 this$2;
                                {
                                    this.this$2 = var1_1;
                                }

                                public void run() {
                                    try {
                                        KeycodeInstaller.installKeycode(LicensePreferencePage.access$600(1.access$500(2.access$400(this.this$2))), (IProgressMonitor)new NullProgressMonitor());
                                        MessageDialog.openInformation((Shell)LicensePreferencePage.access$300(1.access$500(2.access$400(this.this$2))).getShell(), (String)LicenseMessages.licensePreferencePage_unlock_title, (String)LicenseMessages.licensePreferencePage_unlock_message);
                                    }
                                    catch (Exception exception) {
                                        LogManager.getInstance().message(10000, "com.businessobjects.license.manager.ui", exception);
                                    }
                                }
                            });
                        }

                        static /* synthetic */ 1 access$400(2 var0) {
                            return var0.this$1;
                        }
                    };
                    UIUtilities.getDisplay().asyncExec(new Runnable(this, iRunnableWithProgress){
                        private final /* synthetic */ IRunnableWithProgress val$op;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$op = iRunnableWithProgress;
                        }

                        public void run() {
                            try {
                                new ProgressMonitorDialog(LicensePreferencePage.access$300(1.access$500(this.this$1)).getShell()).run(false, false, this.val$op);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                LogManager.getInstance().message(10000, "com.businessobjects.license.manager.ui", (Exception)invocationTargetException);
                            }
                            catch (InterruptedException interruptedException) {
                                LogManager.getInstance().message(10000, "com.businessobjects.license.manager.ui", (Exception)interruptedException);
                            }
                        }
                    });
                }
            }

            static /* synthetic */ LicensePreferencePage access$500(1 var0) {
                return var0.LicensePreferencePage.this;
            }
        });
        this.generateBtn.setEnabled(false);
        this.fieldInfoMap.put(this.kcSet1, new FieldInfo(null, this.kcSet2, 5));
        this.fieldInfoMap.put(this.kcSet2, new FieldInfo(this.kcSet1, this.kcSet3, 7));
        this.fieldInfoMap.put(this.kcSet3, new FieldInfo(this.kcSet2, this.kcSet4, 7));
        this.fieldInfoMap.put(this.kcSet4, new FieldInfo(this.kcSet3, null, 4));
        return composite2;
    }

    public void init(IWorkbench iWorkbench) {
    }

    private String validateKeycode() {
        try {
            KeycodeValidator.validateKeycode(this.getKeycode());
            return null;
        }
        catch (ValidationException validationException) {
            String string = validationException.getMessage();
            if (string == null) {
                string = LicenseMessages.invalid_keycode;
            }
            return string;
        }
    }

    private String getKeycode() {
        return this.kcSet1.getText() + DASH + this.kcSet2.getText() + DASH + this.kcSet3.getText() + DASH + this.kcSet4.getText();
    }

    private static class FieldInfo {
        private Text prevField;
        private Text nextField;
        private int length;

        private FieldInfo(Text text, Text text2, int n) {
            this.prevField = text;
            this.nextField = text2;
            this.length = n;
        }
    }

    private class FieldModifyListener
    implements ModifyListener {
        private FieldModifyListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            Text text = (Text)modifyEvent.widget;
            FieldInfo fieldInfo = (FieldInfo)LicensePreferencePage.this.fieldInfoMap.get(text);
            if (fieldInfo != null && text.getText().length() == fieldInfo.length && fieldInfo.nextField != null) {
                fieldInfo.nextField.forceFocus();
                fieldInfo.nextField.setSelection(0, 0);
            }
            LicensePreferencePage.this.generateBtn.setEnabled(26 == LicensePreferencePage.this.getKeycode().length());
        }
    }

    private class FieldKeyListener
    implements KeyListener {
        private FieldKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            Text text = (Text)keyEvent.widget;
            FieldInfo fieldInfo = (FieldInfo)LicensePreferencePage.this.fieldInfoMap.get(text);
            if (fieldInfo != null) {
                if (fieldInfo.nextField != null && keyEvent.keyCode == 0x1000004 && text.getCaretPosition() == fieldInfo.length) {
                    fieldInfo.nextField.forceFocus();
                    fieldInfo.nextField.setSelection(0, 0);
                } else if (fieldInfo.prevField != null && (keyEvent.keyCode == 0x1000003 || keyEvent.character == '\b') && text.getCaretPosition() == 0) {
                    fieldInfo.prevField.forceFocus();
                    int n = fieldInfo.prevField.getText().length();
                    fieldInfo.prevField.setSelection(n, n);
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

